#!/system/bin/sh

local_host_file=$MODPATH/hosts

test ! -e $local_host_file && return 0

function show_value() {
	local value=$1
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "$file" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

if test "$( show_value '替换hosts' )" != "是" ;then
	rm -rf "${local_host_file}"
	return 0
fi

function correctpath() {
	case $(echo "$1") in
	/system_ext* | /vendor* | /product*)
		echo "/system"$1""
	;;
	/system*)
		echo "$1"
	;;
	esac
}

function mk_new_file() {
	local file=$1
	local new=$(cat "$file" | sort | uniq)
	echo "$new" > "$file"
}

function grep_host() {
	find /data/adb/modules -type f -iname "hosts" | cut -d'/' -f5 | sort | uniq | grep -v "$id"
}

function combine_host() {
	for o in $(grep_host); do
		for i in $(ls /data/adb/modules); do
			name=$(cat /data/adb/modules/$i/module.prop | grep 'name' | cut -d = -f2)
			author=$(cat /data/adb/modules/$i/module.prop | grep 'author' | cut -d = -f2)
			description=$(cat /data/adb/modules/$i/module.prop | grep 'description' | cut -d = -f2)
			size=$(du -sh /data/adb/modules/$i | sed "s|/data/adb/modules/$i||g")
			if test "$i" = "$o" -a "$i" != "$id" -a ! -e "/data/adb/modules/$i/remove" -a ! -e "/data/adb/modules/$i/disable" ; then
				echo " "
				echo "∞————————————————————————∞"
				echo ""
				echo "－名称：$name"
				echo "－作者：$author"
				echo "－简介：$description"
				echo " "
				echo "－大小：$size"
				echo " "
				echo "－ 该模块含有hosts！"
				echo ""
				test "$value" = "1" && echo "－ 正在合并模块中……"
				test "$value" = "0" && echo "－ 禁用该模块的host……"
				echo ""
				find "/data/adb/modules/$i" -iname "hosts" -type f | while read mod_hostfile; do
				if test "$value" = "1" ;then
					echo "$(cat "$mod_hostfile")" >> $local_host_file
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				else
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				fi
			done && echo "－ 完成！"
			echo ""
			echo "∞————————————————————————∞"
			echo " "
		fi
	done
done
}

function mktouch_host() {
find /system/ /system_ext /vendor /product -iname 'hosts' -type f 2> /dev/null | while read hostfile; do
mkdir -p "$MODPATH${hostfile%/*}"
cp -rf $local_host_file "$MODPATH$hostfile"
if test "$value" = "1" ;then
	mk_new_file "$MODPATH$hostfile"
fi
done && rm -rf $local_host_file
}

function save_ad_reward() {
echo "- ※保留广告奖励……※"
for i in $(cat "$MODPATH/广告奖励.prop" | sed '/^#/d;/^[[:space:]]*$/d' )
do
sed -i "/$i/d" $local_host_file
done
}

function add_block_ad_reward() {
echo "- ※去除广告奖励……※"
for i in $(cat "$MODPATH/广告奖励.prop" | sed '/^#/d;/^[[:space:]]*$/d' )
do
sed -i "/$i/d" $local_host_file
done
cat "$MODPATH/广告奖励.prop" | sed '/^#/d;/^[[:space:]]*$/d' | while read host ;do
echo "127.0.0.1 $host" >> $MODPATH/广告奖励.conf
done
cat <<key >> $local_host_file
#广告奖励
$(cat "$MODPATH/广告奖励.conf" )
#END
key
}

function add_custom_host() {
local file="$MODPATH/自定义.prop"
local Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
local local_MODPATH="/data/adb/$Magisk_mod/$id"
if test -e $file ;then
sed -i '/^[[:space:]]*$/d' "$file"
cp -rf "$file" "${file%/*}/自定义host.conf"
echo "$(cat $local_MODPATH/自定义host.conf)" >> "${file%/*}/自定义host.conf"
echo "$(cat ${file%/*}/自定义host.conf | sort -n | uniq )" > "${file%/*}/自定义host.conf"
sed -i '/^[[:space:]]*$/d;/^#/d' "${file%/*}/自定义host.conf"
cat <<key >> $local_host_file
#自定义host
$(cat $MODPATH/自定义host.conf)
#END
key
fi
}


if test "$(show_value "合并host")" = "是" ;then
value='1'
combine_host
else
value='0'
combine_host
fi

if test "$(show_value "广告奖励")" = "是" ;then
cat << key > "${MODPATH}/mod/ad_reward_2.sh"
source "\${0%/*}/ad_reward.sh"
#允许广告奖励
Switch_ad_reward "allow"
#禁用广告奖励
#Switch_ad_reward
key
else
cat << key > "${MODPATH}/mod/ad_reward_2.sh"
source "\${0%/*}/ad_reward.sh"
#允许广告奖励
#Switch_ad_reward "allow"
#禁用广告奖励
Switch_ad_reward
key
fi


add_custom_host && echo "- ※完成添加自定义host！※"

mktouch_host

echo ""
echo "∞————————————————————————∞"
echo " "
rm -rf $MODPATH/自定义.prop #$MODPATH/广告奖励.prop

