#!/system/bin/sh
id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

source $MODPATH/mod/util_functions.sh

file=${0%/*}/ads.conf

ads="$(cat $file | sed '/^[[:space:]]*$/d;/^.*#/d' )"

function cads(){
	if test -e "$1" ;then
		rm -rf "$1"
		touch "$1"
		chmod 000 "$1"
		chattr +i "$1"
	fi
}

function recoveryads(){
	if test -e "$1" ;then
		chattr -i "$1"
		chmod 777 "$1"
		rm -rf "$1"
	fi
}

function cadsclear(){
	for i in $ads;do
		file=`find "$i" 2> /dev/null`
		cads $file 2> /dev/null
	done
}

function recover_all(){
	for i in $ads;do
		file=`find "$i" 2> /dev/null`
		recoveryads $file 2> /dev/null
	done
}

function chmod_file(){
	for i in $ads;do
		file=`find "$i" 2> /dev/null`
		mkdir_file $file 2> /dev/null
	done
}


if test $(show_value "chattr锁定") == 是 ;then
#禁用广告
	cadsclear
else
#删除广告文件
	#recover_all
#锁定文件
	chmod_file
fi
