#!/system/bin/sh

local_host_file=$MODPATH/hosts

test ! -e $local_host_file && return 0

function show_value() {
	local value=$1
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "$file" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

if test "$( show_value '替换hosts' )" != "是" ;then
	rm -rf "${local_host_file}"
	rm -rf "${MODPATH}/mod/kernel_su.sh"
	return 0
fi

function correctpath() {
	case $(echo "$1") in
	/system_ext* | /vendor* | /product*)
		echo "/system"$1""
	;;
	/system*)
		echo "$1"
	;;
	esac
}

function mk_new_file() {
	local file=$1
	local new=$(cat "$file" | sort | uniq)
	echo "$new" > "$file"
}

function grep_host() {
	find /data/adb/modules -type f -iname "hosts" | cut -d'/' -f5 | sort | uniq | grep -v "$id"
}

function combine_host() {
	for o in $(grep_host); do
		for i in $(ls /data/adb/modules); do
			name=$(cat /data/adb/modules/$i/module.prop | grep 'name' | cut -d = -f2)
			author=$(cat /data/adb/modules/$i/module.prop | grep 'author' | cut -d = -f2)
			description=$(cat /data/adb/modules/$i/module.prop | grep 'description' | cut -d = -f2)
			size=$(du -sh /data/adb/modules/$i | sed "s|/data/adb/modules/$i||g")
			if test "$i" = "$o" -a "$i" != "$id" -a ! -e "/data/adb/modules/$i/remove" -a ! -e "/data/adb/modules/$i/disable" ; then
				echo " "
				echo "∞————————————————————————∞"
				echo ""
				echo "－名称：$name"
				echo "－作者：$author"
				echo "－简介：$description"
				echo " "
				echo "－大小：$size"
				echo " "
				echo "－ 该模块含有hosts！"
				echo ""
				test "$value" = "1" && echo "－ 正在合并模块中……"
				test "$value" = "0" && echo "－ 禁用该模块的host……"
				echo ""
				find "/data/adb/modules/$i" -iname "hosts" -type f | while read mod_hostfile; do
				if test "$value" = "1" ;then
					echo -e "\n# ${name}\n$(cat "${mod_hostfile}")\n# END" >> $local_host_file
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				else
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				fi
			done && echo "－ 完成！"
			echo ""
			echo "∞————————————————————————∞"
			echo " "
		fi
	done
done
}

#install for kernel su or apath
function install_for_kernel_su_Apatch(){
local modules_host="$(find "${MODPATH}" -iname 'hosts' -type f | head -n 1)"
local hosts_content="$(cat "${modules_host}")"
local system_host="$(echo "${modules_host}" | sed "s|${MODPATH}||g" )"
local perm_hosts="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -c '%U %G %a' ${system_host})"
local selinux_context="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -Z ${system_host} | grep -i 'S_Context:' | sed 's/.*u:/u:/g' )"
test "${selinux_context}" = "" && selinux_context="u:object_r:system_file:s0"
if [ "$KSU" ] || [ "$APATCH" ]; then
	cp -af "${system_host}" "${modules_host}"
	echo "${hosts_content}" > "${system_host}"
	chcon -r "u:object_r:system_file:s0" "${modules_host}"
	mkdir -p "$MODPATH/worker"
	touch "$MODPATH/skip_mount"
fi
}

function set_perm() {
  chown -R $2:$3 "${1}" || return 1
  chmod -R $4 "${1}" || return 1
  local CON=$5
  [ -z $CON ] && CON=u:object_r:system_file:s0
  chcon -R $CON "${1}" || return 1
}

function mktouch_host() {
find /system /system_ext /vendor /product -iname 'hosts' -type f 2> /dev/null | while read hostfile; do
local perm_hosts="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -c '%U %G %a' "${hostfile}" 2>/dev/null )"
local selinux_context="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -Z "${hostfile}" 2>/dev/null | grep -i 'S_Context:' | sed 's/.*u:/u:/g' )"
test "${selinux_context}" = "" && selinux_context="u:object_r:system_file:s0"
set_perm "${MODPATH}/Host" ${perm_hosts} "${selinux_context}"
mkdir -p "$MODPATH${hostfile%/*}"
if test "$(show_value "广告奖励")" = "是" ;then
	echo "- ※保留广告奖励……※"
	cp -rf "${MODPATH}/Host/reward" "$MODPATH$hostfile"
else
	echo "- ※去除广告奖励……※"
	cp -rf "${MODPATH}/Host/all" "$MODPATH$hostfile"
fi
#if test "$value" = "1" ;then
#	mk_new_file "$MODPATH$hostfile"
#fi
done
rm -rf $local_host_file
}

function save_ad_reward() {
#echo "- ※保留广告奖励……※"
for i in $(cat "$MODPATH/广告奖励.prop" | sed '/^#/d;/^[[:space:]]*$/d' )
do
sed -i "/$i/d" $local_host_file
done
}

function add_block_ad_reward() {
#echo "- ※去除广告奖励……※"
for i in $(cat "$MODPATH/广告奖励.prop" | sed '/^#/d;/^[[:space:]]*$/d' )
do
sed -i "/$i/d" $local_host_file
done
cat "$MODPATH/广告奖励.prop" | sed '/^#/d;/^[[:space:]]*$/d' | while read host ;do
echo "127.0.0.1 $host" >> $MODPATH/广告奖励.conf
done
cat <<key >> $local_host_file
#广告奖励
$(cat "$MODPATH/广告奖励.conf" )
#END
key
}

function Maker_Host_folder(){
local target_folder="${MODPATH}/Host"
mkdir -p "${target_folder}"
save_ad_reward
cp -rf "${local_host_file}" "${target_folder}/reward"
add_block_ad_reward
cp -rf "${local_host_file}" "${target_folder}/all"
}

function add_custom_host() {
local file="$MODPATH/自定义.prop"
local Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
local local_MODPATH="/data/adb/$Magisk_mod/$id"
if test -e $file ;then
sed -i '/^[[:space:]]*$/d' "$file"
cp -rf "$file" "${file%/*}/自定义host.conf"
echo "$(cat $local_MODPATH/自定义host.conf)" >> "${file%/*}/自定义host.conf"
echo "$(cat ${file%/*}/自定义host.conf | sort -n | uniq )" > "${file%/*}/自定义host.conf"
sed -i '/^[[:space:]]*$/d;/^#/d' "${file%/*}/自定义host.conf"
cat <<key >> $local_host_file
#自定义host
$(cat $MODPATH/自定义host.conf)
#END
key
fi
}

function white_domain_list_Running(){
local file="$MODPATH/放行白名单.prop"
local Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
local local_MODPATH="/data/adb/$Magisk_mod/$id"
local local_FILE="${local_MODPATH}/放行白名单.prop"

if test "$(show_value "读取配置")" = "是" ;then
	if test -f "${local_FILE}" ;then
		local original_white="$(cat "${local_FILE}")"
			echo "${original_white}" >> "${file}"
				local Combine_white="$(cat "${file}" | sed '/^\!/d;/^\#/d;/^[[:space:]]*$/d' | sort -u)"
			echo "${Combine_white}" > "${file}"
	fi
fi

echo -e "\n- ※读取放行白名单……※\n"
local white_domain_list="$(cat "${file}" | sed '/^\#/d;/^\!/d;/^[[:space:]]*$/d' | grep -Eo '([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}' | sort -u )"
for i in ${white_domain_list}
do
	sed -i "/${i}/d" "${local_host_file}" && echo "- ※剔除域名: ${i}"
done
echo -e "\n- ※剔除域名完成……※\n"
}


function Maker_reward_script(){
mkdir -p "${MODPATH}/mod/广告奖励"
echo -e '#放行广告\necho "[✔] 广告奖励已放行"' > "${MODPATH}/mod/广告奖励/reward.sh"
echo -e '#拦截广告\necho "[✘] 广告奖励已拦截"' > "${MODPATH}/mod/广告奖励/all.sh"
chmod -R 0777 "${MODPATH}/mod/广告奖励"
local config_file="${MODPATH}/广告奖励.prop"
test ! -f "${config_file}" && echo "※“广告奖励文件丢失……" && return 0
local config_read="$(cat "${config_file}" | sed '/^#/d;/^[[:space:]]*$/d')"
for i in ${config_read}
do
cat << key >> "${MODPATH}/mod/广告奖励/reward.sh"
iptables -D OUTPUT -m string --string "$i" --algo bm --to 65535 -j DROP
key
cat << key >> "${MODPATH}/mod/广告奖励/all.sh"
iptables -A OUTPUT -m string --string "$i" --algo bm --to 65535 -j DROP
key
done
}


if test "$(show_value "合并host")" = "是" ;then
value='1'
combine_host
else
value='0'
combine_host
fi

#if test "$(show_value "广告奖励")" = "是" ;then
#cat << key > "${MODPATH}/mod/ad_reward_2.sh"
#source "\${0%/*}/ad_reward.sh"
#允许广告奖励
#Switch_ad_reward "allow"
#禁用广告奖励
#Switch_ad_reward
#key
#Maker_reward_script
#else
#cat << key > "${MODPATH}/mod/ad_reward_2.sh"
#source "\${0%/*}/ad_reward.sh"
#允许广告奖励
#Switch_ad_reward "allow"
#禁用广告奖励
#Switch_ad_reward
#key
#Maker_reward_script
#fi

#剔除白名单域名
white_domain_list_Running

add_custom_host && echo "- ※完成添加自定义host！※"

#mount方式
Maker_Host_folder
#生成hosts
mktouch_host

if test "$( show_value '直接挂载hosts' )" != "是" ;then
	install_for_kernel_su_Apatch
fi



#echo ""
#echo "∞————————————————————————∞"
#echo " "
rm -rf $MODPATH/自定义.prop $MODPATH/广告奖励.conf $MODPATH/check_bin.sh $MODPATH/mount_bind_update.sh

