#!/system/bin/sh
MODDIR=${0%/*}
BUSYBOXDIR=$MODDIR/busybox
export PATH=/system/bin:$BUSYBOXDIR:$PATH

function overlay_system_hosts(){
local modules_host="$MODDIR/Host/all"
local modules_host_reward="${modules_host%/*}/reward"
local system_hosts="/system/etc/hosts"
grep -q '广告奖励=否' "${MODDIR}/配置.prop" || modules_host="${modules_host_reward}"
if test -d "$MODDIR/worker" ;then
if test "${modules_host_folder}" = "" ;then
	echo "[!] hosts文件丢失！"
else
#mount --bind 挂载
	if test -f "${system_hosts}" ;then
		mount --bind "${modules_host}" "${system_hosts}"
	else
		echo "系统hosts未找到或者脚本错误 ${system_hosts}"
	fi
  fi
fi
}

#设置action.sh权限
test -f "${MODDIR}/action.sh" && chmod 0755 "${MODDIR}/action.sh"

test -e $MODDIR/mod && {
	chmod -R 777 $MODDIR/mod
	until $(dumpsys deviceidle get screen) ;do
		sleep 10s
	done
	for i in $MODDIR/mod/*.sh ;do
		nohup $i >/dev/null 2>&1 &
	done
}

test -e $MODDIR/crond && {
chmod -R 777 $MODDIR/crond
crond -c $MODDIR/crond
}

#挂载systemless hosts
(overlay_system_hosts &)


