#!/system/bin/sh

if test "$(getprop ro.miui.ui.version.name)" = "" ;then 
	echo "非MIUI！"
	exit 0
fi

id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

sleep 2.5m

pm disable com.miui.analytics >/dev/null 2>&1
pm suspend com.miui.analytics >/dev/null 2>&1
analytics_path=`pm path com.miui.analytics | cut -d':' -f2`

if test "$(echo "${analytics_path}" | grep '^/data' )" != "" ;then
	pm clear com.miui.analytics >/dev/null 2>&1
		pm uninstall com.miui.analytics >/dev/null 2>&1
		if test -f "$MODPATH/system/app/AnalyticsCore/Analytics.apk" ;then
			pm install "$MODPATH/system/app/AnalyticsCore/Analytics.apk" >/dev/null 2>&1
		fi
			pm disable com.miui.analytics >/dev/null 2>&1
		pm suspend com.miui.analytics >/dev/null 2>&1
	pm hide com.miui.analytics >/dev/null 2>&1
fi


#删除并且chattr +i 广告文件
function X_Analysis(){
	if test -e "$1" ;then
		rm -rf "$1"
		touch "$1"
		chmod 000 "$1"
		chcon -R u:object_r:system_file:s0 "${1}"
		#chattr -i "$1"
	fi
}

#恢复chattr +i锁定的文件，并且删除
function RE_Analysis(){
	if test -e "$1" ;then
		chattr -R -i "${1%/*}" >/dev/null 2>&1
		chattr -i "$1"
		chmod 777 "$1"
		rm -rf "$1"
		mkdir -p "${1%/*}"
		touch "${1}"
	fi
}

echo "－ 查找 Analysis 文件夹中……"
echo "－ 请耐心等待……"
dir=`find /data/data /data/media/*[0-9]*/Android -iname '*app_analytics*' -perm 000 -o -iname '*app_analytics*' -type d 2> /dev/null `

test "$dir" != "" && {
	echo "－ 找到Analysis 文件夹！"
	for file in $dir ;do
		echo "－ $file "
		RE_Analysis $file && echo "－ 删除成功！" || echo "－ 删除失败！"
	done
} || echo "－ 未找到Analysis 文件夹！"


