#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>

#define BUFFER_SIZE 256
#define TITLE_SIZE 256
#define TEXT_SIZE 3840
#define CMD_SIZE 4096
#define TIME_SIZE 20

int check_package_exists(const char *package_name) {
    FILE *fp = popen("pm list packages", "r");
    if (!fp) return 0;

    char buffer[BUFFER_SIZE];
    while (fgets(buffer, BUFFER_SIZE, fp)) {
        if (strstr(buffer, package_name)) {
            pclose(fp);
            return 1;
        }
    }
    pclose(fp);
    return 0;
}

void run_cmd_as_uid_2000(const char *command) {
    if (setuid(2000) == 0) {
        system(command);
    }
}

void notification_simulation(const char *text, const char *title) {
    char final_title[TITLE_SIZE] = "代号10007";
    char final_text[TEXT_SIZE] = "您未给出任何信息";
    char time_str[TIME_SIZE];
    char command[CMD_SIZE];

    time_t now = time(NULL);
    strftime(time_str, TIME_SIZE, "%Y-%m-%d %H:%M:%S", localtime(&now));

    if (title && *title) {
        strncpy(final_title, title, TITLE_SIZE - 1);
    }
    if (text && *text) {
        strncpy(final_text, text, TEXT_SIZE - 1);
    }

    if (check_package_exists("com.google.android.ext.services")) {
        run_cmd_as_uid_2000("cmd notification allow_assistant 'com.google.android.ext.services/android.ext.services.notification.Assistant'");
    }

    snprintf(command, CMD_SIZE, "cmd notification post -S messaging --conversation '%s' --message '%s:%s' -t '%s' '%d' '%s' >/dev/null 2>&1",
            time_str, final_title, final_text, final_title, rand(), final_title);

    run_cmd_as_uid_2000(command);
}

int main(int argc, char *argv[]) {
    srand(time(NULL));
    notification_simulation(argc > 1 ? argv[1] : NULL, argc > 2 ? argv[2] : NULL);
    return 0;
}