id="$id"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
local_MODPATH="/data/adb/$Magisk_mod/$id"
conf_file="${MODPATH}/配置.prop"
target_file="$local_MODPATH/配置.prop"
test ! -f "$target_file" && target_file="$local_MODPATH/配置.conf"

function show_value() {
	local value=$1
	local file="${2}"
	cat "${file}" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

function replace_value() {
	local name="${1}"
	local value="$(show_value "${name}" "${target_file}" )"
	local file="${2}"
	if test "$value" != "" ;then
		sed -i "s|^$name=.*|$name=$value|g" $file
		echo " 修改 [ $name ] 值为 [ $value ]"
	else 
		echo "添加新的配置选项 [ $name ] 值为 [ $(show_value "${name}" "$conf_file") ]"
	fi
}


if test -e $target_file ;then
	if test $(show_value "读取配置" "${conf_file}" ) == 否 ;then
		echo -e "\n∞————————————————————————∞\n"
		echo "- 应用模块压缩包配置……"
		for i in $(cat "$conf_file" | sed '/^#/d;/^[[:space:]]*$/d;s/=.*//g' | sed '/^读取配置/d' )
		do
			echo "[ ${i} ] 值为 [ $(show_value "$i" "$conf_file") ]"
		done
		echo -e "\n∞————————————————————————∞\n"
	else
		echo ""
		echo "∞————————————————————————∞"
		echo ""
		echo "- 读取上次修改的配置……"
		for i in $(cat "$conf_file" | sed '/^#/d;/^[[:space:]]*$/d;s/=.*//g' | sed '/^读取配置/d' )
		do
			replace_value "$i" "$conf_file"
		done
		echo ""
		echo "- 完成！"
		echo ""
		echo "∞————————————————————————∞"
	fi
fi


if test "$(show_value '小米云备份' "${conf_file}")" != "禁用" ;then
	rm -rf "${MODPATH}/mod/a0.app.xiaomi.com.sh"
fi

if test "$(show_value '广告文件监视器' "${conf_file}")" != "启用" ;then
	rm -rf "${MODPATH}/mod/ads_monitor.sh"
#else
#	if test `cat "${local_MODPATH}/mod/ads_monitor/ads_monitor.prop" | wc -l | sed '/^[[:space:]]*$/d' ` -gt `cat "${MODPATH}/mod/ads_monitor/ads_monitor.prop" | wc -l | sed '/^[[:space:]]*$/d'` ;then
#		cp -af "${local_MODPATH}/mod/ads_monitor/ads_monitor.prop" "${MODPATH}/mod/ads_monitor/ads_monitor.prop" >/dev/null 2>&1
#	fi 
fi

if test "$(show_value 'MountHost' "${conf_file}")" != "禁用" ;then
	touch "${MODPATH}/skip_mount"
	key_source $MODPATH/mount_bind_update.sh
fi


