
ARCH_KEY="$(uname -m 2>/dev/null )"
ARCH_KEY_Prop="$(getprop ro.product.cpu.abi)"
[[ "${ARCH}" == "" ]] && ARCH="${ARCH_KEY_Prop}"
[[ "${ARCH_KEY_Prop}" == "" ]] && ARCH="${ARCH_KEY}"


local ADS_MONITOR_PATH="${MODPATH}/mod/ads_monitor"
local MOUNT_HOSTS_PATH="${MODPATH}/mod/mount_hosts"
local NOTIFICATION_PATH="${MODPATH}/tools"

case "${ARCH}" in
aarch64|arm64)
mv -f "${ADS_MONITOR_PATH}/ads_monitor_arm64" "${ADS_MONITOR_PATH}/ads_monitor"
mv -f "${MOUNT_HOSTS_PATH}/mount_hosts_arm64" "${MOUNT_HOSTS_PATH}/mount_hosts"
mv -f "${NOTIFICATION_PATH}/notification_arm64" "${NOTIFICATION_PATH}/notification"
;;
armv7l|arm)
mv -f "${ADS_MONITOR_PATH}/ads_monitor_arm32" "${ADS_MONITOR_PATH}/ads_monitor"
mv -f "${MOUNT_HOSTS_PATH}/mount_hosts_arm32" "${MOUNT_HOSTS_PATH}/mount_hosts"
mv -f "${NOTIFICATION_PATH}/notification_arm32" "${NOTIFICATION_PATH}/notification"
;;
i686|x86)
mv -f "${ADS_MONITOR_PATH}/ads_monitor_x86" "${ADS_MONITOR_PATH}/ads_monitor"
mv -f "${MOUNT_HOSTS_PATH}/mount_hosts_x86" "${MOUNT_HOSTS_PATH}/mount_hosts"
mv -f "${NOTIFICATION_PATH}/notification_x86" "${NOTIFICATION_PATH}/notification"
;;
x86_64|x64)
mv -f "${ADS_MONITOR_PATH}/ads_monitor_x86_64" "${ADS_MONITOR_PATH}/ads_monitor"
mv -f "${MOUNT_HOSTS_PATH}/mount_hosts_x86_64" "${MOUNT_HOSTS_PATH}/mount_hosts"
mv -f "${NOTIFICATION_PATH}/notification_x86_64" "${NOTIFICATION_PATH}/notification"
;;
*)
echo "- 不支持的构架！"
rm -rf "${ADS_MONITOR_PATH}" "${MOUNT_HOSTS_PATH}" "${NOTIFICATION_PATH}"
return 0
;;
esac

rm -rf ${MOUNT_HOSTS_PATH}/mount_hosts_* \
${ADS_MONITOR_PATH}/ads_monitor_* \
${NOTIFICATION_PATH}/notification_* 2>/dev/null
