author="`grep_prop author $TMPDIR/module.prop`"
name="`grep_prop name $TMPDIR/module.prop`"
description="`grep_prop description $TMPDIR/module.prop`"
id="`grep_prop id $TMPDIR/module.prop`"

#获取magisk类型
function get_magisk_lite(){
local until_function=/data/adb/magisk/util_functions.sh
if grep -q lite_modules $until_function ;then
	echo "－ 🌙当前为: Magisk Lite◎$MAGISK_VER_CODE"
else
	if [ "$APATCH" ] || [ "$KSU" ];then
		echo " - 🤔当前环境非Magisk……"
	else
case "${MAGISK_VER}" in
*alpha)
	echo "－ ☀当前为: Magisk Alpha◎$MAGISK_VER_CODE"
;;
*delta)
	echo "－ ☀当前为: Magisk Delta◎$MAGISK_VER_CODE"
;;
*kitsune)
	local magisk_type="${MAGISK_VER%-*}"
	if [[ -n $(echo "${magisk_type}" | grep -E '[0-9]{2}\.[0-9]') ]] ;then
		echo "－ ☀当前为: Kitsune Mask◎$MAGISK_VER_CODE"
	else
		echo "－ ☀当前为: Kitsune Mask(${magisk_type})◎$MAGISK_VER_CODE"
	fi
;;
*-*)
	local magisk_others="$(echo "${MAGISK_VER##*-}" | tr '[:lower:]' '[:upper:]')"
	echo "－ ☀当前为: Magisk ${magisk_others}◎$MAGISK_VER_CODE"
;;
*)
	echo "－ ☀当前为: Magisk Official◎$MAGISK_VER_CODE"
;;
esac
	fi
fi
}

#获取酷安名称
function get_coolapk_user_name(){
for i in /data/user/0/com.coolapk.market/shared_prefs/*preferences*.xml
do
	username="$(grep '<string name="username">' "${i}" | sed 's/.*"username">//g;s/<.*//g')"
	if [[ -n "${username}" ]];then
	 echo "${username}"
	 break
	fi
done
}

#获取github用户名
function get_github_user(){
local github_name="$(dumpsys content | grep -Eo 'Account[[:space:]].*u[0-9]{1,3}.*com\.github\.android' | sed 's/Account[[:space:]]//g;s/[[:space:]]u[0-9].*//g' | sort -u | head -n 1)"
echo "${github_name}"
}


function hello_master(){
	echo ""
if test -n "$(getprop persist.sys.device_name)" ;then
	echo "－ ●您好！"$(getprop persist.sys.device_name)"！●"
elif test "$(get_coolapk_user_name)" != "" ;then
	echo "－ ●您好！"$(get_coolapk_user_name)"！●"
elif [[ -n "$(get_github_user)" ]];then
	echo "－ ●您好！"$(get_github_user)"！●"
elif test -n "$(pm list users | cut -d : -f2 )" ;then
	echo - ●您好！ $(pm list users | cut -d : -f2 )！●
fi
	echo "－ ●欢迎使用本模块！●"
	get_magisk_lite
	echo ""
}


echo ""
echo "∞————————————————————————∞"
hello_master
echo "－品牌: `getprop ro.product.brand`"
echo "－代号: `getprop ro.product.device`"
echo "－模型: `getprop ro.product.model`"
echo "－安卓版本: `getprop ro.build.version.release`"
test "`getprop ro.miui.ui.version.name`" != "" && echo "－MIUI版本: MIUI `getprop ro.miui.ui.version.name` - `getprop ro.build.version.incremental` "
echo "－内核版本: `uname -a `"
echo "－运存大小: `free -m|grep "Mem"|awk '{print $2}'`MB  已用:`free -m|grep "Mem"|awk '{print $3}'`MB  剩余:$((`free -m|grep "Mem"|awk '{print $2}'`-`free -m|grep "Mem"|awk '{print $3}'`))MB"
echo "－Swap大小: `free -m|grep "Swap"|awk '{print $2}'`MB  已用:`free -m|grep "Swap"|awk '{print $3}'`MB  剩余:`free -m|grep "Swap"|awk '{print $4}'`MB"
echo "∞————————————————————————∞"
echo ""
echo "∞————————————————————————∞"
echo "- 模块信息"
echo "- 名称: $name    "
echo "- 作者：$author"
echo "- $description    "
echo "∞————————————————————————∞"
echo ""

