function set_perm() {
  chown -R $2:$3 "${1}" >/dev/null 2>&1
  chmod -R $4 "${1}" >/dev/null 2>&1
  local CON=$5
  [ -z $CON ] && CON=u:object_r:system_file:s0
  chcon -R $CON "${1}" >/dev/null 2>&1
}

function mount_set_perm_for_hosts(){
local target_file="${1}"
test ! -f "${target_file}" && return
local system_host="/system/etc/hosts"
if test ! -f "${system_host}" ;then
for file in $(find /system/ /system_ext /vendor /product -iname 'hosts' -type f 2>/dev/null)
do
case "${file}" in
/system_ext* | /vendor* | /product*)
	system_host="/system"${file}""
	break
;;
/system*)
	system_host="${file}"
	break
;;
		esac
	done
fi
local perm_hosts="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -c '%U %G %a' ${system_host} 2>/dev/null )"
local selinux_context="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -Z ${system_host} 2>/dev/null | grep -i 'S_Context:' | sed 's/.*u:/u:/g' )"
test "${selinux_context}" = "" && selinux_context="u:object_r:system_file:s0"
set_perm "${target_file%/*}" ${perm_hosts} "${selinux_context}"
umount "${system_host}" >/dev/null 2>&1
mount --bind "${target_file}" "${system_host}" >/dev/null 2>&1
}
function Zygisk_next_Re_hidden() {
export PATH="/data/adb/modules/zygisksu/bin:$PATH"
local state_file="/data/adb/zygisksu/denylist_enforce"
local policy_file="${state_file%/*}/denylist_policy"
local state_value=$(cat "${state_file}" 2>/dev/null)
local policy_value=$(cat "${policy_file}" 2>/dev/null)
[ "$(command -v zygiskd)" = "" ] && return

case "${policy_value}" in
 0) zygiskd denylist-policy default ;;
 1) zygiskd denylist-policy whitelist ;;
 *) zygiskd denylist-policy default ;;
esac

case "${state_value}" in
 1) zygiskd enforce-denylist enabled ;;
 2) zygiskd enforce-denylist just_umount ;;
 *) zygiskd enforce-denylist just_umount ;;
esac

if [ ! -f "${state_file}" ]; then
	zygiskd denylist-policy default
	echo "2" > "${state_file}"
	zygiskd enforce-denylist just_umount
fi

[ ! -f "${policy_file}" ] && zygiskd denylist-policy default
}

mount_set_perm_for_hosts "${0%/*}/all"

#调用zygisknext隐藏内存修改痕迹
(Zygisk_next_Re_hidden &)
