id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

source $MODPATH/mod/util_functions.sh

function set_perm() {
  chown -R $2:$3 "${1}" >/dev/null 2>&1
  chmod -R $4 "${1}" >/dev/null 2>&1
  local CON=$5
  [ -z $CON ] && CON=u:object_r:system_file:s0
  chcon -R $CON "${1}" >/dev/null 2>&1
}

function mount_set_perm_for_hosts(){
local target_file="${1}"
test ! -f "${target_file}" && return
local system_host="/system/etc/hosts"
if test ! -f "${system_host}" ;then
for file in $(find /system/ /system_ext /vendor /product -iname 'hosts' -type f 2>/dev/null)
do
case "${file}" in
/system_ext* | /vendor* | /product*)
	system_host="/system"${file}""
	break
;;
/system*)
	system_host="${file}"
	break
;;
		esac
	done
fi
local perm_hosts="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -c '%U %G %a' ${system_host} 2>/dev/null )"
local selinux_context="$(`find /data/adb/ -iname "busybox" -type f | sed '/modules/d' | head -n 1` stat -Z ${system_host} 2>/dev/null | grep -i 'S_Context:' | sed 's/.*u:/u:/g' )"
test "${selinux_context}" = "" && selinux_context="u:object_r:system_file:s0"
set_perm "${target_file%/*}" ${perm_hosts} "${selinux_context}"
umount "${system_host}" >/dev/null 2>&1
mount --bind "${target_file}" "${system_host}" >/dev/null 2>&1
}

function Zygisk_next_Re_hidden() {
export PATH="/data/adb/modules/zygisksu/bin:$PATH"
local state_file="/data/adb/zygisksu/denylist_enforce"
local policy_file="${state_file%/*}/denylist_policy"
local state_value=$(cat "${state_file}" 2>/dev/null)
local policy_value=$(cat "${policy_file}" 2>/dev/null)
[ "$(command -v zygiskd)" = "" ] && return

case "${policy_value}" in
 0) zygiskd denylist-policy default ;;
 1) zygiskd denylist-policy whitelist ;;
 *) zygiskd denylist-policy default ;;
esac

case "${state_value}" in
 1) zygiskd enforce-denylist enabled ;;
 2) zygiskd enforce-denylist just_umount ;;
 *) zygiskd enforce-denylist just_umount ;;
esac

if [ ! -f "${state_file}" ]; then
	zygiskd denylist-policy default
	echo "2" > "${state_file}"
	zygiskd enforce-denylist just_umount
fi

[ ! -f "${policy_file}" ] && zygiskd denylist-policy default
}

white_file="$MODPATH/放行白名单.prop"
white_domain_list="$(cat "${white_file}" | sed '/^\#/d;/^\!/d;/^[[:space:]]*$/d' | grep -Eo '([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}' | sort -u )"
echo -e "- <<< 读取白名单 >>>"
find "$MODPATH" -iname "hosts" -type f -o -iname "reward" -type f -o -iname "all" -type f 2>/dev/null | while read local_host_file
do
	for i in ${white_domain_list}
		do
		sed -i "/${i}/d" "${local_host_file}" && echo "- ※剔除域名: ${i}"
	done
done

if test "$(show_value '广告奖励')" = "否" ;then
	mount_set_perm_for_hosts "${MODPATH}/Host/all" && echo "- ※挂载 all 文件" || echo -e "- <<< 失败 >>>"
else
	mount_set_perm_for_hosts "${MODPATH}/Host/reward" && echo "- ※挂载 reward 文件" || echo -e "- <<< 失败 >>>"
fi
(Zygisk_next_Re_hidden &)
echo -e "- <<< 完成 >>>"