author="`grep_prop author $TMPDIR/module.prop`"
name="`grep_prop name $TMPDIR/module.prop`"
description="`grep_prop description $TMPDIR/module.prop`"
id="`grep_prop id $TMPDIR/module.prop`"

#获取magisk类型
function get_magisk_lite(){
local until_function_file=/data/adb/magisk/util_functions.sh
if grep -q lite_modules $until_function_file 2>/dev/null ;then
	echo "－ 🌙当前为: Magisk Lite◎$MAGISK_VER_CODE"
else
	if [ "$APATCH" ] || [ "$KSU" ];then
		test "${APATCH_VER_CODE}" != "" && echo " - 🌟当前为: Aptch◎${APATCH_VER_CODE}……"
		if test "${KSU_VER_CODE}" != "" -a "${KSU_KERNEL_VER_CODE}" != "" ; then
			echo " - 🌟当前为: Kernel SU◎${KSU_VER_CODE}(${KSU_KERNEL_VER_CODE})……"
			return
		fi
		test "${KSU_VER_CODE}" != "" && echo " - 🌟当前为: Kernel SU◎${KSU_VER_CODE}……"
	else
case "${MAGISK_VER}" in
*alpha)
	echo "－ ☀当前为: Magisk Alpha◎$MAGISK_VER_CODE"
;;
*delta)
	echo "－ ☀当前为: Magisk Delta◎$MAGISK_VER_CODE"
;;
*kitsune)
	local magisk_type="${MAGISK_VER%-*}"
	if [[ -n $(echo "${magisk_type}" | grep -E '[0-9]{2}\.[0-9]') ]] ;then
		echo "－ ☀当前为: Kitsune Mask◎$MAGISK_VER_CODE"
	else
		echo "－ ☀当前为: Kitsune Mask(${magisk_type})◎$MAGISK_VER_CODE"
	fi
;;
*-*)
	local magisk_others="$(echo "${MAGISK_VER##*-}" | tr '[:lower:]' '[:upper:]')"
	echo "－ ☀当前为: Magisk ${magisk_others}◎$MAGISK_VER_CODE"
;;
*)
	echo "－ ☀当前为: Magisk Official◎$MAGISK_VER_CODE"
;;
esac
	fi
fi
}

#获取酷安名称
function get_coolapk_user_name(){
for i in /data/user/0/com.coolapk.market/shared_prefs/*preferences*.xml
do
	username="$(grep '<string name="username">' "${i}" | sed 's/.*"username">//g;s/<.*//g')"
	if [[ -n "${username}" ]];then
	 echo "${username}"
	 break
	fi
done
}

#获取github用户名
function get_github_user(){
local github_user_file="/data/user/0/com.github.android/shared_prefs/user_preferences.xml"
local github_name="$(dumpsys content | grep -Eo 'Account[[:space:]].*u[0-9]{1,3}.*com\.github\.android' | sed 's/Account[[:space:]]//g;s/[[:space:]]u[0-9].*//g' | sort -u | head -n 1)"
[ -z "${github_name}" ] || echo "${github_name}" && return
sed -E '/\"key_account_name\"/!d;s/(.*\"key_account_name\">)(.*)(<.*)/\2/g' "${github_user_file}"
}


function hello_master(){
	echo ""
if test -n "$(getprop persist.sys.device_name)" ;then
	echo "－ ●您好！"$(getprop persist.sys.device_name)"！●"
elif test "$(get_coolapk_user_name)" != "" ;then
	echo "－ ●您好！"$(get_coolapk_user_name)"！●"
elif [[ -n "$(get_github_user)" ]];then
	echo "－ ●您好！"$(get_github_user)"！●"
elif test -n "$(pm list users | cut -d : -f2 )" ;then
	echo - ●您好！ $(pm list users | cut -d : -f2 )！●
fi
	echo "－ ●欢迎使用本模块！●"
	get_magisk_lite
	echo ""
}

function getprop_other_value() {
local prop_value="${1}"
local base_name="${prop_value#ro.}"
local base_name="${base_name#*.}"
local result=$(getprop "${prop_value}")
[ -n "${result}" ] && echo "${result}" && return
result=$(getprop "ro.$base_name")
[ -n "${result}" ] && echo "${result}" && return
[ "${base_name}" = "${prop_value}" ] && base_name="${prop_value#ro.}"
for i in system product vendor odm system_ext meizu oplus
do
	new_prop="ro.${i}.${base_name}"
	new_prop_market="ro.${i}.${base_name#*.}"
	result=$(getprop "${new_prop}")
	market_result=$(getprop "${new_prop_market}")
	[ -n "${result}" ] && echo "${result}" && return
	[ -n "${market_result}" ] && echo "${market_result}" && return
done
}

echo ""
echo "∞————————————————————————∞"
hello_master
echo "－品牌: $(getprop_other_value ro.product.brand)"
echo "－代号: $(getprop_other_value ro.product.device)"
if [ -n "$(getprop ro.vendor.oplus.market.name)" ]; then
    echo "－机型: $(getprop ro.vendor.oplus.market.name)"
elif [ -n "$(getprop_other_value ro.product.marketname)" ]; then
    echo "－机型: $(getprop_other_value ro.product.marketname)"
else
    echo "－机型: $(getprop_other_value ro.product.model)"
fi
echo "－安卓版本: $(getprop ro.build.version.release)"
if [ -n "$(getprop ro.mi.os.version.name)" ]; then
    echo "－HyperOS版本: Hyper$(getprop ro.mi.os.version.name) - $(getprop ro.mi.os.version.incremental)"
elif [ -n "$(getprop ro.miui.ui.version.name)" ]; then
    echo "－MIUI版本: MIUI $(getprop ro.miui.ui.version.name) - $(getprop ro.build.version.incremental)"
fi
if [ -n "$(getprop ro.build.version.oplusrom)" ]; then
    echo "－ColorOS版本: ColorOS $(getprop ro.build.version.oplusrom) - $(getprop ro.build.display.id)"
elif [ -n "$(getprop ro.build.version.oplusrom.display)" ]; then
    echo "－ColorOS版本: ColorOS $(getprop ro.build.version.oplusrom.display) - $(getprop ro.build.display.id)"
fi
if [ "$(echo `getprop ro.build.display.id` | grep -i 'Flyme')" != "" ]; then
	echo "－Flyme版本: `getprop ro.build.display.id`"
elif [ -n "$(getprop_other_value ro.vendor.build.flyme.version)" ]; then
	echo "－Flyme版本: Flyme `getprop_other_value ro.vendor.build.flyme.version`"
fi

echo "－内核版本: $(uname -a)"
echo "－运存大小: $(($(grep '^MemTotal:' /proc/meminfo | tr -s ' ' | cut -d ' ' -f2)/1024 ))MB 已用:$(( ( $(grep '^MemTotal:' /proc/meminfo|tr -s ' ' | cut -d ' ' -f2) -$(grep '^MemFree:' /proc/meminfo|tr -s ' ' | cut -d ' ' -f2) )/1024 ))MB 可用:$(($(grep '^MemAvailable:' /proc/meminfo|tr -s ' ' | cut -d ' ' -f2)/1024 ))MB"
echo "－Swap大小: $(($(grep '^SwapTotal:' /proc/meminfo | tr -s ' ' | cut -d ' ' -f2)/1024 ))MB 已用:$(( ( $(grep '^SwapTotal:' /proc/meminfo|tr -s ' ' | cut -d ' ' -f2) -$(grep '^SwapFree:' /proc/meminfo|tr -s ' ' | cut -d ' ' -f2) )/1024 ))MB 剩余:$(( $(grep '^SwapFree:' /proc/meminfo|tr -s ' ' | cut -d ' ' -f2)/1024 ))MB"
echo "∞————————————————————————∞"
echo ""
echo "∞————————————————————————∞"
echo "- 模块信息"
echo "- 名称: $name    "
echo "- 作者：$author"
echo "- $description    "
echo "∞————————————————————————∞"
echo ""

