#!/bin/sh

id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

source $MODPATH/mod/util_functions.sh

test -f "$MODPATH/mod/notification.sh" && exit 0 || sleep 5m

local_host_file=`find "$MODPATH" -iname "hosts" -type f -o -iname "reward" -type f -o -iname "all" -type f 2>/dev/null `

[ "${local_host_file}" = "" ] && exit 0

function show_value() {
	local value=$1
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "${file}" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

function grep_host() {
	find /data/adb/modules -type f -iname "hosts" | cut -d'/' -f5 | sort | uniq | grep -v "$id" | sed '/^[[:space:]]*$/d'
}

function combine_host() {
if test "$(show_value "合并host")" = "是" ;then
	value='1'
else
	value='0'
fi
	for o in $(grep_host); do
		for i in $(ls /data/adb/modules); do
			name=$(cat /data/adb/modules/$i/module.prop | grep 'name' | cut -d = -f2)
			author=$(cat /data/adb/modules/$i/module.prop | grep 'author' | cut -d = -f2)
			description=$(cat /data/adb/modules/$i/module.prop | grep 'description' | cut -d = -f2)
			size=$(du -sh /data/adb/modules/$i | sed "s|/data/adb/modules/$i||g")
			if test "$i" = "$o" -a "$i" != "$id" -a ! -e "/data/adb/modules/$i/remove" -a ! -e "/data/adb/modules/$i/disable" ; then
				echo " "
				echo "∞————————————————————————∞"
				echo ""
				echo "－名称：$name"
				echo "－作者：$author"
				echo "－简介：$description"
				echo " "
				echo "－大小：$size"
				echo " "
				echo "－ 该模块含有hosts！"
				echo ""
				test "$value" = "1" && echo "－ 正在合并模块中……"
				test "$value" = "0" && echo "－ 禁用该模块的host……"
				target_count_modules="名称:${name},作者:$author,路径:/data/adb/modules/$i"
				total_module="${target_count_modules}\n${total_module}"
				echo ""
				find "/data/adb/modules/$i" -iname "hosts" -type f | while read mod_hostfile; do
				if test "$value" = "1" ;then
					for v in ${local_host_file} ;do
						test -f "$mod_hostfile" && mv -f "$mod_hostfile" "$mod_hostfile.bak"
						echo -e "\n# ${name}\n$(cat "${mod_hostfile}.bak")\n# END" >> "${v}"
					done
				else
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				fi
			done && echo "－ 完成！"
			echo ""
			echo "∞————————————————————————∞"
			echo " "
		fi
		done
	notification_simulation " `echo "冲突模块已做处理\n\n${total_module}" ` `echo '\n如果不生效，请先进行重启操作🇨🇳！'` " "去广告模块" "2000"
done
}


(combine_host &)

