#!/system/bin/sh

id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

source $MODPATH/mod/util_functions.sh

if test "$(show_value 'MountHost')" = "禁用" ;then
	sleep 2m
else
a="0"
until $(pgrep -f "mount_hosts" >/dev/null 2>&1)
do
	test "${a}" = "4" && break
	a="$(($a + 1))"
	sleep 30s
done
	sleep 2m
fi


function Host_info(){
local dir="${0%/*}"
local MODPATH="${dir%/*}"
local host_file=`find "${MODPATH}" -iname "hosts" -type f | head -n 1`
test "${host_file}" = "" && host_file="/system/etc/hosts"
local host_count="$(cat $host_file | sed '/^#/d;/^[[:space:]]*$/d' | wc -l)"
if test "$host_count" -ge "500000" ;then 
	local sate="网络存在一定延迟"
elif test "$host_count" -ge "50000" ;then 
	local sate="网络小幅度延迟"
elif test "$host_count" -lt "50000" ;then 
	local sate="网络基本无影响"
fi
echo "当前Host数量: ${host_count}，${sate}"
}


function echo_head_info(){
echo "品牌=$(getprop_other_value ro.product.brand)($(getprop_other_value ro.product.device))"
if [ -n "$(getprop ro.vendor.oplus.market.name)" ]; then
    echo "机型=$(getprop ro.vendor.oplus.market.name)"
elif [ -n "$(getprop_other_value ro.product.marketname)" ]; then
    echo "机型=$(getprop_other_value ro.product.marketname)"
else
    echo "机型=$(getprop_other_value ro.product.model)"
fi
echo "安卓版本=$(getprop ro.build.version.release)"
if [ -n "$(getprop ro.mi.os.version.name)" ]; then
    echo "HyperOS版本=Hyper$(getprop ro.mi.os.version.name) - $(getprop ro.mi.os.version.incremental)"
elif [ -n "$(getprop ro.miui.ui.version.name)" ]; then
    echo "MIUI版本=MIUI $(getprop ro.miui.ui.version.name) - $(getprop ro.build.version.incremental)"
fi
if [ -n "$(getprop ro.build.version.oplusrom)" ]; then
    echo "ColorOS版本=ColorOS $(getprop ro.build.version.oplusrom) - $(getprop ro.build.display.id)"
elif [ -n "$(getprop ro.build.version.oplusrom.display)" ]; then
    echo "ColorOS版本=ColorOS $(getprop ro.build.version.oplusrom.display) - $(getprop ro.build.display.id)"
fi
if [ "$(echo `getprop ro.build.display.id` | grep -i 'Flyme')" != "" ]; then
	echo "Flyme版本=`getprop ro.build.display.id`"
elif [ -n "$(getprop_other_value ro.vendor.build.flyme.version)" ]; then
	echo "Flyme版本=Flyme `getprop_other_value ro.vendor.build.flyme.version`"
fi
Host_info
}

function magisk_app_uid(){
local package userid
if test "$( pm list package | grep -w 'com.topjohnwu.magisk' )" != "" ;then
	package='com.topjohnwu.magisk'
elif test "$( pm list package | grep -w 'io.github.huskydg.magisk' )" != "" ;then
	package='io.github.huskydg.magisk'
elif test "$( pm list package | grep -w 'io.github.vvb2060.magisk' )" != "" ;then
	package='io.github.vvb2060.magisk'
else
	package=`magisk --sqlite "SELECT value FROM strings where key='requester'" | cut -d'=' -f2`
fi

if test "$package" != '' ;then
	userid="$(cmd package list package -U "${package}" | grep "package:${package}[[:space:]]uid:" | sed 's/.*uid://g' | tr -cd '[0-9]')"
	echo "${userid}"
else
	echo '2000'
fi
}


notification_simulation "$(echo_head_info)" "去广告模块" "2000"

sleep 15s

source "${0%/*}/disable_other_module_hosts.sh"

combine_host

