#!/system/bin/sh
MODDIR=${0%/*}
BUSYBOXDIR=$MODDIR/busybox
export PATH=/system/bin:$BUSYBOXDIR:/data/adb/modules/zygisksu/bin:$PATH

function overlay_system_hosts(){
local modules_host="$MODDIR/Host/all"
local modules_host_reward="${modules_host%/*}/reward"
local system_hosts="/system/etc/hosts"
grep -q '广告奖励=否' "${MODDIR}/配置.prop" || modules_host="${modules_host_reward}"
if test -d "$MODDIR/worker" -o -f "$MODDIR/skip_mount" ;then
  if test ! -f "${modules_host}" ;then
	echo "[!] hosts文件丢失！"
 else
#mount --bind 挂载
	if test -f "${system_hosts}" ;then
		mount --bind "${modules_host}" "${system_hosts}" || mount -o bind "${modules_host}" "${system_hosts}"
	else
		echo "系统hosts未找到或者脚本错误 ${system_hosts}"
	fi
  fi
fi
}

function zygisk_next_hidden(){
local zygisk_denylist_state="/data/adb/zygisksu/denylist_enforce"
local zygisk_denylist_policy="${zygisk_denylist_state%/*}/denylist_policy"
if test "$(which zygiskd)" != "" -a ! -f "${zygisk_denylist_state}" ;then
	echo "2" > "${zygisk_denylist_state}"
	zygiskd enforce-denylist just_umount
fi
if test "$(which zygiskd)" != "" -a ! -f "${zygisk_denylist_policy}" ;then
	echo "0" > "${zygisk_denylist_policy}"
	zygiskd denylist-policy default
fi
}

#挂载systemless hosts
(overlay_system_hosts &)
#存在zygisk_next调用zygisk隐藏内存修改痕迹
(zygisk_next_hidden &)
