/*
 * Decompiled with CFR 0.152.
 */
package modimapper.mapper;

import jakarta.ws.rs.core.HttpHeaders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

public class DigestMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper {
    public static final String PROVIDER_ID = "digest-protocol-mapper";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final String DIGEST_VALUE = "DigestAuditValue";
    private static final String DIGEST_ALG = "DigestAuditAlgo";

    public String getDisplayCategory() {
        return "Token Mapper";
    }

    public String getDisplayType() {
        return "Digest Token Mapper";
    }

    public String getHelpText() {
        return "Inserisce l'algoritmo che genera il digest ed il digest stesso nel token";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        HttpHeaders httpHeaders = keycloakSession.getContext().getHttpRequest().getHttpHeaders();
        String digestValue = "";
        String digestAlg = "";
        List reqHeaders = httpHeaders.getRequestHeader(DIGEST_VALUE);
        if (reqHeaders != null && !reqHeaders.isEmpty()) {
            digestValue = (String)reqHeaders.get(0);
        }
        if ((reqHeaders = httpHeaders.getRequestHeader(DIGEST_ALG)) != null && !reqHeaders.isEmpty()) {
            digestAlg = (String)reqHeaders.get(0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alg", digestAlg);
        map.put("value", digestValue);
        token.setOtherClaims("digest", map);
    }

    static {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, DigestMapper.class);
    }
}

