#!/bin/bash


function build_RDN {
T="$1"
V="$2"
RDN=

shopt -s extglob
T="${T##+([[:space:]])}"
V="${V%%+([[:space:]])}"

[ -n "${T}" -a -n "${V}" ] && RDN="${T^^}=${V//\//\\/}"
echo "$RDN"
}


function build_DN {
SUBJ="$1"

if [ -n "${SUBJ}" ]
then
        while IFS='=' read -d, TAG VAL
        do
                DN="${DN}/$(build_RDN "$TAG" "$VAL")"
        done <<<"${SUBJ},"

        if [ ${DN:0:2} == "//" ]
        then
                DN=
                while IFS='=' read -d/ TAG VAL
                do
                        DN="${DN}/$(build_RDN "$TAG" "$VAL")"
                done <<<"${SUBJ:1}/"
        fi
fi

echo "$DN"

}


function certificato_EE {
NOME="$1"
TIPO="$2"
#DAYS=720
DAYS=5475
NOME_NOSPAZI="${NOME// /_}"

EE_SUBJECT="c=it, o=govway.org, cn=${NOME}"

        echo "Creazione End Entity per ${NOME}" 
        echo "Creo chiave privata End Entity su ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem" 

        openssl genrsa -out ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem 2048

        cat /dev/urandom |tr -dc '[:alnum:][:digit:]_.;,@%#!^&*()+-'|head -c 16 > ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.README.txt
        openssl rsa \
        -in  ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem \
        -des3 \
        -passout file:${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.README.txt \
        -out  ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem.withpasswd

        echo "Proteggo la chiave privata End Entity con password" 
        /bin/mv -f ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem.withpasswd ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem
        chmod 400 ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.README.txt
        chmod 400 ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem

        echo "Creo richiesta di certificazione su ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.csr.pem" 
        EE_SUBJ_CANONICO=$(build_DN "${EE_SUBJECT}")
        openssl req -config ${WORK_DIR}/openssl_${SOGGETTO}.conf \
        -key ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.key.pem \
        -passin file:${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.README.txt \
        -new -sha256 -out ${WORK_DIR}/ca/csr/ee_${NOME_NOSPAZI}.csr.pem \
        -subj "${EE_SUBJ_CANONICO}"   

        echo "Firmo richiesta di certificazione ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.csr.pem su ${WORK_DIR}/ca/certs/ee_${NOME_NOSPAZI}.cert.pem" 

        openssl ca -config ${WORK_DIR}/openssl_${SOGGETTO}.conf \
        -batch \
        -passin file:${WORK_DIR}/ca/private/ca_${SOGGETTO}.README.txt \
        -extensions ${TIPO}_cert -days ${DAYS} -notext -md sha256 \
        -in ${WORK_DIR}/ca/csr/ee_${NOME_NOSPAZI}.csr.pem \
        -out ${WORK_DIR}/ca/certs/ee_${NOME_NOSPAZI}.cert.pem
#        chmod 000 ${WORK_DIR}/ca/private/ee_${NOME_NOSPAZI}.README.txt
        chmod 444 ${WORK_DIR}/ca/certs/ee_${NOME_NOSPAZI}.cert.pem
}


##############################################
##############################################
################ MAIN ########################
##############################################
##############################################
FQDN="${1:-test.govway.org}"
PKI_DIR="${3:-./pki}"
read -d.  SOGGETTO <<< "$FQDN"
WORK_DIR="${PKI_DIR}/CA_${SOGGETTO}"
CA_SUBJECT='C=it, O=govway.org, CN=GovWay CA'
CN="${2:-${SOGGETTO}}"


certificato_EE "${CN}" "server"

