<?php

class KurdishDictionary {
	public const Topics = array(
	    'general'   => 'گشتی',
		'Kurmanji'   => 'کورمانجی',
		'Synonymous'   => 'هاوواتا',
		'medical'   => 'پزیشکی',
	    'Geology'   => 'زەویناسی',
	    'awrami'   => 'هەورامی',
	    'Chemistry'   => 'کیمیا',
	    'mathematic'   => 'بیرکاری',
	    'saicology'   => 'دەروونناسی',
	    'Economic'   => 'ئابوری',
	    'Statistical'   => 'ئامار',
	    'Military'   => 'سەربازی',
		'law'       => 'یاسا',
		'sociology' => 'کۆمەڵناسی',
		'computer'  => 'کۆمپیوتر',
		'politics'   => 'رامیاری',
		'Vegetable' => 'ڕووەک'
	);

	public function __construct() {
		add_action( 'after_setup_theme', [ $this, 'theme_support' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'register_styles' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'register_scripts' ] );

		add_action( 'admin_enqueue_scripts', [ $this, 'admin_register_styles' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_register_scripts' ] );

		add_filter( 'posts_search', [ $this, 'search_by_title' ], 10, 2 );
		add_action( 'add_meta_boxes', [ $this, 'register_meta_boxes' ] );
		add_action( 'save_post', [ $this, 'meta_save' ], 9999999995, 2 );
		add_action( 'template_redirect', [ $this, 'search_result' ], 5 );
		add_action( 'admin_menu', [ $this, 'admin_menu' ] );
		add_action( 'pre_get_posts', [ $this, 'search_order' ] );
	}

	function search_order( $query ) {
		if ( $query->is_search() && $query->is_main_query() ) {
			$query->set( 'orderby', 'title' );
		}
	}

	function admin_menu() {
		add_menu_page(
			'وشەی نوێ',
			'وشەی نوێ',
			'manage_options',
			'add-word',
			[ $this, 'addWord' ],
			'dashicons-welcome-add-page',
			4
		);
	}

	function addWord() {
		$update_message = '';
		if ( isset( $_POST['add_word'] ) && wp_verify_nonce( $_POST['add_word'], 'new_word' ) ) {
			$postID = $_POST['word_post_id'];
			$title  = ucwords( $_POST['word_title'] );

			if ( empty( $postID ) ) {
				$query = new WP_Query( array(
					'post_status' => 'publish',
					'post_type'   => 'post',
					's'           => $title,
					'exact'       => true
				) );
				if ( $query->have_posts() ) {
					$query->the_post();
					$postID = get_the_ID();
				}
			}

			$postData = array(
				'ID'          => $postID,
				'post_title'  => $title,
				'post_status' => 'publish',
				'post_author' => get_current_user_id(),
				'meta_input'  => array(
					'_translates' => $_POST['word_translates'],
				)
			);

			$result = wp_insert_post( $postData );

			if ( is_wp_error( $result ) )
				$update_message = $this->message( 'هەڵه لە تۆمارکردنی وشە!', 'error' );
			else
				$update_message = $this->message( 'وشە بەسەرکەوتوویی تۆمارکرا' );
		}

		?>
        <div class="wrap">
            <h1 class="wp-heading-inline">زیادکردنی وشە</h1>
			<?php echo $update_message ?>
            <form action="" method="post">
				<?php wp_nonce_field( 'new_word', 'add_word', false ) ?>
                <input type="hidden" name="word_post_id" id="word-post-id" value="">
                <table class="table-bm wp-list-table widefat striped">
                    <tr>
                        <th scope="row"><label for="search-input"><b>ووشەی ئینگلیزی</b></label></th>
                        <td><input type="text" id="search-input" name="word_title" class="regular-text ltr" required
                                   autofocus></td>
                    </tr>
					<?php
					foreach ( self::Topics as $topic => $title ) {
						echo '<tr>
                                    <td style="width: 150px;">' . $title . '</td>
                                    <td><input type="text" name="word_translates[' . $topic . ']"  class="regular-text" id="translate_topic_' . $topic . '" value=""></td>
                                </tr>';
					}
					?>
                    <tr>
                        <td colspan="2">
                            <input type="submit" value="پاشکەوت" class="button button-large button-primary">
                            <input type="reset" value="چۆڵکردنی خشتەکان" class="button button-large button-secondary">
                        </td>
                    </tr>
                </table>
            </form>
        </div>
		<?php
	}

	function search_result() {
		if ( is_404() ) {
			wp_redirect( get_bloginfo( 'url' ) );
			exit;
		} elseif ( is_search() && mb_strlen( get_search_query() ) >= 2 && isset( $_GET['format'] ) && $_GET['format'] === 'json' ) {
			$result = [];
			if ( have_posts() ) {
				while( have_posts() ) {
					the_post();

					$postData = array(
						'word' => get_the_title(),
						'url'  => get_the_permalink(),
					);

					if ( isset( $_GET['detail'] ) && $_GET['detail'] === 'true' ) {
						$postID                 = get_the_ID();
						$translates             = get_post_meta( $postID, '_translates', true );
						$postData['id']         = $postID;
						$postData['translates'] = $translates;
					}

					$result [] = $postData;
				}
			}

			wp_send_json( $result );
			exit;
		}
	}

	function register_meta_boxes() {
		add_meta_box( 'bm-meta', 'وەرگێڕان', array( $this, 'meta_box_display' ), [ 'post' ] );
	}

	/**
	 * @param $post WP_Post
	 */
	function meta_box_display( $post ) {
		wp_nonce_field( basename( __FILE__ ), "ds-nonce", false );
		$postID     = $post->ID;
		$translates = get_post_meta( $postID, '_translates', true );

		?>
        <table class="table-bm wp-list-table widefat striped">
			<?php
			foreach ( self::Topics as $topic => $title ) {
				$translate = isset( $translates[ $topic ] ) ? $translates[ $topic ] : '';
				echo '<tr>
                        <td style="width: 150px;">' . $title . '</td>
                        <td><input type="text" name="word_translates[' . $topic . ']"  class="regular-text" value="' . $translate . '"></td>
                    </tr>';
			}
			?>
        </table>
		<?php
	}

	/**
	 * @param $post_id integer
	 * @param $post WP_Post
	 *
	 * @return void
	 */
	function meta_save( $post_id, $post ) {
		/*
		* We need to verify this came from our screen and with proper authorization,
		* because the save_post action can be triggered at other times.
		*/
		// Check if our nonce is set.
		if ( ! isset( $_POST['ds-nonce'] ) ) {
			return;
		}

		if ( ! isset( $_POST["ds-nonce"] ) || ! wp_verify_nonce( $_POST["ds-nonce"], basename( __FILE__ ) ) ) {
			return;
		}

		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Return if it's a post revision
		if ( false !== wp_is_post_revision( $post_id ) ) {
			return;
		}

		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}
		} elseif ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		if ( in_array( get_post_status( $post_id ), array( 'auto-draft', 'inherit', 'trash' ) ) ) {
			return;
		}

		$pos = strpos( $post->post_name, 'autosave' );
		if ( $pos !== false ) {
			return;
		}

		$pos = strpos( $post->post_name, 'revision' );
		if ( $pos !== false ) {
			return;
		}

		if ( isset( $_POST['word_translates'] ) ) {
			update_post_meta( $post_id, '_translates', $_POST['word_translates'] );
		}
	}

	function message( $message, $type = 'updated', $is_dismissible = true ) {
		return '<div id="setting-error-settings_updated" class="' . $type . ( $is_dismissible ? ' is-dismissible ' : '' ) . ' settings-error notice " ><p>' . $message . '</p></div> ';
	}

	
	// new Search SQL filter for matching against post title only.
	function search_by_title( $search, $wp_query ) {
	    global $wpdb;
        if ( empty( $search ) )
            return $search; // skip processing - no search term in query
        $q = $wp_query->query_vars;
        $n = ! empty( $q['exact'] ) ? '' : '%';
        $search =
        $searchand = '';
        foreach ( (array) $q['search_terms'] as $term ) {
            $term = esc_sql( like_escape( $term ) );
            $search .= "{$searchand}($wpdb->posts.post_title LIKE '{$term}{$n}')";
            $searchand = ' AND ';
        }
        if ( ! empty( $search ) ) {
            $search = " AND ({$search}) ";
            if ( ! is_user_logged_in() )
                $search .= " AND ($wpdb->posts.post_password = '') ";
        }
        return $search;
	}

	/**
	 * Register and Enqueue Styles.
	 */
	function admin_register_styles() {
		global $pagenow;
		if ( $pagenow === 'admin.php' && isset( $_GET['page'] ) && $_GET['page'] === 'add-word' ) {
			$theme_version = wp_get_theme()->get( 'Version' );
			wp_enqueue_style( 'admin-theme-style', get_template_directory_uri() . '/assets/css/admin.min.css', array(),
				$theme_version );
		}
	}

	/**
	 * Register and Enqueue Scripts.
	 */
	function admin_register_scripts() {
		global $pagenow;
		if ( $pagenow === 'admin.php' && isset( $_GET['page'] ) && $_GET['page'] === 'add-word' ) {
			$theme_version = wp_get_theme()->get( 'Version' );

			wp_enqueue_script( 'easy-autocomplete-js',
				get_template_directory_uri() . '/assets/js/jquery.easy-autocomplete.js', array( 'jquery' ),
				$theme_version, true );

			wp_enqueue_script( 'admin-theme-js', get_template_directory_uri() . '/assets/js/admin.js',
				array( 'jquery', 'easy-autocomplete-js' ), $theme_version, true );

			wp_localize_script( 'admin-theme-js', 'website', array( 'url' => get_bloginfo( 'url' ) ) );

			wp_script_add_data( 'admin-theme-js', 'defer', true );
		}
	}

	/**
	 * Register and Enqueue Styles.
	 */
	function register_styles() {
		$theme_version = wp_get_theme()->get( 'Version' );
		wp_enqueue_style( 'theme-style', get_template_directory_uri() . '/style.min.css', array(), $theme_version );
	}

	/**
	 * Register and Enqueue Scripts.
	 */
	function register_scripts() {
		$theme_version = wp_get_theme()->get( 'Version' );

		wp_enqueue_script( 'easy-autocomplete-js',
			get_template_directory_uri() . '/assets/js/jquery.easy-autocomplete.js', array( 'jquery' ),
			$theme_version, true );

		wp_enqueue_script( 'theme-js', get_template_directory_uri() . '/assets/js/global.js',
			array( 'jquery', 'easy-autocomplete-js' ), $theme_version, true );

		wp_localize_script( 'theme-js', 'website', array( 'url' => get_bloginfo( 'url' ) ) );

		wp_script_add_data( 'theme-js', 'defer', true );
	}

	function theme_support() {
		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);
	}
}

new KurdishDictionary();


///remove menu
function remove_menus(){
  //remove_menu_page( 'index.php' );                  //Dashboard
  //remove_menu_page( 'edit.php' );                   //Posts
  //remove_menu_page( 'upload.php' );                 //Media
  //remove_menu_page( 'edit.php?post_type=page' );    //Pages
  //remove_menu_page( 'edit-comments.php' );          //Comments
 // remove_menu_page( 'themes.php' );                 //Appearance
 // remove_menu_page( 'plugins.php' );                //Plugins
 // remove_menu_page( 'users.php' );                  //Users
// remove_menu_page( 'tools.php' );                  //Tools
// remove_menu_page( 'options-general.php' );        //Settings 
   
}
add_action( 'admin_menu', 'remove_menus' );






