<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
	<link href="http://toppillcaremarket.com/" rel="stylesheet" type="text/css">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
	<link href="https://v1.fontapi.ir/css/Estedad:300;500" rel="stylesheet">
	<?php wp_head(); ?>
</head>
<body>
<?php wp_body_open(); ?>
<div class="container content">
    <a href="<?php bloginfo( 'url' ); ?>"><h1 class="title"><?php bloginfo( 'name' ); ?></h1></a>
	
    <div class="dictionary-form">
        <form action="<?php bloginfo( 'url' ); ?>" method="get">
            <label for="search-input" class="sr-only">Word</label>
            <input type="search" name="s" value="" placeholder="Search for..." id="search-input" required
                   autocomplete="off" minlength="2" onkeydown="return (event.keyCode!=13);"/>
            <!-- <button type="submit" class="search-submit">Search</button> -->
        </form>
		
    </div>

    <div class="search-result">
		
		<?php
		if ( is_search() || is_single() )
			if ( have_posts() ) {
				$result = '';
				$topics = KurdishDictionary::Topics;
				while( have_posts() ) {
					the_post();
					$postID       = get_the_ID();
					$content      = apply_filters( 'the_content', get_the_content() );
					$translates   = get_post_meta( $postID, '_translates', true );
					$hasThumbnail = has_post_thumbnail();

					$result .= '<div class="translate ' . ( $hasThumbnail ? 'has-image' : '' ) . '">';

					if ( $hasThumbnail ) {
						$image  = get_the_post_thumbnail_url( $postID, 'full' );
						$result .= '<div class="image cover" style="background-image: url(\'' . $image . '\')"></div>';
					}

					$result .= '<div><h2 class="word">' . get_the_title() . '</h2>';

					// Translate topics
					if ( isset( $translates ) && $translates ) {
						$result .= '<div class="topics">';
						foreach ( $topics as $topic => $title ) {
							if ( ! isset( $translates[ $topic ] ) || empty( trim( $translates[ $topic ] ) ) )
								continue;
							$result .= '<div class="item"><span class="topic">' . $title . '</span><span>' . $translates[ $topic ] . '</span></div>';
						}
						$result .= '</div>';
					}

					// Description
					$result .= '<div class="description">' . $content . '</div>';

					$result .= '</div>';
					$result .= '</div>';
				}
				echo $result;
			} else {
				echo '<div class="not-found">گەڕانی ئێوە ئەنجامێکی نەبوو.</div>';
			}
		?>
    </div>
</div>
<footer class="footer">
    <div class="container">
        © <a href="https://linux.krd">linux.krd</a> <?php echo date( 'Y' ) ?> / LGPL <span style="float: right;
    padding-right: 50px;"> <a href="<?php echo get_home_url(); ?>/we " target="_blank">ئێمە</a>   .  <a href="https://linux.krd/comments/" target="_blank">لێدوان</a>   .  <a href="https://github.com/linux-krd" target="_blank">گیت‌هاب</a></span>
    </div>
</footer>
<?php wp_footer(); ?>
</body>
</html>