/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer;

import io.github.lizhangqu.intellij.android.bundle.analyzer.ApkSizeCalculator;
import io.github.lizhangqu.intellij.android.bundle.analyzer.Archive;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveContext;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveEntry;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveManager;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveNode;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveTreeStream;
import io.github.lizhangqu.intellij.android.bundle.analyzer.InnerArchiveEntry;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.ArchiveTreeNode;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.MutableTreeNode;

public class ArchiveTreeStructure {
    public static ArchiveNode create(ArchiveContext archiveContext) throws IOException {
        return ArchiveTreeStructure.createWorker(archiveContext.getArchiveManager(), archiveContext.getArchive(), "");
    }

    private static ArchiveNode createWorker(ArchiveManager archiveManager, Archive archive, String pathPrefix) throws IOException {
        Path contentRoot = archive.getContentRoot();
        ArchiveTreeNode rootNode = new ArchiveTreeNode(new ArchiveEntry(archive, contentRoot, pathPrefix));
        Stack<ArchiveTreeNode> stack = new Stack<ArchiveTreeNode>();
        stack.push(rootNode);
        while (!stack.isEmpty()) {
            ArchiveTreeNode node = (ArchiveTreeNode)stack.pop();
            Path path = node.getData().getPath();
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            Throwable throwable = null;
            try {
                for (Path childPath : stream) {
                    ArchiveTreeNode childNode;
                    Archive innerArchive = archiveManager.openInnerArchive(archive, childPath);
                    if (innerArchive != null) {
                        ArchiveTreeNode newArchiveNode = (ArchiveTreeNode)ArchiveTreeStructure.createWorker(archiveManager, innerArchive, pathPrefix + childPath.toString());
                        childNode = new ArchiveTreeNode(new InnerArchiveEntry(archive, childPath, pathPrefix, innerArchive));
                        for (ArchiveNode archiveNodeChild : newArchiveNode.getChildren()) {
                            childNode.add((MutableTreeNode)((Object)archiveNodeChild));
                        }
                    } else {
                        childNode = new ArchiveTreeNode(new ArchiveEntry(archive, childPath, pathPrefix));
                        if (Files.isDirectory(childPath, new LinkOption[0])) {
                            stack.push(childNode);
                        }
                    }
                    node.add(childNode);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return rootNode;
    }

    public static void updateRawFileSizes(ArchiveNode root, ApkSizeCalculator calculator) {
        Map<String, Long> rawFileSizes = root.getData() instanceof InnerArchiveEntry ? calculator.getRawSizePerFile(((InnerArchiveEntry)root.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getRawSizePerFile(root.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStream(root).forEach(node -> {
            Long rawFileSize;
            ArchiveEntry data = node.getData();
            if (node != root && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateRawFileSizes(node, calculator);
            }
            if ((rawFileSize = (Long)rawFileSizes.get(data.getPath().toString())) != null) {
                data.setRawFileSize(rawFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getRawFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getRawFileSize()).reduce(0L, Long::sum);
                data.setRawFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void updateDownloadFileSizes(ArchiveNode root, ApkSizeCalculator calculator) {
        Map<String, Long> downloadFileSizes = root.getData() instanceof InnerArchiveEntry ? calculator.getDownloadSizePerFile(((InnerArchiveEntry)root.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getDownloadSizePerFile(root.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStream(root).forEach(node -> {
            Long downloadFileSize;
            ArchiveEntry data = node.getData();
            if (node != root && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateDownloadFileSizes(node, calculator);
            }
            if ((downloadFileSize = (Long)downloadFileSizes.get(data.getPath().toString())) != null) {
                data.setDownloadFileSize(downloadFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getDownloadFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getDownloadFileSize()).reduce(0L, Long::sum);
                data.setDownloadFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void sort(ArchiveNode root, Comparator<ArchiveNode> comparator) {
        assert (root instanceof ArchiveTreeNode);
        ArchiveTreeStructure.sort((ArchiveTreeNode)root, comparator);
    }

    private static void sort(ArchiveTreeNode root, Comparator<ArchiveNode> comparator) {
        ArrayList<ArchiveNode> children = new ArrayList<ArchiveNode>(root.getChildren());
        children.sort(comparator);
        root.removeAllChildren();
        for (ArchiveNode child : children) {
            root.add((ArchiveTreeNode)child);
            ArchiveTreeStructure.sort(child, comparator);
        }
    }
}

