/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer.internal;

import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveContext;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveEntry;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveNode;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveTreeStructure;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.ApkDiffEntry;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.ApkEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApkDiffParser {
    public static DefaultMutableTreeNode createTreeNode(ArchiveContext oldFile, ArchiveContext newFile) throws IOException {
        ArchiveNode oldRoot = ArchiveTreeStructure.create(oldFile);
        ArchiveNode newRoot = ArchiveTreeStructure.create(newFile);
        return ApkDiffParser.createTreeNode(oldRoot, newRoot);
    }

    private static DefaultMutableTreeNode createTreeNode(ArchiveNode oldFile, ArchiveNode newFile) throws IOException {
        String name;
        if (oldFile == null && newFile == null) {
            throw new IllegalArgumentException("Both old and new files are null");
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        long oldSize = 0L;
        long newSize = 0L;
        HashSet<String> childrenInOldFile = new HashSet<String>();
        ArchiveEntry data = oldFile == null ? newFile.getData() : oldFile.getData();
        String string = name = data.getPath().getFileName() != null ? data.getPath().getFileName().toString() : data.getArchive().getPath().getFileName().toString();
        if (oldFile != null) {
            if (!oldFile.getChildren().isEmpty()) {
                for (ArchiveNode oldChild : oldFile.getChildren()) {
                    ArchiveNode newChild = null;
                    if (newFile != null) {
                        for (ArchiveNode archiveNode : newFile.getChildren()) {
                            if (!archiveNode.getData().getPath().getFileName().toString().equals(oldChild.getData().getPath().getFileName().toString())) continue;
                            newChild = archiveNode;
                            break;
                        }
                    }
                    childrenInOldFile.add(oldChild.getData().getPath().getFileName().toString());
                    DefaultMutableTreeNode childNode = ApkDiffParser.createTreeNode(oldChild, newChild);
                    node.add(childNode);
                    ApkDiffEntry entry = (ApkDiffEntry)childNode.getUserObject();
                    oldSize += entry.getOldSize();
                    newSize += entry.getNewSize();
                }
                if (Files.size(oldFile.getData().getPath()) > 0L) {
                    oldSize = Files.size(oldFile.getData().getPath());
                } else if (oldFile.getParent() == null) {
                    oldSize = Files.size(oldFile.getData().getArchive().getPath());
                }
            } else {
                oldSize += Files.size(oldFile.getData().getPath());
            }
        }
        if (newFile != null) {
            if (!newFile.getChildren().isEmpty()) {
                for (ArchiveNode newChild : newFile.getChildren()) {
                    if (childrenInOldFile.contains(newChild.getData().getPath().getFileName().toString())) continue;
                    DefaultMutableTreeNode childNode = ApkDiffParser.createTreeNode(null, newChild);
                    node.add(childNode);
                    ApkDiffEntry entry = (ApkDiffEntry)childNode.getUserObject();
                    oldSize += entry.getOldSize();
                    newSize += entry.getNewSize();
                }
                if (Files.size(newFile.getData().getPath()) > 0L) {
                    newSize = Files.size(newFile.getData().getPath());
                } else if (newFile.getParent() == null) {
                    newSize = Files.size(newFile.getData().getArchive().getPath());
                }
            } else {
                newSize += Files.size(newFile.getData().getPath());
            }
        }
        node.setUserObject(new ApkDiffEntry(name, oldFile, newFile, oldSize, newSize));
        ApkEntry.sort(node);
        return node;
    }
}

