/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.apkview;

import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import io.github.lizhangqu.intellij.android.bundle.filetype.SoBundleFileType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkFileSystem
extends ArchiveFileSystem {
    public static final Set<String> EXTENSIONS = ImmutableSet.of((Object)"so", (Object)"ap_", (Object)"ap", (Object)"aar", (Object)"aab", (Object)"apks", (Object[])new String[]{"jar", "war", "awb"});
    public static final String PROTOCOL = "bundle";
    public static final String APK_SEPARATOR = "!/";
    private static final String APKZIP_EXT = "bundlezip";
    private static final String APKZIP_SUFFIX = ".bundlezip";
    private static final Key<Boolean> APKZIP_KEY = Key.create((String)"android.zip.within.bundle");

    public static ApkFileSystem getInstance() {
        return (ApkFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            ApkFileSystem.$$$reportNull$$$0(0);
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)APK_SEPARATOR);
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            ApkFileSystem.$$$reportNull$$$0(2);
        }
        String string = localPath + APK_SEPARATOR;
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            ApkFileSystem.$$$reportNull$$$0(4);
        }
        ArchiveHandler archiveHandler = VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, JarHandler::new);
        if (archiveHandler == null) {
            ApkFileSystem.$$$reportNull$$$0(5);
        }
        return archiveHandler;
    }

    @NotNull
    public String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            ApkFileSystem.$$$reportNull$$$0(6);
        }
        String string = super.getRelativePath(file);
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            ApkFileSystem.$$$reportNull$$$0(8);
        }
        int apkSeparatorIndex = path.indexOf(APK_SEPARATOR);
        assert (apkSeparatorIndex >= 0) : "Path passed to ApkFileSystem must have apk separator '!/': " + path;
        String string = path.substring(0, apkSeparatorIndex + APK_SEPARATOR.length());
        if (string == null) {
            ApkFileSystem.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            ApkFileSystem.$$$reportNull$$$0(10);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        if (path == null) {
            ApkFileSystem.$$$reportNull$$$0(11);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            ApkFileSystem.$$$reportNull$$$0(12);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] bytes;
        if (file == null) {
            ApkFileSystem.$$$reportNull$$$0(13);
        }
        if (!this.isBinaryXml(file, bytes = super.contentsToByteArray(file))) {
            if (bytes == null) {
                ApkFileSystem.$$$reportNull$$$0(14);
            }
            return bytes;
        }
        byte[] byArray = BinaryXmlParser.decodeXml((String)file.getName(), (byte[])bytes);
        if (byArray == null) {
            ApkFileSystem.$$$reportNull$$$0(15);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            ApkFileSystem.$$$reportNull$$$0(16);
        }
        if (APKZIP_EXT.equals(local.getExtension()) && Boolean.TRUE.equals(local.getUserData(APKZIP_KEY))) {
            return true;
        }
        if ("xml".equalsIgnoreCase(local.getExtension())) {
            return true;
        }
        if (SoBundleFileType.INSTANCE.getDefaultExtension().equalsIgnoreCase(local.getExtension())) {
            InputStream inputStream = null;
            try {
                inputStream = local.getInputStream();
                byte[] buffer = new byte[4];
                int read = inputStream.read(buffer, 0, 4);
                if (read == 4 && buffer[0] == 80 && buffer[1] == 75 && buffer[2] == 3 && buffer[3] == 4) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return false;
        }
        return EXTENSIONS.contains(local.getExtension());
    }

    @Nullable
    public VirtualFile extractAndGetContentRoot(VirtualFile file) {
        File tempFile;
        try {
            tempFile = FileUtil.createTempFile((String)file.getName(), (String)APKZIP_SUFFIX, (boolean)true);
        }
        catch (IOException e) {
            Logger.getInstance(ApkFileSystem.class).warn("IOException while extracting zip file from APK", (Throwable)e);
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(file.contentsToByteArray());){
            Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.getInstance(ApkFileSystem.class).warn("IOException while copying contents of zip file to temp file", (Throwable)e);
            return null;
        }
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true);
        if (vfile == null) {
            return null;
        }
        vfile.putUserData(APKZIP_KEY, (Object)Boolean.TRUE);
        return ApkFileSystem.getInstance().getRootByLocal(vfile);
    }

    public boolean isBinaryXml(VirtualFile file, byte[] bytes) {
        return ApkFileSystem.isBinaryXml(this.getRelativePath(file), bytes);
    }

    public static boolean isBinaryXml(String relativePath, byte[] bytes) {
        boolean encodedXmlPath;
        if (!relativePath.endsWith(".xml")) {
            return false;
        }
        boolean bl = encodedXmlPath = relativePath.equals("AndroidManifest.xml") || relativePath.startsWith("res") && !relativePath.startsWith("res/raw");
        if (!encodedXmlPath) {
            return false;
        }
        short code = Shorts.fromBytes((byte)bytes[1], (byte)bytes[0]);
        return code == Chunk.Type.XML.code();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/github/lizhangqu/intellij/android/bundle/apkview/ApkFileSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/github/lizhangqu/intellij/android/bundle/apkview/ApkFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

