/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer;

import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import io.github.lizhangqu.intellij.android.bundle.analyzer.Archive;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveContext;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveEntry;
import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveNode;
import io.github.lizhangqu.intellij.android.bundle.analyzer.InnerArchiveEntry;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.ApkArchive;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.AppBundleArchive;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.ArchiveManagerImpl;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.InstantAppBundleArchive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

public class Archives {
    public static ArchiveContext open(Path path) throws IOException {
        return Archives.open(path, NullLogger.getLogger());
    }

    public static ArchiveContext open(Path path, ILogger logger) throws IOException {
        ArchiveManagerImpl archiveManager = new ArchiveManagerImpl(logger);
        return archiveManager.openArchive(path);
    }

    public static ArchiveEntry getFirstManifestArchiveEntry(ArchiveNode input) {
        if (input.getData().getArchive() instanceof ApkArchive) {
            Archive archive = input.getData().getArchive();
            return Archives.getTopLevelManifestEntry(input, archive);
        }
        if (input.getData().getArchive() instanceof InstantAppBundleArchive) {
            return input.getChildren().stream().map(node -> {
                if (node.getData() instanceof InnerArchiveEntry) {
                    ArchiveEntry innerEntry = ((InnerArchiveEntry)node.getData()).asArchiveEntry();
                    return Archives.getTopLevelManifestEntry(node, innerEntry.getArchive());
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (input.getData().getArchive() instanceof AppBundleArchive) {
            AppBundleArchive appBundleArchive = (AppBundleArchive)input.getData().getArchive();
            ArchiveNode baseDir = Archives.getChild(input, appBundleArchive.getContentRoot().resolve("base/"));
            if (baseDir == null) {
                return null;
            }
            ArchiveNode manifestDir = Archives.getChild(baseDir, baseDir.getData().getPath().resolve("manifest/"));
            if (manifestDir == null) {
                return null;
            }
            ArchiveNode manifest = Archives.getChild(manifestDir, manifestDir.getData().getPath().resolve("AndroidManifest.xml"));
            if (manifest == null) {
                return null;
            }
            return manifest.getData();
        }
        return null;
    }

    private static ArchiveNode getChild(ArchiveNode input, Path path) {
        return input.getChildren().stream().filter(node -> node.getData().getPath().equals(path)).findFirst().orElse(null);
    }

    private static ArchiveEntry getTopLevelManifestEntry(ArchiveNode input, Archive archive) {
        Path path = archive.getContentRoot().resolve("AndroidManifest.xml");
        return input.getChildren().stream().filter(x -> x.getData().getPath().equals(path)).map(ArchiveNode::getData).findFirst().orElse(null);
    }
}

