/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.apkview;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.internal.AppBundleArchive;
import com.android.tools.idea.log.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import io.github.lizhangqu.intellij.android.bundle.apkview.ApkViewPanel;
import io.github.lizhangqu.intellij.android.bundle.apkview.ProtoXmlPrettyPrinterImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkParser {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private final ArchiveContext myArchiveContext;
    private final ApkSizeCalculator myApkSizeCalculator;
    @Nullable
    private ListenableFuture<ArchiveNode> myTreeStructure;
    @Nullable
    private ListenableFuture<ArchiveNode> myTreeStructureWithDownloadSizes;
    @Nullable
    private ListenableFuture<Long> myRawFullApkSize;
    @Nullable
    private ListenableFuture<Long> myCompressedFullApkSize;

    public ApkParser(@NotNull ArchiveContext archiveContext, @NotNull ApkSizeCalculator sizeCalculator) {
        if (archiveContext == null) {
            ApkParser.$$$reportNull$$$0(0);
        }
        if (sizeCalculator == null) {
            ApkParser.$$$reportNull$$$0(1);
        }
        this.myArchiveContext = archiveContext;
        this.myApkSizeCalculator = sizeCalculator;
    }

    @NotNull
    public Archive getArchive() {
        Archive archive = this.myArchiveContext.getArchive();
        if (archive == null) {
            ApkParser.$$$reportNull$$$0(2);
        }
        return archive;
    }

    public synchronized void cancelAll() {
        ListenableFuture[] futures;
        for (ListenableFuture future : futures = new ListenableFuture[]{this.myTreeStructureWithDownloadSizes, this.myTreeStructure, this.myRawFullApkSize, this.myCompressedFullApkSize}) {
            if (future == null) continue;
            future.cancel(true);
        }
    }

    @NotNull
    public synchronized ListenableFuture<ArchiveNode> constructTreeStructure() {
        if (this.myTreeStructure == null) {
            this.myTreeStructure = ourExecutorService.submit(this::createTreeNode);
        }
        ListenableFuture<ArchiveNode> listenableFuture = this.myTreeStructure;
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(3);
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<ArchiveNode> updateTreeWithDownloadSizes() {
        if (this.myTreeStructureWithDownloadSizes == null) {
            this.myTreeStructureWithDownloadSizes = Futures.transform(this.constructTreeStructure(), input -> {
                ArchiveTreeStructure.updateDownloadFileSizes((ArchiveNode)input, (ApkSizeCalculator)this.myApkSizeCalculator);
                return input;
            }, (Executor)PooledThreadExecutor.INSTANCE);
        }
        ListenableFuture<ArchiveNode> listenableFuture = this.myTreeStructureWithDownloadSizes;
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(4);
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidApplicationInfo> getApplicationInfo(@NotNull Path pathToAapt, @Nullable ArchiveEntry entry) {
        if (pathToAapt == null) {
            ApkParser.$$$reportNull$$$0(5);
        }
        ListenableFuture listenableFuture = ourExecutorService.submit(() -> {
            if (pathToAapt == null) {
                ApkParser.$$$reportNull$$$0(17);
            }
            return ApkParser.getAppInfo(pathToAapt, entry);
        });
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(6);
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getUncompressedApkSize() {
        if (this.myRawFullApkSize == null) {
            this.myRawFullApkSize = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkRawSize(this.myArchiveContext.getArchive().getPath()));
        }
        ListenableFuture<Long> listenableFuture = this.myRawFullApkSize;
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(7);
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getCompressedFullApkSize() {
        if (this.myCompressedFullApkSize == null) {
            this.myCompressedFullApkSize = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkDownloadSize(this.myArchiveContext.getArchive().getPath()));
        }
        ListenableFuture<Long> listenableFuture = this.myCompressedFullApkSize;
        if (listenableFuture == null) {
            ApkParser.$$$reportNull$$$0(8);
        }
        return listenableFuture;
    }

    @NotNull
    private ArchiveNode createTreeNode() throws IOException {
        ArchiveNode node = ArchiveTreeStructure.create((ArchiveContext)this.myArchiveContext);
        ArchiveTreeStructure.updateRawFileSizes((ArchiveNode)node, (ApkSizeCalculator)this.myApkSizeCalculator);
        ArchiveNode archiveNode = node;
        if (archiveNode == null) {
            ApkParser.$$$reportNull$$$0(9);
        }
        return archiveNode;
    }

    @NotNull
    public static AndroidApplicationInfo getAppInfo(Path pathToAapt, @Nullable Archive archive) {
        if (archive == null) {
            AndroidApplicationInfo androidApplicationInfo = AndroidApplicationInfo.UNKNOWN;
            if (androidApplicationInfo == null) {
                ApkParser.$$$reportNull$$$0(10);
            }
            return androidApplicationInfo;
        }
        Path path = archive.getContentRoot().resolve("AndroidManifest.xml");
        return ApkParser.getAppInfo(pathToAapt, new ArchiveEntry(archive, path, ""));
    }

    @NotNull
    public static AndroidApplicationInfo getAppInfo(Path pathToAapt, @Nullable ArchiveEntry archiveEntry) {
        block7: {
            AndroidApplicationInfo androidApplicationInfo;
            if (archiveEntry == null) {
                AndroidApplicationInfo androidApplicationInfo2 = AndroidApplicationInfo.UNKNOWN;
                if (androidApplicationInfo2 == null) {
                    ApkParser.$$$reportNull$$$0(11);
                }
                return androidApplicationInfo2;
            }
            try {
                if (!(archiveEntry.getArchive() instanceof AppBundleArchive)) break block7;
                androidApplicationInfo = ApkParser.getAppInfoFromAppBundle(archiveEntry);
            }
            catch (Throwable e) {
                Logger.getInstance(ApkViewPanel.class).warn("Unable to retrieve application info from artifact", e);
                AndroidApplicationInfo androidApplicationInfo3 = AndroidApplicationInfo.UNKNOWN;
                if (androidApplicationInfo3 == null) {
                    ApkParser.$$$reportNull$$$0(13);
                }
                return androidApplicationInfo3;
            }
            if (androidApplicationInfo == null) {
                ApkParser.$$$reportNull$$$0(12);
            }
            return androidApplicationInfo;
        }
        return ApkParser.getAppInfoFromApk(pathToAapt, archiveEntry);
    }

    private static AndroidApplicationInfo getAppInfoFromAppBundle(@NotNull ArchiveEntry entry) throws Exception {
        if (entry == null) {
            ApkParser.$$$reportNull$$$0(14);
        }
        byte[] content = Files.readAllBytes(entry.getPath());
        String doc = new ProtoXmlPrettyPrinterImpl().prettyPrint(content);
        byte[] decodedContent = doc.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(decodedContent);){
            ManifestData data = AndroidManifestParser.parse((InputStream)stream);
            AndroidApplicationInfo androidApplicationInfo = new AndroidApplicationInfo(data.getPackage(), data.getVersionName(), (long)data.getVersionCode().intValue());
            return androidApplicationInfo;
        }
    }

    @NotNull
    private static AndroidApplicationInfo getAppInfoFromApk(Path pathToAapt, @NotNull ArchiveEntry archiveEntry) throws ProcessException {
        if (archiveEntry == null) {
            ApkParser.$$$reportNull$$$0(15);
        }
        AaptInvoker invoker = new AaptInvoker(pathToAapt, (ILogger)new LogWrapper(ApkParser.class));
        File archiveFile = archiveEntry.getArchive().getPath().toFile();
        String entryPath = archiveEntry.getPath().toString();
        if (entryPath.startsWith("/")) {
            entryPath = entryPath.substring(1);
        }
        List xmlTree = invoker.getXmlTree(archiveFile, entryPath);
        AndroidApplicationInfo androidApplicationInfo = AndroidApplicationInfo.parse((List)xmlTree);
        if (androidApplicationInfo == null) {
            ApkParser.$$$reportNull$$$0(16);
        }
        return androidApplicationInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sizeCalculator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/github/lizhangqu/intellij/android/bundle/apkview/ApkParser";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToAapt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/github/lizhangqu/intellij/android/bundle/apkview/ApkParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constructTreeStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTreeWithDownloadSizes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncompressedApkSize";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompressedFullApkSize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeNode";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppInfoFromApk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAppInfoFromAppBundle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAppInfoFromApk";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getApplicationInfo$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

