/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.apkview.dex;

import com.android.tools.apk.analyzer.dex.DexDisassembler;
import com.android.tools.apk.analyzer.dex.DexFiles;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.Tree;
import io.github.lizhangqu.intellij.android.bundle.EdtExecutor;
import io.github.lizhangqu.intellij.android.bundle.apkview.dex.DexCodeViewer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.util.ReferenceUtil;

public class ShowDisassemblyAction
extends AnAction
implements DumbAware {
    private final Tree myTree;

    public ShowDisassemblyAction(@NotNull Tree tree) {
        if (tree == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(0);
        }
        super("Show Bytecode", "Show Bytecode", AllIcons.Toolwindows.Documentation);
        this.myTree = tree;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DexElementNode node = this.getSelectedNode();
        if (!ShowDisassemblyAction.canDisassemble(node)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    static boolean canDisassemble(@Nullable DexElementNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof DexClassNode) && !(node instanceof DexMethodNode)) {
            return false;
        }
        if (!node.isDefined()) {
            return false;
        }
        return node.getUserObject() instanceof Path;
    }

    @Nullable
    private DexElementNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionPath();
        Object component = path.getLastPathComponent();
        return component instanceof DexElementNode ? (DexElementNode)component : null;
    }

    public void actionPerformed(final AnActionEvent e) {
        final DexElementNode node = this.getSelectedNode();
        assert (node != null);
        final Project project = ShowDisassemblyAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        ListeningExecutorService pooledThreadExecutor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        Path dexPath = (Path)node.getUserObject();
        ListenableFuture dexFileFuture = pooledThreadExecutor.submit(() -> DexFiles.getDexFile((Path)dexPath));
        Futures.addCallback((ListenableFuture)dexFileFuture, (FutureCallback)new FutureCallback<DexBackedDexFile>(){

            public void onSuccess(@Nullable DexBackedDexFile dexBackedDexFile) {
                String byteCode;
                assert (dexBackedDexFile != null);
                try {
                    byteCode = ShowDisassemblyAction.getByteCode(dexBackedDexFile, node);
                }
                catch (Exception ex) {
                    Messages.showErrorDialog((Project)project, (String)("Unable to get byte code: " + ex.getMessage()), (String)"View Dex Bytecode");
                    return;
                }
                DexCodeViewer component = new DexCodeViewer(project, byteCode);
                JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, null).setProject(project).setDimensionServiceKey(project, ShowDisassemblyAction.class.getName(), false).setResizable(true).setMovable(true).setTitle("DEX Byte Code for " + node.getName()).createPopup();
                Disposer.register((Disposable)popup, (Disposable)component);
                popup.showInBestPositionFor(e.getDataContext());
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                Messages.showErrorDialog((String)("Error constructing dex file: " + t), (String)"View Dex Bytecode");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "io/github/lizhangqu/intellij/android/bundle/apkview/dex/ShowDisassemblyAction$1", "onFailure"));
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    @NotNull
    static String getByteCode(@NotNull DexBackedDexFile dex, @NotNull DexElementNode node) {
        if (dex == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(1);
        }
        if (node == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(2);
        }
        if (node instanceof DexMethodNode) {
            return ShowDisassemblyAction.getByteCodeForMethod(dex, (DexMethodNode)node);
        }
        if (node instanceof DexClassNode) {
            return ShowDisassemblyAction.getByteCodeForClass(dex, (DexClassNode)node);
        }
        throw new RuntimeException("Disassembly only available for methods and classes defined in this dex file");
    }

    @NotNull
    private static String getByteCodeForMethod(@NotNull DexBackedDexFile dex, @NotNull DexMethodNode node) {
        String string;
        MethodReference desc;
        if (dex == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(3);
        }
        if (node == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(4);
        }
        if ((desc = node.getReference()) == null) {
            throw new RuntimeException("Unable to identify method descriptor for " + node.getName());
        }
        try {
            DexClassNode parent = (DexClassNode)node.getParent();
            assert (parent != null) : "Method node must have a parent class";
            string = new DexDisassembler(dex).disassembleMethod(DebuggerUtilsEx.signatureToName((String)parent.getReference().getType()), ReferenceUtil.getMethodDescriptor((MethodReference)desc));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getByteCodeForClass(@NotNull DexBackedDexFile dex, @NotNull DexClassNode node) {
        String string;
        String fqcn;
        if (dex == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(6);
        }
        if (node == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(7);
        }
        if ((fqcn = DebuggerUtilsEx.signatureToName((String)node.getReference().getType())) == null) {
            throw new RuntimeException("Unable to get the fully qualified class name for " + node);
        }
        try {
            string = new DexDisassembler(dex).disassembleClass(fqcn);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            ShowDisassemblyAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dex";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/github/lizhangqu/intellij/android/bundle/apkview/dex/ShowDisassemblyAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/github/lizhangqu/intellij/android/bundle/apkview/dex/ShowDisassemblyAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteCodeForMethod";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteCodeForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getByteCode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getByteCodeForMethod";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getByteCodeForClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

