/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer.dex.tree;

import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;

public abstract class DexElementNode
extends DefaultMutableTreeNode {
    private final String name;
    private final ImmutableReference reference;
    private boolean defined;
    private boolean removed;
    private int methodReferencesCount;
    private int methodDefinitionsCount;

    DexElementNode(String name, boolean allowsChildren) {
        this(name, allowsChildren, null);
    }

    DexElementNode(String name, boolean allowsChildren, ImmutableReference reference) {
        super(null, allowsChildren);
        this.name = name;
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public DexElementNode getChildAt(int i) {
        return (DexElementNode)super.getChildAt(i);
    }

    public void sort(Comparator<DexElementNode> comparator) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            DexElementNode node = this.getChildAt(i);
            node.sort(comparator);
        }
        if (this.children != null) {
            Collections.sort(this.children, comparator);
        }
    }

    public <T extends DexElementNode> T getChildByType(String name, Class<T> type) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            DexElementNode node = this.getChildAt(i);
            if (!name.equals(node.getName()) || !type.equals(node.getClass())) continue;
            return (T)node;
        }
        return null;
    }

    public boolean isSeed(ProguardSeedsMap seedsMap, ProguardMap map, boolean checkChildren) {
        if (seedsMap != null && checkChildren) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                DexElementNode node = this.getChildAt(i);
                if (!node.isSeed(seedsMap, map, checkChildren)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DexElementNode getParent() {
        return (DexElementNode)super.getParent();
    }

    public void update() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            DexElementNode node = this.getChildAt(i);
            node.update();
        }
    }

    protected static String combine(String parentPackage, String childName) {
        return parentPackage.isEmpty() ? childName : parentPackage + "." + childName;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public void setDefined(boolean defined) {
        this.defined = defined;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public int getMethodReferencesCount() {
        return this.methodReferencesCount;
    }

    protected void setMethodReferencesCount(int methodReferencesCount) {
        this.methodReferencesCount = methodReferencesCount;
    }

    public int getMethodDefinitionsCount() {
        return this.methodDefinitionsCount;
    }

    protected void setMethodDefinitionsCount(int methodDefinitionsCount) {
        this.methodDefinitionsCount = methodDefinitionsCount;
    }

    public abstract long getSize();
}

