/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer.dex.tree;

import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import io.github.lizhangqu.intellij.android.bundle.analyzer.dex.PackageTreeCreator;
import io.github.lizhangqu.intellij.android.bundle.analyzer.dex.tree.DexElementNode;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;

public class DexFieldNode
extends DexElementNode {
    private long size;

    public DexFieldNode(String displayName, ImmutableFieldReference reference) {
        super(displayName, false, (ImmutableReference)reference);
    }

    public FieldReference getReference() {
        return (FieldReference)super.getReference();
    }

    @Override
    public boolean isSeed(ProguardSeedsMap seedsMap, ProguardMap map, boolean checkChildren) {
        FieldReference reference;
        if (seedsMap != null && (reference = this.getReference()) != null) {
            String fieldName = PackageTreeCreator.decodeFieldName(reference, map);
            String className = PackageTreeCreator.decodeClassName(reference.getDefiningClass(), map);
            return seedsMap.hasField(className, fieldName);
        }
        return false;
    }

    @Override
    public void update() {
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

