/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer.internal;

import io.github.lizhangqu.intellij.android.bundle.analyzer.ArchiveNode;
import io.github.lizhangqu.intellij.android.bundle.analyzer.internal.ApkEntry;
import java.nio.file.Path;

public class ApkDiffEntry
implements ApkEntry {
    private final String name;
    private final ArchiveNode oldFile;
    private final ArchiveNode newFile;
    private final long oldSize;
    private final long newSize;

    ApkDiffEntry(String name, ArchiveNode oldFile, ArchiveNode newFile, long oldSize, long newSize) {
        if (oldFile == null && newFile == null) {
            throw new IllegalArgumentException("Both files can't be null");
        }
        this.name = name;
        this.oldFile = oldFile;
        this.newFile = newFile;
        this.oldSize = oldSize;
        this.newSize = newSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getPath() {
        assert (this.oldFile != null || this.newFile != null);
        return this.oldFile != null ? this.oldFile.getData().getPath() : this.newFile.getData().getPath();
    }

    @Override
    public long getSize() {
        return this.newSize - this.oldSize;
    }

    public long getOldSize() {
        return this.oldSize;
    }

    public long getNewSize() {
        return this.newSize;
    }

    public static long getOldSize(ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getOldSize();
        }
        return apkEntry.getSize();
    }

    public static long getNewSize(ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getNewSize();
        }
        return apkEntry.getSize();
    }

    public String toString() {
        return this.getName();
    }
}

