/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.intellij.android.bundle.analyzer.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;

public interface ApkEntry {
    public static ApkEntry fromNode(Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ApkEntry)) {
            return null;
        }
        return (ApkEntry)userObject;
    }

    public static void sort(DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            children.add((DefaultMutableTreeNode)node.getChildAt(i));
        }
        Collections.sort(children, (o1, o2) -> {
            ApkEntry entry1 = ApkEntry.fromNode(o1);
            ApkEntry entry2 = ApkEntry.fromNode(o2);
            if (entry1 == null || entry2 == null) {
                return 0;
            }
            return Long.compare(entry2.getSize(), entry1.getSize());
        });
        node.removeAllChildren();
        for (DefaultMutableTreeNode child : children) {
            node.add(child);
        }
    }

    public String getName();

    public Path getPath();

    public long getSize();
}

