/*
 * keccak_1600 function
 * C. Buchner 2014 
 *
 */

__constant static const sph_u64 RC[] = {
  SPH_C64(0x0000000000000001), SPH_C64(0x0000000000008082),
  SPH_C64(0x800000000000808A), SPH_C64(0x8000000080008000),
  SPH_C64(0x000000000000808B), SPH_C64(0x0000000080000001),
  SPH_C64(0x8000000080008081), SPH_C64(0x8000000000008009),
  SPH_C64(0x000000000000008A), SPH_C64(0x0000000000000088),
  SPH_C64(0x0000000080008009), SPH_C64(0x000000008000000A),
  SPH_C64(0x000000008000808B), SPH_C64(0x800000000000008B),
  SPH_C64(0x8000000000008089), SPH_C64(0x8000000000008003),
  SPH_C64(0x8000000000008002), SPH_C64(0x8000000000000080),
  SPH_C64(0x000000000000800A), SPH_C64(0x800000008000000A),
  SPH_C64(0x8000000080008081), SPH_C64(0x8000000000008080),
  SPH_C64(0x0000000080000001), SPH_C64(0x8000000080008008)
};


inline void keccak_block(ulong *s) {
	size_t i;
	ulong t[5], u[5], v, w;

	for (i = 0; i < 24; i++) {
		/* theta: c = a[0,i] ^ a[1,i] ^ .. a[4,i] */
		t[0] = s[0] ^ s[5] ^ s[10] ^ s[15] ^ s[20];
		t[1] = s[1] ^ s[6] ^ s[11] ^ s[16] ^ s[21];
		t[2] = s[2] ^ s[7] ^ s[12] ^ s[17] ^ s[22];
		t[3] = s[3] ^ s[8] ^ s[13] ^ s[18] ^ s[23];
		t[4] = s[4] ^ s[9] ^ s[14] ^ s[19] ^ s[24];

		/* theta: d[i] = c[i+4] ^ rotl(c[i+1],1) */
		u[0] = t[4] ^ SPH_ROTL64(t[1], 1);
		u[1] = t[0] ^ SPH_ROTL64(t[2], 1);
		u[2] = t[1] ^ SPH_ROTL64(t[3], 1);
		u[3] = t[2] ^ SPH_ROTL64(t[4], 1);
		u[4] = t[3] ^ SPH_ROTL64(t[0], 1);

		/* theta: a[0,i], a[1,i], .. a[4,i] ^= d[i] */
		s[0] ^= u[0]; s[5] ^= u[0]; s[10] ^= u[0]; s[15] ^= u[0]; s[20] ^= u[0];
		s[1] ^= u[1]; s[6] ^= u[1]; s[11] ^= u[1]; s[16] ^= u[1]; s[21] ^= u[1];
		s[2] ^= u[2]; s[7] ^= u[2]; s[12] ^= u[2]; s[17] ^= u[2]; s[22] ^= u[2];
		s[3] ^= u[3]; s[8] ^= u[3]; s[13] ^= u[3]; s[18] ^= u[3]; s[23] ^= u[3];
		s[4] ^= u[4]; s[9] ^= u[4]; s[14] ^= u[4]; s[19] ^= u[4]; s[24] ^= u[4];

		/* rho pi: b[..] = rotl(a[..], ..) */
		v = s[1];
		s[1] = SPH_ROTL64(s[6], 44);
		s[6] = SPH_ROTL64(s[9], 20);
		s[9] = SPH_ROTL64(s[22], 61);
		s[22] = SPH_ROTL64(s[14], 39);
		s[14] = SPH_ROTL64(s[20], 18);
		s[20] = SPH_ROTL64(s[2], 62);
		s[2] = SPH_ROTL64(s[12], 43);
		s[12] = SPH_ROTL64(s[13], 25);
		s[13] = SPH_ROTL64(s[19], 8);
		s[19] = SPH_ROTL64(s[23], 56);
		s[23] = SPH_ROTL64(s[15], 41);
		s[15] = SPH_ROTL64(s[4], 27);
		s[4] = SPH_ROTL64(s[24], 14);
		s[24] = SPH_ROTL64(s[21], 2);
		s[21] = SPH_ROTL64(s[8], 55);
		s[8] = SPH_ROTL64(s[16], 45);
		s[16] = SPH_ROTL64(s[5], 36);
		s[5] = SPH_ROTL64(s[3], 28);
		s[3] = SPH_ROTL64(s[18], 21);
		s[18] = SPH_ROTL64(s[17], 15);
		s[17] = SPH_ROTL64(s[11], 10);
		s[11] = SPH_ROTL64(s[7], 6);
		s[7] = SPH_ROTL64(s[10], 3);
		s[10] = SPH_ROTL64(v, 1);

		v = s[0]; w = s[1]; s[0] ^= (~w) & s[2]; s[1] ^= (~s[2]) & s[3]; s[2] ^= (~s[3]) & s[4]; s[3] ^= (~s[4]) & v; s[4] ^= (~v) & w;
		v = s[5]; w = s[6]; s[5] ^= (~w) & s[7]; s[6] ^= (~s[7]) & s[8]; s[7] ^= (~s[8]) & s[9]; s[8] ^= (~s[9]) & v; s[9] ^= (~v) & w;
		v = s[10]; w = s[11]; s[10] ^= (~w) & s[12]; s[11] ^= (~s[12]) & s[13]; s[12] ^= (~s[13]) & s[14]; s[13] ^= (~s[14]) & v; s[14] ^= (~v) & w;
		v = s[15]; w = s[16]; s[15] ^= (~w) & s[17]; s[16] ^= (~s[17]) & s[18]; s[17] ^= (~s[18]) & s[19]; s[18] ^= (~s[19]) & v; s[19] ^= (~v) & w;
		v = s[20]; w = s[21]; s[20] ^= (~w) & s[22]; s[21] ^= (~s[22]) & s[23]; s[22] ^= (~s[23]) & s[24]; s[23] ^= (~s[24]) & v; s[24] ^= (~v) & w;

		s[0] ^= RC[i];
	}
};