# -*- coding: UTF-8 -*-
import sys,re,os
from urlparse import parse_qsl
import base64
import urllib
import urllib2
import urllib3
import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc
import json
import cookielib
import traceback
import urlparse

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.audio.storytel')

PATH            = addon.getAddonInfo('path')
DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'

FANART=RESOURCES+'fanart.jpg'
sys.path.append( os.path.join( RESOURCES, "lib" ) )
import pyaes

exlink = params.get('url', None)
name= params.get('name', None)
rys= params.get('image', None)

UA= 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0'
TIMEOUT=15

#s = requests.Session()

def build_url(query):
    return base_url + '?' + urllib.urlencode(query)

def add_item(url, name, image, mode, folder=False, IsPlayable=False, infoLabels=False, movie=True,itemcount=1, page=1,fanart=FANART,moviescount=0):
	list_item = xbmcgui.ListItem(label=name)

	if IsPlayable:
		list_item.setProperty("IsPlayable", 'True')
	if not infoLabels:
		infoLabels={'title': name,'plot':name}
	list_item.setInfo(type="video", infoLabels=infoLabels)	
	
	art_keys = ['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
	art = dict(zip(art_keys,[image for x in art_keys]))
	art['landscape'] = fanart if fanart else art['landscape']
	art['fanart'] = fanart if fanart else art['landscape']
	list_item.setArt(art)
	if 'Następna strona' not in infoLabels.get('title',''):
		isp = []
		isp.append(('Informacja', 'XBMC.Action(Info)'),)
		list_item.addContextMenuItems(isp, replaceItems=False)
	
	
	ok=xbmcplugin.addDirectoryItem(
		handle=addon_handle,
		url = build_url({'mode': mode, 'url' : url, 'page' : page, 'moviescount' : moviescount,'movie':movie,'name':name,'image':image}),			
		listitem=list_item,
		isFolder=folder)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %D, %P")
	return ok

def home():	
	a = getLogin()
	if a:
		add_item('https://www.storytel.se/api/getCategories.action', '[B][COLOR khaki]Kategorie[/COLOR][/B]', 'http://www.techpage.pl/wp-content/uploads/2016/02/storytel-logo-600x648.png', "listKateg", folder=True,fanart=RESOURCES+'fanart.png')
		add_item('https://www.storytel.se/api/getFeaturedLists.action', '[B][COLOR khaki]Polecane[/COLOR][/B]', 'http://www.techpage.pl/wp-content/uploads/2016/02/storytel-logo-600x648.png', "listKategList", folder=True,fanart=RESOURCES+'fanart.png')
		add_item('https://www.storytel.se/api/getFeaturedLists.action', '[B][COLOR khaki]Serie[/COLOR][/B]', 'http://www.techpage.pl/wp-content/uploads/2016/02/storytel-logo-600x648.png', 'listSeries', folder=True,fanart=RESOURCES+'fanart.png')
		add_item('', '[B][COLOR khaki]Szukaj[/COLOR][/B]', 'http://www.techpage.pl/wp-content/uploads/2016/02/storytel-logo-600x648.png', 'wyszukaj', folder=True,fanart=RESOURCES+'fanart.png')
	else:
		add_item('', '[B][COLOR khaki]Zaloguj[/COLOR][/B]', 'http://www.techpage.pl/wp-content/uploads/2016/02/storytel-logo-600x648.png', "Opcje", IsPlayable = False, folder=False,fanart=RESOURCES+'fanart.png')
		
		
def gen_hex_code(myrange=6):
	import random
	return ''.join([random.choice('0123456789abcdef') for x in range(myrange)])

def device_id():
	deviceid = gen_hex_code(8) + '-' + gen_hex_code(4) + '-' + gen_hex_code(4) + '-' + gen_hex_code(4) + '-' + gen_hex_code(12)
	return deviceid
	
	
def getLogin():
	u = addon.getSetting('user')
	p = addon.getSetting('pass')
	l = addon.getSetting('login')
	logged=False
	if u and p and l == 'true':
		pwdaes=qualityv = addon.getSetting('pwdaes')
		token = addon.getSetting('token')
		dev_id = addon.getSetting('dev_id')
		if (dev_id == ''):
			devid = device_id()
			addon.setSetting('dev_id',devid)
			dev_id = addon.getSetting('dev_id')

		key='56515a424a365444384d395742555754'
		key=key.decode('hex')
		iv= '6a6f6977656630387532336a33343161'
		iv=iv.decode('hex')
		decrypter = pyaes.Encrypter(pyaes.AESModeOfOperationCBC(key, iv = iv))
		hasloaes = decrypter.feed(p)
		hasloaes  += decrypter.feed()
		hasloaes=(hasloaes.encode('hex')).upper()
		if not pwdaes == hasloaes:
			addon.setSetting('pwdaes',hasloaes)
			pwdaes = addon.getSetting('pwdaes')
		#
		headers = {
			'accept-encoding': 'gzip',
			'cache-control': 'public, max-stale=2419200',
			'connection': 'Keep-Alive',
			'user-agent': 'okhttp/3.12.0',
		}
		
		params = (
			('m', '1'),
			('uid', u),
			('pwd', pwdaes),
			('token', 'guestpl'),
			('userid', '-1'),
			('version', '5.13.5'),
			('terminal', 'android'),
			('locale', 'pl'),
			('kidsMode', 'false'),
			('deviceId', dev_id),)

		
		response = requests.get('https://www.storytel.se/api/login.action', headers=headers, params=params).json()
		if response['message']:
			
			if (response['message']).lower()=='wrong password':
				xbmcgui.Dialog().notification('[B]Nieudane logowanie[/B]', 'Sprawdź login i hasło w ustawieniach wtyczki.',xbmcgui.NOTIFICATION_INFO, 6000)
				return logged
			else:
			
				addon.setSetting('premka','premium')
		else:
			addon.setSetting('premka','darmowe')

		token=response['accountInfo']['singleSignToken']
		addon.setSetting('token',token)
		bearer=response['accountInfo']['jwt']
		addon.setSetting('bearer',bearer)
		userid=response['accountInfo']['userId']
		addon.setSetting('userid','%s'%userid)
		logged = True
	return logged

def PLchar(char):
	if type(char) is not str:
		char=char.encode('utf-8')
	char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
	char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
	char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
	char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
	char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
	char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
	char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
	char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
	char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
	char = char.replace('&#8217;',"'")
	char = char.replace('&#8211;',"-")	
	char = char.replace('&#8230;',"...")	
	char = char.replace('&#8222;','"').replace('&#8221;','"')	
	char = char.replace('[&hellip;]',"...")
	char = char.replace('&#038;',"&")	
	char = char.replace('&#039;',"'")
	char = char.replace('&quot;','"')
	char = char.replace('&nbsp;',".").replace('&amp;','&')
	return char	

def Wyszukaj(qq):
	token = addon.getSetting('token')
	dev_id = addon.getSetting('dev_id')
	bearer = addon.getSetting('bearer')
	usrid = addon.getSetting('userid')
	prem = addon.getSetting('premka')
	headers = {
		'accept-encoding': 'gzip',
		'authorization': 'Bearer %s'%bearer,
		'cache-control': 'only-if-cached',
		'connection': 'Keep-Alive',
		'user-agent': 'okhttp/3.12.0',
	}
	
	params = (
		('q', qq),
		('filters', 'A:1,E:0,pl:1,en:1'),
		('token', token),
		('userid', usrid),
		('version', '5.13.5'),
		('terminal', 'android'),
		('locale', 'pl'),
		('kidsMode', 'false'),
		('deviceId', dev_id),)

	out=[]
	response = requests.get('https://www.storytel.se/api/search.action', headers=headers, params=params).json()
	for data in response['books']:
		try:
			code = data['book']['series'][0]['name']
		except:
			code = ''
		img =  data['book']['largeCover']
		img=re.sub('(\d+x\d+)', '640x640', img)
		src ='https://www.storytel.se'+img
		title =  PLchar(data['book']['name'])
		plot =  PLchar(data['abook']['description'])
		href =  data['abook']['id']

		if prem=='premium':
			aa= data['abook']['lengthInHHMM']
			dur =':'.join(re.findall('(\d+)',aa))
			duration = getDuration(dur) if dur else ''
		else:
			duration = 180
		film = {
			'href'   : href,
			'title'  : title,
			'plot'   : plot,
			'code'   : code,
			'duration' : duration,
			'img'    : src}
		out.append(film)
	if out:
		itemz=out
		items = len(out)
		for f in itemz:
			add_item(name=f.get('title'), url=f.get('href'), mode='playBook', image=f.get('img'), IsPlayable=True, folder=False, infoLabels=f, itemcount=items,fanart=f.get('img'))	
		
		xbmcplugin.setContent(addon_handle, 'videos')
		xbmcplugin.endOfDirectory(addon_handle)	
	else:
		xbmcgui.Dialog().notification('[B]Niestety[/B]', 'Brak materiału do wyświetlenia',xbmcgui.NOTIFICATION_INFO, 6000)
		
def ListSeries():
	series = getSeries()
	itemz=series 
	items = len(series)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listSerBooks', image=f.get('img'), folder=True, infoLabels=f, itemcount=items,fanart=f.get('img'))	
	
	xbmcplugin.setContent(addon_handle, 'videos')
	xbmcplugin.endOfDirectory(addon_handle)	
	
def getSeries():
	token = addon.getSetting('token')
	dev_id = addon.getSetting('dev_id')
	bearer = addon.getSetting('bearer')
	usrid = addon.getSetting('userid')
	prem = addon.getSetting('premka')
	headers = {
		'accept-encoding': 'gzip',
		'authorization': 'Bearer %s'%bearer,
		'cache-control': 'only-if-cached',
		'connection': 'Keep-Alive',
		'user-agent': 'okhttp/3.12.0',
	}
	
	params = (
		('token', token),
		('userid', usrid),
		('version', '5.13.5'),
		('terminal', 'android'),
		('locale', 'pl'),
		('kidsMode', 'false'),
		('deviceId', dev_id),)

	out=[]
	response = requests.get('https://www.storytel.se/api/getSeriesDefs.action', headers=headers, params=params).json()
	for data in response["seriesDefs"]:
		href= data['seriesId']
		plot= PLchar(data['description'])
		src =  data['imageUrl']
		src = 'https://www.storytel.se'+src
		title =  PLchar(data['name'])
		href='%s|%s'%(href,title)
		film = {
			'href'   : href,
			'title'  : title,
			'plot'   : plot,
			'img'    : src}
		out.append(film)
	return out

def PlayBook(url):
	usrid= addon.getSetting('userid')
	token = addon.getSetting('token')
	usrag='Storytel/5.13.5 (Linux;Android 4.4.2) ExoPlayerLib/1.5.11'

	pth='https://www.storytel.se/mp3streamRangeReq/?startposition=0&programId='+url+'&token='+token+'&userid='+usrid+'&locale=pl&version=5.13.5&terminal=android|User-Agent='+urllib.quote(usrag)+'&connection=Keep-Alive'+'&accept-encoding=identity'

	xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=pth))
	
def ListBooks(url):

	books,npage = getBooks(url)	
	itemz=books
	items = len(books)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='playBook', image=f.get('img'), IsPlayable=True, folder=False, infoLabels=f, itemcount=items,fanart=f.get('img'))	
	if npage:
		for f in npage:	
			add_item(name=f.get('title'), url=f.get('href'), mode='listBooks', image=f.get('img'), folder=True, infoLabels=f, itemcount=items,fanart=f.get('img'))	

	xbmcplugin.setContent(addon_handle, 'videos')
	xbmcplugin.endOfDirectory(addon_handle)	

getDuration = lambda duration: sum([a*b for a,b in zip([60,3600], map(int,duration.split(':')[::-1]))])
def ListSerBooks(url):
	books,npage = getSerBooks(url)	
	itemz=books
	items = len(books)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='playBook', image=f.get('img'), IsPlayable=True, folder=False, infoLabels=f, itemcount=items,fanart=f.get('img'))	
	if npage:
		for f in npage:	
			add_item(name=f.get('title'), url=f.get('href'), mode='listBooks', image=f.get('img'), folder=True, infoLabels=f, itemcount=items,fanart=f.get('img'))	
	xbmcplugin.setContent(addon_handle, 'videos')

	xbmcplugin.endOfDirectory(addon_handle)	
def getSerBooks(url):

	token = addon.getSetting('token')
	dev_id = addon.getSetting('dev_id')
	bearer = addon.getSetting('bearer')
	usrid = addon.getSetting('userid')
	prem = addon.getSetting('premka')
	headers = {
		'accept-encoding': 'gzip',
		'authorization': 'Bearer %s'%bearer,
		'cache-control': 'only-if-cached',
		'connection': 'Keep-Alive',
		'user-agent': 'okhttp/3.12.0',
	}
	if '/api/' in url:
		dane=re.findall('filterValues=(.+?)&start=(\d+)&hits=(\d+)',url)[0]
		fval=dane[0]
		strt=dane[1]
		hits=dane[2]

		params = (
			('orderBy', 'NOTHING'),
			('filterKeys', 'LIST_ID'),
			('filterValues', fval),
			('start', strt),
			('hits', hits),
			('hideTitle', 'false'),
			('filters', 'A:1,E:0,pl:1,en:1'),
			('token', token),
			('userid', usrid),
			('version', '5.13.5'),
			('terminal', 'android'),
			('locale', 'pl'),
			('kidsMode', 'false'),
			('deviceId', dev_id),
		)
	else:
		urlk=url.split('|')
		fval = urlk[0]
		listid = urlk[1]
		params = (
			('orderBy', 'SERIES_ORDER'),
			('filterKeys', 'SERIES'),
			('filterValues', fval),
			('listTitle', listid),
			('filters', 'A:1,E:0,pl:1,en:1'),
			('hits', '30'),
			('token', token),
			('userid', usrid),
			('version', '5.13.5'),
			('terminal', 'android'),
			('locale', 'pl'),
			('kidsMode', 'false'),
			('deviceId', dev_id),
		)

	out = []
	npout = []
	response = requests.get('https://www.storytel.se/api/getSmartList.action', headers=headers, params=params).json()

	aa=response["loadMoreUrl"]
	if aa:
		npout.append({'title':'NEXT_PAGE','href':aa,'img':'','plot':''})
	for data in response['books']:
		try:
			code = data['book']['series'][0]['name']
		except:
			code = ''
		img =  data['book']['largeCover']
		img=re.sub('(\d+x\d+)', '640x640', img)
		src ='https://www.storytel.se'+img
		title =  PLchar(data['book']['name'])
		plot =  PLchar(data['abook']['description'])
		href =  data['abook']['id']

		if prem=='premium':
			aa= data['abook']['lengthInHHMM']
			dur =':'.join(re.findall('(\d+)',aa))
			duration = getDuration(dur) if dur else ''
		else:
			duration = 180
		film = {
			'href'   : href,
			'title'  : title,
			'plot'   : plot,
			'code'   : code,
			'duration' : duration,
			'img'    : src}
		out.append(film)
	return out,npout


def getBooks(url):

	token = addon.getSetting('token')
	dev_id = addon.getSetting('dev_id')
	bearer = addon.getSetting('bearer')
	usrid = addon.getSetting('userid')
	prem = addon.getSetting('premka')
	headers = {
		'accept-encoding': 'gzip',
		'authorization': 'Bearer %s'%bearer,
		'cache-control': 'only-if-cached',
		'connection': 'Keep-Alive',
		'user-agent': 'okhttp/3.12.0',
	}
	if '/api/' in url:
		dane=re.findall('filterValues=(.+?)&start=(\d+)&hits=(\d+)',url)[0]
		fval=dane[0]
		strt=dane[1]
		hits=dane[2]
		params = (
			('orderBy', 'NOTHING'),
			('filterKeys', 'LIST_ID'),
			('filterValues', fval),
			('start', strt),
			('hits', hits),
			('hideTitle', 'false'),
			('filters', 'A:1,E:0,pl:1,en:1'),
			('token', token),
			('userid', usrid),
			('version', '5.13.5'),
			('terminal', 'android'),
			('locale', 'pl'),
			('kidsMode', 'false'),
			('deviceId', dev_id),
		)
	else:
		urlk=url.split('|')
		fval = urlk[0]
		listid = urlk[1]
		params = (
			('orderBy', 'NOTHING'),
			('filterKeys', 'LIST_ID'),
			('filterValues', fval),
			('listIdentifier', listid),
			('hideTitle', 'false'),
			('filters', 'A:1,E:0,pl:1,en:1'),
			('token', token),
			('userid', usrid),
			('version', '5.13.5'),
			('terminal', 'android'),
			('locale', 'pl'),
			('kidsMode', 'false'),
			('deviceId', dev_id),
		)
	out = []
	npout = []
	response = requests.get('https://www.storytel.se/api/getSmartList.action', headers=headers, params=params).json()
	aa=response["loadMoreUrl"]
	if aa:
		npout.append({'title':'NEXT_PAGE','href':aa,'img':'','plot':''})
	for data in response['books']:
		try:
			code = data['book']['series'][0]['name']
		except:
			code = ''
		img =  data['book']['largeCover']
		img=re.sub('(\d+x\d+)', '640x640', img)
		src ='https://www.storytel.se'+img
		title =  PLchar(data['book']['name'])
		plot =  PLchar(data['abook']['description'])
		href =  data['abook']['id']

		if prem=='premium':
			aa= data['abook']['lengthInHHMM']
			dur =':'.join(re.findall('(\d+)',aa))
			duration = getDuration(dur) if dur else ''
		else:
			duration = 180
		film = {
			'href'   : href,
			'title'  : title,
			'plot'   : plot,
			'code'   : code,
			'duration' : duration,
			'img'    : src}
		out.append(film)
	return out,npout
	
def ListKategList(url,rys):	
	content = getKategList(url,rys)	
	itemz=content
	items = len(content)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listBooks', image=f.get('img'), folder=True, infoLabels=f, itemcount=items,fanart=f.get('img'))	

	xbmcplugin.endOfDirectory(addon_handle)	
	
def getKategList(url,imag):
	token = addon.getSetting('token')
	dev_id = addon.getSetting('dev_id')
	bearer = addon.getSetting('bearer')
	usrid = addon.getSetting('userid')
	headers = {
		'accept-encoding': 'gzip',
		'authorization': 'Bearer %s'%bearer,
		'cache-control': 'only-if-cached',
		'connection': 'Keep-Alive',
		'user-agent': 'okhttp/3.12.0',
	}


	params = (
		('categoryId', url),
		('token', token),
		('userid', usrid),
		('version', '5.13.5'),
		('terminal', 'android'),
		('locale', 'pl'),
		('kidsMode', 'false'),
		('deviceId', dev_id),)

	out=[]
	if 'getFeaturedLists' in url:
		response = requests.get(url, headers=headers, params=params).json()
	else:
		response = requests.get('https://www.storytel.se/api/getCategoryLists.action', headers=headers, params=params).json()
	for data in response['data']:
		src = 'http://www.techpage.pl/wp-content/uploads/2016/02/storytel-logo-600x648.png'#imag #
		title = PLchar(data['title']) #
		if title =='':
	
			src = data['absoluteImgUrl']
		listurl = data['listUrl']
		
		try:
			dal=re.findall('filterValues=(.+?)&listIdentifier=(.+?)&listTitle',listurl,re.DOTALL)[0]
			href = '|'.join(dal)	
			film = {
				'href'   : href,
				'title'  : title,
				'plot'   : '',
				'img'    : src}
			out.append(film)
		except:
			pass
		
		
		#dal=re.findall('filterValues=(.+?)&listIdentifier=(.+?)&listTitle',listurl,re.DOTALL)[0]
		#href = '|'.join(dal)	
		#film = {
		#	'href'   : href,
		#	'title'  : title,
		#	'plot'   : '',
		#	'img'    : src}
		#out.append(film)
	return out
	
def ListKateg(url):
	kategorie = getKateg(url)
	itemz=kategorie
	items = len(kategorie)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listKategList', image=f.get('img'), folder=True, infoLabels=f, itemcount=items,fanart=f.get('img'))	

	xbmcplugin.endOfDirectory(addon_handle)	
def getKateg(url):
	token = addon.getSetting('token')
	dev_id = addon.getSetting('dev_id')
	bearer = addon.getSetting('bearer')
	usrid = addon.getSetting('userid')
	headers = {
		'accept-encoding': 'gzip',
		'authorization': 'Bearer %s'%bearer,
		'cache-control': 'only-if-cached',
		'connection': 'Keep-Alive',
		'user-agent': 'okhttp/3.12.0',
	}

	params = (
		('token', token),
		('userid', usrid),
		('version', '5.13.5'),
		('terminal', 'android'),
		('locale', 'pl'),
		('filters', 'A:1,E:0,pl:1,en:1'),
		('kidsMode', 'false'),
		('deviceId', dev_id),
	)

	response = requests.get(url, headers=headers, params=params).json()
	out=[]

	for data in response.get('categorys',''):
		src = data['bannerUrl'] #
		title = PLchar(data['title']) #
		href = data['id'] #
		film = {
			'href'   : href,
			'title'  : title,
			'plot'   : '',
			'img'    : src}
		out.append(film)
	return out	
	
if __name__ == '__main__':
	mode = params.get('mode', None)
	
	if not mode:
		home()
		xbmcplugin.endOfDirectory(addon_handle)		

	elif mode == 'Opcje':
		addon.openSettings()
		xbmc.executebuiltin('XBMC.Container.Refresh()')
		#xbmcplugin.endOfDirectory(addon_handle,True)
	elif mode == 'listKateg':
		ListKateg(exlink)
		#xbmcplugin.setContent(addon_handle, 'videos')	
		xbmcplugin.endOfDirectory(addon_handle,True)
	elif mode == 'listKategList':
		ListKategList(exlink,rys)
		#xbmcplugin.setContent(addon_handle, 'videos')	
		xbmcplugin.endOfDirectory(addon_handle,True)
	elif mode == 'listBooks':
		ListBooks(exlink)
		#xbmcplugin.setContent(addon_handle, 'videos')	
		xbmcplugin.endOfDirectory(addon_handle,True)
	elif mode == 'playBook':
		PlayBook(exlink)
	elif mode == 'listSeries':
		ListSeries()
		#xbmcplugin.setContent(addon_handle, 'videos')	
		xbmcplugin.endOfDirectory(addon_handle,True)
	elif mode == 'listSerBooks':
		ListSerBooks(exlink)
		#xbmcplugin.setContent(addon_handle, 'videos')	
		xbmcplugin.endOfDirectory(addon_handle,True)
	elif mode == 'wyszukaj':
		qq = xbmcgui.Dialog().input(u'Szukaj, Podaj tytuł filmu/serialu', type=xbmcgui.INPUT_ALPHANUM)
		if qq:
			qq=qq.replace(' ','+')
			Wyszukaj(qq)
