# -*- coding: UTF-8 -*-

import sys, os, re, json, base64, math, random
PY3 = sys.version_info >= (3,0,0)

if PY3:
# for Python 3
	to_unicode = str

	from urllib.parse import unquote, parse_qs, parse_qsl, quote, urlencode, quote_plus

else:
	# for Python 2
	to_unicode = unicode

	from urllib import unquote, quote, urlencode, quote_plus
	from urlparse import parse_qsl, parse_qs
	
import io

import xbmc, xbmcvfs

import requests
import xbmcgui
import xbmcplugin
import xbmcaddon

import inputstreamhelper

#urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.35mmonline')

PATH			= addon.getAddonInfo('path')
try:
	DATAPATH		= xbmcvfs.translatePath(addon.getAddonInfo('profile'))
except:
	DATAPATH	= xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
	
if not os.path.exists(DATAPATH):
	os.makedirs(DATAPATH)
napisy = os.path.join(DATAPATH,'napisy')


RESOURCES	   = PATH+'/resources/'
ikonaempty = RESOURCES+'empty.png'
ikona = RESOURCES+'../icon.png'
FANART=RESOURCES+'../fanart.jpg'

exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)
page = params.get('page',[1])[0]

wybornapisow =  addon.getSetting('wybornapisow')  
wybornapisow =  True if wybornapisow == 'true' else False



sess = requests.Session()

headers = {
	'Host': 'cms.35mm.online',
	'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:92.0) Gecko/20100101 Firefox/92.0',
	'accept': 'application/json, text/plain, */*',
	'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
	'x-language': 'pl-pl',
	'embedcode': 'null',
	'origin': 'https://35mm.online',
	'dnt': '1',
	'referer': 'https://35mm.online/',
	'sec-fetch-dest': 'empty',
	'sec-fetch-mode': 'cors',
	'sec-fetch-site': 'same-site',
	'te': 'trailers',
}



def build_url(query):

	return base_url + '?' + urlencode(query)

def add_item(url, name, image, mode, folder=False, IsPlayable=False, infoLabels=False, contextmenu=None,itemcount=1, page=1,fanart=FANART,moviescount=0):
	list_item = xbmcgui.ListItem(label=name)

	if IsPlayable:
		list_item.setProperty("IsPlayable", 'True')
	if not infoLabels:
		infoLabels={'title': name,'plot':name}
	if contextmenu:
		out=contextmenu
		list_item.addContextMenuItems(out, replaceItems=True)
	list_item.setInfo(type="video", infoLabels=infoLabels)	
	list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'icon': image, 'fanart': FANART})
	ok=xbmcplugin.addDirectoryItem(
		handle=addon_handle,
		url = build_url({'mode': mode, 'url' : url, 'page' : page, 'moviescount' : moviescount,'title':name,'image':image}),			
		listitem=list_item,
		isFolder=folder)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
	return ok

def home():
	add_item('https://35mm.online/vod/fabula/', 'FABUŁA', 'DefaultMovies.png', "listcontent", True)
	add_item('https://35mm.online/vod/dokument/', 'DOKUMENT', 'DefaultMovies.png', "listcontent", True)
	add_item('https://35mm.online/vod/kroniki/', 'KRONIKI', 'DefaultMovies.png', "listcontent", True)
	add_item('https://35mm.online/vod/animacja/', 'ANIMACJE', 'DefaultMovies.png', "listcontent", True)
	add_item('https://35mm.online/kolekcje/kolekcje/', 'KOLEKCJE', 'DefaultMovies.png', "listcontent", True)
	add_item('https://35mm.online/vod/dla-dzieci/', "DLA DZIECI", 'DefaultMovies.png', "listcontent", True)

	xbmcplugin.endOfDirectory(addon_handle)
 


def ListContent(url,pg,srch=''):

	
	headers.update({'x-origin-url': url})
	response = sess.get('https://cms.35mm.online/umbraco/api/content', headers=headers,verify=False)
	zz=''
	ab=response.json()

	parentIDval =''
	try:
		filters = (response.json()).get('content',None).get('listView',None).get('filters',None)
	except:
		filters = None
	if filters:
		for filter in filters:
			ac=''

			if filter.get('field',None) == 'parentID':

				parentID = 'parentID.%s'%(to_unicode(filter.get('type',None)))
				minparent = to_unicode(filter.get('value',None).get('min',None))
				maxparent = to_unicode(filter.get('value',None).get('max',None))
				
				parentIDval = parentID+'=%s,%s'%(minparent,maxparent)
				parentIDv = '%s,%s'%(minparent,maxparent)

				break

	if parentIDval:
		sortparentn = addon.getSetting(parentIDv+'sortn')
		lataparentn = addon.getSetting(parentIDv+'latan')
		if not sortparentn:
			addon.setSetting(parentIDv+'sortn','alfabetycznie rosnąco')
			addon.setSetting(parentIDv+'sortv','0')
			
		if not lataparentn:
			addon.setSetting(parentIDv+'latan','1940,2021')
			addon.setSetting(parentIDv+'latav','1940,2021')

		sortparentn = addon.getSetting(parentIDv+'sortn')
		lataparentn = addon.getSetting(parentIDv+'latan')

		url = 'https://cms.35mm.online/umbraco/api/search?page=1&limit=48&%s'%(parentIDval)

		tyt2 = 'Wyświetl materiały dla [COLOR gold]%s [/COLOR]'%nazwa
		add_item(name=tyt2, url=parentIDv, mode='listlista', image='', folder=True, infoLabels={'plot':tyt2,'title':tyt2})
		add_item(str(parentIDv), "-    [COLOR lightblue]sortowanie:[/COLOR] [B]"+sortparentn+'[/B]','DefaultRecentlyAddedMovies.png', 'filtr:%ssort'%(str(parentIDv)), folder=False,fanart='')
		add_item(str(parentIDv), "-    [COLOR lightblue]lata:[/COLOR] [B]"+lataparentn+'[/B]','DefaultRecentlyAddedMovies.png', 'filtr:%slata'%(str(parentIDv)), folder=False,fanart='')
		add_item(parentIDv, '-    [B][COLOR lightblue]Szukaj w [/COLOR][COLOR gold]%s [/COLOR][/B]'%nazwa, 'DefaultAddonsSearch.png', "search", True)
		add_item(parentIDv, '......................................................................', ikonaempty, "   ", False)

	items = (response.json()).get('content',None).get('items',None)
	
	
	zz=''
	for item in items:
		if item.get('alias',None) == 'boxItems':
		
			value = item.get('value',None)

			if value.get('header',None):
				ac=''

				ad=''
				dane = quote(json.dumps(value.get('items',None)))
				tytul=(value.get('header',None)).encode('utf-8')
				add_item(name=tytul, url=dane, mode='listdane', image='', folder=True, infoLabels={'plot':tytul,'title':tytul})	
			else:
				try:
					items2 =  item.get('value',None).get('items',None)

					for item2 in items2:
						tytul=(item2.get('title',None)).encode('utf-8')
						description=(item2.get('description',None)).encode('utf-8')
						img = (item2.get('image',None).get('url',None)).encode('utf-8')
						hurl = 'https://35mm.online'+item2.get('url',None)
						add_item(name=tytul, url=hurl, mode='linkorseason', image=img, folder=True, infoLabels={'plot':description,'title':tytul})
				except:

					vvv=''

	xbmcplugin.endOfDirectory(addon_handle)

def ListLista(parentIDv,pg, qr=''):
    ab=''
    
    ac=''
    sortparentv = addon.getSetting(parentIDv+'sortv')
    lataparentv = addon.getSetting(parentIDv+'latav')
    url = 'https://cms.35mm.online/umbraco/api/search?page=%s&limit=48&sort_field.5=%s&parentID.4=%s&__productionYear.4=%s'%(to_unicode(pg),sortparentv,parentIDv,lataparentv)

    url=url+'&searchPhrase.3='+qr if qr else url
    response = sess.get(url, headers=headers, verify=False)

    pageCount = response.json().get('pageCount',None)
    records = response.json().get('records',None)
    for rc in records:
        kraj = ''
        rok =''
        imag = rc.get('image',None).get('url',None)
        if not PY3:
    
    
            tytul = rc.get('title',None).encode('utf-8')
            description = rc.get('description',None).encode('utf-8')

            
            url = rc.get('url',None).encode('utf-8')
        else:
            tytul = rc.get('title',None)
            description = rc.get('description',None)

            
            url = rc.get('url',None)
        description = description if description else tytul
        description = re.sub('<[^<]+?>', '', description) 
        try:
            kraj,rok = (to_unicode(rc.get('subtitle' ,None))).split('|')
        except:
            pass
    
        
    
        url = 'https://35mm.online'+url
        mud = 'linkorseason'
        add_item(name=tytul, url=url, mode='linkorseason', image=imag, folder=True, infoLabels={'plot':description,'title':tytul, 'country':kraj, 'year':int(rok)})	
    if records:
        if int(pg)<int(pageCount):

            add_item(name='[COLOR blue]>> Nastepna strona [/COLOR]', url=parentIDv, mode='listlista', image='', folder=True, page=int(pg)+1)

        xbmcplugin.setContent(addon_handle, 'videos')
        xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[B]Uwaga[/B]', 'Brak materiałów do wyświetlenia[CR]Może zmień ustawienia.',xbmcgui.NOTIFICATION_INFO, 8000,False)

def linkorseason(url,bt=False):

    headers.update({'x-origin-url': url})
    zz=''
    response = sess.get('https://cms.35mm.online/umbraco/api/content', headers=headers,verify=False)
    try:
        sezon = response.json().get("content",None).get("seasonsModel",None).get("seasons")
    except:
        sezon = None

    atdId = to_unicode((response.json()).get('content',None).get("atdId",None))
    popx = False
    if atdId !=0:
        popx = True
        description = to_unicode((response.json()).get('content',None).get("description",None)) 
        atdId = to_unicode((response.json()).get('content',None).get("atdId",None))
        genres = (response.json()).get('content',None).get("genre",None)
        year = (response.json()).get('content',None).get("year",None)
        duration = (response.json()).get('content',None).get("duration",None)
        duration = duration if duration else '0'
        imag = (response.json()).get('content',None).get('image',None).get('url',None)
        kateg = ', '.join([(x.strip()).lower() for x in genres]) if genres else ''

        if not PY3:
        
        
        
  
            description = (re.sub('<[^<]+?>', '', description))	.encode('utf-8')	

            title =((response.json()).get('content',None).get("title",None)).encode('utf-8')

            country = ((response.json()).get('content',None).get("country",None)).encode('utf-8')
        

            kateg = kateg.encode('utf-8')
        else:
            description = (re.sub('<[^<]+?>', '', description))	

            title =((response.json()).get('content',None).get("title",None))

            country = ((response.json()).get('content',None).get("country",None))
        

            kateg = kateg

        title1 ='[COLOR gold]%s [/COLOR]'%title       
        infol = {'plot':description,'title':title1, 'genre':kateg , 'country':country, 'year':int(year), 'duration':int(duration)*60}
        
        fullurl = atdId+'|'+ quote(json.dumps(infol))
        add_item(name=title1, url=fullurl, mode='playvid', image=imag, folder=False, infoLabels=infol)	

    if not bt:
        if sezon:
            epizody = sezon[0].get('episodes',None)
            for epizod in epizody:
                kraj = ''
                rok =''
                if not PY3:
                    tytul = epizod.get('title',None).encode('utf-8')
                    description = epizod.get('description',None).encode('utf-8')
                    imag = epizod.get('image',None).get('url',None).encode('utf-8')
                    try:
                        kraj,rok = ((to_unicode(epizod.get('subtitle' ,None))).encode('utf-8')).split('|')
                    except:
                        pass
                    url = epizod.get('url',None).encode('utf-8')
                else:
                    
                    url = epizod.get('url',None)
                    tytul = epizod.get('title',None)
                    description = epizod.get('description',None)
        
        
                    imag = epizod.get('image',None).get('url',None)
                    try:
                        kraj,rok = ((to_unicode(epizod.get('subtitle' ,None)))).split('|')
                    except:
                        pass
                    url = epizod.get('url',None)
                
        
                
                description = description if description else tytul
                description = (re.sub('<[^<]+?>', '', description))
                url = 'https://35mm.online'+url
                mud = 'linkorseason2'
        
                add_item(name=tytul, url=url, mode=mud, image=imag, folder=True, infoLabels={'plot':description,'title':tytul, 'country':kraj, 'year':int(rok)})	
        
        else:
            if not popx:
                description = to_unicode((response.json()).get('content',None).get("description",None)) 
                atdId = to_unicode((response.json()).get('content',None).get("atdId",None))
                genres = (response.json()).get('content',None).get("genre",None)
                year = (response.json()).get('content',None).get("year",None)
                duration = (response.json()).get('content',None).get("duration",None)
                duration = duration if duration else '0'
                imag = (response.json()).get('content',None).get('image',None).get('url',None)
                kateg = ', '.join([(x.strip()).lower() for x in genres]) if genres else ''
                if not PY3:
                
                
                
            
                    description = (re.sub('<[^<]+?>', '', description))	.encode('utf-8')	
            
                    title =((response.json()).get('content',None).get("title",None)).encode('utf-8')
            
                    country = ((response.json()).get('content',None).get("country",None)).encode('utf-8')
                
            
                    kateg = kateg.encode('utf-8')
                else:
                    description = (re.sub('<[^<]+?>', '', description))	
            
                    title =((response.json()).get('content',None).get("title",None))
            
                    country = ((response.json()).get('content',None).get("country",None))
                
            
                    kateg = kateg
                infol = {'plot':description,'title':title, 'genre':kateg , 'country':country, 'year':int(year), 'duration':int(duration)*60}
                
                fullurl = atdId+'|'+ quote(json.dumps(infol))
                add_item(name=title, url=fullurl, mode='playvid', image=imag, folder=False, infoLabels=infol)	
        
    xbmcplugin.endOfDirectory(addon_handle)	

def ListDane(dane):
    dane = json.loads(unquote(dane))
    for dd in dane:
        url = 'https://35mm.online'+dd.get('url',None)
    
        if not PY3:
            title = (dd.get('title',None)).encode('utf-8')
            description = (dd.get('description',None)).encode('utf-8') 
            description = re.sub('<[^<]+?>', '', description)
            img = (dd.get('image',None).get('url',None)).encode('utf-8')
        else:
            title = (dd.get('title',None))
            description = (dd.get('description',None))
            description = re.sub('<[^<]+?>', '', description)
            img = (dd.get('image',None).get('url',None))
        add_item(name=title, url=url, mode='linkorseason', image=img, folder=True, infoLabels={'plot':description,'title':title})	
    xbmcplugin.endOfDirectory(addon_handle)
	
	
	
	
def dec(chra):

    try:    
        if sys.version_info >= (3,0,0):
            chra =repr(chra.encode('utf-8'))
            chra = chra.replace('\\xc3\\xaa','ę').replace('\\xc3\\x8a','Ę')
            chra = chra.replace('\\xc3\\xa6','ć').replace('\\xc3\\x86','Ć')
            chra = chra.replace('\\xc2\\xbf','ż').replace('\\xc2\\x9f','Ż')
            chra = chra.replace('\\xc2\\xb9','ą').replace('\\xc2\\x99','Ą')
            
            chra = chra.replace('\\xc5\\x93','ś').replace('\\xc5\\x92','Ś')
            chra = chra.replace('\\xc3\\xb3','ó').replace('\\xc3\\x93','Ó')
            
            chra = chra.replace('\\xc5\\xb8','ź').replace('\\xc5\\xb7','Ź')
            
            chra = chra.replace('\\xc2\\xb3','ł').replace('\\xc2\\x93','Ł')
            
            chra = chra.replace('\\xc3\\xb1','ń').replace('\\xc3\\x91','Ń')
            chra = chra .replace("b\'",'')

            chra = chra .replace("\\n",'\n').replace("\\r",'\r') 
            chra = chra .replace("\\'","'")

        else:

            chra = chra.replace('\xc3\xaa','ę').replace('\xc3\x8a','Ę')
            chra = chra.replace('\xc3\xa6','ć').replace('\xc3\x86','Ć')
            chra = chra.replace('\xc2\xbf','ż').replace('\xc2\x9f','Ż')
            chra = chra.replace('\xc2\xb9','ą').replace('\xc2\x99','Ą')
            
            chra = chra.replace('\xc5\x93','ś').replace('\xc5\x92','Ś')
            chra = chra.replace('\xc3\xb3','ó').replace('\xc3\x93','Ó')
            
            chra = chra.replace('\xc5\xb8','ź').replace('\xc5\xb7','Ź')
            
            chra = chra.replace('\xc2\xb3','ł').replace('\xc2\x93','Ł')
            
            chra = chra.replace('\xc3\xb1','ń').replace('\xc3\x91','Ń')



    except:
        pass
        
    return chra
def transPolish(subtlink):

	try:
		response = sess.get(subtlink, headers=headers, verify=False)
	
		if PY3:
		
			response  = response.text
		else:
			response  = response.content
		gg=dec(response)
	
		open(napisy, 'w').write(gg)
	
		return True
	except:
		return False
	
def PlayVid(url):

	atdId,infol = url.split('|')
	dane = json.loads(unquote(infol))

	url = 'https://cms.35mm.online/umbraco/api/products/%s/videos/playlist?platform=BROWSER&videoType=MOVIE'%(atdId)
	response = sess.get(url, headers=headers,verify=False)
	ab=response.json()
	subsout=[]

	subt = False
	subtitles = response.json().get('subtitles',None)
	for subtitle in subtitles:
		subt = subtitle.get('url',None)
		subt = 'https:' + subt if subt.startswith('//') else subt

		label = subtitle.get('language',None)
		label = 'audiodeskrypcja (pol)' if 'qtp' in label else label
		subsout.append({'label':label,'subt':subt})
	subt = False
	if wybornapisow and subsout:
		labels = [x.get('label') for x in subsout]
		sel = xbmcgui.Dialog().select('Wybierz język:',labels)    
		if sel>-1:
			subt=subsout[sel].get('subt')
			if subsout[sel].get('label') == 'pol':
			
				subt = napisy if transPolish(subt) else subt
				
		else:
			subt = False

	dash = response.json().get('sources',None).get('DASH',None)[-1].get('src',None)

	dash = 'https:' + dash if dash.startswith('//') else dash
	lic_url = response.json().get('drm',None).get('WIDEVINE',None).get('src',None)

	play_item = xbmcgui.ListItem(path=dash)
	play_item.setProperty("IsPlayable", "true")    

	PROTOCOL = 'mpd'
	DRM = 'com.widevine.alpha'
	
	is_helper = inputstreamhelper.Helper(PROTOCOL, drm=DRM)
	if is_helper.check_inputstream():
		play_item.setArt({'thumb': rys, 'poster': rys, 'banner': rys, 'fanart': FANART})
		play_item.setInfo(type="Video", infoLabels=dane)
		play_item.setMimeType('application/xml+dash')
		play_item.setContentLookup(False)
		if sys.version_info >= (3,0,0):
			play_item.setProperty('inputstream', is_helper.inputstream_addon)
		else:
			play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
		play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)	
		if lic_url:
			play_item.setProperty('inputstream.adaptive.license_type', DRM)

			play_item.setProperty('inputstream.adaptive.license_key', lic_url+'||R{SSM}|')
		if subt:
			play_item.setSubtitles([subt])
	xbmc.Player().play(dash,play_item)

def router(paramstring):
    args = dict(parse_qsl(paramstring))
    
    if args:
        mode = args.get('mode', None)
    
        if 'filtr' in mode:

            ff = mode.split(':')[1]

            if 'sort' in ff:
                dd='sortowanie:'
                
                value=['0','1','2','3']
                label=['Alfabetycznie - rosnąco' ,'Alfabetycznie - malejąco' ,'Rok produkcji - rosnąco' ,'Rok produkcji - malejąco' ]
                sel = xbmcgui.Dialog().select('Select '+dd,label)
                if sel != -1:
                
                    sel = sel if sel>-1 else quit()
                    v = value[sel] if value[sel] else ''
                    n = label[sel]
                    a = ff+'v'
                    b = ff+'n'
                    addon.setSetting(ff+'v',v)
                    addon.setSetting(ff+'n',n)
                    xbmc.executebuiltin('Container.Refresh')

            elif 'lat' in ff:

                dd='zakres lat:'

                value = [str(x) for x in range(1941,2022)][::-1]
                label = value

                sel = xbmcgui.Dialog().select('Zakres lat od:' ,label)
                if sel != -1:
                    sel = sel if sel>-1 else quit()
                    v = value[sel] if value[sel] else ''
                    n = label[sel]

                else:
                    a=''
                sel = xbmcgui.Dialog().select('Zakres lat do:' ,label)
                if sel != -1:
                    sel = sel if sel>-1 else quit()
                    v2 = value[sel] if value[sel] else ''
                    n2 = label[sel]

                    vlk = '%s,%s'%(v,v2)
                    addon.setSetting(ff+'v',vlk)
                    addon.setSetting(ff+'n',vlk)
                else:
                    a=''

                xbmc.executebuiltin('Container.Refresh')
            else:
                quit()

        elif mode == 'szukaj':
            query = xbmcgui.Dialog().input(u'Szukaj...', type=xbmcgui.INPUT_ALPHANUM)
            if query:	
    
                url = 'https://api.cda.pl/video/search?query=gracz&page=1&limit=20'
    
                ListContent('1',1,url)
    
            else:
                quit()
        elif mode=='search':

            
            query = xbmcgui.Dialog().input(u'Szukaj...', type=xbmcgui.INPUT_ALPHANUM)
            if query:	  
                ListLista(exlink,page,query)

        elif mode == 'listcontent':
            ListContent(exlink,page)
            
        elif mode =='playvid':
            PlayVid(exlink)

        elif mode == 'listdane':
            ListDane(exlink)
            
        elif mode == 'listlista':
            ListLista(exlink,page)
            
        elif mode == 'linkorseason':
            linkorseason(exlink)
        elif mode == 'linkorseason2':
            linkorseason(exlink,True)
 
    else:
        home()	
if __name__ == '__main__':
	router(sys.argv[2][1:])
