# -*- coding: utf-8 -*-

#'\nCreated on Thu Feb 11 18:47:43 2016\n\n@author: ramic\n'
import requests
import re
from resources.lib import jsunpack as jsunpack
import sys, json
import string, xbmc

if sys.version_info >= (3,0,0):
# for Python 3
    from urllib.parse import unquote,quote
    import urllib.parse as urlparse
else:
    # for Python 2
    from urllib import unquote,quote
    from urlparse import urlparse
    
sess=requests.Session()
BASEURL='https://www.cda.pl'
TIMEOUT = 5
PY3 = sys.version_info[0] == 3
if PY3:
    rot13 = str.maketrans(
        "ABCDEFGHIJKLMabcdefghijklmNOPQRSTUVWXYZnopqrstuvwxyz",
        "NOPQRSTUVWXYZnopqrstuvwxyzABCDEFGHIJKLMabcdefghijklm")
else:
    rot13 = string.maketrans(
        "ABCDEFGHIJKLMabcdefghijklmNOPQRSTUVWXYZnopqrstuvwxyz",
        "NOPQRSTUVWXYZnopqrstuvwxyzABCDEFGHIJKLMabcdefghijklm")

UAx = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:91.0) Gecko/20100101 Firefox/91.0'    
        
        
def getUrl(url,data=None,cookies=None):
    headers = {
        'User-Agent': UAx,
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Connection': 'keep-alive',
        'Upgrade-Insecure-Requests': '1',}
    link=sess.get(url,verify=False,headers=headers).content
    if PY3:
        link = link.decode(encoding='utf-8', errors='strict')
    return link
    
def _get_encoded(content):
    src=''
    idx1 = content.find('|||http')
    if  idx1>0:
        idx2 = content.find('.split', idx1)
        encoded =content[ idx1: idx2]
        if encoded:
            tmp = encoded.split('player')[0]
            tmp=re.sub('[|]+\\w{2,3}[|]+','|',tmp,re.DOTALL)
            tmp=re.sub('[|]+\\w{2,3}[|]+','|',tmp,re.DOTALL)
            remwords=['http','cda','pl','logo','width','height','true','static','st','mp4','false','video','static',
                    'type','swf','player','file','controlbar','ads','czas','position','duration','bottom','userAgent',
                    'match','png','navigator','id', '37', 'regions', '09', 'enabled', 'src', 'media']
            remwords=['http', 'logo', 'width', 'height', 'true', 'static', 'false', 'video', 'player',
                'file', 'type', 'regions', 'none', 'czas', 'enabled', 'duration', 'controlbar', 'match', 'bottom',
                'center', 'position', 'userAgent', 'navigator', 'config', 'html', 'html5', 'provider', 'black',
                'horizontalAlign', 'canFireEventAPICalls', 'useV2APICalls', 'verticalAlign', 'timeslidertooltipplugin',
                'overlays', 'backgroundColor', 'marginbottom', 'plugins', 'link', 'stretching', 'uniform', 'static1',
                'setup', 'jwplayer', 'checkFlash', 'SmartTV', 'v001', 'creme', 'dock', 'autostart', 'idlehide', 'modes',
               'flash', 'over', 'left', 'hide', 'player5', 'image', 'KLIKNIJ', 'companions', 'restore', 'clickSign',
                'schedule', '_countdown_', 'countdown', 'region', 'else', 'controls', 'preload', 'oryginalne', 'style',
                '620px', '387px', 'poster', 'zniknie', 'sekund', 'showAfterSeconds', 'images', 'Reklama', 'skipAd',
                 'levels', 'padding', 'opacity', 'debug', 'video3', 'close', 'smalltext', 'message', 'class', 'align',
                  'notice', 'media']
            for one in remwords:
                tmp=tmp.replace(one,'')
            cleanup=tmp.replace('|',' ').split()
            out={'server': '', 'e': '', 'file': '', 'st': ''}
            if len(cleanup)==4:
                for one in cleanup:
                    if one.isdigit():
                        out['e']=one
                    elif re.match('[a-z]{2,}\\d{3}',one) and len(one)<10:
                        out['server'] = one
                    elif len(one)==22:
                        out['st'] = one
                    else:
                        out['file'] = one
                src='https://%s.cda.pl/%s.mp4?st=%s&e=%s'%(out.get('server'),out.get('file'),out.get('st'),out.get('e'))
    return src
########################################################
def cda_replace(match, link):
    data = getUrl('https://www.cda.pl/js/player.js')
    if match == '1':
        data1 = getDataBeetwenMarkers(data, '11:344', ';return', False)[1]
        dane1 = re.compile('replace\((.+?)\)', re.DOTALL).findall(data1)
        for i in range(len(dane1)):
            rep = dane1[i]
            item = rep.split(',')
            a = item[0].replace('"','')
            b = item[1].replace('"','')
            link = link.replace(a, b)
        return link
    else:
        data2 = getDataBeetwenMarkers(data, 'da=function', '}};', False)[1]
        dane2 = re.compile('replace\((.+?)\)', re.DOTALL).findall(data2)
        for i in range(len(dane2)):
            rep = dane2[i]
            item = rep.split(',')
            a = item[0].replace('"','')
            b = item[1].replace('"','')
            link = link.replace(a, b)
        return link
def getDataBeetwenMarkers(data, marker1, marker2, withMarkers=True, caseSensitive=True):
    if caseSensitive:
        idx1 = data.find(marker1)
    else:
        idx1 = data.lower().find(marker1.lower())
    if -1 == idx1: return False, ''
    if caseSensitive:
        idx2 = data.find(marker2, idx1 + len(marker1))
    else:
        idx2 = data.lower().find(marker2.lower(), idx1 + len(marker1))
    if -1 == idx2: return False, ''   
    if withMarkers:
        idx2 = idx2 + len(marker2)
    else:
        idx1 = idx1 + len(marker1)
    return True, data[idx1:idx2]        
#########################################
def _videoLink(content):
    src =''
    evals = re.compile('eval(.*?)\\{\\}\\)\\)',re.DOTALL).findall(content)
    if evals:
        for eval in evals:
            eval=re.sub('  ',' ',eval)
            eval=re.sub('\n','',eval)
            try:
                unp = jsunpack.unpack(eval)
            except:
                unp=''
            if unp:
                unp=re.sub('\\\\','',unp)
                match = re.compile('["\']*file["\']*\\s*:\\s*["\'](.+?)["\'],',  re.DOTALL).search(content)
                match2 = re.compile('["\']file["\']:["\'](.*?\\.mp4)["\']',  re.DOTALL).search(content)
                if match:   src = match.group(1)
                elif match2: src = match2.group(1)
                if src:
                    break
    else:
        match = re.compile('["\']*file["\']*\\s*:\\s*["\'](.+?)["\'],',  re.DOTALL).search(content)
        match2 = re.compile('["\']file["\']:["\'](.*?\\.mp4)["\']',  re.DOTALL).search(content)
        if match:   src = match.group(1)
        elif match2: src = match2.group(1)
        else:
            src = _get_encoded_unpaker(content)
            if not src:
                src = _get_encoded(content)
        
    return src

def getLinkCda(url):

    url=url.split('?wersja=')
    try:
        ab=url[0].replace('http://www.cda','https://www.cda')
    except:
        ab=''
    content = getUrl(ab)
    out=[]
    if not'Trwa konwersja wgranego' in content and not 'ten link zosta' in content:
    
    
        pldata=re.findall("""player_data=\\'({.*?script>"})\\'""",content)#[0]
        if pldata:

            vid_data = (json.loads(pldata[0])).get("video",None)
            
            
            id = vid_data.get("id",None)
            ts = vid_data.get('ts',None) 
            hash2 = vid_data.get('hash2',None) 
            
            
            qualities = vid_data.get("qualities",None)
            pokolei = sorted(qualities, key=lambda x: int(x.replace('p','')),reverse=True)
            
            maks=qualities.get(pokolei[0],None)

            data = '{"jsonrpc":"2.0","method":"videoGetLink","params":["'+str(id)+'","%s",'+str(ts)+',"'+str(hash2)+'",{}],"id":1}'
            for x in pokolei:
                un = data%(str(qualities.get(x,None)))
                out.append((un,x))
    else:
        out='trwa konwersja'
    return out
def getRealLink(data):

    data = json.loads(data)
    headers = {
        'Host': 'www.cda.pl',
        'user-agent': UAx,
        'accept': 'application/json, text/javascript, */*; q=0.01',
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'content-type': 'application/json',
        'origin': 'https://ebd.cda.pl',
        'sec-fetch-dest': 'empty',
        'sec-fetch-mode': 'cors',
        'sec-fetch-site': 'same-site',
        'te': 'trailers',
    }

    response = requests.post('https://www.cda.pl/', headers=headers, json=data, verify=False).json()
    real_link = response.get("result",None).get("resp",None)
    real_link = real_link+'|User-Agent='+quote(UAx)
    return real_link