# -*- coding: utf-8 -*-

import sys,re,os

import six
from six.moves import urllib_parse, http_cookiejar
from six import iteritems


import xbmc,xbmcgui,xbmcaddon, xbmcvfs
import xbmcplugin
import resolveurl as urlresolver

if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    


try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
cache = StorageServer.StorageServer('segos')
import resources.lib.segos as segos #segos
import resources.lib.cdapl as cdapl #cdapl

base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urllib_parse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonId     = my_addon.getAddonInfo('id')
addonName       = my_addon.getAddonInfo('name')
PATH        = my_addon.getAddonInfo('path')
try:
    DATAPATH    = xbmcvfs.translatePath(my_addon.getAddonInfo('profile'))#.decode('utf-8')
except:
    DATAPATH    = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES   = PATH+'/resources/'
FANART      = None
sys.path.append( os.path.join( RESOURCES, "lib" ) )

xbmcplugin.addSortMethod( addon_handle, sortMethod=xbmcplugin.SORT_METHOD_UNSORTED)
xbmcplugin.addSortMethod( addon_handle, sortMethod=xbmcplugin.SORT_METHOD_DATE)
xbmcplugin.addSortMethod( addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE)
xbmcplugin.addSortMethod( addon_handle, sortMethod=xbmcplugin.SORT_METHOD_LABEL)
xbmcplugin.addSortMethod( addon_handle, sortMethod=xbmcplugin.SORT_METHOD_LASTPLAYED)


def addLinkItem(name, url, mode, page=1, iconimage=None, infoLabels=False, IsPlayable=True,fanart=FANART,contextmenu=None,itemcount=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page})
    if iconimage==None:
        iconimage='DefaultFolder.png'
    if six.PY2:    
        li = xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
    else:
        li = xbmcgui.ListItem(name)
    li.setArt({ 'poster': iconimage, 'thumb' : iconimage, 'icon' : iconimage ,'fanart':fanart,'banner':iconimage})
    if not infoLabels:
        infoLabels={'title': name,'plot':name}
    li.setInfo(type='video', infoLabels=infoLabels)
    if IsPlayable:
        li.setProperty('IsPlayable', 'true')
    if fanart:
        li.setProperty('fanart_image',fanart)
    if contextmenu:
        men=contextmenu
        if infoLabels.get('trailer',''):
            men.append(('Zwiastun', 'RunPlugin(plugin://%s?mode=zwiastun&ex_link=%s)'%(addonId,infoLabels.get('trailer'))))
        li.addContextMenuItems(men, replaceItems=True)        
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=li,isFolder=False,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
    return ok
def addDir(name,ex_link=None, page=0, mode='folder',iconImage='DefaultFolder.png', infoLabels=None, fanart=FANART,contextmenu=None,itemcount=1):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page})

    if six.PY3:    
        li = xbmcgui.ListItem(name)

    else:
        li = xbmcgui.ListItem(name, iconImage=iconImage, thumbnailImage=iconImage)
    
    if not infoLabels:
        infoLabels={'title': name,'plot':name}
    if infoLabels:
        li.setInfo(type='video', infoLabels=infoLabels)
    
    if fanart:
        li.setProperty('fanart_image', fanart )
    if contextmenu:
        isp=contextmenu
        li.addContextMenuItems(isp, replaceItems=True)
    else:
        isp = []
        isp.append(('Informacja', 'XBMC.Action(Info)'),)
        li.addContextMenuItems(isp, replaceItems=False)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%P')
    return ok


def encoded_dict(in_dict):
    out_dict = {}
    
    for k, v in iteritems(in_dict):
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(encoded_dict(query))
    
def ListSerials(ex_link,page):
    items,pagination = segos.scanPageSer(ex_link,int(page))
    infoTab = True if 'true' in my_addon.getSetting('infoTab') else False
    infoTab = False
    if pagination[0]:
        addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=ex_link, page=pagination[0], mode='__page__S', IsPlayable=False)
    item=len(items)
    for f in items:
        contextmenu = []
        if 'moja-lista' in ex_link:
            contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            

        else:
            contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
        f.update(segos.getMovieInfo(f.get('url'),infoTab))
        addDir(f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=f,iconImage=f.get('img'), contextmenu=contextmenu)    
    if pagination[1]:
        addLinkItem(name='[COLOR blue]>> Następna strona >>[/COLOR]', url=ex_link, page=pagination[1], mode='__page__S', IsPlayable=False)
        
    
    xbmcplugin.endOfDirectory(addon_handle)    
def ListSearch(ex_link):
    items = segos.scanSearch(ex_link)
    if items:
        item=len(items)    
        for f in items:
            url=f.get('url')
            contextmenu = []
            if 'moja-lista' in ex_link:
                contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
    
            else:
                contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
            
            if '/seriale/' in url:
                addDir('[B][COLOR blue]Serial [/B][/COLOR]'+f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=f,iconImage=f.get('img'), contextmenu=contextmenu)    
            else:    
                addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=item, contextmenu=contextmenu)    
        if '/seriale/' in ex_link:
            xbmcplugin.setContent(addon_handle, 'tvshows')
        else:
            xbmcplugin.setContent(addon_handle, 'movies')
        xbmcplugin.endOfDirectory(addon_handle)    
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak materiałów do wyświetlenia[/B][/COLOR]', xbmcgui.NOTIFICATION_WARNING, 5000)        
    
def ListMoja(ex_link):
    items,msg = segos.scanMoja(ex_link)    
    if items:
        item=len(items)    
        for f in items:
            url=f.get('url')
            contextmenu = []
            if 'moja-lista' in ex_link:
                contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
    
            else:
                contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
            
            if '/seriale/' in url:
                addDir('[B][COLOR blue]Serial [/B][/COLOR]'+f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=False,iconImage=f.get('img'), contextmenu=contextmenu)    
            else:    
                addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=False, IsPlayable=True,itemcount=item, contextmenu=contextmenu)    
        xbmcplugin.setContent(addon_handle, 'movies')
        xbmcplugin.endOfDirectory(addon_handle)    

    else:
        if msg:
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]'+msg+'[/B][/COLOR]', xbmcgui.NOTIFICATION_WARNING, 5000)        

        else:
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak materiałów do wyświetlenia[/B][/COLOR]', xbmcgui.NOTIFICATION_WARNING, 5000)        

        
def ListMovies(ex_link,page):
    items,pagination = segos.scanPage(ex_link,int(page))
    infoTab = True if 'true' in my_addon.getSetting('infoTab') else False
    infoTab = False
    
    if items:
        if pagination[0]:
            addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=ex_link, page=pagination[0], mode='__page__M', IsPlayable=False)
        item=len(items)    
        for f in items:
            f.update(segos.getMovieInfo(f.get('url'),infoTab))
            url=f.get('url')
            contextmenu = []
            if 'moja-lista' in ex_link:
                contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
    
            else:
                contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
            
            if '/seriale/' in url:
                addDir('[B][COLOR blue]Serial [/B][/COLOR]'+f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=f,iconImage=f.get('img'), contextmenu=contextmenu)    
            else:    
                if f.get('plot'):
                    labi=f
                else:
                    labi=False
                addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=labi, IsPlayable=True,itemcount=item, contextmenu=contextmenu)    
        if pagination[1]:
            addLinkItem(name='[COLOR blue]>> Następna strona >>[/COLOR]', url=ex_link, page=pagination[1], mode='__page__M', IsPlayable=False)
        if '/seriale/' in ex_link:
            xbmcplugin.setContent(addon_handle, 'tvshows')
        else:
            xbmcplugin.setContent(addon_handle, 'movies')
        xbmcplugin.endOfDirectory(addon_handle)    
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak materiałów do wyświetlenia[/B][/COLOR]', xbmcgui.NOTIFICATION_WARNING, 5000)        
    
def ListMoviesKAT(ex_link,page):
    items,pagination = segos.scanPageKat(ex_link,int(page))
    infoTab = True if 'true' in my_addon.getSetting('infoTab') else False
    infoTab = False
    if pagination[0]:
        addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=ex_link, page=pagination[0], mode='__page__MK', IsPlayable=False)
    item=len(items)
    for f in items:
        contextmenu = []
        if 'moja-lista' in ex_link:
            contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            

        else:
            contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)   #, 'ex_link' : entry})            
        f.update(segos.getMovieInfo(f.get('url'),infoTab))
        url=f.get('url')
        if '?page=seriale' in url:
            addDir('[B][COLOR blue]Serial [/B][/COLOR]'+f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=f,iconImage=f.get('img'), contextmenu=contextmenu)        
        else:            
            addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=item, contextmenu=contextmenu)    
    if pagination[1]:
        addLinkItem(name='[COLOR blue]>> Następna strona >>[/COLOR]', url=ex_link, page=pagination[1], mode='__page__MK', IsPlayable=False)
    xbmcplugin.endOfDirectory(addon_handle)        
    
    
def ListEpisodes(ex_link):
    items = segos.getSeasons(ex_link)
    if items:
        item=len(items)
        for f in items:
            addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=item)
        xbmcplugin.setContent(addon_handle, 'episodes')
        xbmcplugin.endOfDirectory(addon_handle)    
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak materiałów do wyświetlenia[/B][/COLOR]', xbmcgui.NOTIFICATION_WARNING, 5000,False)        

def getLinks(ex_link):
    links = segos.getVideoLinks(ex_link)        
    stream_url=''
    if len(links):
        if len(links)>1:
            
            linksSEG = [x.get('host') for x in links]
            s = xbmcgui.Dialog().select('Linki',linksSEG)
        else:
            s=0
        #    
        hrefSEG=links[s].get('href') if s>-1 else ''
        host=links[s].get('host') if s>-1 else ''
        if not hrefSEG:
            xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))

        if 'hdseans.pl' in hrefSEG:#'segos.es' in hrefSEG:
            hrefSEG = segos.getSegosVid(hrefSEG)
            if 'mp4' in hrefSEG:    
                stream_url = hrefSEG
        elif 'cda.pl' in hrefSEG:
            try:
                stream_url = cdapl.getLinkCda(hrefSEG)
                if stream_url:
                    if my_addon.getSetting('jakcda')== 'true':
                        stream_url = stream_url[0][0]
                    else:
                        if type(stream_url) is list:
                            
                            qual = [x[1] for x in stream_url]
                            select = xbmcgui.Dialog().select('Wybierz jakość (cda)', qual)
                            
                            if select>-1:
                                stream_url = stream_url[select][0]
                            else:
                                
                                stream_url=''
                    if stream_url:

                        stream_url = cdapl.getRealLink(stream_url)
                else:
                    xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Link nie działa.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)
                    return
            except:
                xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Link nie działa.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)
                return
    
        elif 'rapidvideo' in hrefSEG or 'raptu' in hrefSEG:
            import resources.lib.vidsources as vidsrc
            stream_url = vidsrc.getVideo(hrefSEG)
            if type(stream_url) is list:
                if len(stream_url)==1:
                    stream_url = stream_url[0][0]
                else:
                    qual = [x[1] for x in stream_url]
                    select = xbmcgui.Dialog().select('Wybierz jakość (raptu, rapidvideo)', qual)
                    if select>-1:
                        stream_url = stream_url[select][0]
                    else:
                        try:stream_url = urlresolver.resolve(hrefSEG)
                        except: stream_url=''
        elif 'embedsb' in hrefSEG:

            import resources.lib.vidsources as vidsrc
            stream_url = vidsrc.getVideo2(hrefSEG)
        else:
            if hrefSEG:
                try:
                    stream_url = urlresolver.resolve(hrefSEG)
                except Exception as e:
                    stream_url=''
                    s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]',str(e))
            else:
                pass
    if stream_url:
        xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
    else:
        xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))    
    
def dodObejrz(url):    

    if url:
        if '#player' in url:
            url=url.replace('#player','/user-list-add')
        else:
            url+='/user-list-add'
        content,kuk = segos.getUrlReq(url)    
        xbmcgui.Dialog().notification('[B]Dodano...[/B]', '', xbmcgui.NOTIFICATION_INFO, 5000)
def usunObejrz(url):    

    url+='/user-list-remove'
    content,kuk = segos.getUrlReq(url)            
    xbmcgui.Dialog().notification('[B]Usunięto...[/B]', ' ', xbmcgui.NOTIFICATION_WARNING, 5000)
def login():
    u = my_addon.getSetting('user')
    p = my_addon.getSetting('pass')
    logged=False
    if u and p:
        logged,dod =  segos.getLogin(u,p)
    if logged:
        addDir('[B]HDseans.pl - %s - %s - Moja lista[/B]'%(u,dod),ex_link='https://hdseans.pl/moja-lista', mode='ListMoja',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    else:
        addLinkItem('[B]Zaloguj[/B]','',mode='settings',iconimage='',IsPlayable=False)
def start():
    u = my_addon.getSetting('user')
    p = my_addon.getSetting('pass')
    logged=False
    logged,dod =  segos.getLogin(u,p)

segos.COOKIEFILE=os.path.join(DATAPATH,'segos.cookie')
def search():
    return cache.get('history').split(';')
def setHistory(entry):
    history = search()
    if history == ['']:
        history = []
    entry =   entry.decode('utf-8') if six.PY2 else entry  
    history.insert(0, entry  )
    cache.set('history',';'.join(history[:50]))
def delOne(entry):
    history = search()
    if history:
        cache.set('history',';'.join(history[:50]))
    else:
        delAll()
def delAll():
    cache.delete('history')

mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
page = args.get('page',[1])[0]
fsortv = my_addon.getSetting('FsortV')
fsortn = my_addon.getSetting('FsortN') if fsortv else 'Domyslnie'

fkatv = my_addon.getSetting('fkatV')

fkatn = my_addon.getSetting('fkatN')
skatv = my_addon.getSetting('skatV')
skatn = my_addon.getSetting('skatN')

fjakv = my_addon.getSetting('fjakV')

fjakn = my_addon.getSetting('fjakN') 
sjakv = my_addon.getSetting('sjakV')

sjakn = my_addon.getSetting('sjakN')
bjakv = my_addon.getSetting('bjakV')
bjakn = my_addon.getSetting('bjakN')

fwerv = my_addon.getSetting('fwerV')
fwern = my_addon.getSetting('fwerN') 
swerv = my_addon.getSetting('swerV')

swern = my_addon.getSetting('swerN') 
bwerv = my_addon.getSetting('bwerV')

bwern = my_addon.getSetting('bwerN') 


flatv = my_addon.getSetting('flatV')

flatn = my_addon.getSetting('flatN') 
slatv = my_addon.getSetting('slatV')

slatn = my_addon.getSetting('slatN') 
blatv = my_addon.getSetting('blatV')

blatn = my_addon.getSetting('blatN') 

focev = my_addon.getSetting('foceV')

focen = my_addon.getSetting('foceN')
socev = my_addon.getSetting('soceV')

socen = my_addon.getSetting('soceN') 
bocev = my_addon.getSetting('boceV')

bocen = my_addon.getSetting('boceN') 


if mode is None:
    login()
    addDir(name='[B][COLOR blue]Filmy[/B][/COLOR]',ex_link='https://hdseans.pl/filmy', mode='filmcat',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir(name='[B][COLOR blue]Seriale[/B][/COLOR]',ex_link='https://hdseans.pl/seriale', mode='sercat',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir(name='[B][COLOR blue]Bajki[/B][/COLOR]',ex_link='https://hdseans.pl/bajki', mode='bajkicat',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir('[B]Szukaj[/B]','',mode='Szukaj')
    xbmcplugin.setContent(addon_handle, 'videos')
    xbmcplugin.endOfDirectory(addon_handle)
    
elif mode[0] == 'filmcat':
    addDir(name='Ostatnio dodane',ex_link='dodanef', mode='ListTop',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    #addDir(name='Najpoppularniejsze',ex_link='popularf', mode='ListPopular',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir(name='Najlepiej oceniane',ex_link='ocenaf', mode='ListTop',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addLinkItem('[COLOR blue]Gatunki:[/COLOR] [B]'+fkatn+'[/B]','',mode='filtr:fkat',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Wersja językowa:[/COLOR] [B]'+fwern+'[/B]','',mode='filtr:fwer',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Jakość:[/COLOR] [B]'+fjakn+'[/B]','',mode='filtr:fjak',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Rok produkcji:[/COLOR] [B]'+flatn+'[/B]','',mode='filtr:flat',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Oceny widzów:[/COLOR] [B]'+focen+'[/B]','',mode='filtr:foce',iconimage='',IsPlayable=False)
    addDir(name='[B][COLOR blue]Wyświetl filmy[/B][/COLOR]',ex_link='f|https://hdseans.pl/filmy/search', mode='ListMovies',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir('[B]Szukaj[/B]','',mode='Szukaj')
    xbmcplugin.setContent(addon_handle, 'videos')
    xbmcplugin.endOfDirectory(addon_handle)
    
elif mode[0] == 'sercat':
    addDir(name='Ostatnio dodane odcinki',ex_link='dodanes', mode='ListTop',page=1,iconImage='DefaultFolder.png',fanart=FANART)
   # addDir(name='Najpoppularniejsze seriale',ex_link='populars', mode='ListPopular',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addLinkItem('[COLOR blue]Gatunki:[/COLOR] [B]'+skatn+'[/B]','',mode='filtr:skat',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Wersja językowa:[/COLOR] [B]'+swern+'[/B]','',mode='filtr:swer',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Jakość:[/COLOR] [B]'+sjakn+'[/B]','',mode='filtr:sjak',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Rok produkcji:[/COLOR] [B]'+slatn+'[/B]','',mode='filtr:slat',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Oceny widzów:[/COLOR] [B]'+socen+'[/B]','',mode='filtr:soce',iconimage='',IsPlayable=False)
    addDir(name='[B][COLOR blue]Wyświetl seriale[/B][/COLOR]',ex_link='s|https://hdseans.pl/seriale/search', mode='ListMovies',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir('[B]Szukaj[/B]','',mode='Szukaj')
    xbmcplugin.setContent(addon_handle, 'videos')
    xbmcplugin.endOfDirectory(addon_handle)
    
elif mode[0] == 'bajkicat':
   # addDir(name='Najpoppularniejsze',ex_link='popularb', mode='ListPopular',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addLinkItem('[COLOR blue]Jakość:[/COLOR] [B]'+bjakn+'[/B]','',mode='filtr:bjak',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Wersja językowa:[/COLOR] [B]'+bwern+'[/B]','',mode='filtr:bwer',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Rok produkcji:[/COLOR] [B]'+blatn+'[/B]','',mode='filtr:blat',iconimage='',IsPlayable=False)
    addLinkItem('[COLOR blue]Oceny widzów:[/COLOR] [B]'+bocen+'[/B]','',mode='filtr:boce',iconimage='',IsPlayable=False)
    addDir(name='[B][COLOR blue]Wyświetl bajki[/B][/COLOR]',ex_link='b|https://hdseans.pl/bajki/search', mode='ListMovies',page=1,iconImage='DefaultFolder.png',fanart=FANART)
    addDir('[B]Szukaj[/B]','',mode='Szukaj')
    xbmcplugin.setContent(addon_handle, 'videos')
    xbmcplugin.endOfDirectory(addon_handle)
    
    
elif mode[0] =='ListPopular':
    items = segos.ListPopular(ex_link)
    for f in items:
        url=f.get('url')
        contextmenu = []
        if 'moja-lista' in ex_link:
            contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)         

        else:
            contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)             
        if '/seriale/' in url:
            addDir('[B][COLOR blue]Serial [/B][/COLOR]'+f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=f,iconImage=f.get('img'), contextmenu=contextmenu)    
        else:    
            addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=10, contextmenu=contextmenu)

    if '/seriale/' in ex_link:
        xbmcplugin.setContent(addon_handle, 'tvshows')
    else:
        xbmcplugin.setContent(addon_handle, 'movies')
    xbmcplugin.endOfDirectory(addon_handle)
    
    
    
    
elif mode[0] == 'settings':
    my_addon.openSettings()
    xbmc.executebuiltin('Container.Refresh()')
elif mode[0] == 'ListTop':
    items = segos.ListTop(ex_link)
    for f in items:
        url=f.get('url')
        contextmenu = []
        if 'moja-lista' in ex_link:
            contextmenu.append(('Usuń z "Moja lista"', 'Container.Refresh(%s)'%  build_url({'mode': 'usundobejrz', 'ex_link' : f.get('url')})),)         

        else:
            contextmenu.append(('Dodaj do "Moja lista"', 'Container.Update(%s)'%  build_url({'mode': 'dodobejrz', 'ex_link' : f.get('url')})),)             
        if '/seriale/' in url and not '#player' in url:
            addDir('[B][COLOR blue]Serial [/B][/COLOR]'+f.get('title'),ex_link=f.get('url'),mode='epizody',infoLabels=f,iconImage=f.get('img'), contextmenu=contextmenu)    
        else:    
            addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=10, contextmenu=contextmenu)
    if '/seriale/' in ex_link:
        xbmcplugin.setContent(addon_handle, 'tvshows')
    else:
        xbmcplugin.setContent(addon_handle, 'movies')
    xbmcplugin.endOfDirectory(addon_handle)
elif 'filtr' in mode[0]:

    sst = mode[0].split(":")[-1]
    if 'wer' in sst:
        dd='wersję językową:'
        label=['Wszystkie',    'LEKTOR',    'DUBBING',    'NAPISY PL',    'OBCOJĘZYCZNE']
        value=['','links[language]=Lektor+PL','links[language]=Dubbing+PL','links[language]=Napisy+PL','links[language]=ENG']
    elif 'kat' in sst:
        dd='gatunek:'
        label=["Wszystkie","Akcja","Animowany","Biograficzny","Dokumentalny","Dramat","Familijny","Fantasy","Historyczny","Horror","Inne","Katastroficzny","Komedia","Komedia romantyczna","Krymina�","Melodramat","Muzyczny","Obyczajowy","Przygodowy","Psychologiczny","Romans","Sci-Fi","Sensacyjny","Thriller","Western","Wojenny","Komedia kryminalna","Sportowy","Szpiegowski","Satyra","Sztuki walki","Kr�tkometra�owy","Kostiumowy","Dramat historyczny","Erotyczny","Komedia obyczajowa","Etiuda","Polityczny","Czarna komedia","Dramat spo�eczny","Dreszczowiec","Dla m�odzie�y","Ba��","Biblijny","Anime","Film-Noir","Karate","Fikcja literacka"]
        value=["","genre[]=akcja","genre[]=animowany","genre[]=biograficzny","genre[]=dokumentalny","genre[]=dramat","genre[]=familijny","genre[]=fantasy","genre[]=historyczny","genre[]=horror","genre[]=inne","genre[]=katastroficzny","genre[]=komedia","genre[]=komedia-romantyczna","genre[]=kryminal","genre[]=melodramat","genre[]=muzyczny","genre[]=obyczajowy","genre[]=przygodowy","genre[]=psychologiczny","genre[]=romans","genre[]=sci-fi","genre[]=sensacyjny","genre[]=thriller","genre[]=western","genre[]=wojenny","genre[]=komedia-kryminalna","genre[]=sportowy","genre[]=szpiegowski","genre[]=satyra","genre[]=sztuki-walki","genre[]=krotkometrazowy","genre[]=kostiumowy","genre[]=dramat-historyczny","genre[]=erotyczny","genre[]=komedia-obyczajowa","genre[]=etiuda","genre[]=polityczny","genre[]=czarna-komedia","genre[]=dramat-spoleczny","genre[]=dreszczowiec","genre[]=dla-mlodziezy","genre[]=basn","genre[]=biblijny","genre[]=anime","genre[]=film-noir","genre[]=karate","genre[]=fikcja-literacka"]

    elif 'lat' in sst:
        dd='rok produkcji:'
        label=['Wszystkie','2021','2020','2019','2018-2017','2016-2015','<2014']
        value=['','year=2021','year=2020','year=2019','year=2018-2017','year=2016-2015','year=<2014']
    elif 'jak' in sst:
        dd='jakość:'
        label=['Wszystkie','Bardzo wysoka (1080p)','Dobra (720p)','Średnia (480p, 360p, inne)']
        value=['','links[quality]=1080p','links[quality]=720p','links[quality]=420']
    elif 'oce' in sst:
        dd='oceny widzów'
        label=['Wszystkie','8.00 - 10.00','6.00 - 8.00','4.00 - 6.00','< 4.00']
        value=['','reviews=8-10','reviews=6-8','reviews=4-6','reviews=0-4']

    if 'kat' in sst:
        s = xbmcgui.Dialog().multiselect('Wybierz '+dd,label)
    else:
        s = xbmcgui.Dialog().select('Wybierz '+dd,label)

    if s<=-1: quit()#s=0
    if isinstance(s,list):
        if 0 in s: s=[0]
        v = '&'+'%s'%('&'.join( [ value[i] for i in s])) if s[0]!=0 else ''
        n = ', '.join( [ label[i] for i in s])
    else:
        s = s if s>-1 else quit()
        v = '&'+'%s'%value[s] if value[s] else ''
        n = label[s]

    my_addon.setSetting(sst+'V',v)
    my_addon.setSetting(sst+'N',n)
    
    fkatv = my_addon.getSetting('fkatV')
    skatv = my_addon.getSetting('skatV')
    fwerv = my_addon.getSetting('fwerV')
    swerv = my_addon.getSetting('swerV')
    bwerv = my_addon.getSetting('bwerV')
    
    fjakv = my_addon.getSetting('fjakV')
    sjakv = my_addon.getSetting('sjakV')
    bjakv = my_addon.getSetting('bjakV')
    
    flatv = my_addon.getSetting('flatV')
    slatv = my_addon.getSetting('slatV')
    blatv = my_addon.getSetting('blatV')
    
    focev = my_addon.getSetting('foceV')
    socev = my_addon.getSetting('soceV')
    bocev = my_addon.getSetting('boceV')

    dataf=fkatv+fwerv+fjakv+flatv+focev
    datas=skatv+swerv+sjakv+slatv+socev
    datab=bwerv+bjakv+blatv+bocev
    
    
    
    my_addon.setSetting('fdata',dataf)
    my_addon.setSetting('sdata',datas)
    my_addon.setSetting('bdata',datab)
    xbmc.executebuiltin('Container.Refresh')
    

elif mode[0] == 'Opcje':
    my_addon.openSettings()
elif mode[0] == '__page__M':
    url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : ex_link ,'page':page})
    xbmc.executebuiltin('Container.Refresh(%s)'% url)
elif mode[0] == '__page__MK':
    url = build_url({'mode': 'ListMoviesKat', 'foldername': '', 'ex_link' : ex_link ,'page':page})
    xbmc.executebuiltin('Container.Refresh(%s)'% url)
elif mode[0] == '__page__S':
    url = build_url({'mode': 'ListSerials', 'foldername': '', 'ex_link' : ex_link ,'page':page})
    xbmc.executebuiltin('Container.Refresh(%s)'% url)
    
elif mode[0] == 'ListMoja':    
    start()
    ListMoja(ex_link)    

elif mode[0] == 'ListMovies':
    start()
    if 'moja-lista' in ex_link:
        urlk=ex_link
    else:
        urlk=ex_link+fsortv
    ListMovies(urlk,page)        

elif mode[0] == 'ListMoviesKat':
    start()
    ListMoviesKAT(ex_link,page)
elif mode[0] == 'ListSerials':
    start()
    ListSerials(ex_link+fsortv,page)
elif mode[0] == 'epizody':
    start()
    ListEpisodes(ex_link)
    
elif mode[0] == 'dodobejrz':
    dodObejrz(ex_link)    
elif mode[0] == 'usundobejrz':
    usunObejrz(ex_link)    
    ListMoja('https://hdseans.pl/moja-lista')
elif mode[0] == 'getLinks':
    getLinks(ex_link)
elif mode[0] == 'ListSearch':    
    ListSearch(ex_link)
elif mode[0] == 'GatunekRok':
    data = segos.GatunekRok()
    if data:     
        genres = [x[1].strip() for x in data]
        hrefs = [x[0].strip() for x in data]
        for label,url in zip(genres,hrefs):
            genr=url.split('&category=')#[-1]
            if fsortv:
                linkx=genr[0]+fsortv+genr[-1]
            else:
                linkx=url
            addDir(name=label,ex_link=linkx, mode='ListMoviesKat',page=1,iconImage='DefaultFolder.png',fanart=FANART)
        xbmcplugin.endOfDirectory(addon_handle)
        
elif mode[0] =='Szukaj':
    addDir('[COLOR lightgreen]Nowe Szukanie[/COLOR]','',mode='SzukajNowe')
    entries = search()
    if not entries == ['']:
        for entry in entries:
            contextmenu = []
            contextmenu.append(('Usuń', 'Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'ex_link' : entry})),)
            contextmenu.append(('Usuń całą historię', 'Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
            entry = entry.encode('utf-8') if six.PY2 else entry
            addDir(name=entry, ex_link='https://hdseans.pl/autocomplete?query='+urllib_parse.quote_plus(entry), mode='ListSearch', page=1, fanart=None, contextmenu=contextmenu)
    xbmcplugin.endOfDirectory(addon_handle)    

elif mode[0] =='SzukajNowe':
    d = xbmcgui.Dialog().input('Szukaj, Podaj tytuł', type=xbmcgui.INPUT_ALPHANUM)
    if d:
        setHistory(d)
        ListSearch('https://hdseans.pl/autocomplete?query='+urllib_parse.quote_plus(d)) #bo%C5%BCe
    else:
        quit()

elif mode[0] =='SzukajUsun':
    delOne(ex_link)
    xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
elif mode[0] == 'SzukajUsunAll':
    delAll()
    xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
elif mode[0] == 'zwiastun':
    id=ex_link.split('/')[-1].split('=')[-1]
    mediaPath = 'plugin://plugin.video.youtube/?action=play_video&videoid=%s' % id
    xbmc.executebuiltin('xbmc.PlayMedia('+mediaPath+')')
elif mode[0] == 'folder':
    pass
else:
    xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
