# -*- coding: utf-8 -*-

import sys,re,os
import urllib,urllib2
import urlparse
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin

base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urlparse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonId     = my_addon.getAddonInfo('id')
addonName       = my_addon.getAddonInfo('name')
PATH        = my_addon.getAddonInfo('path').decode('utf-8')
DATAPATH    = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES   = PATH+'/resources/'
ICON       = PATH+'/icon.png'
l1l111llll11l1_mS_        = RESOURCES+'mh.png'
FANART=RESOURCES+'fanart.png'
sys.path.append(RESOURCES+'lib/')
urlopen = urllib2.urlopen
urllib_request = urllib2.Request
dialog = xbmcgui.Dialog()
import time

def addLinkItem(name, url, mode, page=1, iconimage='DefaultFolder.png', infoLabels={}, IsPlayable=True, isFolder=False, fanart=FANART,itemcount=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page,'minfo':str(infoLabels)})
    isFolder = infoLabels.get('isFolder',isFolder)
    if isFolder and infoLabels.get('year',False):
        name += ' (%s)'%infoLabels.get('year')
    playItem = xbmcgui.ListItem(name)
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[infoLabels.get(x,iconimage) for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape']
    playItem.setArt(art)
    id = infoLabels.pop('id') if infoLabels.has_key('id') else False
    playItem.setInfo(type="video", infoLabels=infoLabels)
    if IsPlayable and not isFolder:
        playItem.setProperty('IsPlayable', 'true')
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=playItem,isFolder=isFolder,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok
	
def addDir(name,ex_link=None, page=1, mode='folder',iconImage='DefaultFolder.png', infoLabels={}, fanart=FANART,contextmenu=None):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page})
    li = xbmcgui.ListItem(name)
    if infoLabels:
        li.setInfo(type="video", infoLabels=infoLabels)
    art_keys=['thumb','poster','banner','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[infoLabels.get(x,iconImage) for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape']
    li.setArt(art)
    if contextmenu:
        isp=contextmenu
        li.addContextMenuItems(isp, replaceItems=True)
    else:
        isp = []
        isp.append(('Informacja', 'XBMC.Action(Info)'),)
        li.addContextMenuItems(isp, replaceItems=False)
    xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")

def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))
def getYTlink(YTurl,YTout=[],index=False):
    aparty = getAparty()
    out = aparty.getYTid(YTurl)
    ff = {}
    if out and isinstance(out,list):
        ff = out[0]
        YTurl='http://youtube.com/watch?v=%s' %ff.get('id')
        try:
            import resolveurl as urlresolver
            ff['url'] = urlresolver.resolve(YTurl)
        except:
            pass
    if index:
        YTout[index]=ff
    return ff
def Loguj(usr,passwd):
    aparty = getAparty()
    status=aparty.Logowanie(usr,passwd)
    if status.get('status'):
        xbmcgui.Dialog().notification('Pomyślne logowanie','[B]Twoja Muzyka[/B] jest już dostępna', ICON, 2000, False)
    else:
        xbmcgui.Dialog().notification('[COLOR red]Problem z logowaniem[/COLOR]','Sprawdź dane użytkownika w opcjach wtyczki' ,ICON, 5000)
def getAparty():
    import arenapartypl as aparty
    aparty.COOKIEFILE=os.path.join(DATAPATH,'cookie.da')
    return aparty
class arenaparty():
    @staticmethod
    def root():
        addDir(name='Popularny Album',mode='popular_albums',ex_link='',iconImage=RESOURCES+'album.png',infoLabels={})
        addDir(name='Popularny Gatunek',mode='popular_genres',ex_link='',iconImage=RESOURCES+'gatunek.png',infoLabels={})
        addDir(name='Top 50',mode='top_50',ex_link='',iconImage=RESOURCES+'top.png',infoLabels={})
        addDir(name='Nowe wydania',mode='new_releases',ex_link='',iconImage=RESOURCES+'nowe.png',infoLabels={})
        infoLabel={'plot':'Twoja Muzyka - zawartość synchronizaowana z serwisem.'}
        addDir(name=' [B]Piosenki[/B]',mode='user_content',ex_link='https://arenaparty.pl/secure/user/library/tracks',iconImage=RESOURCES+'tw_piosenki.png',infoLabels=infoLabel)
        addDir(name=' [B]Albumy[/B]',mode='user_content',ex_link='https://arenaparty.pl/secure/user/library/albums',iconImage=RESOURCES+'album.png',infoLabels=infoLabel)
        addDir(name=' [B]Artyści[/B]',mode='user_content',ex_link='https://arenaparty.pl/secure/user/library/artists',iconImage=RESOURCES+'tw_artysci.png',infoLabels=infoLabel)
        addDir(name='Szukaj',mode='search',ex_link=None, iconImage=RESOURCES+'szukaj.png')
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def Popular_Genres():
        aparty = getAparty()
        out = aparty.Popular_Genres()
        for f in out:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='genres_artists', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def Genres_Artists(nturl):
        aparty = getAparty()
        out,pagination = aparty.Genres_Artists(nturl)
        mud='__page__:genres_artists'
        if pagination[0]:
            addLinkItem(name='[COLOR lightblue]<< poprzednia strona <<[/COLOR]', url=pagination[0], mode=mud, IsPlayable=False)
        for f in out:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='artist_content', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        if pagination[1]:
            addLinkItem(name='[COLOR lightblue]>> następna strona >>[/COLOR]', url=pagination[1], mode=mud, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def Artist_Content(nturl):
        aparty = getAparty()
        out = aparty.Artist_Content(nturl)
        pagination = out.get('pagination',(False,False))
        tracksy = out.get('top_tracks',[])
        albumy = out.get('albums',[])
        if len(tracksy)>1: addLinkItem('[COLOR lightblue][B]Play Top Tracks[/B][/COLOR]', url=urllib.quote(str(tracksy)), mode='playYTAll', infoLabels={'plot':'Tworzy playliste ze wszystkimi utworami w katalogu'}, iconimage=ICON, IsPlayable=False)
        for f in tracksy: addLinkItem(name=f.get('title'), url=f.get('href'), mode='playYT', iconimage=f.get('img'), infoLabels=f, isFolder=False, IsPlayable=True)
        mud='__page__:artist_content'
        for f in albumy:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='popular_albums_tracks', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        if pagination[1]:
            addLinkItem(name='[COLOR lightblue]>> następna strona >>[/COLOR]', url=pagination[1], mode=mud, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def AddToLibrary(ex_link):
        aparty = getAparty()
        libEntry = eval(ex_link)
        status = aparty.add2library(libEntry,'add')
        if status.get('status'):
            xbmc.executebuiltin('Notification([COLOR green]OK[/COLOR],'+status.get('msg')+' , 2000)')
        else:
            xbmc.executebuiltin('Notification([COLOR red]Problem[/COLOR],'+status.get('msg')+',2000)')
    @staticmethod
    def User_Content(nturl):
        usr = my_addon.getSetting('user')
        passwd = my_addon.getSetting('pass')
        if not usr or not passwd:
            if xbmcgui.Dialog().yesno("Twoja Muzyka","Zawartość tego folderu jest dostępna po zalogowaniu","[B]Wprowadzić dane użytkownika?[/B]"):
                my_addon.openSettings()
                usr = my_addon.getSetting('user')
                passwd = my_addon.getSetting('pass')
        aparty = getAparty()
        out = aparty.User_Content(nturl)
        if not out and (usr and passwd):
            Loguj(usr,passwd)
            out = aparty.User_Content(nturl)
        pagination = out.get('pagination',(False,False))
        dane  = out.get('tracks',[])
        albumy  = out.get('albums',[])
        artysci = out.get('artists',[])
        if len(dane):
            if len(dane)>1: addLinkItem('[COLOR lightblue][B]Play All[/B][/COLOR]', url=urllib.quote(str(dane)), mode='playYTAll', infoLabels={'plot':'Tworzy playliste ze wszystkimi utworami w katalogu'}, iconimage=ICON, IsPlayable=False)
            for f in dane: addLinkItem(name=f.get('title'), url=f.get('href'), mode='playYT', iconimage=f.get('img'), infoLabels=f, isFolder=False, IsPlayable=True)
        mud='__page__:artist_content'
        for f in albumy:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='popular_albums_tracks', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        for f in artysci:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='artist_content', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        if pagination[1]:
            addLinkItem(name='[COLOR lightblue]>> następna strona >>[/COLOR]', url=pagination[1], mode=mud, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def New_Releases():
        aparty = getAparty()
        out = aparty.New_Releases()
        for f in out: addLinkItem(name=f.get('title'), url=f.get('href'), mode='popular_albums_tracks', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def _page(mode,ex_link):
        mymode=mode.split(":")[-1]
        url = build_url({'mode': mymode, 'foldername': '', 'ex_link' : ex_link })
        xbmc.executebuiltin('XBMC.Container.Update(%s)'% url)
    @staticmethod
    def Popular_Albums():
        aparty = getAparty()
        out = aparty.Popular_Albums()
        for f in out:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='popular_albums_tracks', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def getTracks(traksy):
        aparty = getAparty()
        out = aparty.getTracks(traksy)
        if len(out)>1: addLinkItem('[COLOR lightblue][B]Play Album[/B][/COLOR]', url=urllib.quote(str(out)), mode='playYTAll', infoLabels={'plot':'Tworzy playliste KODI ze wszystkimi utworami w katalogu'}, iconimage=ICON, IsPlayable=False)
        for f in out:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='playYT', iconimage=f.get('img'), infoLabels=f, isFolder=False, IsPlayable=True)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def Top_50():
        aparty = getAparty()
        out = aparty.Top_50()
        if len(out)>1: addLinkItem('[COLOR lightblue][B]Play All[/B][/COLOR]', url=urllib.quote(str(out)), mode='playYTAll', infoLabels={'plot':'Tworzy playliste ze wszystkimi utworami w katalogu'}, iconimage=ICON, IsPlayable=False)
        for f in out:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='playYT', iconimage=f.get('img'), infoLabels=f, isFolder=False, IsPlayable=True)
        xbmcplugin.endOfDirectory(addon_handle)
    @staticmethod
    def PlayYT(ex_link):
        aparty = getAparty()
        out = aparty.getYTid(ex_link)
        if out and isinstance(out,list):
            YTurl='http://youtube.com/watch?v=%s' %out[0].get('id')
            try:
                import resolveurl as urlresolver
                stream_url = urlresolver.resolve(YTurl)
            except Exception,e:
                stream_url=''
            if stream_url:
                xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
            else:
                xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
		
    @staticmethod
    def PlayYTAll(daneYTlinks):
        data = eval(urllib.unquote(daneYTlinks))
        playlista = xbmc.PlayList(xbmc.PLAYLIST_VIDEO)
        playlista.clear()

        pdialog = xbmcgui.DialogProgress()
        pdialog.create('Tworzę playlistę','Proszę czekać...')
        pdialog.update(0)
        increment = 100/len(data)
        progress = 0.0
		
        for d in data:
            if pdialog.iscanceled() or xbmc.abortRequested:
                pdialog.close()
                return
            href2 = d.get('href','')
            first = getYTlink(href2)
            li = xbmcgui.ListItem(d.get('title'), iconImage=d.get('img'),thumbnailImage=d.get('img'))
            infoLabels = {'Title':d.get('title')}
            li.setInfo(type='Video',infoLabels=infoLabels)
            li.setProperty("IsPlayable","true")
        
            playlista.add(first.get('url'),li)
            progress = progress + increment
            pdialog.update( int( progress ) )
        pdialog.close()
        xbmc.Player().play(playlista) 
		
    @staticmethod
    def Search(mode,ex_link):
        from cache import storage
        mymode=mode.split(":")[-1] if ':' in mode else ''
        if mymode == '':
            addDir('[COLOR lightgreen]Nowe szukanie ...[/COLOR]',ex_link='',mode='search:new')
            entries = storage().getHistory()
            if not entries == ['']:
                for entry in entries:
                    contextmenu = []
                    contextmenu.append((u'Remove', 'XBMC.Container.Update(%s)'% build_url({'mode': 'search:delOne', 'ex_link' : entry})),)
                    contextmenu.append((u'Remove All', 'XBMC.Container.Update(%s)' % build_url({'mode': 'search:delAll'})),)
                    addDir(name=entry, ex_link=entry, mode='search:new', fanart=None, contextmenu=contextmenu)
            xbmcplugin.endOfDirectory(addon_handle)
        elif mymode =='new':
            if not ex_link:
                search_entry = dialog.input(u'wykonawca/album/utwór', type=xbmcgui.INPUT_ALPHANUM)
                if search_entry: storage(). setHistory(search_entry)
                else: return
            else:
                search_entry = ex_link
            if search_entry:
                aparty = getAparty()
                out = aparty.search(search_entry)
                dane  = out.get('tracks',[])
                albumy  = out.get('albums',[])
                artysci = out.get('artists',[])
                for f in dane: addLinkItem(name=f.get('title'), url=f.get('href'), mode='playYT', iconimage=f.get('img'), infoLabels=f, isFolder=False, IsPlayable=True)
                for f in albumy: addLinkItem(name=f.get('title'), url=f.get('href'), mode='popular_albums_tracks', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
                for f in artysci:addLinkItem(name=f.get('title'), url=f.get('href'), mode='artist_content', iconimage=f.get('img'), infoLabels=f, isFolder=True, IsPlayable=False)
            xbmcplugin.endOfDirectory(addon_handle)
        elif mymode =='delOne':
            storage().delOne(ex_link)
            xbmc.executebuiltin('XBMC.Container.Update(%s)'%  build_url({'mode': 'search'}))
        elif mymode =='delAll':
            storage().delAll()
            xbmc.executebuiltin('XBMC.Container.Update(%s)'%  build_url({'mode': 'search'}))



