# -*- coding: utf-8 -*-

import urllib2,urllib
import re,os,json,base64
from random import choice
import cookielib
from urlparse import urlparse,urljoin

TIMEOUT = 15
UA='Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36'
COOKIEFILE=os.path.join(os.getcwd(),'cookie')
def getUrl(u):
    kuks = getCookieString()
    headers = { 'User-Agent': UA, 'referer': 'https://arenaparty.pl/', 'cookie':kuks}
    try:
        req = urllib2.Request(u, None, headers)
        content = urllib2.urlopen(req)
        data = json.load(content)
    except:
        data={}
    return data
def User_Content(url):
    dd = getUrl(url)
    
    if not dd: return {}
    
    out={}
    if '/library/tracks'in url:
        dd=dd.get('pagination')
        tracksy = dd.get('data',[])
        npage=dd.get('next_page_url',False)
        ppage=dd.get('prev_page_url',False)
        out['tracks'] = getTracks(tracksy)
        out['pagination']=(ppage,npage)
    elif '/library/albums'in url:
        dd=dd.get('pagination').get('data',[])
        out['albums']= getAlbums(dd)
    elif 'library/artists' in url:
        dd=dd.get('pagination').get('data',[])
        out['artists'] = getArtists(dd)
    return out

class l1ll111ll11l1_mS_(urllib2.HTTPErrorProcessor):
    def http_response(self, request, response):
        return response
def add2library(ids=[25498],action='add'):
    if not ids:
        status = {'msg':'Brak identyfikatora pozycji','status':False}
    else:

        url = 'https://arenaparty.pl/secure/user/likeables'

        data = {"likeables":[{"likeable_id":ids,"likeable_type":"App\\Track"}]}

        params = urllib.urlencode(data)
        cookiejar = cookielib.LWPCookieJar()
        try: cookiejar.load(COOKIEFILE,True,True)
        except: cookiejar = cookielib.LWPCookieJar()
        opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cookiejar),urllib2.HTTPRedirectHandler())
        urllib2.install_opener(opener)
        sc = getCookieString()
        token = re.findall('XSRF-TOKEN=(.*?);',sc)
        if not token:
            status = {'msg':'nie jestesteś zalogowany','status':False}
            return status
        sc+='ArenaParty_cookie_notice=1;'
        header = { 'User-Agent': UA, 'Cookie':sc,'Referer':'https://arenaparty.pl','Content-Type':'application/json','X-XSRF-TOKEN':token[0],
                   'Host':'arenaparty.pl','Origin':'https://arenaparty.pl','Connection':'keep-alive','Accept':'*/*','Pragma':'no-cache'}
        try:
            req = urllib2.Request(url, params ,header)
            response = urllib2.urlopen(req)
            content = response.read()
            response.close()
            status = {'msg':'Akcja zakończona pomyślnie!','status':True}
        except:
            status = {'msg':'Serwis zwrócił bład','status':False}
    return status
def getCookieString():
    cookiejar = cookielib.LWPCookieJar()
    try:
        cookiejar.load(COOKIEFILE,True,True)
        sc = ';'.join(['%s=%s'%(c.name,c.value) for c in cookiejar])
    except:
        sc=''
    return sc
def Logowanie(u,p):
    url = 'https://arenaparty.pl/secure/auth/login'
    data ={"email":u,"password":p,"remember":True}
    cookiejar = cookielib.LWPCookieJar()
    opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cookiejar))
    urllib2.install_opener(opener)
    params=urllib.urlencode(data)
    status={'status':False}
    try:
        req = urllib2.Request(url, params,{ 'User-Agent': UA, 'referer': 'https://arenaparty.pl/' })
        response = urllib2.urlopen(req)
        content = response.read()
        response.close()
        r=json.loads(content)
        a=r['data'].decode('base64')
        user = re.findall('"user":({.*?\}),"guests_role',a)
        user = json.loads(user[0]) if user else {}
        status['display_name']=user.get('display_name','[B]Zaloguj[/B]')
        status['avatar']=user.get('avatar','')
        if 'success' in r["status"]:
            status['cookie']=';'.join(['%s=%s'%(c.name,c.value) for c in cookiejar])
            cookiejar.save(COOKIEFILE, ignore_discard = True)
            status['status']=True
    except:
        pass
    return status
def search(text='ira',ilosc=10):

    try:
        nturl = 'https://arenaparty.pl/secure/search/%s?limit=%d&modelTypes=App\Artist,App\Album,App\Track,App\User,App\Playlist'%(urllib.quote(text),ilosc)
        dd = getUrl(nturl)
    except:
        dd = {}
    out={}
    tracksy = dd.get('results').get('tracks',[])
    albumy = dd.get('results').get('albums',[])
    artysci = dd.get('results').get('artists',[])
    if tracksy:  out['tracks'] = getTracks(tracksy)
    if albumy:  out['albums'] = getAlbums(albumy)
    if artysci: out['artists'] = getArtists(artysci)
    return out
def Popular_Genres():
    u='https://arenaparty.pl/secure/channel/genres'

    nturl= 'https://arenaparty.pl/secure/genres/%s' 
    dd = getUrl(u)
    dd = dd.get('channel').get('content')
    for f in dd:
        f['title']=f.get('name')
        f['img']=f.get('image')
        f['href']=nturl%urllib.quote(f.get('name'))
    return dd
def Genres_Artists(url):
    content = getUrl(url)
    
    npage=content.get('artists',{}).get('next_page_url',False)
    ppage=content.get('artists',{}).get('prev_page_url',False)
    dd = content.get('artists',{}).get('data',[])
    out = getArtists(dd)
    return out,(ppage,npage)
def getArtists(dd):
    out=[]
    nturl= 'https://arenaparty.pl/secure/artists/{}?with=bio,bioImages&top_tracks=true'
    for f in dd:
        dane={}
        dane['title']=f.get('name')
        if f.get('bio',{}):
            dane['plot']=f.get('bio',{}).get('bio','')
            try:
                fanart = f.get('bio',{}).get('images',[])
                dane['fanart'] = choice(fanart).get('url','')
            except:
                pass
				
        dane['img']=f.get('image_large') if f.get('image_large') else f.get('image')
        dane['href']=nturl.format(f.get('id'))
        out.append(dane)
    return out
def Artist_Content(url):
    content = getUrl(url)
    out={}
    tracksy = content.get('top_tracks',[])
    if len(tracksy)>1: out['top_tracks'] = getTracks(tracksy)
    if content.get('albums'):
        dd=content.get('albums')
        out['albums']= getAlbums(dd.get('data'))
        npage=dd.get('next_page_url',False)
        ppage=dd.get('prev_page_url',False)
        out['pagination']=(ppage,npage)
    return out
def New_Releases():
    u='https://arenaparty.pl/secure/channel/new-releases'
    dd = getUrl(u)
    out = getAlbums(dd)
    return out
def Popular_Albums():
    u='https://arenaparty.pl/secure/channel/popular-albums'
    dd = getUrl(u)

    return getAlbums(dd)
def getAlbums(dd):
    out=[]

    try:
    	dd = dd.get('channel').get('content')
    except:
    	dd=dd
    for f in dd:
        dane={}
        dane['artist_'] = f.get('artist',{}).get('name','')
        dane['title']='[B]'+ dane['artist_'] +'[/B] - ' if dane['artist_'] else ''
        dane['title']+= f.get('name')
        dane['img']=f.get('image')
        tracksy= f.get('tracks',[])
        dane['plot'] =''
        dane['plot']+='Artysta: %s\n'%dane['artist_'] if dane['artist_'] else ''
        dane['plot']+='Album: %s\n'%f.get('name') if f.get('name') else ''
        dane['plot']+='%d: tracks\n'%(len(tracksy))
        for l1l1111ll11l1_mS_ in tracksy:
            l1l1111ll11l1_mS_['image'] = f.get('image')
        if tracksy: dane['href']=json.dumps(tracksy)
        else: dane['href']='https://arenaparty.pl/secure/albums/%d?simplified='%f.get('id')
        out.append(dane)
    return out
def getTracks(tracksy):
    import datetime
    if not isinstance(tracksy,list) and tracksy.startswith('http'):
        dd = getUrl(tracksy)
        tracksy = dd.get('album').get('tracks')
    out=[]
    nturl= 'https://arenaparty.pl/secure/search/audio/%s/%s/%s'
    for f in tracksy:
        dane={}
        dane['artist_'] = f.get('artists')[0].get('name')
        dane['album_']=f.get('album_name','')
        dane['title']='%02d. %s'%(f.get('number',1),f.get('name'),)
        dane['img'] = f.get('image') if f.get('image') else f.get('album',{}).get('image')
        dane['plot'] =''
        dane['id'] =f.get('id',False)
        dane['code']=str(datetime.timedelta(seconds=int(f.get('duration'))/1000))
        dane['duration']=f.get('duration')
        if f.get('youtube_id'):
            dane['href']=f.get('youtube_id')
        else:
            dane['href']=nturl%( dane['id'],urllib.quote(dane['artist_'].encode('utf-8')) , urllib.quote(f.get('name','').encode('utf-8')) )
        out.append(dane)
    return out
def Top_50():
    import datetime

    nturl= 'https://arenaparty.pl/secure/search/audio/%s/%s/%s'
    u='https://arenaparty.pl/secure/channel/popular-tracks'
    dd = getUrl(u)
    out=[]
    dd = dd.get('channel').get('content')
    for f in dd:
        dane={}

        dane['artist_'] = f.get('artists')[0].get('name')
        dane['album_']=f.get('album_name','')
        dane['title']='[B]%s[/B] - %s'%(dane['album_'],f.get('name'))
        dane['img'] = f.get('album',{}).get('image','') if f.get('album') else ''
        dane['id'] =f.get('id',False)
        dane['plot'] =''
        dane['plot']+='Artysta: %s\n'%dane['artist_'] if dane['artist_'] else ''
        dane['plot']+='Album: %s\n'%f.get('name') if f.get('name') else ''
        dane['code']=str(datetime.timedelta(seconds=int(f.get('duration'))/1000))
        dane['duration']=f.get('duration')
        dane['youtube_id']=f.get('youtube_id','')
        if f.get('youtube_id',''):
            dane['href']=f.get('youtube_id','')
        else:
            dane['href']=nturl%( dane['id'],urllib.quote(dane['artist_'].encode('utf-8')) , urllib.quote(f.get('name','').encode('utf-8')) )
        out.append(dane)
    return out
def getYTid(YTurl):
    if YTurl.startswith('http'):
        dd = getUrl(YTurl)
    else:
        dd=[{'id':YTurl}]
    return dd


