# -*- coding: UTF-8 -*-
import sys,re
import six
from six.moves import urllib_parse, http_cookiejar

import requests,json
import xbmcgui, xbmc, xbmcvfs, xbmcplugin, xbmcaddon

if six.PY3:
    LOGNOTICE = xbmc.LOGINFO

else:
    LOGNOTICE = xbmc.LOGNOTICE

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.artetvpl')

PATH            = addon.getAddonInfo('path')
try:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
except:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
    
RESOURCES       = PATH+'/resources/'
file = RESOURCES+'categ.json'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'
prawo = RESOURCES+'right.png'

exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

UA= 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:84.0) Gecko/20100101 Firefox/84.0'
TIMEOUT=15

headersx = {'User-Agent': UA,}

headers = {

    'cache-control': 'public, max-age=60',
    'user-agent': 'arte/214402057',
    'authorization': 'Bearer MWZmZjk5NjE1ODgxM2E0MTI2NzY4MzQ5MTZkOWVkYTA1M2U4YjM3NDM2MjEwMDllODRhMjIzZjQwNjBiNGYxYw',

}

sess = requests.Session()

sess.cookies = http_cookiejar.LWPCookieJar()

EMAC_URL = 'https://api.arte.tv/api/emac/v3/pl/app/{}?authorizedAreas=ALL%2CSAT'

PROGRAM_URL = 'https://api.arte.tv/api/emac/v3/pl/app/{}' 

PLAYLIST_URL = 'https://api.arte.tv/api/player/v2/playlist/pl/{}'

def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):
    list_item = xbmcgui.ListItem(label=name)
    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')    
    if not infoLabels:
        infoLabels={'title': name}    
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})

    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'title':name,'image':image}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")


def home():
    add_item('https://api.arte.tv/api/emac/v3/pl/app/HOME?authorizedAreas=ALL,SAT','Strona główna', ikona, "listmaincateg" ,fanart=FANART, folder=True, IsPlayable=False)
    add_item('https://api.arte.tv/api/emac/v3/pl/app/MOST_VIEWED','Popularne', ikona, "listcontent" ,fanart=FANART, folder=True, IsPlayable=False)
    add_item('https://api.arte.tv/api/emac/v3/pl/app/MOST_RECENT','Najnowsze', ikona, "listcontent" ,fanart=FANART, folder=True, IsPlayable=False)
    add_item('https://api.arte.tv/api/emac/v3/pl/app/MOST_RECENT','Ostatnia szansa', ikona, "listcontent" ,fanart=FANART, folder=True, IsPlayable=False)
    add_item('https://api.arte.tv/api/emac/v3/pl/app/MAGAZINES','Magazyny', ikona, "listcontent" ,fanart=FANART, folder=True, IsPlayable=False)
    add_item('https:','Kategorie', ikona, "home2" ,fanart=FANART, folder=True, IsPlayable=False)
    add_item('', '[COLOR lightblue]Szukaj[/COLOR]', 'DefaultAddonsSearch.png', "search", folder=True)    
def home2():
    import json

    f = xbmcvfs.File(file)
    b = f.read()
    f.close()
    urlp=''

    jsdatas= json.loads(b)
    for data in jsdatas:
        title = data.get("label",None).encode(encoding='utf-8', errors='strict')
        plot = data.get("description",None).encode(encoding='utf-8', errors='strict')
        add_item(urlp,title, ikona, "listsubcateg" ,fanart=FANART, folder=True, IsPlayable=False,infoLabels={'plot':plot,'title':title})
    add_item('', '[COLOR lightblue]Szukaj[/COLOR]', 'DefaultAddonsSearch.png', "search", folder=True)    
    xbmcplugin.endOfDirectory(addon_handle)
    
def ListSubcateg(tit):
    f = xbmcvfs.File(file)
    b = f.read()
    f.close()
    urlp=''

    jsdatas= json.loads(b)
    for data in jsdatas:
        maincode =  data.get("code",None)
        if tit == data.get("label",None).encode(encoding='utf-8', errors='strict'):
            for subcateg in data.get("subcategories",None):
                title = subcateg.get("label",None).encode(encoding='utf-8', errors='strict')
                plot = subcateg.get("description",None).encode(encoding='utf-8', errors='strict')
                urlk = subcateg.get("url",None)
                if 'genres' in urlk:
                    urlp =  "https://api.arte.tv/api/emac/v3/pl/app/MOST_RECENT?category=%s&subcategories=%s"%(maincode, subcateg.get("code",None))
                else:
                    urlp = 'emac|'+subcateg.get("code",None)
                
                add_item(urlp,title, ikona, "listcontent" ,fanart=FANART, folder=True, IsPlayable=False,infoLabels={'plot':plot,'title':title})
            
    xbmcplugin.endOfDirectory(addon_handle)
    
def ListMainCateg(url):
    response = sess.get(url, headers=headers,verify=False)
    for zone in (response.json()).get('zones',None):#"zones"
        if zone.get("title",None) == "Top teaser" or 'Banner' in zone.get("title",None) or 'Wszystkie kategorie' in zone.get("title",None):
            continue
        else:
            if zone.get("data",None):
                title = zone.get("title",None).encode(encoding='utf-8', errors='strict')
                plot = zone.get("description",None)#.encode(encoding='utf-8', errors='strict')
                plot = plot.encode(encoding='utf-8', errors='strict') if plot else title
                
                cod = zone.get("code",None).get("name",None)# "code"
                add_item(url,title, ikona, "listmainsubcateg" ,fanart=FANART, folder=True, IsPlayable=False,infoLabels={'plot':plot,'title':title})
            else:
                continue
    xbmcplugin.endOfDirectory(addon_handle)
    
def ListMainSubCateg(url,subtitle):
    subtitle = subtitle.encode(encoding='utf-8', errors='strict') if six.PY3 else subtitle
    response = sess.get(url, headers=headers,verify=False)
    for zone in (response.json()).get('zones',None):
        if zone.get("title",None) == "Top teaser" or 'Banner' in zone.get("title",None) or 'Wszystkie kategorie' in zone.get("title",None):
            continue
        else:
            if zone.get("data",None):
                title = zone.get("title",None).encode(encoding='utf-8', errors='strict')
                if subtitle==title:
                    for data in zone.get("data",None):
                        title = data.get("title",None).encode(encoding='utf-8', errors='strict')
                        plot = data.get("shortDescription",None)
                        plot =plot.encode(encoding='utf-8', errors='strict') if plot else title
                        programid = data.get('programId',None)
                        urlp = 'https://api.arte.tv/api/player/v2/config/pl/'+programid
                        img = data.get('images',None)
                        for key, value in img.items():

                            if value:
                                if 'blurUrl' in value:
                                    img = value.get('blurUrl',None)
                        img = re.sub('(\d+x\d+.+?)$','1920x1080',img)
                        durat = data.get('duration',None)
                        fold = False
                        ispla = True
                        mod = 'playvidarte'
                        if 'RC-' in programid:
                            fold =True
                            ispla = False
                            mod = 'listcontent'
                            
                            urlp = PROGRAM_URL.format(programid)
                        add_item(urlp,title, img , mod ,fanart=FANART, folder=fold, IsPlayable=ispla,infoLabels={'plot':plot,'title':title,'duration':durat})

                    npage = zone.get("nextPage",None)
                    if npage:
                        npage = re.sub('limit\=\d+','limit=20',npage)
                        add_item(npage,'>> Następna strona >>', prawo, 'listcontent' ,fanart=FANART, folder=True, IsPlayable=False)

    xbmcplugin.endOfDirectory(addon_handle)            
                
                
                
def ListContent(typurlmain,subctit=None):
    try:
        typ,url = typurlmain.split('|')
    except:
        typ=''
        url = typurlmain
    if 'emac' == typ:
        main_url = EMAC_URL.format(url)
    else:
        main_url = url

    response = sess.get(main_url, headers=headers,verify=False)

    if 'emac' in typ or 'emac/v3/' in main_url and not 'MANUAL_TEASERS' in main_url and not '&page=' in main_url :
        for zone in (response.json()).get('zones',None):

            for data in zone.get('data',None):

                programid = data.get('programId',None)
                if not programid:
                    continue
                urlp = 'https://api.arte.tv/api/player/v2/config/pl/'+programid
                title = data.get('title',None).encode(encoding='utf-8', errors='strict')
                plot = data.get('shortDescription',None)
                plot = plot.encode(encoding='utf-8', errors='strict') if plot else title
                img = data.get('images',None)
                for key, value in img.items():
                    if value:
                        if 'blurUrl' in value:
                            img = value.get('blurUrl',None)
                img = re.sub('(\d+x\d+.+?)$','1920x1080',img)
                durat = data.get('duration',None)
                fold = False
                mod = 'playvidarte'
                ispla = True
                add_item(urlp,title, img, mod ,fanart=FANART, folder=fold, IsPlayable=ispla,infoLabels={'plot':plot,'title':title,'duration':durat})
            npage = zone.get('nextPage',None) 
            if npage:
                npage = re.sub('limit\=\d+','limit=20',npage)
                add_item(npage,'>> Następna strona >>', prawo, 'listcontent' ,fanart=FANART, folder=True, IsPlayable=False)
    else:
        for data in (response.json()).get('data',None):
            programid = data.get('programId',None)
            urlp = 'https://api.arte.tv/api/player/v2/config/pl/'+programid
            title = data.get('title',None).encode(encoding='utf-8', errors='strict')
            plot = data.get('shortDescription',None)
            plot = plot.encode(encoding='utf-8', errors='strict') if plot else title
            img = data.get('images',None)
            for key, value in img.items():

                if value:
                    if 'blurUrl' in value:
                        img = value.get('blurUrl',None)
            img = re.sub('(\d+x\d+.+?)$','1920x1080',img)
            durat = data.get('duration',None)
            fold = False
            mod = 'playvidarte'
            ispla = True
            add_item(urlp,title, img, mod ,fanart=FANART, folder=fold, IsPlayable=ispla,infoLabels={'plot':plot,'title':title,'duration':durat})
        npage = (response.json()).get('nextPage',None) 
        if npage:
            npage = re.sub('limit\=\d+','limit=20',npage)
            add_item(npage,'>> Następna strona >>', prawo, 'listcontent' ,fanart=FANART, folder=True, IsPlayable=False)

    xbmcplugin.endOfDirectory(addon_handle) 
def PlayVidarte(url):

    headers.update({'authorization': 'Bearer MzYyZDYyYmM1Y2Q3ZWRlZWFjMmIyZjZjNTRiMGY4MzY4NzBhOWQ5YjE4MGQ1NGFiODJmOTFlZDQwN2FkOTZjMQ'})

    response = sess.get(url, headers=headers, verify=False).json()
    streams = response.get("data",None).get("attributes",None).get("streams",None)
    out=[]
    for stream in streams:

        version = stream.get('versions',None)[0].get('label',None)
        stream_url = stream.get('url',None) 
        out.append({'title':version,'url':stream_url})
    
    t = [ x.get('title') for x in out]
    u = [ x.get('url') for x in out]

    select = xbmcgui.Dialog().select("Wybierz wersję:", t)
    
    if select > -1:
        link = u[select];    
        
        play_item = xbmcgui.ListItem(path=link)
        play_item.setProperty('inputstream.adaptive.manifest_type', 'hls')
        play_item.setProperty('inputstreamaddon', 'inputstream.adaptive')
        play_item.setMimeType('application/vnd.apple.mpegurl')
        play_item.setProperty('inputstream.adaptive.stream_headers','User-Agent='+UA )
        play_item.setContentLookup(False)    
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    else:

        quit()

def router(paramstring):
    params = dict(urllib_parse.parse_qsl(paramstring))
    if params:    

        mode = params.get('mode', None)

        if mode == "listcontent":
            ListContent(exlink)
            
        elif mode == "listsubcateg":
            ListSubcateg(nazwa)
            
        elif mode =="home2":
            home2()
            
        elif mode == "listmaincateg":
            ListMainCateg(exlink)        
            
        elif mode == "listmainsubcateg":
            ListMainSubCateg(exlink,nazwa)    
            
        elif mode == 'playvidarte':
            PlayVidarte(exlink)

        elif mode=='search':
            query = xbmcgui.Dialog().input(u'Szukaj...', type=xbmcgui.INPUT_ALPHANUM)
            if query:      
                query=query.replace(' ','%20')
                urlk = 'https://api.arte.tv/api/emac/v3/pl/app/SEARCH?query='+query
                ListContent(urlk )
        else:
            pass
    else:
        home()
        xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])