# -*- coding: UTF-8 -*-
import sys,re,os
PY3 = sys.version_info >= (3,0,0)
try:
    # For Python 3.0 and later
    from urllib.parse import urlencode, parse_qsl, quote
    from resources.lib.cmf3 import parseDOM
except ImportError:
    # Fall back to Python 2's urllib
    from resources.lib.cmf2 import parseDOM
    from urlparse import parse_qsl
    from urllib import urlencode, quote

import base64

import urllib3
import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs

import resolveurl as urlresolver

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.bajeczkiorg')

PATH            = addon.getAddonInfo('path')
try:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
except:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
    
RESOURCES       = PATH+'/resources/'
FANART=PATH+'fanart.jpg'

exlink = params.get('url', None)
name= params.get('title', None)
page = params.get('page',[1])

UA='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:109.0) Gecko/20100101 Firefox/110.0'
TIMEOUT=15

headers = {'User-Agent': UA,}
sess = requests.Session()

def build_url(query):
    return base_url + '?' + urlencode(query)

def add_item(url, name, image, folder, mode,  isPlayable=True, infoLabels=False, FANART=None, itemcount=1, page=0):

    list_item = xbmcgui.ListItem(label=name)    
        
    if isPlayable:
        list_item.setProperty("IsPlayable", 'true')
    if not infoLabels:
        infoLabels={'title': name,'plot':name}

    list_item.setInfo(type="video", infoLabels=infoLabels)

    FANART = FANART if FANART else image
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': FANART})
    xbmcplugin.addDirectoryItem(
        handle=addon_handle,    
        url = build_url({'title':name,'mode': mode, 'url' : url, 'page' : page,'plot':infoLabels,'image':image}),    
        listitem=list_item,
        isFolder=folder)

def home():

    add_item(name='Wszystkie bajki', url='http://bajeczki.org/all-categories/', mode="listbajki", image=RESOURCES+'icon.png', folder=True, isPlayable=False)
    add_item(name='Filmy', url='https://bajeczki.org/pelnometrazowe/', mode='listodcinki', image=RESOURCES+'icon.png', folder=True, isPlayable=False)
    add_item(name='Ostatnio dodane', url='http://bajeczki.org/page/%d/?s=', mode="ostdodane", image=RESOURCES+'icon.png', folder=True, isPlayable=False)
    add_item(name='[COLOR lightblue]Szukaj[/COLOR]', url='http://bajeczki.org/all-categories/', mode= "search", image=RESOURCES+'icon.png', folder=True, isPlayable=False)
    
    xbmcplugin.endOfDirectory(addon_handle)

def ListBajki(exlink):
    links= getBajki(exlink)
    itemz=links
    items = len(links)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='listodcinki', image=f.get('img'), folder=True, isPlayable=False, infoLabels={'title':f.get('title'),'plot':f.get('title')}, itemcount=items)


    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)

def getBajki(url):        
    html=getUrlReq(url)
    out=[]
    try:
        result=parseDOM(html,'div', attrs={'class': "all-categories"})[0] #    <div class="content-block clear">
        links=parseDOM(result,'div', attrs={'class': "category-bar"})
        for link in links:
            href = parseDOM(link, 'a', ret='href')[0] 
            tit=parseDOM(link,'span')[0]
            ilosc=parseDOM(link,'strong')[0]
            title=tit+' ['+ilosc+']'
            out.append({ 'href'  : href,'img': '','title' : PLchar(title),'mediatype': 'movie'})                    
    except:
        pass
    return out

def ListOdcinki(exlink,page=1):
    page = int(page) if page else 1
    links, pagin= getOdcinki(exlink,page)

    itemz=links
    items = len(links)
    for f in itemz:

        add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=False, isPlayable=True, infoLabels={'title':f.get('title'),'plot':f.get('title')}, itemcount=items)

    if pagin:

        y,x=pagin.split('|')
        add_item(name=y, url=exlink, mode='listodcinki', image=None, folder=True, isPlayable=False, infoLabels=None, itemcount=items, page=x)

    if 'pelnometrazowe' in exlink:
    
        add_item(name='Filmy -strona głowna', url='https://bajeczki.org/pelnometrazowe/', mode='listodcinki', image=RESOURCES+'icon.png', folder=True, isPlayable=False)
    else:
        add_item(name='Wszystkie bajki', url='http://bajeczki.org/all-categories/', mode="listbajki", image=RESOURCES+'icon.png', folder=True, isPlayable=False)


    xbmcplugin.setContent(addon_handle, 'videos')
    xbmcplugin.endOfDirectory(addon_handle)    

def getOdcinki(url,page=1):
    url=url+'/page/%d/'%page if not url.endswith('/') else url+'page/%d/'%page
    html=getUrlReq(url)

    out=[]
    pages = getPages(html)

    try:
        result=parseDOM(html,'div', attrs={'class': "content-block clear"})[0] #    <div class="content-block clear">
        links=parseDOM(result,'div', attrs={'class': "hentry.*?"})
        for link in links:
            href = parseDOM(link, 'a', ret='href')[0] 
            title=parseDOM(link,'a')[1]
            imag = parseDOM(link, 'img', ret='data-src')#[0]
            imag = imag [0] if imag else parseDOM(link, 'img', ret='src')[0]
            out.append({ 'href'  : PLchar(href),'img': PLchar(imag),'title' : PLchar(title),'mediatype': 'movie', 'plot':PLchar(title)})                    
    except:
        pass
    return (out,pages)

def ListDodane(exlink,page):
    page = int(page) if page else 1    
    links, pagin = getDodane(exlink,page)

    itemz=links
    items = len(links)
    mud='getLinks'
    fold=False
    for f in itemz:
    
        add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=False, isPlayable=True, infoLabels={'title':f.get('title'),'plot':f.get('title')}, itemcount=items)
    if pagin:

        y,x=pagin.split('|')
        add_item(name=y, url=exlink, mode='ostdodane', image=None, folder=True, isPlayable=False, infoLabels=None, itemcount=items, page=x)

    add_item(name='Główna', url='http://bajeczki.org/page/%d/?s=', mode="ostdodane", image=RESOURCES+'icon.png', folder=True, isPlayable=False)

    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)    

def getDodane(url,page=1):    
    url=url%page
    html=getUrlReq(url)
    pages = getPages(html)

    out=[]
    links = parseDOM(html, 'article', attrs={'class': "hentry clear"})  #<article class="">
    for link in links:        
        href = parseDOM(link, 'a', ret='href')[0] #[1]
        imag = parseDOM(link, 'img', ret='data-src')#[0]
        imag = imag [0] if imag else parseDOM(link, 'img', ret='src')[0]
        imag = re.sub('p/w(\d+)', 'p/w500', imag)        
        title = parseDOM(link, 'a')[1] #[1]
        out.append({'title':PLchar(title),'href':PLchar(href),'img':PLchar(imag)})
    return (out, pages)

def getPages(content):

    nav = re.findall('<nav class="navigation pagination".+?>(.+?)</nav>', content, re.DOTALL);
    if len(nav) != 0:
        nav = nav[0]
    else:
        return False

    naststrona = re.findall('"next page-numbers" href="(.+?)"',nav,re.DOTALL)
    if naststrona:
        ilosc = re.findall('\/(\d+)\/',naststrona[0])[0]
        tyt = 'Następna strona [%s]'%str(ilosc)
        pg = str(ilosc)
        tyt2 = tyt+'|'+pg
        return tyt2 
    else:
        return False

def getPageLinks(pages):

    if pages[0] == False:
        return {}

    min = pages[0]
    current = pages[1]
    max = pages[2]

    links = {}
    for x in range(min,max+1):
        if x == current:
            links[x]='[COLOR blue]>> Strona '+str(x)+' <<[/COLOR]'
        else:
            links[x]= 'Strona '+str(x)

    return links


def getUrlReq(url, red=False):
	if red:
		return sess.get(url, headers=headers,verify=False).url

	else:
		content=sess.get(url, headers=headers,verify=False).content
		if PY3:
			content = content.decode(encoding='utf-8', errors='strict')
		if 'wp-die-message' in content:
			xbmcgui.Dialog().notification('[B]Błąd[/B]', 'Błąd połączenia z bazą\n Spróbuj ponownie za chwilę..',xbmcgui.NOTIFICATION_INFO, 8000,False)
			sys.exit(0)
		
		else:
			return content
    
# https://github.com/Kodi-vStream/venom-xbmc-addons
# https://github.com/Kodi-vStream/venom-xbmc-addons
# https://github.com/Kodi-vStream/venom-xbmc-addons

def temp_decode(data):
    startpos = data.find('"\\""+') + 5
    endpos = data.find('"\\"")())()')

    first_group = data[startpos:endpos]

    l = re.search("(\(!\[\]\+\"\"\)\[.+?\]\+)", first_group, re.DOTALL)
    if l:
        first_group = first_group.replace(l.group(1), 'l').replace('$.__+', 't').replace('$._+', 'u').replace('$._$+', 'o')

        tmplist = []
        js = re.search('(\$={.+?});', data, re.DOTALL)
        if js:
            js_group = js.group(1)[3:][:-1]

            second_group = js_group.split(',')

            i = -1

            for x in second_group:
                a, b = x.split(':')

                if b == '++$':
                    i += 1
                    tmplist.append(("{}{}{}".format('$.', a, '+'), i))

                elif b == '(![]+"")[$]':
                    tmplist.append(("{}{}{}".format('$.', a, '+'), 'false'[i]))

                elif b == '({}+"")[$]':
                    tmplist.append(("{}{}{}".format('$.', a, '+'), '[object Object]'[i]))

                elif b == '($[$]+"")[$]':
                    tmplist.append(("{}{}{}".format('$.',a,'+'),'undefined'[i]))

                elif b == '(!""+"")[$]':
                    tmplist.append(("{}{}{}".format('$.', a, '+'), 'true'[i]))


            tmplist = sorted(tmplist, key=lambda x: x[1])

            for x in tmplist:
                first_group = first_group.replace(x[0], str(x[1]))

            first_group = first_group.replace(r'\\"' , '\\').replace("\"\\\\\\\\\"", "\\\\").replace('\\"', '\\').replace('"', '').replace("+", "")



    try:
        final_data = unicode(first_group, encoding = 'unicode-escape')
        return final_data
    except:
        return False

# https://github.com/Kodi-vStream/venom-xbmc-addons
# https://github.com/Kodi-vStream/venom-xbmc-addons
# https://github.com/Kodi-vStream/venom-xbmc-addons

def getLinks(exlink):
    html=getUrlReq(exlink)   
    stream=''
    result=parseDOM(html,'div', attrs={'class': "entry-content"})#[0]    

    if result:
        try:
            result2 = result[0].lower()
            src = parseDOM(result2,'iframe', ret='data-src')#[0]
            src = src[0] if src else parseDOM(result2,'iframe', ret='src')[0]
            stream= 'https:'+src if src.startswith('//') else src
            if 'embed.mystream' in html:
                src=re.findall('"(http.+?mystream.to.+?)"',html)[0]
                html=getUrlReq(src)
                aResult = re.findall('([$]=.+?\(\)\)\(\);)', html,re.DOTALL)    
                
                if (aResult):
                    for i in aResult:
                        decoded = temp_decode(i)
                    
                        if decoded:
                            r = re.search("setAttribute\(\'src\', *\'([^']+)\'\)", decoded, re.DOTALL)
                            if r:
                                api_call = r.group(1)
                    if (api_call):
                        stream=''
                        stream_url= api_call + '|User-Agent=' + UA + '&Referer=' + exlink + '&Origin=https://embed.mystream.to'

            else:
                stream=getUrlReq(stream, True)

        except:
            import json

            new=re.findall('data-item="([^"]+)"',result[0])[0].replace('&quot;','"')
            new2=json.loads(new)
            stream=new2['sources'][0]['src']

    if stream:

        try:
            if 'mp4' not in stream:
                stream_url = urlresolver.resolve(stream)
            else:
                headersx = {
                    'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:85.0) Gecko/20100101 Firefox/85.0',
                    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                    'DNT': '1',
                    'Connection': 'keep-alive',
                    'Upgrade-Insecure-Requests': '1',
                    'TE': 'Trailers',
                }

                hea= '&'.join(['%s=%s' % (name, value) for (name, value) in headersx.items()])  

                stream_url=stream+'|'+hea
        except Exception as e:

            if 'vkprime.' in stream:
                stream_url = getVkprime(stream, exlink)  
            else:
                stream_url=''
                sel = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Link nie działa.','ERROR: %s'%str(e))  
                quit()
 
    if stream_url:   

        play_item = xbmcgui.ListItem(path=stream_url)
        play_item.setMimeType('video/mp4')

        play_item.setContentLookup(False)
        play_item.setProperty("IsPlayable", "true")
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    else:
        sel = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Link nie działa.')
        quit()
     
def getVkprime(url, ref):
    packer = re.compile('(eval\(function\(p,a,c,k,e,(?:r|d).*)')
    hdrs = {'User-Agent': UA, 'Referer':ref}
    html =requests.get(url, headers=hdrs, verify=False).text
    zz=''
    unpacked=''
    packeds = packer.findall(html)
    if packeds:
        import resources.lib.jsunpack as jsunpack
        for packed in packeds:
            unpacked += jsunpack.unpack(packed)
    srcs = re.findall('sources\:\s*(\[.*?\])',unpacked,re.DOTALL)
    link = ''
    if srcs:
        link = re.findall("""file:\s*['"](.+?)['"]""",srcs[0])[0]
        link = link + '|User-Agent='+UA
    return link        

def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&")    
    char = char.replace('&nbsp;',".").replace('&amp;','&')
    return char    
    
    
def router(paramstring):

    params = dict(parse_qsl(paramstring))
    
    if params:
        mode = params.get('mode', None)
        if mode == 'listbajki':
            ListBajki(exlink)        
        elif mode == 'listodcinki':
            ListOdcinki(exlink,page)
        elif mode == 'ostdodane':
            ListDodane(exlink,page)        
        elif mode == 'getLinks':
            getLinks(exlink)   
        elif mode == 'pageM':
            url = build_url({'mode': 'ostdodane', 'foldername': name, 'url' : exlink, 'page' : page})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
        elif mode=='search':
            query = xbmcgui.Dialog().input(u'Szukaj, Podaj tytuł filmu', type=xbmcgui.INPUT_ALPHANUM)
            if query:      
                query=query.replace(' ','+')
                elink='http://bajeczki.org/page/%d/?s='+query         
                ListDodane(elink,page)    
    else:
        home()
if __name__ == '__main__':
    router(sys.argv[2][1:])