# -*- coding: UTF-8 -*-
from __future__ import division
import sys,re,os
import six
from six.moves import urllib_parse

#import json

import requests
from requests.compat import urlparse

import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs
from resources.lib.brotlipython import brotlidec


if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    from resources.lib.cmf3 import parseDOM
else:
    from resources.lib.cmf2 import parseDOM
import resolveurl

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.bolly2tolly')

PATH            = addon.getAddonInfo('path')
if six.PY2:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
else:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'

exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

page = params.get('page',[1])

UA = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:109.0) Gecko/20100101 Firefox/110.0'
TIMEOUT=15

headers = {'User-Agent': UA,}
sess = requests.Session()

def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):
    list_item = xbmcgui.ListItem(label=name)
    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')    
    if not infoLabels:
        infoLabels={'title': name}    
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})
    
    if contextmenu:
        out=contextmenu
        list_item.addContextMenuItems(out, replaceItems=True)

    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page, 'title':name,'image':image}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")

def home():

    add_item('https://www.bolly2tolly.sale/movies-online/page/1', '[COLOR khaki][B]All movies[/COLOR][/B]', ikona, "listmovies",fanart=FANART, folder=True)
	
    add_item('https://www.bolly2tolly.sale/category/english-movies/page/1', '[B]-  english[/B]', ikona, "listmovies",fanart=FANART, folder=True)
    add_item('https://www.bolly2tolly.sale/category/hindi-movies/page/1', '[B]- hindi[/B]', ikona, "listmovies",fanart=FANART, folder=True)
    add_item('https://www.bolly2tolly.sale/category/telugu-movies/page/1', '[B]- telugu[/B]', ikona, "listmovies",fanart=FANART, folder=True)
    add_item('https://www.bolly2tolly.sale/category/tamil-movies/page/1', '[B]- tamil[/B]', ikona, "listmovies",fanart=FANART, folder=True)
    add_item('https://www.bolly2tolly.sale/category/malayalam-movies/page/1', '[B]- malayalam[/B]', ikona, "listmovies",fanart=FANART, folder=True)
    add_item('https://www.bolly2tolly.sale/category/kannada-movies/page/1', '[B]- kannada[/B]', ikona, "listmovies",fanart=FANART, folder=True)
    add_item('https://www.bolly2tolly.sale/category/bengali-movies/page/1', '[B]- bengali[/B]', ikona, "listmovies",fanart=FANART, folder=True)
	
    add_item('https://www.bolly2tolly.sale/category/tv-shows/page/1', '[COLOR khaki][B]All shows[/COLOR][/B]', ikona, "listmovies",fanart=FANART, folder=True)
	

def ListMovies(url, pg):


	if '/page/' in url:
		url = re.sub('/page/\\d+','/page/%d'%int(pg),url)
	else:
		url = url + '/page/%d' %int(pg)
	html = sess.get(url, headers = headers, verify=False).text


	
	ntpage = re.findall('class\s*=\s*"next page\-numbers"\s*href\s*=\s*"([^"]+)"',html,re.DOTALL)

	links = parseDOM(html,'article', attrs={'id':"post\-.*?"} )
	for link in links:
	
		href = parseDOM(link,'a', ret="href")[0]
		href = 'https://www.bolly2tolly.sale/'+href if href.startswith('/') else href
	

		img = parseDOM(link,'img', ret="src")#[0]
		try:
			img = ikona if img[0] == '' else img[0]
		except:
			img = ikona

		title = parseDOM(link,'h3')[0]

		title = title.replace('&#8217;',"'").replace('&#8211;','-')
		ispla = False
		fold = True
		mod = 'listlinks'
		h2 = href+'|'+title
		if '/serie/' in href:
			ispla = False
			fold = True
			mod = 'listserial'
			h2 = href
		add_item(h2, title, img, mod,fanart=FANART, folder=fold, IsPlayable=ispla, infoLabels={'plot':title})
	
	
	

	if ntpage:
		nextpage = unicode(int(pg)+1)
		add_item(ntpage[0], '>> next page >>' ,RESOURCES+'right.png', "listmovies",fanart=FANART, page=nextpage, folder=True)
	xbmcplugin.endOfDirectory(addon_handle) 
	
def ListSerial(url):

	html = sess.get(url, headers = headers, verify=False).text
	orig_title = re.findall('original\s*title\:.*?>([^<]+)<',html,re.DOTALL+re.I)[0]
	img_main = re.findall('thumbnailUrl\"\:\s*"([^"]+)"',html,re.DOTALL+re.I)[0]
	plot = re.findall('description"\:\s*"([^"]+)"',html,re.DOTALL+re.I)
	plot = plot[0] if plot else ''
	
	result = parseDOM(html,'main')[0].replace('&quot;','"')
	out=[]
	seasons = parseDOM(result,'div', attrs={'class':"Wdgt AABox"} )
	for season in seasons:
		ses = re.findall('data\-tab\="([^"]+)"',season,re.DOTALL)[0]
		episodes = parseDOM(season,'tr')
		
		for episode in episodes:
			epis = re.findall('num\s*"\s*>([^<]+)<',episode,re.DOTALL+re.I)[0]

			imag = re.findall('img\s*.*?src\="([^"]+)"',episode,re.DOTALL+re.I)[0]
			imag = 'https:'+imag if imag.startswith('//') else imag
			info = re.findall('MvTbTtl">(.*?)<\/span',episode,re.DOTALL+re.I)[0]
			href = parseDOM(info,'a', ret="href")[0]
			epistitle =  parseDOM(info,'a')[0]
			jaki = ' - S%02dE%02d '%(int(ses),int(epis))+' - [COLOR gold][B]'+epistitle+'[/B][/COLOR]'
				
			tyt = orig_title+jaki
			out.append({'title':tyt,'href':href,'img':imag, 'fnrt':FANART, 'plot':plot, 'season' : int(ses),'episode' : int(epis) })
	sezony =  splitToSeasons(out)

	for i in sorted(sezony.keys()):
		ac=urllib_parse.quote_plus(str(sezony[i]))
		add_item(ac, i, img_main, 'listepisodes',fanart=FANART, folder=True, IsPlayable=False, infoLabels={'plot':plot})
	xbmcplugin.endOfDirectory(addon_handle) 
		
		
def ListEpisodes(exlink):
	import ast

	episodes = ast.literal_eval(urllib_parse.unquote_plus(exlink))
	
	itemz=episodes
	items = len(episodes)
	
	for f in itemz:
		add_item(f.get('href')+'|'+f.get('title'), f.get('title'), f.get('img'), 'listlinks',fanart=FANART, folder=True, IsPlayable=False, infoLabels={'plot':f.get('plot')})
	xbmcplugin.endOfDirectory(addon_handle) 
def splitToSeasons(input):
	out={}
	seasons = [x.get('season') for x in input]

	xx= re.findall('^(.*?)\-',input[0].get('title', None))[0]
	for s in set(seasons):

		out[xx+ ' Season %02d'%s]=[input[i] for i, j in enumerate(seasons) if j == s]
	return out
	
def ListLinks(urlk):

	url,tyt = urlk.split('|')	
	html = sess.get(url, headers = headers, verify=False).text
	html = html.replace('&quot;','"').replace('&amp;','&')
	inf = parseDOM(html,'p', attrs={'class':"Info"} )
	duration = 0 
	year = 0

	if inf:
		dur = re.findall('access_time">([^<]+)<',inf[0],re.DOTALL)
		year = re.findall('date_range">([^<]+)<',inf[0],re.DOTALL)
		if dur:

			try:
				duration = dur[0].replace('h ','*60+').replace('m','')
				duration = int(eval(duration))*60
			except:
				duration = 0
		if year:
			year = year[0]
		else:
			year = 0 

	plot = re.findall('description"\s*\:\s*"([^"]+)"',html,re.DOTALL)
	plot = plot[0] if plot else tyt

	imag = re.findall('thumbnailUrl"\s*\:\s*"([^"]+)"',html,re.DOTALL+re.I)
	imag = imag[0] if imag else ikona
	imag = 'https:'+imag if imag.startswith('//') else imag
	ids = [(a.start(), a.end()) for a in re.finditer('<li\s*data\-short', html)]
	ids.append( (-1,-1) )
	hosty =[]
	for i in range(len(ids[:-1])):
		subset = html[ ids[i][1]:ids[i+1][0] ]
		opt = re.findall('tplayernv\s*=\s*"([^"]+)"\s*>',subset,re.DOTALL)[0]
		host = re.findall('span>([^<]+)<',subset,re.DOTALL)[0]
		hosty.append({"host": host, "opt": opt})
	ok = False
	for x in hosty:
		ok = True
		ht = x.get('opt')
		src = re.findall('id="'+ht+'">.*?src="([^"]+)"',html,re.DOTALL)[0]
		src = src.replace('&#038;','&')
		tit = tyt+ ' [I][COLOR khaki]'+x.get('host')+'[/I][/COLOR]'
		mod = 'playvideo' 
		ispla = True
		fold = False
		if 'oyohd' in tit.lower():
			tit+= '[COLOR red][B] (X)[/B][/COLOR]'
			mod = 'none' 
			ispla = False
			fold = False
			
		add_item(src, tit, imag, mod,fanart=FANART, folder=fold, IsPlayable=ispla, infoLabels={'plot':plot, 'year':year, 'duration':duration})
	if ok:
		xbmcplugin.endOfDirectory(addon_handle) 
	else:
		xbmcgui.Dialog().notification('[B]Info[/B]', 'Links are not available',xbmcgui.NOTIFICATION_INFO, 6000)
def PlayVideo(url):	

	html = sess.get(url, headers = headers, verify=False).text

	iframe = parseDOM(html,'iframe', ret="src")#[0]
	if iframe:
		try:
			link = resolveurl.resolve(iframe[-1])
		except:
			link=''
		if 'ninjastream.' in iframe[-1]:
			link = Resolve_ninja(url=iframe[-1], ref=url)
		elif 'neohd' in iframe[-1] or 'ninjahd' in iframe[-1]:
			if not link:
				link = Resolve_Neo(url=iframe[-1], ref=url)

	if link:	

		play_item = xbmcgui.ListItem(path=link)#

		play_item.setProperty('inputstream', 'inputstream.ffmpegdirect')
		play_item.setProperty('inputstream.ffmpegdirect.mime_type', 'video/mp4')
		play_item.setContentLookup(False)

		xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
		
def Resolve_Neo(url,ref)	:
	#from resolveurl by gujal
	#neohd plugin

	import json
	import codecs
	import time
	from resources.lib.jscrypto import jscrypto
	headers.update({'Referer': ref})
	zz=''
	response = sess.get(url, headers = headers, verify=False)
	cookies=dict(response.cookies)
	html = response.text
	r = re.search(r"var\s*playerConfig\s*=\s*({.*?})", html)  #will be updated
	host = urlparse(url).netloc
	if r:
		data = json.loads(r.group(1))
		ct = data.get('ct', False)
		salt = codecs.decode(data.get('s'), 'hex')
		html2 = jscrypto.decode(ct, 'F1r3b4Ll_GDP~5H', salt)
		html2 = html2[1:-1].replace('\\"', '"')
		s = re.search(r'apiQuery":"([^"]+)', html2)
		if s:
			headers.update({'Referer': url, 'X-Requested-With': 'XMLHttpRequest'})
			aurl = 'https://{0}/api/?{1}&_={2}'.format(host, s.group(1), int(time.time() * 1000))
			jd = sess.get(aurl, headers=headers).json()
			urlk = jd.get('sources')[0].get('file').replace(' ', '%20')
			if urlk.startswith('//'):
				urlk = 'https:' + urlk
			link = urlk+'|User-Agent='+UA+'&Referer='+url
	return link

	
def Resolve_ninja(url,ref):
	headers.update({'Referer': ref})
	zz=''
	response = sess.get(url, headers = headers, verify=False)
	cookies=dict(response.cookies)
	html = response.text

	csrf = re.findall('csrf\-token"\s*content\s*=\s*"([^"]+)"',html,re.DOTALL)[0]
	xsrf = cookies.get('XSRF-TOKEN', None)

	headersx = {
		'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:109.0) Gecko/20100101 Firefox/115.0',
		'Accept': 'application/json, text/plain, */*',
		'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
		'Referer': url,
		'X-Requested-With': 'XMLHttpRequest',
		'X-CSRF-TOKEN': csrf,		'Content-Type': 'application/json;charset=utf-8',
		'X-XSRF-TOKEN': xsrf,
		'Origin': 'https://ninjastream.to',
		'DNT': '1',
		'Connection': 'keep-alive',
		'Sec-Fetch-Dest': 'empty',
		'Sec-Fetch-Mode': 'cors',
		'Sec-Fetch-Site': 'same-origin',
	}
	id_ = url.split('/')[-1]

	data = {'id':id_}

	html = sess.post('https://ninjastream.to/api/video/get', cookies=sess.cookies, headers=headersx, json=data).json()
	link = html.get('result', None).get('playlist', None)
	link = link+'|User-Agent='+UA+'&Referer='+url
	return link

def router(paramstring):
	params = dict(urllib_parse.parse_qsl(paramstring))
	if params:    
	
		mode = params.get('mode', None)
	
		if mode == 'listmovies':
			ListMovies(exlink, page)	
		elif mode == 'playvideo':
			PlayVideo(exlink)
		elif mode == 'listserial':
			ListSerial(exlink)
		elif mode == 'listlinks':
			ListLinks(exlink)
			
			
		elif mode == 'listepisodes':
			ListEpisodes(exlink)


	else:
		home()
		xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])