# -*- coding: utf-8 -*-
import sys,re,os
import urllib,urllib2
import urlparse
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import resolveurl as urlresolver

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
cache = StorageServer.StorageServer('cdaonline')
import resources.lib.cdahd as cdahd #cdahd
import resources.lib.sess as session #session

base_url		= sys.argv[0]
addon_handle	= int(sys.argv[1])
args			= urlparse.parse_qs(sys.argv[2][1:])
my_addon		= xbmcaddon.Addon()
addonName	   = my_addon.getAddonInfo('name')
PATH		= my_addon.getAddonInfo('path')
DATAPATH	= xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES   = PATH+'/resources/'
FANART=RESOURCES+'fanart.png'
cdahd.COOKIEFILE=os.path.join(DATAPATH,'cookie')

import time,threading

def addLinkItem(name, url, mode, page=1, iconimage='DefaultFolder.png', infoLabels=False, IsPlayable=True,fanart=FANART,itemcount=1):
	u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page})
	liz = xbmcgui.ListItem(name)
	art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
	art = dict(zip(art_keys,[iconimage for x in art_keys]))
	art['landscape'] = fanart if fanart else art['landscape']
	liz.setArt(art)
	if not infoLabels:
		infoLabels={'title': name}
	liz.setInfo(type='video', infoLabels=infoLabels)
	if IsPlayable:
		liz.setProperty('IsPlayable', 'true')
	contextMenuItems = []
	contextMenuItems.append(('Informacja', 'XBMC.Action(Info)'))
	liz.addContextMenuItems(contextMenuItems, replaceItems=False)
	ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
	return ok

def addDir(name,ex_link=None, page=1, mode='folder',iconImage='DefaultFolder.png', infoLabels=None, fanart=FANART,contextmenu=None):
	url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page})
	li = xbmcgui.ListItem(name)
	if infoLabels:
		li.setInfo(type='video', infoLabels=infoLabels)
	art_keys=['thumb','poster','banner','clearart','clearlogo','landscape','icon']
	art = dict(zip(art_keys,[iconImage for x in art_keys]))
	art['landscape'] = fanart if fanart else art['landscape']
	li.setArt(art)
	if contextmenu:
		contextMenuItems=contextmenu
		li.addContextMenuItems(contextMenuItems, replaceItems=True)
	else:
		contextMenuItems = []
		contextMenuItems.append(('Informacja', 'XBMC.Action(Info)'),)
		li.addContextMenuItems(contextMenuItems, replaceItems=False)
	xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')

def addLinkItem2(name, url='', mode='', iconimage=None, fanart=FANART):
	u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':1})
	liz = xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
	liz.setProperty('IsPlayable', 'false')
	if fanart:
		liz.setProperty('fanart_image',fanart)
	ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False)
	return ok

def encoded_dict(in_dict):
	out_dict = {}
	for k, v in in_dict.iteritems():
		if isinstance(v, unicode):
			v = v.encode('utf8')
		elif isinstance(v, str):
			v.decode('utf8')
		out_dict[k] = v
	return out_dict

def build_url(query):
	return base_url + '?' + urllib.urlencode(encoded_dict(query))

def ListMovies(ex_link,page):
	opisy=False
	if 'true' in my_addon.getSetting('pokazopisy'):
		opisy=True
	page = int(page) if page else 1
	group=''
	if '|'in ex_link:
		ex_link,group = ex_link.split('|')	
	filmy,pagination = cdahd.scanMainPage(ex_link,page,group,opisy)
	if pagination[0]:
		addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__M', page=pagination[0], IsPlayable=False)
	items=len(filmy)
	for f in filmy:
		addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=items)
	if pagination[1]:
		addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__M', page=pagination[1], IsPlayable=False)
	xbmcplugin.setContent(addon_handle, 'movies')	
	xbmcplugin.endOfDirectory(addon_handle)
def ListSeriale(ex_link,page):
	opisy=False
	page = int(page) if page else 1
	group=''
	if '|'in ex_link:
		ex_link,group = ex_link.split('|')
	filmy,pagination = cdahd.scanMainPage(ex_link,int(page),group,False)
	my_mode = 'getEpisodes'
	if 'true' in my_addon.getSetting('groupEpisodes'):
		my_mode = 'getSeasons'
	if pagination[0]:
		addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__S', page=pagination[0], IsPlayable=False)
	items=len(filmy)
	for f in filmy:
		addDir(name=f.get('title'), ex_link=f.get('href'), mode=my_mode, iconImage=f.get('img'), infoLabels=f)
	if pagination[1]:
		addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__S', page=pagination[1], IsPlayable=False)
	xbmcplugin.endOfDirectory(addon_handle)
def getEpisodes(ex_link):
	episodes = cdahd.scanEpisodes(ex_link)
	for f in episodes:
		addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
	xbmcplugin.endOfDirectory(addon_handle)
def getSeasons(ex_link):
	episodes = cdahd.scanEpisodes(ex_link)
	seasons =cdahd.splitToSeasons(episodes)
	for nameX in sorted(seasons.keys()):
		addDir(name=nameX, ex_link=urllib.quote(str(seasons[nameX])), mode='getEpisodes2')
	xbmcplugin.setContent(addon_handle, 'season')
	xbmcplugin.endOfDirectory(addon_handle)
def getEpisodes2(ex_link):
	episodes = eval(urllib.unquote(ex_link))
	for f in episodes:
		addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,fanart=f.get('img'))
	xbmcplugin.setContent(addon_handle, 'episodes')
	xbmcplugin.endOfDirectory(addon_handle)
def ListFS(ex_link):
	filmy,seriale = cdahd.search(ex_link)
	for f in filmy:
		addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(filmy))
	for f in seriale:
		addDir(name=f.get('title'), ex_link=f.get('href'), mode='getEpisodes', iconImage=f.get('img'), infoLabels=f)
	xbmcplugin.endOfDirectory(addon_handle)
def getLinks(ex_link):

	streams = cdahd.getVideos_(ex_link)
	stream_url=''
	t = [ x.get('title') for x in streams]
	u = [ x.get('url') for x in streams]
	h = [ x.get('host') for x in streams]
	select = xbmcgui.Dialog().select('Sources', t)
	if select>-1:
		link = u[select]
		link = session.getSess_(link)
		if 'gounlimited.to' in link:
			stream_url=cdahd.getGoUnlim(link)	
		if 'verystream' in link:
			stream_url=cdahd.getverystream(link)
		if 'upstream.to' in link:
			stream_url=cdahd.getupstream(link)
		if 'hqq.tv' in link or 'waaw' in link: 
			stream_url=cdahd.getHqq(link,ex_link)
		if not stream_url:
			try:
				stream_url = urlresolver.resolve(link)
			except Exception,e:
				stream_url=''
				s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link bedzie działał?','ERROR: %s'%str(e))
	else:
		quit()
	if stream_url:
		xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
	else:
		xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
		quit()
def getHistory():
	return cache.get('history').split(';')

def setHistory(entry):
	history = getHistory()
	if history == ['']:
		history = []
	history.insert(0, entry)
	cache.set('history',';'.join(history[:50]))

def searchDel(entry):
	history = getHistory()
	if history:
		cache.set('history',';'.join(history[:50]))
	else:
		searchDelAll()

def searchDelAll():
	cache.delete('history')

mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
page = args.get('page',[1])[0]
sortV = my_addon.getSetting('sortV')
sortN = my_addon.getSetting('sortN') if sortV else 'Daty dodania'
qualityV = my_addon.getSetting('qualityV')
qualityN = my_addon.getSetting('qualityN') if qualityV else 'Wszystkie'
versionV = my_addon.getSetting('versionV')
versionN = my_addon.getSetting('versionN') if versionV else 'Wszystkie'

if mode is None:
	cdahd.setCFcookies()
	addDir(name='[COLOR blue]Filmy[/COLOR]',ex_link='http://cda-hd.cc/filmy-online/',page=1, mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='  Premiery',ex_link='http://cda-hd.cc/|<h3>Nowe od',page=1, mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='  Losowe filmy',ex_link='http://cda-hd.cc/|<h3>Losowe',page=1, mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='  [Kategoria]',ex_link='film|gatunek',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='  [Rok]',ex_link='film|rok',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='[COLOR blue]Seriale[/COLOR]',ex_link='https://cda-hd.cc/seriale-online/',page=1, mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='  [Kategoria]',ex_link='serial|gatunek',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='  [Rok]',ex_link='serial|rok',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
	addDir('[COLOR blue]Szukaj[/COLOR]','',mode='Szukaj')
	xbmcplugin.endOfDirectory(addon_handle)
elif 'filtr' in mode[0]:
	sst = mode[0].split(':')[-1]
	if sst=='sort':
		label=['Daty dodania','Liczba głosów','Premiera','Odsłony','Ocena']
		value=['sort:date','sort:vote','sort:premiere','sort:view','sort:rate']
		msg = 'Sortowanie'
	elif sst=='quality':
		label=['Wszystkie','Niska','Średnia','Wysoka','4K UHD']
		value=['','quality:1','quality:2','quality:3','quality:4']
		msg = 'Jakosc'
	elif sst=='version':
		label=['Wszystkie','Dubbing','Lektor','Napisy','PL','ENG']
		value=['','version:2','version:1','version:3','version:4','version:5']
		msg = 'Wersja'
	s = xbmcgui.Dialog().select(msg,label)
	s = s if s>-1 else 0
	my_addon.setSetting(sst+'V',value[s])
	my_addon.setSetting(sst+'N',label[s])
	xbmc.executebuiltin('XBMC.Container.Refresh')
elif mode[0] == 'ListMovies':
	dod=''
	ListMovies(ex_link+dod,page)
	xbmcplugin.setContent(addon_handle, 'movies')
elif mode[0] == 'ListMoviesKids':
	ListMovies(ex_link,page)
	xbmcplugin.setContent(addon_handle, 'movies')
elif mode[0] == 'Opcje':
	my_addon.openSettings()
elif mode[0] == '__page__M':
	url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : ex_link, 'page': page})
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
elif mode[0] == '__page__S':
	url = build_url({'mode': 'ListSeriale', 'foldername': '', 'ex_link' : ex_link, 'page': page})
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
elif mode[0] == 'getEpisodes':
	getEpisodes(ex_link)
	xbmcplugin.setContent(addon_handle, 'episodes')
elif mode[0] == 'getEpisodes2':
	getEpisodes2(ex_link)
	xbmcplugin.setContent(addon_handle, 'episodes')
elif mode[0] == 'ListSeriale':
	ListSeriale(ex_link,page)
	xbmcplugin.setContent(addon_handle, 'tvshows')
elif mode[0] == 'getSeasons':
	getSeasons(ex_link)
	xbmcplugin.setContent(addon_handle, 'tvshows')
elif mode[0] == 'ListFS':
	ListFS(ex_link)
	xbmcplugin.setContent(addon_handle, 'tvshows')
elif mode[0] == 'getLinks':
	getLinks(ex_link)
elif mode[0] == 'GatunekRok':
	param = ex_link.split('|')
	data = cdahd.genreYearFilter(catFS=param[0],typFS=param[1])
	if data:
		sct = xbmcgui.Dialog().select('Wybierz:', data[0])
		if sct>-1:
			if param[0]=='film':
				mode_MovSer = 'ListMovies'
				href = data[1][sct]
				ListMovies(href,1)
			else:
				mode_MovSer = 'ListSeriale'
				href = data[1][sct]
				ListSeriale(href,1)
			#url = build_url({'mode': mode_MovSer, 'foldername': '', 'ex_link' : href, 'page': 1})
			#xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
			#xbmcplugin.endOfDirectory(addon_handle)
		else:
			quit()
elif mode[0] == 'Opcje':
	my_addon.openSettings()
elif mode[0] =='Szukaj':
	addDir('[COLOR green]Nowe Szukanie[/COLOR]','',mode='SzukajNowe')
	historia = getHistory()
	if not historia == ['']:
		for entry in historia:
			contextmenu = []
			contextmenu.append(('Usun', 'XBMC.Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'ex_link' : entry})),)
			contextmenu.append(('Usun cała historie', 'XBMC.Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
			addDir(name=entry, ex_link=entry.replace(' ','+'), mode='ListFS', fanart=None, contextmenu=contextmenu)
	xbmcplugin.setContent(addon_handle, 'videos')	
	xbmcplugin.endOfDirectory(addon_handle)		
elif mode[0] =='SzukajNowe':
	d = xbmcgui.Dialog().input('Szukaj, Podaj tytuł filmu/serialu', type=xbmcgui.INPUT_ALPHANUM)
	if d:
		setHistory(d)
		ex_link=d.replace(' ','+')
		ListFS(ex_link)
		xbmcplugin.setContent(addon_handle, 'tvshows')
	else:
		quit()
elif mode[0] =='SzukajUsun':
	searchDel(ex_link)
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
elif mode[0] == 'SzukajUsunAll':
	searchDelAll()
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
elif mode[0] == 'folder':
	pass
else:
	quit()
	#xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))







