# -*- coding: utf-8 -*-
import sys,re,os
import urllib,urllib2
import urlparse
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import time,threading

base_url		= sys.argv[0]
addon_handle	= int(sys.argv[1])
args			= urlparse.parse_qs(sys.argv[2][1:])
my_addon		= xbmcaddon.Addon()
addonId		 = my_addon.getAddonInfo('id')
addonName	   = my_addon.getAddonInfo('name')
PATH			= my_addon.getAddonInfo('path').decode('utf-8')
DATAPATH		= xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES	   = PATH+'/resources/'
FANART		  = RESOURCES+'fanart.png'
sys.path.append(RESOURCES+'lib/')
responseCDA	 = urllib2.urlopen
req			 = urllib2.Request
dialog		  = xbmcgui.Dialog()

def addLinkItem(name, url, mode, page=1, iconimage='DefaultFolder.png', infoLabels={}, IsPlayable=True, fanart=FANART,itemcount=1):
	u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page,'minfo':str(infoLabels)})
	isFolder = infoLabels.get('isFolder',False)
	if isFolder and infoLabels.get('year',False):
		name += ' (%s)'%infoLabels.get('year')
	liz = xbmcgui.ListItem(name)
	art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
	art = dict(zip(art_keys,[infoLabels.get(x,iconimage) for x in art_keys]))
	art['landscape'] = fanart if fanart else art['landscape']
	liz.setArt(art)
	liz.setInfo(type='video', infoLabels=infoLabels)
	if IsPlayable and not isFolder:
		liz.setProperty('IsPlayable', 'true')
	ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=isFolder,totalItems=itemcount)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
	return ok

def addDir(name,ex_link=None, page=1, mode='folder',iconImage='DefaultFolder.png', infoLabels={}, fanart=FANART,contextmenu=None):
	url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page})
	li = xbmcgui.ListItem(name)
	if infoLabels:
		li.setInfo(type='video', infoLabels=infoLabels)
	art_keys=['thumb','poster','banner','clearart','clearlogo','landscape','icon']
	art = dict(zip(art_keys,[infoLabels.get(x,iconImage) for x in art_keys]))
	art['landscape'] = fanart if fanart else art['landscape']
	li.setArt(art)
	if contextmenu:
		contextMenuItems=contextmenu
		li.addContextMenuItems(contextMenuItems, replaceItems=True)
	else:
		contextMenuItems = []
		contextMenuItems.append(('Informacja', 'XBMC.Action(Info)'),)
		li.addContextMenuItems(contextMenuItems, replaceItems=False)
	xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')

def addLinkItem2(name, url='', mode='', iconimage=None, fanart=FANART):
	u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':1})
	liz = xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
	liz.setProperty('IsPlayable', 'false')
	if fanart:
		liz.setProperty('fanart_image',fanart)
	ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False)
	return ok

def encoded_dict(in_dict):
	out_dict = {}
	for k, v in in_dict.iteritems():
		if isinstance(v, unicode):
			v = v.encode('utf8')
		elif isinstance(v, str):
			v.decode('utf8')
		out_dict[k] = v
	return out_dict

def build_url(query):
	return base_url + '?' + urllib.urlencode(encoded_dict(query))

class cdaxonline():
	@staticmethod
	def root():
		addDir(name='[B]Filmy[/B] ',mode='content',ex_link='http://cda-tv.pl/filmy-online')
		addDir(name=' Polecane filmy',mode='contentR',ex_link='http://cda-tv.pl/filmy-online')
		addDir(name=' Filmy HD',mode='content',ex_link='http://cda-tv.pl/jakosc/hd/')
		addDir(name=' Filmy FHD',mode='content',ex_link='http://cda-tv.pl/jakosc/full-hd/')
		addDir(name=' Nowe linki',mode='content',ex_link='https://cda-tv.pl/jakosc/nowe-linki/')
		addDir(name='  Gatunek',mode='kategorie',ex_link=None)
		addDir(name='  Rok',mode='rok',ex_link=None)
		addDir(name='[B]Seriale[/B]',mode='content',ex_link='http://cda-tv.pl/seriale-online/')
		addDir(name='  Polecane seriale',mode='contentR',ex_link='http://cda-tv.pl/seriale-online/')
		addDir(name='  Odcinki',mode='content',ex_link='http://cda-tv.pl/odcinki-online/')
		addDir(name='[B]Rozrywka[/B]',mode='content',ex_link='http://cda-tv.pl/gatunki/rozrywka/')
		addDir(name='Szukaj',mode='search',ex_link=None)
		xbmcplugin.endOfDirectory(addon_handle)

	@staticmethod
	def content(ex_link):
		from cdaxDef import cdaxOnline2
		opisy=False
		if 'true' in my_addon.getSetting('pokazopisy') and 'hd/' in ex_link:
			opisy=True		
		out,outCDAX,pageCDX = cdaxOnline2().getContentCDAX(ex_link,opisy)
		pageCNTmode='__page__:content'
		if pageCDX[1]:
			addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=pageCDX[1], mode=pageCNTmode, IsPlayable=False)
		for f in out:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='playOpenKatalog', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
		for f in outCDAX:
			addDir(f.get('title'),f.get('href'), page=1, mode='seriale_seasons',iconImage=f.get('img'), infoLabels=f)
		if pageCDX[0]:
			addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=pageCDX[0], mode=pageCNTmode, IsPlayable=False)
		xbmcplugin.setContent(addon_handle, 'movies')
		xbmcplugin.endOfDirectory(addon_handle)

	@staticmethod
	def contentsearch(ex_link):
		from cdaxDef import cdaxOnline2
		out,outCDAX,pageCDX = cdaxOnline2().getContentCDAXsearch(ex_link)
		pageCNTmode='__page__:contentsearch'
		if pageCDX[1]:
			addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=pageCDX[1], mode=pageCNTmode, IsPlayable=False)
		for f in out:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='playOpenKatalog', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
		for f in outCDAX:
			addDir(f.get('title'),f.get('href'), page=1, mode='seriale_seasons',iconImage=f.get('img'), infoLabels=f)
		if pageCDX[0]:
			addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=pageCDX[0], mode=pageCNTmode, IsPlayable=False)
		xbmcplugin.setContent(addon_handle, 'movies')
		xbmcplugin.endOfDirectory(addon_handle)
		
	@staticmethod
	def contentR(ex_link):
		from cdaxDef import cdaxOnline2
		opisy=False
		if 'true' in my_addon.getSetting('pokazopisy'):
			opisy=True
		out,outCDAX,pageCDX = cdaxOnline2().getContentRecommended(ex_link,opisy)
		pageCNTmode='__page__:content'
		
		if out or outCDAX:
			if pageCDX[1]:
				addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=pageCDX[1], mode=pageCNTmode, IsPlayable=False)
			
			for f in out:
				addLinkItem(name=f.get('title'), url=f.get('href'), mode='playOpenKatalog', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
			for f in outCDAX:
				addDir(f.get('title'),f.get('href'), page=1, mode='seriale_seasons',iconImage=f.get('img'), infoLabels=f)
			if pageCDX[0]:
				addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=pageCDX[0], mode=pageCNTmode, IsPlayable=False)
			xbmcplugin.setContent(addon_handle, 'movies')
			xbmcplugin.endOfDirectory(addon_handle)
		else:
			xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak linków.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)		
		
	@staticmethod
	def category(ex_link=''):
		from cdaxDef import cdaxOnline2
		out = cdaxOnline2().getCatCDAX()
		for oneCDAX in out:
			addDir(name=oneCDAX.get('title'),mode='content',ex_link=oneCDAX.get('href'))
		xbmcplugin.endOfDirectory(addon_handle)

	@staticmethod
	def getYear(ex_link=''):
		from cdaxDef import cdaxOnline2
		out = cdaxOnline2().release()
		for oneCDAX in out:
			addDir(name=oneCDAX.get('title'),mode='content',ex_link=oneCDAX.get('href'))
		xbmcplugin.endOfDirectory(addon_handle)

	@staticmethod
	def page(mode,ex_link):
		_mymode=mode.split(':')[-1]
		url = build_url({'mode': _mymode, 'foldername': '', 'ex_link' : ex_link })
		xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)

	@staticmethod
	def search(mode,ex_link):
		from history import SearchHistory
		mymode=mode.split(':')[-1] if ':' in mode else ''
		if mymode == '':
			addDir('[COLOR lightgreen]Nowe Szukanie[/COLOR]',ex_link='',mode='search:new')
			history = SearchHistory().HistoryLoad()
			if not history == ['']:
				for entry in history:
					contextmenu = []
					contextmenu.append(('Usun', 'XBMC.Container.Refresh(%s)'% build_url({'mode': 'search:delOne', 'ex_link' : entry})),)
					contextmenu.append(('Usun całą historię', 'XBMC.Container.Update(%s)' % build_url({'mode': 'search:delAll'})),)
					addDir(name=entry, ex_link=entry.replace(' ','+'), mode='search:new', fanart=None, contextmenu=contextmenu)
			xbmcplugin.endOfDirectory(addon_handle)
		elif mymode =='new':
			if not ex_link:
				search_entry = dialog.input('Szukaj, Podaj tytuł filmu', type=xbmcgui.INPUT_ALPHANUM)
				if search_entry: SearchHistory().HistoryAdd(search_entry)
				else: quit()
			else:
				search_entry = ex_link
			if search_entry:
				from cdaxDef import cdaxOnline2
				out,outCDAX,pageCDX = cdaxOnline2().getContentCDAXsearch('https://cda-tv.pl/?s='+search_entry.replace(' ','+'))
				pageCNTmode='__page__:contentsearch'
				if pageCDX[1]:
					addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=pageCDX[1], mode=pageCNTmode, IsPlayable=False)
				for f in out: addLinkItem(name=f.get('title'), url=f.get('href'), mode='playOpenKatalog', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
				for f in outCDAX: addDir(f.get('title'),f.get('href'), page=1, mode='seriale_seasons',iconImage=f.get('img'), infoLabels=f)
				if pageCDX[0]:
					addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=pageCDX[0], mode=pageCNTmode, IsPlayable=False)
			xbmcplugin.endOfDirectory(addon_handle)
		elif mymode =='delOne':
			SearchHistory().HistoryDel(ex_link)
			xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'search'}))
		elif mymode =='delAll':
			SearchHistory().HistoryClear()
			xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'search'}))
		#xbmcplugin.setContent(addon_handle, 'movies')

	@staticmethod
	def playOpenKatalog(ex_link):
		stream_url=''
		from cdaxDef import cdaxOnline2
		streams = cdaxOnline2().getVideosCDAX(ex_link)
		LinkCDAX=''
		if len(streams)>0:
			select = xbmcgui.Dialog().select('Wybór źródła: [host] ', [ x.get('title') for x in streams]) if len(streams)>1 else 0
			if select>-1:
				LinkCDAX = streams[select].get('href')
				if streams[select].get('resolved') == False:
					LinkCDAX = cdaxOnline2().getSrcs(LinkCDAX)
				else:
					LinkCDAX = cdaxOnline2().getSrcsTrue(LinkCDAX)	
		else:
			xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak linków.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)		
		if LinkCDAX:
			if 'verystream' in LinkCDAX:
				stream_url = cdaxOnline2().getverystream(LinkCDAX)	
			else:
			
			
				try:
					import resolveurl as urlresolver
					stream_url = urlresolver.resolve(LinkCDAX)
				except Exception,e:
					stream_url=''
					s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link będzie działał?','Resolveurl ERROR: [%s]'%str(e))
		if stream_url:
			xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
		else:
			xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))

	@staticmethod
	def getSeasons(ex_link):
		from cdaxDef import cdaxOnline2
		out = cdaxOnline2().getEpisodesCDAX(ex_link)
		if out:
	  #  print('seriale_seasons',ex_link,out)
			episContent = cdaxOnline2().getSesCDAX(out)
			for nameCDAX in sorted(episContent.keys()):
				addDir(name=nameCDAX, ex_link=urllib.quote(str(episContent[nameCDAX])), mode='seriale_episodes')
			xbmcplugin.setContent(addon_handle, 'tvshows')
			xbmcplugin.endOfDirectory(addon_handle)
		else:
			xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Brak listy odcinków do wyświetlenia.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)		

	@staticmethod
	def getEpisodes(ex_link):
		quotLink = eval(urllib.unquote(ex_link))
		for f in quotLink:
			f['title'] ='S%02dE%02d %s'%( f.get('season'),f.get('episode'),f.get('title'))
			addLinkItem(name=f['title'], url=f.get('href'), mode='playOpenKatalog', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
		xbmcplugin.setContent(addon_handle, 'episodes')
		xbmcplugin.endOfDirectory(addon_handle)
