# -*- coding: UTF-8 -*-

import sys,re,os
import six
from six.moves import urllib_parse

import requests, json
from requests.compat import urlparse
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs

if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    from resources.lib.cmf3 import parseDOM
else:
    from resources.lib.cmf2 import parseDOM
    
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.darmowatv')
proxyport = addon.getSetting('proxyport')

PATH            = addon.getAddonInfo('path')
if six.PY2:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
else:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'
prawo =RESOURCES+'right.png'
exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

page = params.get('page',[1])
infl = params.get('infol', None)

UA = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:89.0) Gecko/20100101 Firefox/89.0'
TIMEOUT=15

headers = {'User-Agent': UA,}
sess = requests.Session()



#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_UNSORTED, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_DATE, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_LABEL, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_LASTPLAYED, label2Mask = "%R, %P, %Y")

def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):

    if six.PY3:    
        list_item = xbmcgui.ListItem(name)
    
    else:
        list_item = xbmcgui.ListItem(name, iconImage=image, thumbnailImage=image)
    
    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')  
        out = []
        out.append(('Informacja', 'Action(Info)'),)
        list_item.addContextMenuItems(out, replaceItems=False)
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})
    if not infoLabels:
        infoLabels={'title': name}  

    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page, 'title':name,'image':image,'infol':infoLabels}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%Y")
    
def home():
    add_item('http://217.61.2.227/', 'Beta TV', ikona, "betamenu",fanart=FANART, folder=True)
    add_item('http://45.148.120.109/pl5.txt', 'Polstream.ml', ikona, "listcontent",fanart=FANART, folder=True)
    add_item('xx', 'Strumyk (kanały)', ikona, "strumyk",fanart=FANART, folder=True)
        
    
def MenuBeta():
    add_item('http://217.61.2.227/', 'Beta TV - [COLOR gold]TV[/COLOR]', ikona, "listcontent",fanart=FANART, folder=True)
    add_item('http://217.61.2.227/', 'Beta TV - [COLOR gold]VOD[/COLOR]',ikona, 'listvod',fanart=FANART, folder=True)
    add_item('http://217.61.2.227/', 'Szukaj',ikona, 'searchvod',fanart=FANART, folder=True)
    xbmcplugin.endOfDirectory(addon_handle)

def StrumykListTVs():
    add_item('http://strims.top/l/PolsatNews.php', 'Polsat News', ikona, "listlinks",fanart=FANART, folder=True)
    add_item('http://strims.top/l/TVN24.php', 'TVN24', ikona, "listlinks",fanart=FANART, folder=True)
    add_item('http://strims.top/l/TVPInfo.php', 'TVP Info', ikona, "listlinks",fanart=FANART, folder=True)
    add_item('http://strims.top/l/BBC.php', 'BBC', ikona, "listlinks",fanart=FANART, folder=True)
    add_item('http://strims.top/l/CNN.php', 'CNN', ikona, "listlinks",fanart=FANART, folder=True)
    add_item('http://strims.top/l/SkyNews.php', 'Sky News', ikona, "listlinks",fanart=FANART, folder=True)
    add_item('http://strims.top/l/24TV.php', 'Ukraina TV', ikona, "listlinks",fanart=FANART, folder=True)
    
    add_item('http://strims.top/l/TVN24.php', 'Polska', ikona, "listtv3",fanart=FANART, folder=True)
    add_item('http://strims.top/l/TVN24.php', 'World Sport', ikona, "listtv2",fanart=FANART, folder=True)
    add_item('http://strims.top/l/TVN24.php', 'World News', ikona, "listtv2",fanart=FANART, folder=True)
    add_item('http://strims.top/l/TVN24.php', 'World Music', ikona, "listtv2",fanart=FANART, folder=True)
    add_item('http://strims.top/l/TVN24.php', 'World Channels', ikona, "listtv2",fanart=FANART, folder=True)

    xbmcplugin.endOfDirectory(addon_handle)
    
    
    
def getPage(main, subc = None): 
    import base64
    dt = "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"
    data = base64.b64decode(dt) 
    if sys.version_info >= (3,0,0):
        data = data.decode(encoding='utf-8', errors='strict')

    if main and not 'Polska' in main:
        mainpage = re.findall('main="'+main+'"(.+?)endmain',data,re.DOTALL)[0]
        out=[{'href':k,'title':x} for k,x in re.findall('href="(.+?)"\,name\="(.+?)"',mainpage,re.DOTALL) ]
    else:
        if subc:
            mainpage = re.findall('kateg="'+subc+'"(.+?)endkateg',data,re.DOTALL)[0]
            out=[{'href':k,'title':x} for k,x in re.findall('href="(.+?)"\,name\="(.+?)"',mainpage,re.DOTALL) ]
        else:
            out = [{'href': '', 'title': 'SPORT'},   {'href': '', 'title': 'RÓŻNE'}, {'href': '', 'title': 'REGIONALNE'}, {'href': '', 'title': 'STACJE RADIOWE'}]

    return out
    
def StrumykListTVs2(tyt):
    links = getPage(tyt) 
    if links:
        for f in links:
            ilabel = {'plot':f.get('title', None), 'title':f.get('title', None)}
            add_item(f.get('href', None), f.get('title', None),ikona, 'playtv',fanart=FANART, infoLabels = ilabel, folder=False, IsPlayable=True)

    xbmcplugin.endOfDirectory(addon_handle)

def StrumykListTVs3(ff, xx, play=None):
    links = getPage(ff, xx) 
    if play:
        mod = 'playtv'
        ispla = True
        fold = False
    else:
        mod = 'listtv4'
        ispla = False
        fold = True
    for f in links:
    
        ilabel = {'plot':f.get('title', None), 'title':f.get('title', None)}
        add_item(f.get('href', None), f.get('title', None),ikona, mod,fanart=FANART, infoLabels = ilabel, folder=fold, IsPlayable=ispla)

    xbmcplugin.endOfDirectory(addon_handle)
def ListVod(query, pg):
    headers = {
    'User-Agent': UA,

     'Accept-Encoding': 'gzip, deflate',
    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
    'X-Requested-With': 'XMLHttpRequest',}

    if 'query:' in query:
        searchquery = query.split(':')[-1]
    else:
        query ='none'
        searchquery =''
    data = {
        'page': str(pg),
        'query': searchquery,
    }

    html = getUrlReqOk('http://217.61.2.227/fetch.php',ref='',data=data, headers={}, json=False)
    links = re.findall('<h4>(.*?)<\/p>', html,re.DOTALL)

    nast = re.findall('data\-page\_number\="(\d+)">nast',html,re.DOTALL+re.I)
    
    for link in links:
        try:
            tyt,opis,href,imag = re.findall('<b>([^<]+)<.*?h4>([^"]+)".*?href="([^"]+)".*?src\s*=\s*"([^"]+)"',link,re.DOTALL)[0]
            
        except:
            pass

        imag = 'http:' + imag if imag.startswith('//') else imag
        ilabel = {'plot':PLchar(opis.strip(' ')), 'title':PLchar(tyt.strip(' '))}
        add_item(href, PLchar(tyt.strip(' ')),imag, 'playvod',fanart=FANART, infoLabels = ilabel, folder=False, IsPlayable=True)
    if nast:
        add_item(query, '>>> następna strona >>>',prawo, 'listvod',fanart=FANART, folder=True, page=int(nast[0]))
    xbmcplugin.endOfDirectory(addon_handle)

def PlayVod(url):

    html = getUrlReqOk(url, json=False)

    src = re.findall('source.*?src="([^"]+)"',html,re.DOTALL+re.I)
    if src:
        src = src[0].replace('&amp;','&')+'|User-Agent='+UA+'&Referer='+url
        play_item = xbmcgui.ListItem(path=src)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)  

def ListContent(url):

    if 'polstream' in nazwa.lower():
        headers = {

        'User-Agent': UA,
        'Accept': 'application/json',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Content-Type': 'application/json',

        'Referer': 'http://polstream.live/',}

        try:
            html=getUrlReqOk(url,headers=headers, json=True)
        except:
            html=getUrlReqOk('http://polstream.live/pl5.txt',headers=headers, json=True)

    if 'beta' in nazwa.lower():
        html=getUrlReqOk(url)
        result = parseDOM(html,'div', attrs={'class': "channels"})[0]
        links = parseDOM(result,'li')
        for link in links:
            
            href = parseDOM(link,'a', ret="href")[0]
            href = 'http:' + href if href.startswith('//') else href
            tyt = parseDOM(link,'a', ret="title")[0]
            imag = parseDOM(link,'img', ret="src")[0]
            imag = 'http://217.61.2.227/' + imag if imag.startswith('tv') else imag
            ilabel = {'plot':PLchar(tyt), 'title':PLchar(tyt)}
            add_item(href, PLchar(tyt),imag, 'playLink',fanart=FANART, infoLabels = ilabel, folder=False, IsPlayable=True)
    else:

        for kateg in html:
            tyt = kateg.get('title', None)
            try:
                tyt = tyt.encode('latin-1').decode('utf-8')
            except:
                tyt = tyt
            href = urllib_parse.quote(json.dumps(kateg.get('folder', None)))
            ilabel = {'plot':PLchar(tyt), 'title':PLchar(tyt)}
            add_item(href, PLchar(tyt),ikona, 'subcateg',fanart=FANART, infoLabels = ilabel, folder=True)

    xbmcplugin.setContent(addon_handle, 'videos')    

    xbmcplugin.endOfDirectory(addon_handle)
    
def SubCateg(dane):

    dt = json.loads(urllib_parse.unquote(dane))
    for d in dt:
        tyt = d.get('title', None)
        try:
            tyt = tyt.encode('latin-1').decode('utf-8')
        except:
            tyt = tyt
        href = d.get('file', None)
        ilabel = {'plot':tyt, 'title':tyt}
        add_item(href+'!!resolved!!', tyt,ikona, 'playLink',fanart=FANART, infoLabels = ilabel, folder=False, IsPlayable=True)

    xbmcplugin.setContent(addon_handle, 'videos')    

    xbmcplugin.endOfDirectory(addon_handle)
    
def PlayLink(url):

    if not '!!resolved!!' in url:
        html = getUrlReqOk(url)
        
        iframe = parseDOM(html,'source',ret='src')

        if iframe:
            iframe = 'http:' + iframe[0] if iframe[0].startswith('//') else iframe[0]
            iframe+='|User-Agent='+UA+'&Referer='+url
    else:
        iframe = url.split('!!')[0]
        if six.PY2:    
            iframe = 'http://127.0.0.1:%s/dd='%(str(proxyport))+iframe+'|User-Agent='+UA+'&Referer=http://polstream.live'
        else:
            iframe += '|User-Agent='+UA+'&Referer=http://polstream.live'#+url

    if iframe:
        play_item = xbmcgui.ListItem(path=iframe)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)    

    else:
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', "[COLOR red][B]Brak tego video.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)
    

def ListLinks(url, tit):

    html=getUrlReqOk(url)
    basurl = url
    out=[]

    try:
        try:
            result = parseDOM(html,'font size=3.+?')[0].replace('</a><br><br>','</a>|<br><br>')
        except:
    
            if 'strims.top/l/' in url:
    
                resul = re.findall('Javascript required(.+?)$',html,re.DOTALL)[0]
                resul = resul.replace('</b>','').replace('<b>','')
                resul = re.findall('class="tb\-mid">(.*?)$',resul,re.DOTALL)[0]

                f=re.findall('href="(.+?)" style=".*?">(.+?)<',resul,re.DOTALL)
                
                f=re.findall('<a\s*href="([^"]+)"\s*style="[^"]+">([^<]+)<',resul,re.DOTALL)
                
                for k,z in f:
    
                    out.append({'href':url+k,'title':'[COLOR gold][B]'+tit+'[/B][/COLOR] '+z})
    
            result = parseDOM(html,'font',attrs = {'size':'3'})[0].replace('</a><br><br>','</a>|<br><br>')
    
        if '<center><b>' in result or 'zatrzyma' in result or 'prawym doln' in result.lower() or 'lewym dol' in result.lower() or 'playerz' in result.lower():
            result = parseDOM(html,'font',attrs = {'size':'3'})[1]
            
        result=result.replace('\n','').replace('<b>','').replace('</b>','')
    
        try:
            result2=result.replace('\n','').replace('</a> |',' |').replace('<b>','').replace('</b>','')
    
            xx=re.findall('(\w+\:\s*\\r.*?\\r\\r)',result2,re.DOTALL)
            
            for x in xx:
                x=x.replace('br>','')
                lang=re.findall('^(\w+)',x,re.DOTALL)[0]
                
                hreftyt=re.findall('href="(.+?)".+?>(Source \d.+?)<',x)
                if lang and not hreftyt:
                    x=x.replace('</a>','|')
                    hreftyt=re.findall('href="(.+?)".+?>(.+?)\|',x)
                for href,tyt in hreftyt:
                    tyt = tyt.replace('|','')
    
                    href='http://strims.top'+href if href.startswith ('/') else basurl+href
                    tyt='%s - [B]%s[/B]'%(lang,tyt)
                    out.append({'href':href,'title':tit+' '+tyt})
    
        except:
            results=result.split('|')
            
            for result in results:
                href,name=re.findall('href="(.+?)".+?>(.+?)<\/a>',result)[0]

                href='http://strims.top'+href if href.startswith ('/') else basurl+href
                out.append({'href':href,'title':tit+' '+name.replace('<b>','').replace('</b>','')})        
        
    except:

        pass
    if not out:
        try:
    
            results=result.split('|')
            if not 'poczekaj' in results[0].lower():
                for result in results:
                    
                    href,name=re.findall('href="(.+?)".+?>(.+?)<\/a>',result)[0]

                    href='http://strims.top'+href if href.startswith ('/') else basurl+href
                    out.append({'href':href,'title':tit+' '+name.replace('<b>','').replace('</b>','')})    
            else:
                pass
        except:
            out.append({'href':basurl ,'title':'[COLOR gold][B]'+tit+'[/B][/COLOR] ' })    
            pass
    for f in out:
        tit = re.sub('<[^<]+?>', '', f.get('title'))
        ilabel = {'plot':tit, 'title':tit}
        add_item(f.get('href', None), tit,ikona, 'playtv',fanart=FANART, infoLabels = ilabel, folder=False, IsPlayable=True)

    xbmcplugin.endOfDirectory(addon_handle)

    
def unescapeHtml(hh):
    hh=re.findall('(eval\(unescape.+?</script>)',hh,re.DOTALL)[0]
    vales=re.findall("""['"](.+?)['"]""",hh,re.DOTALL)
    vale=vales[0] if vales else ''
    a=urllib_parse.unquote(vale)  
    if 'm3u8' in a or 'src="http' in a:
        return a
    else:
        try:
            spl=re.findall("""split\(['"](.+?)['"]\)""",a,re.DOTALL)[0]
            pl=re.findall("""\+\s*['"](.+?)['"]\);""",a,re.DOTALL)[0]
            odj=re.findall('\(i\)\)(.+?)\);',a,re.DOTALL)[0]    
            funkcja='chr((int(k[i%len(k)])^ord(s[i]))'+odj+')'
            tmp=vales[2]
            tmp = tmp.split(spl)
            s = urllib_parse.unquote(tmp[0]);
            k = urllib_parse.unquote(tmp[1] + pl);
            r=''
            for i in range(0, len(s)):
                r+=eval(funkcja)
            return r
        except:
            return a
    
    
def resolvingCR(url,ref):
    from resources.lib import mydecode
    hdrs = {
        'User-Agent': UA, 'Referer':ref}

    try:
        html=getUrlReqOk(url, headers=hdrs)

    except:
        html=''
    if 'rojadirecta' in url and 'goto/' in url:
    
        url = re.findall('a href="([^"]+)"',html,re.DOTALL)[0]
        ref = 'http://www.rojadirecta.me/en?p4'
        hdrs.update({'Referer': ref})
        html=getUrlReqOk(url, headers=hdrs)

    if not 'manifest.m3u8' in url:
        iframes= parseDOM(html,'iframe',ret='src')#[0]
        dal=''
    
        for iframe in iframes:
            if '/chat.php' in iframe:
                continue
            if 'unblocked.is' in iframe:
                if 'nullrefer.com' in iframe or 'href.li/' in iframe:
                    iframe = urlparse(iframe).query
                hdrs.update({'Referer': url})
                html2=getUrlReqOk(iframe, headers=hdrs)

                stream=self.getUnblocked(html2)
                return stream
            elif 'nullrefer.com' in iframe or 'href.li/' in iframe:

                if 'href.li/' in iframe:
                    iframe = iframe.split('href.li/')[-1]
                else:
                    iframe = urlparse(iframe).query
                hdrs.update({'Referer': url})
                html=getUrlReqOk(iframe, headers=hdrs)
    
                url=iframe
                break
    
            elif 'sportsbay.org' in iframe:
                if iframe.startswith('//'):
    
                    iframe = 'https:'+iframe
                    
                    
                hdrs.update({'Referer': url})
                html=getUrlReqOk(iframe, headers=hdrs)
    
                url=iframe
                dal=iframe
                break
            elif 'cricfree.' in iframe:
                if iframe.startswith('//'):
    
                    iframe = 'https:'+iframe
                    
                hdrs.update({'Referer': url})
                html=getUrlReqOk(iframe, headers=hdrs)

                url=iframe
                dal=iframe
                break
                
                
                
            elif 'daddylive.live' in iframe:
                if iframe.startswith('//'):
    
                    iframe = 'https:'+iframe
                    
                hdrs.update({'Referer': url})
                html=getUrlReqOk(iframe, headers=hdrs)

                url=iframe
                dal=iframe
                break
            elif 'strims.top' in iframe:
                if iframe.startswith('//'):
                    iframe = 'https:'+iframe
                hdrs.update({'Referer': url})
                html=getUrlReqOk(iframe, headers=hdrs)

                url=iframe
                dal=iframe
                break
        
        if html.find("eval(unescape('")>0:

            try:
                html=+unescapeHtml(html)
            except:
                pass
        vido_url=re.findall("""['"](rtmp:.+?)['"]""",html,re.DOTALL)
        if vido_url:
            vido_url = vido_url[0]
        else:
            vido_url=re.findall("""source:\s*['"](.+?)['"]""",html,re.DOTALL)
    
            if vido_url:
                if 'google.' in vido_url[0] :
                    vido_url = ''

            vido_url = vido_url[0]+'|User-Agent='+UA+'&Referer='+dal if vido_url else mydecode.decode(url,html)
            
            if vido_url:
                if 'about:blank' in vido_url:
                    vido_url=mydecode.decode(url,html)    
    else:
        vido_url=url
    return vido_url
    
    
    
    
    
    
    
    
def StrumykPlayTV(url): 
    url='http://strims.top'+url if url.startswith ('/') else url
    if 'http://strims.top' in url:
        video_url = resolvingCR(url,'http://strims.top')    
    else:
        if 'castfree' in url:
            video_url = mydecode.castfree(url,'','http://strims.top')
        elif 'cricfree' in url:

            video_url = mydecode._cricfree(url,'','http://strims.top')

    if video_url:
        play_item = xbmcgui.ListItem(path=video_url)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)    
        


def getUrlReqOk(url,ref='',data={}, headers={}, json=False):    

    headersok = {
    'User-Agent': UA,
    'Accept': 'text/html',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    'Connection': 'keep-alive',
    
    'Referer': ref,}
    if data:
        #headersok = {
        #    'Host': 'filmowo.club',
        #    'user-agent': UA,
        #    'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
        #    'x-requested-with': 'XMLHttpRequest',
        #    'referer': ref,}

        content=sess.post(url, headers=headers,data=data, verify=False)#.text
        content = content.json() if json else content.text
    else:
        headersok = headers if headers else headersok
        content=sess.get(url, headers=headersok,verify=False)#.text
        content = content.json() if json else content.text
            
    
    return content

def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&")    
    char = char.replace('&#039;',"'")
    char = char.replace('&quot;','"').replace('&oacute;','ó').replace('&rsquo;',"'")
    char = char.replace('&nbsp;',".").replace('&amp;','&').replace('&eacute;','e')
    return char    
def PLcharx(char):
    char=char.replace("\xb9","ą").replace("\xa5","Ą").replace("\xe6","ć").replace("\xc6","Ć")
    char=char.replace("\xea","ę").replace("\xca","Ę").replace("\xb3","ł").replace("\xa3","Ł")
    char=char.replace("\xf3","ó").replace("\xd3","Ó").replace("\x9c","ś").replace("\x8c","Ś")
    char=char.replace("\x9f","ź").replace("\xaf","Ż").replace("\xbf","ż").replace("\xac","Ź")
    char=char.replace("\xf1","ń").replace("\xd1","Ń").replace("\x8f","Ź");
    return char    
    
def router(paramstring):
    params = dict(urllib_parse.parse_qsl(paramstring))
    if params:    
    
        mode = params.get('mode', None)
    
    
        if mode =='listcontent':
            ListContent(exlink)
        
        elif mode == 'subcateg':
            SubCateg(exlink)
    
        elif mode =='strumyk':
            StrumykListTVs()
        
        elif mode =='listtv3':
            StrumykListTVs3(None, None)
            
        elif mode == 'listtv4':
            StrumykListTVs3(exlink, nazwa, True)    
            
        elif mode == 'listtv2':
            StrumykListTVs2(nazwa)    
        
        
        elif mode == 'playtv':
            StrumykPlayTV(exlink)
    
        elif mode =='listlinks':
            ListLinks(exlink, nazwa)
            
    
        elif mode == 'playLink':
            PlayLink(exlink)
            
        elif mode =='listvod':
            ListVod(exlink, page)
        elif mode =='betamenu':
            MenuBeta()
            
        elif mode =='searchvod':
            query = xbmcgui.Dialog().input(u'Szukaj...', type=xbmcgui.INPUT_ALPHANUM)
            if query:      
                query=query.replace(' ','+')
                ListVod('query:'+query, 1)
            else:
                pass
        elif mode =='playvod':
            PlayVod(exlink)
    else:
        home()
        xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])