# -*- coding: utf-8 -*-
import sys, re, os
import urllib, urllib2
import urlparse, json
import xbmc, xbmcgui, xbmcaddon
import xbmcplugin
import time, threading

base_url     = sys.argv[0]
addon_handle = int(sys.argv[1])
args         = urlparse.parse_qs(sys.argv[2][1:])
my_addon     = xbmcaddon.Addon()
addonName    = xbmcaddon.Addon().getAddonInfo('name')
addonId      = xbmcaddon.Addon().getAddonInfo('id')
PATH         = xbmcaddon.Addon().getAddonInfo('path')
DATAPATH     = xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('profile')).decode('utf-8')
RESOURCES    = PATH + '/resources/'
FANART       = PATH + '/fanart.jpg'
ICON         = PATH + '/icon.png'

def addLinkItem(name, url, mode, cat = '', iconImage = None, infoLabels = False, IsPlayable = True, fanart = FANART, itemcount = 1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'cat':cat})
    liz = xbmcgui.ListItem(name, iconImage = iconImage, thumbnailImage = iconImage)
    liz.setArt({ 'poster': infoLabels.get('poster', iconImage), 'thumb': iconImage, 'icon': iconImage, 'fanart': infoLabels.get('fanart', iconImage), 'banner': infoLabels.get('banner',iconImage)})
    infoLabels['url'] = str(infoLabels.get('url'))
    liz.setInfo(type = "video", infoLabels = infoLabels)
    if IsPlayable: liz.setProperty('IsPlayable', 'true')
    if fanart: liz.setProperty('fanart_image', fanart)
    ok = xbmcplugin.addDirectoryItem(handle = addon_handle, url = u, listitem = liz, isFolder = False, totalItems = itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok

def addDir(name, url = None, mode = '', cat = '', iconImage = ICON, fanart = FANART, infoLabels = {}, totalItems = 1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link': url, 'cat': cat})
    if iconImage == None: iconImage = 'DefaultFolder.png'
    li = xbmcgui.ListItem(label = name, iconImage = iconImage)
    li = xbmcgui.ListItem(name, iconImage = iconImage, thumbnailImage = iconImage)
    li.setArt({ 'poster': infoLabels.get('poster', iconImage), 'thumb': iconImage, 'icon': iconImage, 'fanart': infoLabels.get('fanart',iconImage), 'banner': infoLabels.get('banner', iconImage)})
    if infoLabels: li.setInfo(type = "video", infoLabels = infoLabels)
    if fanart: li.setProperty('fanart_image', fanart )
    xbmcplugin.addDirectoryItem(handle = addon_handle, url = u,listitem = li, isFolder = True)

def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')

        out_dict[k] = v

    return out_dict

def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))

def getUrl(url):
    req = urllib2.Request(url, data = None, headers = {'User-Agent':'Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6_4; en-US) AppleWebKit/534.3 (KHTML, like Gecko) Chrome/6.0.472.63 Safari/534.3'})
    try:
        response = urllib2.urlopen(req, timeout = 10)
        out = response.read()
        response.close()
    except:
        out = ''

    return out

def getContent(url = 'http://www.dokumentcyfrowo.pl/', category = ''):
    out=[]
    if not category:
        content = getUrl(url)
        categorys = re.compile('<a class="category" href="(.*?)" title="(.*?)">[\s\n]*<div class="move" style="background-image: url\((.*?)\)',re.DOTALL).findall(content)
        for cat, title, img in categorys:
            out.append({'url': cat.strip(),
                        'title': title.strip(),
                        'img': urlparse.urljoin(url, img.strip())})
    else:
        content = getUrl(urlparse.urljoin(url,category))
        wc = re.compile('<div class="cat(?: darker">|">)(.*?)</article>', re.DOTALL).findall(content)
        for mm in wc:
            href = re.findall('<a href="(.*?)" title="(.*?)">',mm)
            data = re.findall('<img src="(.*?)" alt="(.*?)"',mm)
            plot =[x for x in re.findall('>(.*?)<',mm) if x.strip()]
            if href and data:
                plot = '\n'.join(plot) if plot else ''
                plot = re.sub(':\s*\n',': ', plot)
                out.append({'url': href[0][0].strip(),
                            'title': data[0][1].strip(),
                            'plot': unicodePLchar(plot),
                            'img': urlparse.urljoin(url, data[0][0].strip())})
    return out

def play(url):
	content = getUrl(urlparse.urljoin('http://www.dokumentcyfrowo.pl/',url))
	iframe = re.findall('<iframe.+src="(.*?)".+?</iframe',content,re.DOTALL)
	#iframe[0]
	vl = ''
	
	if iframe:
		try:
			import resolveurl as urlresolver
			iframe=iframe[0]
			iframe = 'https:'+iframe if iframe.startswith('//') else iframe
			if 'vimeo' in iframe:
				id=re.findall('\d+',iframe)[0]
				iframe='https://vimeo.com/%s'%id
			vl = urlresolver.resolve(iframe)
		except Exception,e:
			vl = ''
			s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link będzie działał?','Urlresolver ERROR: [%s]'%str(e))
	else:
			xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Brak źródła!')
			pass
	
	if vl:
		xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path = vl))
	else:
		xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path = ''))

def unicodePLchar(txt):
    if type(txt) is not str:
        txt=txt.encode('utf-8')
    s='JiNcZCs7'
    txt = re.sub(s.decode('base64'),'',txt)
    txt = re.sub('<br\s*/>','\n',txt)
    txt = txt.replace('&nbsp;','')
    txt = txt.replace('&lt;br/&gt;',' ')
    txt = txt.replace('&ndash;','-')
    txt = txt.replace('&quot;','"').replace('&amp;quot;','"')
    txt = txt.replace('&oacute;','ó').replace('&Oacute;','Ó')
    txt = txt.replace('&amp;oacute;','ó').replace('&amp;Oacute;','Ó')
    txt = txt.replace('&amp;','&')
    txt = re.sub('&.+;','',txt)
    txt = txt.replace('\u0105','ą').replace('\u0104','Ą')
    txt = txt.replace('\u0107','ć').replace('\u0106','Ć')
    txt = txt.replace('\u0119','ę').replace('\u0118','Ę')
    txt = txt.replace('\u0142','ł').replace('\u0141','Ł')
    txt = txt.replace('\u0144','ń').replace('\u0144','Ń')
    txt = txt.replace('\u00f3','ó').replace('\u00d3','Ó')
    txt = txt.replace('\u015b','ś').replace('\u015a','Ś')
    txt = txt.replace('\u017a','ź').replace('\u0179','Ź')
    txt = txt.replace('\u017c','ż').replace('\u017b','Ż')
    return txt
	
mode    = args.get('mode', None)
fname   = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
cat     = args.get('cat',[''])[0]

if mode is None:
	data = getContent()
	for d in data: addDir(d.get('title'), url = d.get('url'), cat = d.get('url'), mode = 'getContent', infoLabels = d, iconImage = d.get('img',ICON))
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'getContent':
	data = getContent('http://www.dokumentcyfrowo.pl/', ex_link)
	for d in data: addLinkItem(d.get('title'), url = d.get('url'), mode = 'play', infoLabels = d, iconImage = d.get('img'))
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'play':
    play(ex_link)

else:
    xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))

