# -*- coding: utf-8 -*-

import sys,re,os
import urllib,urllib2
import urlparse
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import resolveurl as urlresolver
import time

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
cache = StorageServer.StorageServer('efilmy')

base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urlparse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonName       = my_addon.getAddonInfo('name')
PATH        = my_addon.getAddonInfo('path')
DATAPATH    = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
sys.path.append( os.path.join( PATH,'resources','lib'))
RESOURCES   = PATH+'/resources/'
FANART      = None

import filmwebapi as FILMweb

import efilmy as eFILMY
eFILMY.COOKIEFILE=os.path.join(DATAPATH,'efilmy.cookie')
def getUrl(url,data=None):
    req = urllib2.Request(url,data)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.97 Safari/537.36')
    response = urllib2.urlopen(req)
    content = response.read()
    response.close()
    return content
	
def addLinkItem(name, url, mode, page=1, iconimage='DefaultFolder.png', infoLabels=False, IsPlayable=True,fanart=FANART,itemcount=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page})
    liz = xbmcgui.ListItem(name)
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[iconimage for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape']
    liz.setArt(art)
    if not infoLabels:
        infoLabels={'title': name}
    liz.setInfo(type='video', infoLabels=infoLabels)
    if IsPlayable:
        liz.setProperty('IsPlayable', 'true')
    isp = []
    isp.append(('Informacja', 'XBMC.Action(Info)'))
    liz.addContextMenuItems(isp, replaceItems=False)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%P, %Y, %R')
    return ok
def addDir(name,ex_link=None, page=0, mode='folder',iconImage='DefaultFolder.png', infoLabels=None, fanart=FANART,contextmenu=None,itemcount=1):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page})
    li = xbmcgui.ListItem(name)
    if infoLabels:
        li.setInfo(type='movie', infoLabels=infoLabels)
    art_keys=['thumb','poster','banner','clearart','clearlogo','icon']
    art = dict(zip(art_keys,[iconImage for x in art_keys]))
    li.setArt(art)
    if contextmenu:
        isp=contextmenu
        li.addContextMenuItems(isp, replaceItems=True)
    else:
        isp = []
        isp.append(('Informacja', 'XBMC.Action(Info)'),)
        li.addContextMenuItems(isp, replaceItems=False)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
    return ok
def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))
def updateMetadata(item,use_filmweb='true',itemType='f'):
    if use_filmweb=='true':
        title= item.get('title','')
        year = item.get('year','')
        print title,year
        data = FILMweb.searchFilmweb(title.decode('utf-8'),year.strip(),itemType)
        if data:
            item.update(data)
    item['title'] += item.get('audio','')
    return item
def ListMovies(ex_link):
    use_filmweb_f = my_addon.getSetting('filmweb_f')
    out,pagination = eFILMY.get_content(ex_link)
    if pagination[0]:
        addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=pagination[0], mode='__page__M', IsPlayable=False)
    items=len(out)
    for f in out:
        f=updateMetadata(f,use_filmweb_f,'f')
        addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=items)
    if pagination[1]:
        addLinkItem(name='[COLOR blue]>> Następna strona >>[/COLOR]', url=pagination[1], mode='__page__M', IsPlayable=False)
    xbmcplugin.setContent(addon_handle, 'videos')
def ListSeriale(page):
    print 'ListSeriale',page
    use_filmweb_s = my_addon.getSetting('filmweb_s')
    pagination=int(page)
    out = eFILMY.get_Serial_list(pagination)
    if pagination>0:
        addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__S', page=pagination-1, IsPlayable=False)
    items=len(out)
    for f in out:
        f=updateMetadata(f,use_filmweb_s,'s')
        addDir(name=f.get('title'), ex_link=f.get('url'), mode='getEpisodes', iconImage=f.get('img'), infoLabels=f)
    addLinkItem(name='[COLOR blue]>> Następna strona  >>[/COLOR]', url=ex_link, mode='__page__S', page=pagination+1, IsPlayable=False,itemcount=items)
    xbmcplugin.setContent(addon_handle, 'tvshows')
def getEpisodes(ex_link):
    items = eFILMY.get_Episode_list(ex_link)
    for f in items:
        addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
    xbmcplugin.setContent(addon_handle, 'episodes')
def ListSearch(ex_link):
    out,pagination = eFILMY.search(ex_link)
    if pagination[0]:
        addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=pagination[0], mode='__page__M', IsPlayable=False)
    items=len(out)
    for f in out:
        addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=items)
    if pagination[1]:
        addLinkItem(name='[COLOR blue]>> Następna strona >>[/COLOR]', url=pagination[1], mode='__page__M', IsPlayable=False)
    xbmcplugin.setContent(addon_handle, 'videos')
def getLinks(ex_link):
	streams = eFILMY.getVideoLinks(ex_link)
	if streams:
		stream_url=''
		content=''
		if len(streams)>1:
			msgx = [x.get('msg') for x in streams]
			s = xbmcgui.Dialog().select('Linki',msgx)
		else:
			s=0
		content=streams[s].get('href') if s>-1 else ''
		if not content:
			content = eFILMY.getLink_show_player(streams[s].get('typfs',''),streams[s].get('id',''),streams[s].get('player',''))
		if content:
			if 'vidzer' in content:
				stream_url=content
			elif 'streamin' in content:
				stream_url= eFILMY.getStreamin(content)
			elif 'gounlimited' in content:
				stream_url= eFILMY.getGoUnlim(content)
			elif '/stream/watch/' in content:
				stream_url=content
			elif 'clipwatching' in content:
				stream_url=eFILMY.getClipWatch(content)

				
			if not stream_url:
				try:
					stream_url = urlresolver.resolve(content)
				except Exception,e:
					stream_url=''
					s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]',str(e))
		print 'stream_url',stream_url
		if stream_url:
			xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
		else:
			xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
	else:
		s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]',"Brak działających linków.")
		xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
def getHistory():
    return cache.get('history').split(';')
def setHistory(entry):
    history = getHistory()
    if history == ['']:
        history = []
    history.insert(0, entry)
    cache.set('history',';'.join(history[:50]))
def remCache(entry):
    history = getHistory()
    if history:
        cache.set('history',';'.join(history[:50]))
    else:
        delHistory()
def delHistory():
    cache.delete('history')
def logowanie():
	logged,dod=eFILMY.logowanie()
	return logged,dod
mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
page = args.get('page',[1])[0]
if mode is None:
	logged,dod=logowanie()
	if logged=='false':
		if dod=='darmowe':
			addLinkItem('[COLOR gold]-=Zalogowano=- %s[/COLOR]'%dod,'','  ',IsPlayable=False)
		else:
			addLinkItem('[COLOR gold]-=Zaloguj=-[/COLOR]','','Opcje',IsPlayable=False)
	else:
		addLinkItem('[COLOR gold]-=Zalogowano=- %s[/COLOR]'%dod,'','  ',IsPlayable=False)
	addDir(name='[COLOR blue]Filmy[/COLOR]',ex_link='http://www.efilmy.tv/filmy.html', mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' Top Filmów',ex_link='', mode='Top_filmy',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' Teraz Oglądane',ex_link='http://www.efilmy.tv/filmy.php?cmd=watched', mode='cmd',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' Ostatnio Dodane',ex_link='http://www.efilmy.tv/filmy.php?cmd=added', mode='cmd',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' => [I]Kategorie Filmów[/I]',ex_link='cat', mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' => [I]Rok produkcji[/I]',ex_link='year', mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='[COLOR blue]Seriale[/COLOR]',ex_link='',page=0, mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' Top Seriali',ex_link='', mode='Top_seriale',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' Teraz Oglądane',ex_link='http://www.efilmy.tv/seriale.php?cmd=watched_s', mode='cmd',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name=' Ostatnio Dodane',ex_link='http://www.efilmy.tv/seriale.php?cmd=added_s', mode='cmd',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='[B][COLOR yellow]D[COLOR blue]L[COLOR red]A [COLOR lightgreen]D[COLOR purple]Z[COLOR gold]I[COLOR blue]E[COLOR red]C[COLOR lightgreen]I[/COLOR][/B]',ex_link='http://www.efilmy.tv/kategoria,6,Familijne.html', mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
	addDir('[COLOR green]Szukaj Filmu[/COLOR]','',mode='Szukaj')
	addLinkItem('[COLOR gold]-=Opcje=-[/COLOR]','','Opcje',IsPlayable=False)
	xbmcplugin.endOfDirectory(addon_handle)

elif mode[0] == '__page__M':
	url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : ex_link})
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == '__page__S':
	url = build_url({'mode': 'ListSeriale', 'foldername': '', 'ex_link' : '' ,'page':page})
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] =='cmd':
	items = eFILMY.get_top(ex_link)
	use_filmweb_f = False
	if 'filmy.php' in ex_link:
		use_filmweb_f = my_addon.getSetting('filmweb_f')
	for f in items:
		f=updateMetadata(f,use_filmweb_f,'f')
		addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
		xbmcplugin.setContent(addon_handle, 'videos')
	xbmcplugin.endOfDirectory(addon_handle)	
		
elif mode[0].startswith('Top_'):
	typF = mode[0].split('_')[-1]
	days=['tydzień', '2 tygodnie', 'miesiąc','3 miesiące']
	weeks = ['7','14','31','93']
	s = xbmcgui.Dialog().select('Top %s'%typF,days)
	d=weeks[s] if s>-1 else quit()#weeks[0]
	url = 'http://www.efilmy.tv/%s.php?cmd=popularne&dni=%s'%(typF,d)
	items = eFILMY.get_top(url)
	if typF == 'filmy':
		use_filmweb_f = my_addon.getSetting('filmweb_f')
		for f in items:
			f=updateMetadata(f,use_filmweb_f,'f')
			addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
		xbmcplugin.setContent(addon_handle, 'videos')
	else:
		for f in items:
			addDir(name=f.get('title'), ex_link=f.get('url'), mode='getEpisodes', iconImage=f.get('img'), infoLabels=f)
		xbmcplugin.setContent(addon_handle, 'tvshows')
	xbmcplugin.endOfDirectory(addon_handle)	
elif mode[0] == 'ListMovies':
	ListMovies(ex_link)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'ListSeriale':
	ListSeriale(page)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'getEpisodes':
	getEpisodes(ex_link)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'getLinks':
    getLinks(ex_link)
elif mode[0] == 'ListSearch':
	ListSearch(ex_link)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'GatunekRok':
	data = eFILMY.get_movie_cat_year(ex_link)
	tyt='kategorię' if 'cat' in ex_link else 'rok produkcji'	
	if data:
		label = [x[0].strip() for x in data]
		url = [x[1].strip() for x in data]
		sel = xbmcgui.Dialog().select('Wybierz %s:'%tyt,label)		
		if sel>-1:
			url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : url[sel]})
			xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
			xbmcplugin.endOfDirectory(addon_handle)
		else:
			quit()
elif mode[0] == 'Opcje':
    my_addon.openSettings()
    xbmc.executebuiltin('XBMC.Container.Refresh()')
elif mode[0] =='Szukaj':
	addDir('[COLOR green]Nowe Szukanie[/COLOR]','',mode='SzukajNowe')
	historia = getHistory()
	if not historia == ['']:
		for entry in historia:
			contextmenu = []
			contextmenu.append(('Usuń', 'XBMC.Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'ex_link' : entry})),)
			contextmenu.append(('Usuń całą historię', 'XBMC.Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
			addDir(name=entry, ex_link=entry.replace(' ','+'), mode='ListSearch', fanart=None, contextmenu=contextmenu)
	xbmcplugin.endOfDirectory(addon_handle)			
elif mode[0] =='SzukajNowe':
	d = xbmcgui.Dialog().input('Szukaj, Podaj tytuł filmu/serialu/bajki', type=xbmcgui.INPUT_ALPHANUM)
	if d:
		setHistory(d)
		ListSearch(d)
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] =='SzukajUsun':
	remCache(ex_link)
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'SzukajUsunAll':
	delHistory()
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
	xbmcplugin.endOfDirectory(addon_handle)
elif mode[0] == 'folder':
    pass
#else:
#    xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
