# -*- coding: utf-8 -*-

import sys,os,re
import six
from six.moves import urllib_parse

import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import resolveurl
import time
import ekinotvpl as ekinotv

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
args = urllib_parse.parse_qs(sys.argv[2][1:])
my_addon = xbmcaddon.Addon()


def add_item(name, url, mode,  image='DefaultFolder.png', folder=False, IsPlayable=False, fanart=None, infoLabels=False, kateg='',wersja='',page='1'):
    list_item = xbmcgui.ListItem(label=name)
    
    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')
    if not infoLabels:
        infoLabels={'title': name,'plot':name}
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'icon': image, 'fanart': fanart})
    if IsPlayable:
        isp = []
        isp.append(('Informacja', 'XBMC.Action(Info)'))
        list_item.addContextMenuItems(isp, replaceItems=False)

    ok=xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'foldername': name, 'ex_link' : url,'kat' : kateg,'wer' : wersja,'page' : page}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok


def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def getLinks(ex_link):
    (hostEK,out)=ekinotv.getVideos(ex_link)
    link=''
    premu = False
    select = xbmcgui.Dialog().select('Wybierz źródło', hostEK)
    if select>-1:
        if not '/ex/' in out[select]:
            content = ekinotv.getStreams(hostEK[select],out[select])
            if content:
                if 'verystream' in content:
                    link=ekinotv.getverystream(content)    
                elif 'vidspace.io' in content:
                    link=ekinotv.getvidspace(content)    
                elif 'onlystream.tv' in content or 'gounlimited' in content:
                    link=ekinotv.getOnlyStream(content)
                elif 'abcvideo' in content:
                    link=ekinotv.getOnlyStream(content)
                elif 'mixdrop.co' in content:
                    link=ekinotv.getMixdrop(content)
                elif 'fileone.t' in content:
                    link=ekinotv.getFileone(content)
                    
                    
                else:
                    try:
                    
                        link = resolveurl.resolve(content)
                    except Exception as e:
                        link=''
                        s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link będzie działał?','URL resolver ERROR: [%s]'%str(e))
                        return
        else:
            link = ekinotv.getStreams2(out[select])
            premu = True
        if link:
            play_item = xbmcgui.ListItem(path=link)
            if premu:
                play_item.setProperty('inputstream.adaptive.manifest_type', 'hls')
                play_item.setMimeType('application/x-mpegurl')
                play_item.setContentLookup(False)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
        else:
            s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link będzie działał?')
    else:
        quit()

def getFilmy(kateg,wersja,page,ex_link):

    itemLink,itemLink2= ekinotv.getCategory(kateg=kateg,wersja=wersja, page=page,url=ex_link)
    if int(page)>1:
    
    
        add_item('[COLOR gold]<< Poprzednia Strona %d <<[/COLOR]' %(int(page)-1), url=ex_link, mode='__page__',  image='DefaultFolder.png', folder=False, IsPlayable=False, fanart=None, infoLabels=False, kateg=kateg,wersja=wersja,page= int(page)-1)
    
    for p in itemLink:

        add_item(name=p['title'] , url=p['href'], mode='ChooseAndPlay',  image=p['img'], folder=False, IsPlayable=True, fanart=p['img'], infoLabels={'plot':p.get('plot'),'title':p.get('title'),'year':p.get('year'),'genre':p.get('genre'),'code':p.get('code'),'rating':p.get('rating')})
    

    add_item('[COLOR gold]>> Następna Strona %d >>[/COLOR]' %(int(page)+1), url=ex_link, mode='__page__',  image='DefaultFolder.png', folder=False, IsPlayable=False, fanart=None, infoLabels=False, kateg=kateg,wersja=wersja,page= int(page)+1)
    
    xbmcplugin.addSortMethod( handle=addon_handle, sortMethod=xbmcplugin.SORT_METHOD_GENRE )
    xbmcplugin.endOfDirectory(addon_handle)    
    
def getTestPlay(ex_link):
    if 'openload.co/stream' in ex_link:
        link=ex_link
    else:
        link = resolveurl.resolve(ex_link)
    if link:
        listitem = xbmcgui.ListItem(path=link)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem)
        
xbmcplugin.setContent(addon_handle, 'movies')
mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
kateg = args.get('kat',[''])[0]
wersja = args.get('wer',[''])[0]
page = args.get('page',[''])[0]
rys = args.get('iconImage',[''])[0]
def getLangType():
    langtype=['Napisy','Lektor','Dubbing','ENG','PL']
    versType=''
    for w in langtype:
        if my_addon.getSetting(w)=='true':
            if versType:
                versType += ','
            versType += w
    return versType
versType  = getLangType()
def login():

    logowanie =False
    password = my_addon.getSetting('passw')
    user = my_addon.getSetting('user')
    loguj = my_addon.getSetting('loguj')

    if loguj=='true' and password and user:
    
        logowanie,dane=ekinotv.zaloguj(user,password)
    if logowanie:

    
        add_item(name='Zalogowano jako %s'%dane[0] , url='', mode=' ',  image=dane[1], folder=False, IsPlayable=False, fanart='', infoLabels={})

    else:
        ekinotv.resetkukz()
        url = build_url({'mode': 'Opcje'})
        liz = xbmcgui.ListItem(label = 'Zaloguj')
        liz.setArt({'icon': 'DefaultScript.png'})
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=liz)

        
def router(paramstring):
    args = dict(urllib_parse.parse_qsl(paramstring))
    
    if args:
        mode = args.get('mode', None)    

        if mode == '__page__':
            url = build_url({'mode': 'filmy', 'foldername': '', 'ex_link' : ex_link,'kat' : kateg,'wer' : wersja,'page' : page})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
            xbmcplugin.endOfDirectory(addon_handle)    
        elif mode == 'testPlay':
            getTestPlay(ex_link)
        
        elif mode == 'ChooseAndPlay':
            getLinks(ex_link)
        
        elif mode == 'Opcje':
            my_addon.openSettings()
            xbmc.executebuiltin("Container.Refresh") 
        elif mode =='filmy':
            getFilmy(kateg,wersja,page,ex_link)
            xbmcplugin.endOfDirectory(addon_handle)    
            
        elif mode =='filmy_kategoria':
            data = ekinotv.getFilmCat()
            select = xbmcgui.Dialog().select('Wybierz:', data[0])
            if select>-1:
                getFilmy(data[1][select],wersja,page,ex_link)
                
        elif mode =='szukaj':
            dialog = xbmcgui.Dialog()
            d = dialog.input('Szukaj, Podaj tytuł filmu', type=xbmcgui.INPUT_ALPHANUM)
            if d:
            
                itemLink,itemLink2 = ekinotv.search(d.replace(' ','%20'))
                for p in itemLink:
        
                    add_item(name=p['title'] , url=p['href'], mode='ChooseAndPlay',  image=p['img'], folder=False, IsPlayable=True, fanart=p['img'], infoLabels={'plot':p.get('plot'),'title':p.get('title'),'year':p.get('year'),'genre':p.get('genre'),'code':p.get('code'),'rating':p.get('rating')})
        
                for p in itemLink2:
                
                    add_item(name=p['title'] , url=p['href'], mode='epizody',  image=p['img'], folder=True, IsPlayable=False, fanart=p['img'], infoLabels={'plot':p.get('plot'),'title':p.get('title'),'year':p.get('year'),'genre':p.get('genre'),'code':p.get('code'),'rating':p.get('rating')})
        
                xbmcplugin.endOfDirectory(addon_handle)
            else:
                quit()
        elif mode =='seriale_ktalog':
            itemLink = ekinotv.getSerKat()
            for p in itemLink:
        
                add_item(name=p['title'] , url=p['href'], mode='seriale', folder=True, IsPlayable=False)
        
            xbmcplugin.endOfDirectory(addon_handle)        
            
        elif mode  == '__pages__':
            url = build_url({'mode': 'seriale', 'foldername': '', 'ex_link' : ex_link,'kat' : kateg,'wer' : wersja,'page' : page})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
            xbmcplugin.endOfDirectory(addon_handle)    
            
            
        elif mode =='seriale':
        
            itemLink2,npage,ppage = ekinotv.getSeriale(ex_link,page)
            if ppage:
            
                add_item('[COLOR gold]<< Poprzednia Strona %d <<[/COLOR]' %(int(page)-1), url=ex_link, mode='__pages__',  image='DefaultFolder.png', folder=False, IsPlayable=False, fanart=None, infoLabels=False, kateg=kateg,wersja=wersja,page= int(page)-1)
        
            for p in itemLink2:
        
                add_item(name=p['title'] , url=p['href'], mode='epizody',  image=p['img'], folder=True, IsPlayable=False, fanart=p['img'], infoLabels={'plot':p.get('plot'),'title':p.get('title'),'year':p.get('year'),'genre':p.get('genre'),'code':p.get('code'),'rating':p.get('rating')})
            
                
                
            if npage:
            
                add_item('[COLOR gold]>> Następna Strona %d >>[/COLOR]' %(int(page)+1), url=ex_link, mode='__pages__',  image='DefaultFolder.png', folder=False, IsPlayable=False, fanart=None, infoLabels=False, kateg=kateg,wersja=wersja,page= int(page)+1)
        
            xbmcplugin.endOfDirectory(addon_handle)        
            
        elif mode =='epizody':
            itemLink = ekinotv.getEpisode(ex_link)

            for p in itemLink:
            
                add_item(name=p['title'] , url=p['href'], mode='ChooseAndPlay',  image=p['img'], folder=False, IsPlayable=True, fanart=p['img'], infoLabels={'plot':fname+'[CR]'+p.get('title'), 'title':p.get('title'),'season':p.get('season'),'episode':p.get('episode')})

            xbmcplugin.endOfDirectory(addon_handle)
    else:
        login()
        
        add_item('[COLOR blue]Filmy[/COLOR]', '', 'filmy',  image='DefaultFolder.png', folder=True, kateg='',wersja=versType)
        
        add_item('Filmy HD', '', 'filmy',  image='DefaultFolder.png', folder=True, kateg='35',wersja=versType)
        add_item('Filmy 3D', '', 'filmy',  image='DefaultFolder.png', folder=True, kateg='36',wersja=versType)
        add_item('Filmy Dla Dzieci HD', '', 'filmy',  image='DefaultFolder.png', folder=True, kateg='2,3,5,6',wersja=versType)
        add_item('Filmy [Kategoria]', '', 'filmy_kategoria',  image='DefaultFolder.png', folder=True)
        add_item('[COLOR blue]Seriale Katalog[/COLOR]', '', 'seriale_ktalog',  image='DefaultFolder.png', folder=True)
        add_item('[COLOR green]Szukaj[/COLOR]', '', 'szukaj',  image='DefaultFolder.png', folder=True)
        add_item('-=Opcje=-', '', 'Opcje',  image='DefaultScript.png', folder=False)
        
        xbmcplugin.endOfDirectory(addon_handle)    
    
    
    
if __name__ == '__main__':
    router(sys.argv[2][1:])
    