# -*- coding: utf-8 -*-
import six, xbmc
from six.moves import urllib_request, urllib_parse    
if six.PY3:    
    LOGNOTICE = xbmc.LOGINFO    
    from resources.lib.cmf3 import parseDOM    
else:    
    LOGNOTICE = xbmc.LOGNOTICE    
    from resources.lib.cmf2 import parseDOM  


#import urllib2,urllib,json
import re,os
#import urlparse
#from CommonFunctions import parseDOM

TIMEOUT = 10
UA      = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.97 Safari/537.36'
iteppp  = 25

ddd=[{'tytul':'Ekstraklasa',        'title': 'tabela', 'href':'https://gol24.pl/ekstraklasa/tabela/|ok'},                        {'tytul':'Ekstraklasa',        'title': 'terminarz','href':'https://gol24.pl/ekstraklasa/terminarz/'},    {'tytul':'Ekstraklasa',    'title': 'strzelcy','href':'https://gol24.pl/ekstraklasa/strzelcy/'},        
    {'tytul':'1 liga',            'title': 'tabela', 'href':'https://gol24.pl/1-liga/tabela/|ok'},                            {'tytul':'1 liga',            'title': 'terminarz','href':'https://gol24.pl/1-liga/terminarz/'},    {'tytul':'1 liga',    'title': 'strzelcy','href':'https://gol24.pl/1-liga/strzelcy/'},        
    {'tytul':'2 liga',            'title': 'tabela', 'href':'https://gol24.pl/2-liga/tabela/|ok'},                            {'tytul':'2 liga',            'title': 'terminarz','href':'https://gol24.pl/2-liga/terminarz/'},    {'tytul':'2 liga',    'title': 'strzelcy','href':'https://gol24.pl/2-liga/strzelcy/'},            
    {'tytul':'Puchar Polski',    'title': 'terminarz','href':'https://gol24.pl/puchar-polski/terminarz/'},        
    {'tytul':'Liga angielska',    'title': 'tabela', 'href':'https://gol24.pl/liga-angielska/tabela/|ok'},                    {'tytul':'Liga angielska',    'title': 'terminarz','href':'https://gol24.pl/liga-angielska/terminarz/'},    
    {'tytul':'Liga hiszpańska',    'title': 'tabela', 'href':'https://gol24.pl/liga-hiszpanska/tabela/|ok'},                    {'tytul':'Liga hiszpańska',    'title': 'terminarz','href':'https://gol24.pl/liga-hiszpanska/terminarz/'},    
    {'tytul':'Liga niemiecka',    'title': 'tabela', 'href':'https://gol24.pl/liga-niemiecka/tabela/|ok'},                    {'tytul':'Liga niemiecka',    'title': 'terminarz','href':'https://gol24.pl/liga-niemiecka/terminarz/'},    
    {'tytul':'Liga włoska',        'title': 'tabela', 'href':'https://gol24.pl/liga-wloska/tabela/|ok'},                        {'tytul':'Liga włoska',        'title': 'terminarz','href':'https://gol24.pl/liga-wloska/terminarz/'},        
    {'tytul':'Liga francuska',    'title': 'tabela', 'href':'https://gol24.pl/liga-francuska/tabela/|ok'},                            {'tytul':'Liga francuska',    'title': 'terminarz','href':'https://gol24.pl/liga-francuska/terminarz/'},                
    {'tytul':'Liga holenderska',    'title': 'tabela', 'href':'https://gol24.pl/liga-holenderska/tabela/|ok'},              {'tytul':'Liga holenderska',    'title': 'terminarz','href':'https://gol24.pl/liga-holenderska/terminarz/'},    
    {'tytul':'Liga portugalska',    'title': 'tabela', 'href':'https://gol24.pl/liga-portugalska/tabela/|ok'},              {'tytul':'Liga portugalska',    'title': 'terminarz','href':'https://gol24.pl/liga-portugalska/terminarz/'},    
    {'tytul':'Liga rosyjska',    'title': 'tabela', 'href':'https://gol24.pl/liga-rosyjska/tabela/|ok'},                        {'tytul':'Liga rosyjska',    'title': 'terminarz','href':'https://gol24.pl/liga-rosyjska/terminarz/'},        
    {'tytul':'Liga Mistrzów',    'title': 'tabela', 'href':'https://gol24.pl/liga-mistrzow/grupy/|no'},                            {'tytul':'Liga Mistrzów',    'title': 'terminarz','href':'https://gol24.pl/liga-mistrzow/terminarz/'},    {'tytul':'Liga Mistrzów',    'title': 'strzelcy','href':'https://gol24.pl/liga-mistrzow/strzelcy/'},    
    {'tytul':'Liga Europy',        'title': 'tabela', 'href':'https://gol24.pl/liga-europy/grupy/|no'},                        {'tytul':'Liga Europy',        'title': 'terminarz','href':'https://gol24.pl/liga-europy/terminarz/'},            
    {'tytul':'El. EURO 2020',    'title': 'tabela', 'href':'https://gol24.pl/euro-2020/grupy/|no'},                        {'tytul':'El. EURO 2020',    'title': 'terminarz','href':'https://gol24.pl/euro-2020/terminarz/'},]    

def getUrl(url,data=None,cookies=None):
    req = urllib_request.Request(url,data)
    req.add_header('User-Agent', UA)

    if cookies:
        req.add_header("Cookie", cookies)
    try:
        response = urllib_request.urlopen(req,timeout=TIMEOUT)
        link = response.read()
        response.close()
    except:
        link=''
    if six.PY3:
        link= link.decode(encoding='utf-8', errors='strict')
    return link
    
def getListTerminarz():
    out=[{    'title':'Ekstraklasa',            'url':'Ekstraklasa',    'img':'polska.png'},
        {    'title':'1 liga',                'url':'1 liga',            'img':'polska.png'},
        {    'title':'2 liga',                'url':'2 liga',            'img':'polska.png'},
        {    'title':'Puchar Polski',        'url':'Puchar Polski',    'img':'polska.png'},    
        {    'title':'Liga angielska',        'url':'Liga angielska',    'img':'england.png'},
        {    'title':'Liga hiszpańska',        'url':'Liga hiszpańska','img':'hiszpania.png'},        
        {    'title':'Liga niemiecka',        'url':'Liga niemiecka',    'img':'germany.png'},    
        {    'title':'Liga włoska',            'url':'Liga włoska',    'img':'italy.png'},        
        {    'title':'Liga francuska',        'url':'Liga francuska',    'img':'francja.png'},
        {    'title':'Liga holenderska',        'url':'Liga holenderska','img':'holandia.png'},            
        {    'title':'Liga portugalska',        'url':'Liga portugalska','img':'portugalia.png'},    
        {    'title':'Liga rosyjska',        'url':'Liga rosyjska',    'img':'rosja.png'},                
        {    'title':'Liga Mistrzów',        'url':'Liga Mistrzów',    'img':'liga.png'},    
        {    'title':'Liga Europy',            'url':'Liga Europy',    'img':'liga.png'},
        {    'title':'El. EURO 2020',        'url':'El. EURO 2020',    'img':'liga.png'},                    
        ]    
    return out
def getStrzelcy(url):
    out=[]
    html = getUrl(url)
    
    result=parseDOM(html,'table')[0].replace('<td><b>','</tbody><tbody><td><b>').replace('<td align=left><b>','<td align=left>')
    if 'liga-mitrz' in url:
        result=parseDOM(html,'table')[0].replace('<tbody>','</tbody><tbody>')
    
    links=re.findall('<tbody>(.+?)</tbody>',result,re.DOTALL)
    co=1
    for link in links:
        try:
            goli=re.findall('<td>(.+?)</td>',link,re.DOTALL)[0]
            goli=re.findall('(\d+)',goli)[0]
            strzelec=re.findall('=left>([^<]+)<',link,re.DOTALL)[0].strip()
            if 'liga-mitrz' in url:
                strzelec=re.findall('<b>([^<]+)</tr>',link,re.DOTALL)[0].strip()
            if co==1:
                kolor='orange'
            else:
                kolor='lightblue'
            tit='[COLOR %s][B]%s - %s[/COLOR][/B]'%(kolor,goli,strzelec)
            out.append( {'title':tit,'url':'','img':'','plot':tit})
            if co>4:
                break
            co+=1    
        except:
            pass
    return out

def getWybor(url):
    out=[]
    for i in ddd:
        if url in i.get('tytul'):
            out.append({'url' : i.get('href'),'title': url+' - '+i.get('title')})
    return out
    
def getTabelaKraj(url):
    out=[]
    html = getUrl(url).replace("\'",'"').replace('zielone','lightgreen').replace('fioletowe','violet').replace('czerwone','orangered').replace('pomaranczowe','orange').replace('niebieskie','blue')#
    result=parseDOM(html,'tbody')[0]
    links=re.findall('<tr(.+?)</tr>',result,re.DOTALL)
    for link in links:
        kolor=re.findall('class="(.+?)">',link)[0]
        miejsce=parseDOM(link,'td', attrs={'class': "lp"})[0]#<td class="lp">
        klubn=parseDOM(link,'td', attrs={'class': "nazwa"})[0]
        if klubn.startswith('<a'):
            klub=parseDOM(klubn,'a')[0]
        else:
            klub=re.findall('^(.*?)<a',klubn,re.DOTALL)[0].strip()
        punkty=parseDOM(link,'td', attrs={'class': "pkt"})[0]
        mecz=parseDOM(link,'td', attrs={'class': "liczbaMeczow"})[0]        
        title='[COLOR %s][B]%s. %s[/COLOR][/B]'%(kolor,miejsce,klub)
        plot='[COLOR lightgreen]%s. %s[/COLOR] %s pkt. %s m.'%(miejsce,klub,punkty,mecz)
        out.append( {'title':title,'url':'','img':'','code':'[COLOR gold][B]%s pkt. [/COLOR][COLOR blue](%s m.)[/COLOR][/B]'%(punkty,mecz),'plot':plot})
    return out
    
def getTabelaGrupy(url):
    out=[]
    dalej=[]
    html = getUrl(url).replace("\'",'"').replace('zielone','lightgreen').replace('fioletowe','violet').replace('czerwone','orangered').replace('pomaranczowe','orange').replace('niebieskie','blue')#
    result=parseDOM(html,'div', attrs={'class': "wyborLigi"})[0]    
    links=parseDOM(result,'a')
    co=0
    for link in links:
        tit=link    
        result2=parseDOM(html,'tbody')[co]    
        links2=re.findall('<tr(.+?)</tr>',result2,re.DOTALL)
        for link2 in links2:
            kolor=re.findall('class="(.+?)">',link2)[0]
            miejsce=parseDOM(link2,'td', attrs={'class': "lp"})[0]
            klubn=parseDOM(link2,'td', attrs={'class': "nazwa"})[0]
            if klubn.startswith('<a'):
                klub=parseDOM(klubn,'a')[0]
            else:
                klub=re.findall('^(.*?)<a',klubn,re.DOTALL)[0].strip()
            punkty=parseDOM(link2,'td', attrs={'class': "pkt"})[0]
            mecz=parseDOM(link2,'td', attrs={'class': "liczbaMeczow"})[0]
            title='[COLOR %s][B]%s. %s[/COLOR][/B]'%(kolor,miejsce,klub)
            plot='[COLOR lightgreen]%s. %s[/COLOR] %s pkt. %s m.'%(miejsce,klub,punkty,mecz)
            dalej.append({'title':title,'url':tit,'img':'','code':'[COLOR gold][B]%s pkt. [/COLOR][COLOR blue](%s m.)[/COLOR][/B]'%(punkty,mecz),'plot':plot})
        out.append( {'title':tit,'url':dalej,'img':''})
        co+=1    
    return out
    
def getTerminarz(url):
    out=[]
    dalej=[]
    html = getUrl(url)
    html=html.replace('<tr class="kolejkaData">','</thc><thc><tr class="kolejkaData">').replace('</tbody>','</thc></tbody>')
    result=parseDOM(html,'tbody')[0]
    if 'euro-2020' in url:
        result=parseDOM(html,'tbody ', attrs={'data-druzyny': ""})[0]    
    links=parseDOM(result,'thc')
    dt=''
    for link in links:
        startstop=re.findall('"start">(.+?)</i>.+"stop">(.+?)</i>',link,re.DOTALL)
        if startstop:
            dt='[COLOR white]    (%s - %s)[/COLOR]'%(startstop[0][0],startstop[0][1])
        tit=parseDOM(link,'i', attrs={'class': "rozgrywka"})[0]    
        
        if '>-:-<' not in link:
            tit='[COLOR yellowgreen][B]%s[/COLOR][/B]'%tit
        else:
            tit='[COLOR white][B]%s[/COLOR][/B]'%tit
        out.append( {'title':tit+dt,'url':url,'img':''})    
    return out
    
def getTerminarzCD(url,kat):
    out=[]
    html = getUrl(url)
    html=html.replace('<tr class="kolejkaData">','</thc><thc><tr class="kolejkaData">').replace('</tbody>','</tbs></thc></tbody>').replace('<tr class="dzien">','</tbs><tbs><tr class="dzien">')
    result=re.findall('>'+kat+'<(.+?)</thc>',html,re.DOTALL)[0]
    links=parseDOM(result,'tbs')
    for link in links:
        dat=parseDOM(link,'th')[0]
        links2=parseDOM(link,'tr', attrs={'class': "spotkanie"})#[0]         
        for link2 in links2:
            godzina=parseDOM(link2,'a')[0]
            druz1=re.findall('data-short-name="(.+?)"',link2,re.DOTALL)[0]
            druz2=re.findall('data-short-name="(.+?)"',link2,re.DOTALL)[1]
            wynik=parseDOM(link2,'td', attrs={'class': "wynik"})[0]
            wynik=re.findall('>([^<]+)</a>',wynik,re.DOTALL)[0]
            title='[COLOR blue]%s vs %s[/COLOR]'%(druz1,druz2)
            data='[COLOR khaki]%s - %s [CR][/COLOR]'%(dat,godzina)
            plot='%s[COLOR lightgreen]%s (%s) %s[/COLOR]'%(data,druz1,wynik,druz2)
            out.append( {'title':title,'url':'','img':'','code':'[COLOR gold][B](%s)[/COLOR][/B]'%(wynik),'plot':plot})    
    return out
