import json
import uuid
import sys
import calendar
from datetime import datetime, timedelta
import time

import iso8601
import requests
from urllib.parse import quote, unquote

import xbmc
import xbmcgui
import xbmcvfs
import xbmcaddon
import xbmcplugin

from resources.lib.brotlipython import brotlidec

def resp_text(resp):
    """Return decoded response text."""
    if resp and resp.headers.get('content-encoding') == 'br':
        out = []
        # terrible implementation but it's pure Python
        return brotlidec(resp.content, out).decode('utf-8')
    return resp.text

class Helper:
    def __init__(self, base_url=None, handle=None):
        self.base_url = base_url
        self.handle = handle
        self.addon = xbmcaddon.Addon()
        self.addon_name = xbmcaddon.Addon().getAddonInfo('id')
        self.addon_version = xbmcaddon.Addon().getAddonInfo('version')
        self.datapath = self.translate_path(self.get_path('profile'))
        self.proxyport = self.get_setting('proxyport')

        # API
        try:
            self.napisy = self.load_file(self.datapath+'napisy', isJSON=False)
        except:
            self.napisy = False

        self.base_api_url = 'https://cxm-api.fifa.com/fifaplusweb/api/{}'
        
        self.UA ='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:93.0) Gecko/20100101 Firefox/93.0'

        self.headers = {
            'user-agent': self.UA,
            'accept': 'application/json, text/plain, */*',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'origin': 'https://www.fifa.com',}

        self.headersCujoo = {
            'user-agent': self.UA,
            'accept': 'application/json',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'authorization': 'Bearer 0FIQ3SKOSF09NH33IQO7IRARV5BSPT2N',
            'content-type': 'application/json',
            'origin': 'https://www.fifa.com',}
        try:
            self.kukis = self.load_file(self.datapath+'kukis', isJSON=True)
        except:
            self.kukis = {}
            
        self._sess = None
        self.kuk = {}

    @property
    def sess(self):
        if self._sess is None:
            self._sess = requests.Session()
            if self.kukis:
                self._sess.cookies.update(self.kukis)
                
                
                self._sess.cookies.update(self.kuk)

        return self._sess    
        
    def get_path(self ,data):    
        return self.addon.getAddonInfo(data)
        
    def translate_path(self ,data):
        try:
            return xbmcvfs.translatePath(data)
        except:
            return xbmc.translatePath(data).decode('utf-8')
            
    def save_file(self, file, data, isJSON=False):
        with io.open(file, 'w', encoding="utf-8") as f:
            if isJSON == True:
                str_ = json.dumps(data,indent=4, sort_keys=True,separators=(',', ': '), ensure_ascii=False)
                f.write(to_unicode(str_))
            else:
                f.write(data)

    def load_file(self, file, isJSON=False):

        if not os.path.isfile(file):
            return None
    
        with io.open(file, 'r', encoding='utf-8') as f:
            if isJSON == True:
                return json.load(f, object_pairs_hook=collections.OrderedDict)
            else:
                return f.read() 
                
    def get_setting(self, string):
        return xbmcaddon.Addon(self.addon_name).getSettingString(string)

    def set_setting(self, setting, string):
        return xbmcaddon.Addon(self.addon_name).setSettingString(id=setting, value=string)

    def open_settings(self):
        xbmcaddon.Addon(self.addon_name).openSettings()

        
    def add_item(self, title, url, playable=False, info=None, art=None, content=None, folder=True):

        list_item = xbmcgui.ListItem(label=title)
        if playable:
            list_item.setProperty('IsPlayable', 'true')
            folder = False
        if art:
            list_item.setArt(art)
        else:
            art = {
                'icon': self.addon.getAddonInfo('icon'),
                'fanart': self.addon.getAddonInfo('fanart')
            }
            list_item.setArt(art)
        if info:
            list_item.setInfo('Video', info)
        if content:
            xbmcplugin.setContent(self.handle, content)

        xbmcplugin.addDirectoryItem(self.handle, url, list_item, isFolder=folder)

    def eod(self, cache=True):
        xbmcplugin.endOfDirectory(self.handle, cacheToDisc=cache)

    def notification(self, heading, message):
        xbmcgui.Dialog().notification(heading, message, time=7000)

    def dialog_select(self, heading, label):
        return xbmcgui.Dialog().select(heading,label)
        
        
    def request_sess(self, url, method='get', data='', headers={}, cookies={}, result=True, json=False, allow=True , multipart = False):
        if method == 'get':
            resp = self.sess.get(url, headers=headers, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
        elif method == 'post':
            if multipart:
                resp = self.sess.post(url, headers=headers, files=data, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
            else:
                resp = self.sess.post(url, headers=headers, data=data, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
        elif method == 'delete':
            resp = self.sess.delete(url, headers=headers, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
        if result:
            return resp.json() if json else resp_text(resp)
        else:
            return resp
            

            
            
    def PlayVid (self, mpdurl, lic_url='', PROTOCOL='', DRM='', certificate = '', flags=False, subs = False, hdrs = False):
        from inputstreamhelper import Helper
        play_item = xbmcgui.ListItem(path=mpdurl)
        if subs:
            play_item.setSubtitles(subs)
        if PROTOCOL:
            if 'mp4' in PROTOCOL:
    
                play_item.setMimeType('video/mp4')
                play_item.setProperty('mimetype', 'video/mp4')
                play_item.setProperty('inputstream', 'inputstream.ffmpegdirect')
                play_item.setProperty('inputstream.ffmpegdirect.mime_type', 'video/mp4')
                play_item.setContentLookup(False)
            else:
                is_helper = Helper(PROTOCOL, drm=DRM)
                if is_helper.check_inputstream():
                    if sys.version_info >= (3,0,0):
                        play_item.setProperty('inputstream', is_helper.inputstream_addon)
                    else:
                        play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
                    if 'mpd' in PROTOCOL:
                        play_item.setMimeType('application/xml+dash')
                    else:
                        play_item.setMimeType('application/vnd.apple.mpegurl')
                    play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)
                    #play_item.setProperty('inputstream.adaptive.stream_headers', str(hdrs))
                    if DRM and lic_url:
                        play_item.setProperty('inputstream.adaptive.license_type', DRM)
                        play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
                        play_item.setProperty('inputstream.adaptive.license_key', lic_url)
                        if certificate:
                            play_item.setProperty('inputstream.adaptive.server_certificate', certificate)
                    if flags:
                        play_item.setProperty('inputstream.adaptive.license_flags', "persistent_storage")
                    play_item.setContentLookup(False)
        xbmcplugin.setResolvedUrl(self.handle, True, listitem=play_item)    
            
            
    def PlayVidx (self, mpdurl, lic_url='', PROTOCOL='', DRM='', subs = None):
        from inputstreamhelper import Helper
        play_item = xbmcgui.ListItem(path=mpdurl)
        if subs:
            play_item.setSubtitles(subs)
        if PROTOCOL:

            is_helper = Helper(PROTOCOL, drm=DRM)
            if is_helper.check_inputstream():
                if sys.version_info >= (3,0,0):
                    play_item.setProperty('inputstream', is_helper.inputstream_addon)
                else:
                    play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
                if 'mpd' in PROTOCOL:
                    play_item.setMimeType('application/xml+dash')
                else:
                    play_item.setMimeType('application/vnd.apple.mpegurl')
                play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)
                if DRM and lic_url:
                    play_item.setProperty('inputstream.adaptive.license_type', DRM)
                    play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
                    play_item.setProperty('inputstream.adaptive.license_key', lic_url)
                play_item.setProperty('inputstream.adaptive.license_flags', "persistent_storage")
                play_item.setContentLookup(False)
        xbmcplugin.setResolvedUrl(self.handle, True, listitem=play_item)
    

    def getCorrectTime(self, czas):
        try:
            current_date_temp = datetime.strptime(czas, "%Y-%m-%dT%H:%M:%SZ") #'2022-04-16T12:30:00Z'
        except TypeError:
            current_date_temp = datetime(*(time.strptime(czas, "%Y-%m-%dT%H:%M:%SZ")[0:6]))
        datastart = (current_date_temp + timedelta(hours=+2)).strftime('%H:%M')
        return datastart
    def timeNow(self):
        now=datetime.utcnow()+timedelta(hours=2)
    
        czas=now.strftime('%Y-%m-%d')
    
        try:
            format_date=datetime.strptime(czas, '%Y-%m-%d')
        except TypeError:
            format_date=datetime(*(time.strptime(czas, '%Y-%m-%d')[0:6]))    
        return format_date
    def CreateDays(self):
        dzis=self.timeNow()
        timestampdzis = calendar.timegm(dzis.timetuple())
        tydzien = int(timestampdzis)- 2627424
        out=[]
        for i in range(int(timestampdzis),tydzien,-86400):
            x = datetime.utcfromtimestamp(i)

            dzien = (x.strftime('%d.%m'))
            a1 = x.strftime("%Y.%d.%m")

            try:
                current_date_temp = datetime.strptime(a1, "%Y.%d.%m")
            except TypeError:
                current_date_temp = datetime(*(time.strptime(a1, "%Y.%d.%m")[0:6]))
            datastart = (current_date_temp + timedelta(days=-1)).strftime('%Y-%m-%dT')

            dataend = (current_date_temp).strftime('%Y-%m-%dT')
            dod ='&start_after_time='+datastart+'22%3A00%3A00.000Z&start_before_time='+dataend+'22%3A00%3A00.000Z'

            dnitygodnia = ("poniedziałek","wtorek","środa","czwartek","piątek","sobota","niedziela")
            
            day = x.weekday()
    
            dzientyg = dnitygodnia[day]
    
            out.append({'dzien':dzientyg+ ' '+dzien,'dodane':str(dod)}) 
            
        return out         

    def string_to_date(self, string, string_format):
        s_tuple = tuple([int(x) for x in string[:10].split('-')]) + tuple([int(x) for x in string[11:].split(':')])
        s_to_datetime = datetime(*s_tuple).strftime(string_format)
        return s_to_datetime

    def parse_datetime(self, iso8601_string, localize=False):
        """Parse ISO8601 string to datetime object."""
        datetime_obj = iso8601.parse_date(iso8601_string)
        if localize:
            return self.utc_to_local(datetime_obj)
        else:
            return datetime_obj

    @staticmethod
    def utc_to_local(utc_dt):
        # get integer timestamp to avoid precision lost
        timestamp = calendar.timegm(utc_dt.timetuple())
        local_dt = datetime.fromtimestamp(timestamp)
        assert utc_dt.resolution >= timedelta(microseconds=1)
        return local_dt.replace(microsecond=utc_dt.microsecond)
