# coding: UTF-8
import ast
import sys, re

import requests
import routing
import xbmcvfs

from .helper import Helper
from datetime import datetime, timedelta

base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()

try:
    # Python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote
except:
    # Python 2.7
    from urllib import quote_plus, unquote_plus, quote, unquote

@plugin.route('/')
def root():
    topmenu = helper.base_api_url.format('header?locale=en')
    jsdata = helper.request_sess(topmenu, 'get', headers=helper.headers, json=True)
    topMenuLinks = jsdata.get("burgerMenuLinks", None)

    for tt in topMenuLinks:
        title = tt.get("title", None) 
        if title == 'News' or  'Match Centre' in title or  title == 'FIFA.com':
            continue
            
        url = tt.get("url", None)
        entryType = tt.get("entryType", None)

        helper.add_item(title, plugin.url_for(listsubmenu, url_entryType=quote_plus(url+'|'+entryType)))
    helper.eod()


@plugin.route('/listsubmenu/<url_entryType>')

def listsubmenu(url_entryType):
    url_entryType=unquote_plus(url_entryType)
    dod,entryType = url_entryType.split('|')
    if 'page' == entryType:
        x= 'pages'
        
    page = helper.base_api_url.format(x+dod) 
    jsdata = helper.request_sess(page, 'get', headers=helper.headers, json=True)

    sections = jsdata.get('sections', None)

    for sect in sections:
        try:
            title = sect.get("properties", None).get('heading',None)
        except:
            title= ''
        if title:
            entryEndpoint = sect.get('entryEndpoint',None)
            dod = plugin.url_for(listcontent,  url = quote_plus(entryEndpoint))
            if 'live now' == title.lower() or 'calendar' == title.lower():
                dod = plugin.url_for(listcujoo, url = quote_plus(entryEndpoint))
            elif 'match result' in title.lower():
                continue
            helper.add_item(title, dod )
    helper.eod()
    
@plugin.route('/listcujoo/<url>')
def listcujoo(url):

    url = unquote_plus(url)
    mainurl = url
    if 'maOttCalenda' in url:
        ListCalendar()
    else:
    
        if not 'mcls-api.mycujoo' in url:
    
            from datetime import datetime, timedelta
            now = datetime.now()+timedelta(hours=-4)
            czas=now.strftime('%Y-%m-%dT%H:%M:%S.000Z')
    
            url = 'https://mcls-api.mycujoo.tv/bff/events/v1beta1?order_by=ORDER_START_TIME_ASC&page_size=45&start_after_time='+czas+'&status=EVENT_STATUS_STARTED'

        jsdata = helper.request_sess(url, 'get', headers=helper.headersCujoo, json=True)

        events = jsdata.get('events', None)
        for event in events:

            id = event.get('id', None)
            title = event.get('title', None)
            description = event.get('description', None)
            thumbnail_url = event.get('thumbnail_url', None)
            competition_name = event.get('metadata', None).get('competition_name', None)

            if not thumbnail_url:

                thumbnail_url = helper.addon.getAddonInfo('icon')

            if event.get('status' , None) == 'EVENT_STATUS_FINISHED':
                metadata = event.get('metadata', None)

                try:
                    gosp = metadata.get('home_team', None).get('score', None)
                    gosc = metadata.get('away_team', None).get('score', None)

                    title = title.replace(' vs ', ' [COLOR gold][B]('+str(gosp)+':'+str(gosc)+')[/B][/COLOR] ')
                    description+='[CR][COLOR gold][B]('+str(gosp)+':'+str(gosc)+')[/B][/COLOR] '
                except:
                    title=title
            elif event.get('status' , None) == 'EVENT_STATUS_SCHEDULED':
                start_time = event.get('start_time', None)

                cortime = helper.getCorrectTime(start_time)
                title = '[COLOR yellow][B]'+cortime+'[/B][/COLOR] '+title
                description+='[CR][COLOR yellow][B]'+cortime+'[/B][/COLOR] '

            elif event.get('status' , None) == 'EVENT_STATUS_STARTED':
                
                title = '[COLOR lightgreen][B]LIVE [/B][/COLOR] '+title
            mod = plugin.url_for(playcujoo, id=id)
            if competition_name:
                title+='  [COLOR khaki]('+competition_name+')[/COLOR]'
            ispla = True
            info = {
                'title': title,
                'plot': description
            }
        
            art = {
                'icon': thumbnail_url,
                'fanart': helper.addon.getAddonInfo('fanart'),
            }
    
            helper.add_item(title, mod, playable=ispla, info=info, art=art)    
    helper.eod()


    
    
def ListCalendar():    
    
    days = helper.CreateDays()
    for d in days:
        url = 'https://mcls-api.mycujoo.tv/bff/events/v1beta1?order_by=ORDER_START_TIME_ASC&page_size=65'+d.get('dodane', None)
        mod = plugin.url_for(listcujoo,  url = quote_plus(url))
        ispla = False
        info = {
            'title': d.get('dzien', None),

        }
        
        art = {}
        
        helper.add_item(d.get('dzien', None), mod, playable=ispla, info=info, art=art)    

    return    
    
    
    
@plugin.route('/playcujoo/<id>')
def playcujoo(id):

    stream=''
    url ='https://mls-api.mycujoo.tv/bff/events/v1beta1/'+id
    jsdata = helper.request_sess(url, 'get', headers=helper.headersCujoo, json=True)
    error = jsdata.get('streams', None)[0].get('error', None)
    if error:
        message = error.get("message", None)
        if 'geoblocked' in message:
            streams = jsdata.get('metadata', None).get("mcls_internal_data", None)
            for st in streams:
                if st.get('name', None) =='video_url':
                    stream = st.get('value', None)
                    break
    else:
        stream = jsdata.get('streams', None)[0].get('full_url', None)
        if not stream:
            streams = jsdata.get('metadata', None).get("mcls_internal_data", None)
            for st in streams:
                if st.get('name', None) =='video_url':
                    stream = st.get('value', None)
                    break
    if stream:                
        helper.PlayVid(stream, PROTOCOL = 'hls')
    
@plugin.route('/listcontent/<url>')
def listcontent(url):
    dod = unquote_plus(url)
    dod = dod[1:] if dod.startswith('/') else dod
    url = helper.base_api_url.format(dod)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    items = jsdata.get('items', None)
    mod = None
    ispla = False

    for item in items:
        
        title = item.get('title', None)
        imag = item.get('image', None).get('src', None)
        entryId = item.get('entryId', None)
        programmeType = item.get('programmeType', None)
        
        if programmeType == 3 or programmeType == 4:
            entryId = entryId+'|videoDetails'
            ispla = True
            mod = plugin.url_for(playvid, eidetyp=entryId)
        elif programmeType == 0 or programmeType == 2:
            entryId = 'pages'+item.get('readMorePageUrl', None)#[1:]
            ispla = False
            mod = plugin.url_for(listseries, entryId=quote_plus(entryId))

        info = {
            'title': title,
        }
    
        art = {
            'icon': imag,
            'fanart': helper.addon.getAddonInfo('fanart'),
        }

        helper.add_item(title, mod, playable=ispla, info=info, art=art)    
    if mod:
        helper.eod()

@plugin.route('/listseries/<entryId>')
def listseries(entryId):
    entryId = unquote_plus(entryId)
    url = helper.base_api_url.format(entryId)
    
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    cdn = jsdata.get('sections',None)[0].get("entryEndpoint", None)[1:]
    url = helper.base_api_url.format(cdn)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    seasons = jsdata.get('seasons', None)
    backgroundImage = jsdata.get('backgroundImage', None)
    im =''
    if backgroundImage:
        im = backgroundImage.get('src', None)
    out=[]
    for seas in seasons:
        sesnumber = seas.get('seasonNumber', None)
        episodes = seas.get('episodes', None)
        for epis in episodes:
            episnumber =epis.get('episodeNumber', None)
            entryId = epis.get('entryId', None)
            ftitle = epis.get('title', None)
            plot = epis.get('description', None)
            entryId = entryId+'|videoDetails'
            imag = epis.get('thumbnailImage', None).get('src', None)
    
            jaki = ' - S%02dE%02d'%(int(sesnumber),int(episnumber))
            
            tyt = re.sub(' E\d+',jaki,ftitle)
            out.append({'title':tyt,'href':entryId,'img':imag,'plot':plot, 'season' : int(sesnumber),'episode' : int(episnumber) })
    
    
    sezony =  splitToSeasons(out)
    
    for i in sorted(sezony.keys()):
    
        mod = plugin.url_for(listEpisodes2, exlink=quote_plus(str(sezony[i])))
        ispla = False
        info = {
            'title': i,
        }
    
        art = {
            'icon': im,
            'fanart': helper.addon.getAddonInfo('fanart'),
        }

        helper.add_item(i, mod, playable=ispla, info=info, art=art)    

    helper.eod()

@plugin.route('/listEpisodes2/<exlink>')
def listEpisodes2(exlink):

    episodes = ast.literal_eval(unquote_plus(exlink))

    itemz=episodes
    items = len(episodes)
    
    for f in itemz:

        ispla = True
        mod = plugin.url_for(playvid, eidetyp=f.get('href'))
        info = {
            'title': f.get('title'),
            'plot': f.get('plot'),
            'season' : f.get('season'),
            'episode' : f.get('episode')
        }
    
        art = {
            'icon': f.get('img'),
            'fanart': helper.addon.getAddonInfo('fanart'),
        }

        helper.add_item(f.get('title'), mod, playable=ispla, info=info, art=art)    

    helper.eod()

def splitToSeasons(input):
    out={}
    seasons = [x.get('season') for x in input]
    for s in set(seasons):
        out['Season %02d'%s]=[input[i] for i, j in enumerate(seasons) if j == s]
    return out

def createSubtitle(url):
    m3u8 = helper.request_sess(url, 'get', headers=helper.headers, json=False)
    xx=re.findall('"subs",NAME="([^"]+)".*?URI="([^"]+)",LANGUAGE="([^"]+)"',m3u8,re.DOTALL)
    subsout = []
    for nm,uri,nm2 in xx:
        label =nm+' ['+nm2+']'
        subsout.append({'label':label,'subt':nm})
    if subsout:
        
        labels = [x.get('label') for x in subsout]
        sel = helper.dialog_select('Select subtitle:', labels)
        if sel > -1:
            subt=subsout[sel].get('subt')

            helper.set_setting('napis',subt)

    return 
@plugin.route('/playvid/<eidetyp>')
def playvid(eidetyp):

    if '|' in eidetyp:
        entryId,entryType = eidetyp.split('|')
    else:
        entryId = eidetyp

    dod = 'sections/{}/{}'.format(entryType,entryId)

    url = helper.base_api_url.format(dod)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    
    if entryType == 'videoDetails':
        vidId = jsdata.get("videoEntryId", None)
    else:
        vidId = jsdata.get('video',None).get("videoEntryId", None)
    
    dod = 'video/GetVideoPlayerData/'+vidId+'?includeIdents=true&locale=en'
    dod = 'video/GetVideoPlayerData/'+vidId+'?includeIdents=true&locale=en'
    dod = 'videoPlayerData/'+vidId+'?includeIdents=true&locale=en'
    url = helper.base_api_url.format(dod)

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    contentId = jsdata.get("contentId", None)
    queryStr = jsdata.get("queryStr", None)
    signature = jsdata.get("signature", None)
    if not contentId:
        jsdata = jsdata.get('preplayParameters', None)
        contentId = jsdata.get("contentId", None)
        queryStr = jsdata.get("queryStr", None)
        signature = jsdata.get("signature", None)

    url = 'https://content.uplynk.com/preplay/'+contentId+'/multiple.json?'+queryStr+'&sig='+signature
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)

    playURL = jsdata.get('playURL', None)
    mpdurl = playURL
    napisy = True

    mpdurl +='|User-Agent='    + quote('Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0')

    stream ='http://127.0.0.1:%s/dd='%(str(helper.proxyport))+mpdurl
    helper.PlayVid(stream, lic_url='', PROTOCOL='hls', DRM='', certificate = '')


class Fifa(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


