# -*- coding: utf-8 -*-
import sys,re,os,json

import xbmc,xbmcgui,xbmcaddon, xbmcvfs
import xbmcplugin
import resolveurl as urlresolver

import base64

import requests

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
  
if sys.version_info >= (3,0,0):
# for Python 3
    from resources.lib.cmf3 import parseDOM
    import http.cookiejar as cookielib
    from urllib.parse import unquote,parse_qs, quote, urlencode, quote_plus, parse_qsl
    import urllib.parse as urlparse
    xrange = range
    unicode = str
else:
    # for Python 2
    from resources.lib.cmf2 import parseDOM

    import cookielib
    from urllib import unquote, quote, urlencode, quote_plus
    import urlparse
    from urlparse import parse_qs, parse_qsl
  
  
  
  
cache = StorageServer.StorageServer("filmancc")


base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonName       = my_addon.getAddonInfo('name')
addonId         = my_addon.getAddonInfo('id')
PATH            = my_addon.getAddonInfo('path')
try:
    DATAPATH        = xbmcvfs.translatePath(my_addon.getAddonInfo('profile'))
except:
    DATAPATH        = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'
FANART          = RESOURCES+'fanart.png'
sys.path.append( os.path.join( RESOURCES, "lib" ) )

UA = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0'
fname = args.get('foldername',[''])[0]

mainurl ='https://filman.cc/'
mybtn_user=''
TIMEOUT      = 10

BASEURL='https://filman.cc/'

COOKIEFILE = os.path.join(DATAPATH,'filmancookie')

sess=requests.Session()
sess.cookies = cookielib.LWPCookieJar(COOKIEFILE)

sess2=requests.Session()


def addLinkItem(name, url, mode, page=1, iconimage='DefaultFolder.png', infoLabels=False, contextO=[''], IsPlayable=True,fanart=FANART, itemcount=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page, 'token': mybtn_user})
    liz = xbmcgui.ListItem(name)
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[iconimage for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape']
    liz.setArt(art)
    
    if not infoLabels:
        infoLabels={"title": name,'plot':name}
    
    liz.setInfo(type="video", infoLabels=infoLabels)
    
    if IsPlayable:
        liz.setProperty('IsPlayable', 'true')
    
    isp = []
    content = quote_plus(json.dumps(infoLabels))
    
    if 'DOWNLOAD' in contextO:
        isp.append(('[B]Download[/B]', 'RunPlugin(plugin://%s?mode=DOWNLOAD&ex_link=%s)'%(addonId,content)))
    
    liz.addContextMenuItems(isp, replaceItems=False)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    xbmcplugin.setContent(addon_handle, 'videos')    
    return ok

def addDir(name,ex_link=None, page=1, mode='folder',iconImage='DefaultFolder.png', infoLabels=None, fanart=FANART,contextmenu=None):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page,'iconImage':iconImage, 'token': mybtn_user})
    li = xbmcgui.ListItem(name)
    if not infoLabels:
        infoLabels={"title": name,'plot':name}
    if infoLabels:
        li.setInfo(type="video", infoLabels=infoLabels)
    
    art_keys=['thumb','poster','banner','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[iconImage for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape']
    li.setArt(art)
    
    if contextmenu:
        isp=contextmenu
        li.addContextMenuItems(isp, replaceItems=True)
    
    xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True)
    xbmcplugin.setContent(addon_handle, 'videos')    

def encoded_dict(in_dict):
    out_dict = {}
    try:
        # Python 2
        iter_dict = in_dict.iteritems()
    except AttributeError:
        # Python 3
        iter_dict = in_dict.items()
    out_dict = {}
    for k, v in iter_dict:
   # for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict

def build_url(query):
    return base_url + '?' + urlencode(encoded_dict(query))

def listTv(ex_link):
    mlinks= getTvs(ex_link)
    items = len(mlinks)
    for f in mlinks:
        addDir(name=f.get('title'), ex_link=f.get('href'), mode='getTvLinks', iconImage=f.get('img'), infoLabels={'plot':f.get('title')})
    
def listMovies(ex_link,page):
    page = int(page) if page else 1
    group = ''
    
    if '|'in ex_link:
        ex_link,group = ex_link.split('|')
    
    mlinks,mparams = getMovies(ex_link,page,group)
    if mparams[0]:
        addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__M', page=mparams[0], IsPlayable=False)
    
    items = len(mlinks)
    
    for f in mlinks:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, contextO=['DOWNLOAD'], IsPlayable=True, itemcount=items)
    
    if mparams[1]:
        addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__M', page=mparams[1], IsPlayable=False)
#    xbmcplugin.setContent(addon_handle, 'videos')

def listSeries(ex_link,page):
    page = int(page) if page else 1
    group=''

    if '|'in ex_link:
        ex_link,group = ex_link.split('|')
    
    if group:
        mlinks,mparams = getSeries(ex_link,int(page),group)
    else:
        mlinks,mparams = getSeries(ex_link)

    my_mode = 'getEpisodes'

    if 'true' in my_addon.getSetting('groupEpisodes'):
        my_mode = 'getSeasons'

    if mparams[0]:
        addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__S', page=mparams[0], IsPlayable=False)

    items=len(mlinks)

    for f in mlinks:
        addDir(name=f.get('title'), ex_link=f.get('href'), mode=my_mode, iconImage=f.get('img'))#, infoLabels=f)

    if mparams[1]:
        addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__S', page=mparams[1], IsPlayable=False)

def getSeasons(ex_link):
    episodes = scanEpisodes(ex_link)
    if episodes:
        imag=episodes[0].get('img')#
        seasons = splitToSeasons(episodes)
    
        for i in sorted(seasons.keys()):
            addDir(name=i, ex_link=quote(str(seasons[i])), iconImage=imag, mode='getEpisodes2')
    
    #    xbmcplugin.setContent(addon_handle, 'season')
        xbmcplugin.endOfDirectory(addon_handle,True)        
            
    else:
        sel = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Brak odcinków','')

def getEpisodes(ex_link):
    episodes = scanEpisodes(ex_link)
    if episodes:
        for f in episodes:
            addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, contextO=['DOWNLOAD'], IsPlayable=True)

    #    xbmcplugin.setContent(addon_handle, 'episodes')
        xbmcplugin.endOfDirectory(addon_handle,True)
    else:
        sel = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Brak odcinków','')
def getEpisodes2(ex_link):
    episodes = eval(unquote(ex_link))

    for f in episodes:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, contextO=['DOWNLOAD'], IsPlayable=True, fanart=f.get('img'))
#    xbmcplugin.setContent(addon_handle, 'episodes')
    xbmcplugin.endOfDirectory(addon_handle,True)

def listFS(ex_link):
    mlinks,match = search(ex_link)
    for f in mlinks:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, contextO=['DOWNLOAD'], IsPlayable=True, itemcount=len(mlinks))
    
    for f in match:
        addDir(name=f.get('title'), ex_link=f.get('href'), mode='getEpisodes', iconImage=f.get('img'), infoLabels=f)
    
def getTvLinks(ex_link,rys):

    mlinks = getTvLink(ex_link,rys)
    
    items = len(mlinks)

    for f in mlinks:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='playTv', iconimage=rys, infoLabels={'plot':f.get('title')}, contextO=['DOWNLOAD'], IsPlayable=True, itemcount=items)
            
def PlayTv(ex_link):
    stream_url=ex_link
    if stream_url:
        xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
    else:
        xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))        
                        
def getLinks(ex_link, get_download = False, name = '', image = ''):
    streams = getVideos(ex_link)

    stream_url = ''
    if len(streams)>0:
    
        t = [ x.get('title') for x in streams]
        u = [ x.get('url') for x in streams]
        h = [ x.get('host') for x in streams]
        al = "Z jakiego źródla pobieramy?" if get_download else "  Wersja  |   Host   |  Jakość  "
        
        select = xbmcgui.Dialog().select(al, t)
        
        if select > -1:
            link = u[select];
            link = parseVideoLink(link,[select])
        
            if not stream_url:
                if '.mp4' in link:
                    stream_url=link+'|User-Agent='+quote(UA)
                else:
                    try:
                        stream_url = urlresolver.resolve(link)
                        
                    except Exception as e:
                        stream_url=''
                        sel = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link będzie działał?','Resolveurl ERROR: [%s]'%str(e))
        else:
            pass    
        if stream_url:
            if get_download:
                downloadPath = my_addon.getSetting('download.path')
                if downloadPath and downloadPath != '':
                    import resources.lib.downloader as dw
                    try:
                        dw.download(name, image, stream_url, downloadPath)
                    except:
                        xbmc.executebuiltin( "XBMC.Notification(%s,%s,%i,%s)" % ( '[COLOR red] Bląd pobierania [/COLOR]', name, 5000, image))
                else:
                    xbmcgui.Dialog().ok("FilmanCC", "Ustaw docelowy folder!")
                    xbmc.executebuiltin("Addon.OpenSettings(%s)"%addonId)
        
            xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
        else:
            xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
    else:
        xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
def getHistory():
    return cache.get('history').split(';')

def setHistory(entry):
    history = getHistory()
    if history == ['']:
        history = []
    history.insert(0, entry)
    cache.set('history',';'.join(history[:50]))

def remCache(entry):
    history = getHistory()
    if history:
        cache.set('history',';'.join(history[:50]))
    else:
        delHistory()

def delHistory():
    cache.delete('history')


def login():
    dataPath=os.path.dirname(COOKIEFILE)
    
    if not os.path.exists(dataPath):
        os.makedirs(dataPath)
    u = my_addon.getSetting('user')
    p = my_addon.getSetting('pass')
    l = my_addon.getSetting('login')
    logged=False
    if u and p and l == 'true':
        logged,dane=  getLogin(u,p)
        if logged:
            addLinkItem('[B]Zalogowany jako %s %s[/B]'%(u,dane),'',mode=' ',iconimage='',IsPlayable=False,infoLabels={'plot':dane})
        else:
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd logowania[/B][/COLOR]', '', xbmcgui.NOTIFICATION_INFO, 5000)
            sess.cookies.clear()
            sess.cookies.save(COOKIEFILE, ignore_discard = True)    
            addLinkItem('[B]Zaloguj[/B]','',mode='Opcje',iconimage='',IsPlayable=False,infoLabels={'plot':'[B]Zaloguj[/B]'})
    else:
        global mybtn_user
        sess.cookies.clear()
        sess.headers.update({
                'Host': 'filman.cc',
                'User-Agent': UA,
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Referer': 'http://filman.cc/logowanie',
                'Upgrade-Insecure-Requests': '1',})
    
        url ='https://filman.cc/logowanie'
        cont=sess.get(url)
        aa=sess.cookies
        
        my_cookies = requests.utils.dict_from_cookiejar(aa)
        found = ['%s=%s' % (name, value) for (name, value) in my_cookies.items()]
        
        mybtn_user= ';'.join(found)    
        sess.cookies.save(COOKIEFILE, ignore_discard = True)        
        addLinkItem('[B]Zaloguj[/B]','',mode='Opcje',iconimage='',IsPlayable=False)            
        
#from urlparse import urlparse
#from urlparse import urlsplit

def getLogin(u='',p=''):

    #import kurw
    #kurw.abc()


    try:
        import kurw
        kurw.abc()
    except:
        pass
    
    fkukz = my_addon.getSetting('fjkukz')
    url ='https://filman.cc/logowanie'

    try:

    
        sess.cookies.clear()
        sess.headers = {
            'Host': 'filman.cc',
            'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'dnt': '1',
            'upgrade-insecure-requests': '1',
            'te': 'trailers',
        }
        
        response = sess.get('https://filman.cc/', verify=False)
        response = sess.get('https://filman.cc/logowanie', verify=False)
        data={
            "login": u,
            "password": p,
            "remember": 'on',
            "submit": ''}
        
        response = sess.post('https://filman.cc/logowanie', data=data,verify=False)
        

        ab=sess.cookies
        ad=response.cookies
        content=response.text

        mybtn_user=''.join(['%s=%s;'%(c.name, c.value) for c in sess.cookies])    
    except:
        content=''
    dane=''

    if content.find('Wyloguj')>0:
        out=True
        sess.cookies.save(COOKIEFILE, ignore_discard = True)
        dane='[COLOR yellowgreen] darmowe[/COLOR]'
        my_addon.setSetting('zalog','true')
        try:

            content=sess.get('http://filman.cc/premium', cookies=sess.cookies).text

            danex=re.findall(' aktywne konto premium.+?<strong>(.+?)</strong>(.+?)<',content,re.DOTALL)
            if danex:
                dane='[COLOR orangered] premium do %s %s[/COLOR]'%(danex[0][0],danex[0][1])
                sess.cookies.save(COOKIEFILE, ignore_discard = True)
        except:
            pass
            
    else:
        out=False
        my_addon.setSetting('zalog','false')
    return out,dane
def getUrlReq(url, ref, allow=True):
    #global mybtn_user
    if os.path.isfile(COOKIEFILE):
        sess.cookies.load()
    ab= sess.cookies

    headersy={'User-Agent': UA,'Referer':ref}
    sess.headers.update({
            'Host': 'filman.cc',
            'User-Agent': UA,
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Referer': ref,
            'Upgrade-Insecure-Requests': '1',})
    

    content=sess.get(url ,verify=False, cookies=sess.cookies, allow_redirects=allow)#.text
    if 'Security Check' in content.text:
        content=sess.get(url,headers=headersy)#.text    
        sess.cookies.save(COOKIEFILE, ignore_discard = True)
    if allow:
        content=content.text
    else:
        content=content

    mybtn_user=''.join(['%s=%s;'%(c.name, c.value) for c in sess.cookies])
    
    return content    #.text

def getTvs(url):
    global mybtn_user
    mybtn_user = args.get('token',[''])[0]
    cuk=quote(mybtn_user)
    content=getUrlReq(url,url)
    out=[]
    result=parseDOM(content,'div', attrs={'class': "row tv-list"})[0]
    links=parseDOM(result,'div', attrs={'class': "col-xs-6 col-sm-3"})
    for link in links:
        src = parseDOM(link, 'img', ret='src')[0]
        href = parseDOM(link, 'a', ret='href')[0]   
        title = parseDOM(link, 'a', ret='title')[0]  
        if href and title:
            if src.startswith('//'):
                src = 'http:'+src
            film = {
                'href'   : href,
                'title'  : title,
                'plot'   : '',
                'img'    : src+'|User-Agent='+quote(UA)+'&Referer='+mainurl+'&Cookie='+cuk,}
            out.append(film)
    return out        

def getEpg(url):
    content = getUrl(url)
    plot=''
    trwa=parseDOM(content,'b')[0]
    czastrwa=parseDOM(content,'p')[1]
    czastrwado=parseDOM(content,'p')[2]
    dalej=parseDOM(content,'table', attrs={'width': ".+?"})[0]
    plot+='[COLOR khaki]'+czastrwa+'-'+czastrwado+'[/COLOR] '+trwa
    plot+='[CR]'
    try:
        typhourtitle=re.findall('<tr.+?title="(.+?)".+?<b>(.+?)<\/b.+?<td>(.+?)<\/td',dalej)#[0]
        for typ,hour,title in typhourtitle:
            plot+='[COLOR khaki]'+hour+'[/COLOR] '+title
            plot+='[CR]'
    except:
        pass
    return plot
    
def getTvLink(url,imag):
    zalog = my_addon.getSetting('zalog')
    global mybtn_user
    
    mybtn_user = args.get('token',[''])[0]
    cuk=quote(mybtn_user)

    content=getUrlReq(url,url)
    out=[]
    epgresult=parseDOM(content,'div', attrs={'class': "epg"})#[0]
    plot=''
    if epgresult:
        epgs=parseDOM(epgresult[0],'h4')
        if epgs:
            for epg in epgs:
                plot+='[COLOR khaki]'+epg+'[/COLOR] '
                plot+='[CR][CR]'
        else:
            epgs=parseDOM(epgresult[0],'span')
            if epgs:
                for epg in epgs:
                    plot+='[COLOR khaki]'+epg+'[/COLOR] '
                    plot+='[CR][CR]'                
    result=parseDOM(content,'div', attrs={'class': "tab-content"})#[0]

    if result:
        result=result[0]
        co=1    

        if 'tylko dla zalogowanych' in result:
            u = my_addon.getSetting('user')
            p = my_addon.getSetting('pass')

            logged,dane=  getLogin(u,p)
            content=getUrlReq(url,url)
        tthrefs = re.findall('<iframe.+?src="(.+?)".+?"text-center">([^<]+).+?"text-center">([^<]+)',result,re.DOTALL)
        
        ids = [(a.start(), a.end()) for a in re.finditer('<div role="tabpanel"', result)]
        ids.append( (-1,-1) )
        out=[]
        for i in range(len(ids[:-1])):

            odtw = result[ ids[i][1]:ids[i+1][0] ]
            if 'tab-pane fade" id="' in odtw:

                ab=re.findall('id="([^"]+).*?var player(.+?)watermark',odtw,re.DOTALL)
                if ab:
                    tyt = fname + ' - ' +ab[0][0]
                    info = tyt
                    href = re.findall('source\:\s*"([^"]+)',ab[0][1],re.DOTALL)[0]
                    link = url
                    film = {'href': href+'|User-Agent='+UA+'&Referer='+link,'title': info,'plot': plot,'img': imag,}    
                    out.append(film)
            else:
                continue

    return out
    
def getMovies(url,page=1,group=''):
    global mybtn_user
    mybtn_user = args.get('token',[''])[0]
    cuk=quote(mybtn_user)

    if '?page=' in url:
        url = url.replace('?page=','?page=%d' %page)
    else:
        url += '/' if url[-1] != '/' else ''
        url = url + '?page=%d' %page
    if group:
        url=url.split('?')[0]    
    content= getUrlReq(url,url)
    out=[]
    gr=False
    pr=False
    ids = []
    try:
        result=parseDOM(content,'div', attrs={'class': "col-sm-9"})[1]
    except:
        result=content        #<ul class='clearfix pagination'>
    mdata=parseDOM(content,'ul', attrs={'class': "clearfix pagination"})#[0]     #<ul class='clearfix pagination'>
    mdata = unquote(mdata[0]) if mdata else content
    gr=False
    
    if mdata.find( '?page=%d' %(page+1))>-1:
        gr = page+1
    links=parseDOM(result,'div', attrs={'class': "col-xs-6 col-sm-3 col-lg-2"}) #[0]    col-xs-6 col-sm-3 col-lg-2 #<ul class='clearfix pagination'>        links=
    for link in links:
        src = parseDOM(link, 'img', ret='src')[0]
        href = parseDOM(link, 'a', ret='href')[0]   
        plot = parseDOM(link, 'a', ret='data-text')#[0]  
        try:
            title = parseDOM(link,'div', attrs={'class': "title"})[0]
        except:
            title = parseDOM(link, 'a', ret='title')[0]  
        try:
            rating = parseDOM(link,'div', attrs={'class': "rate"})[0]
        except:
            rating =''
        try:
            year = int(parseDOM(link,'div', attrs={'class': "film_year"})[0])
        except:
            year=''
        if href and title:
            if src.startswith('//'):
                src = 'http:'+src
            film = {
                'href'   : href,
                'title'  : fixSC(title),
                'plot'   : fixSC(plot[0]) if plot else '',
                'img'    : src+'|User-Agent='+quote(UA)+'&Referer='+mainurl+'&Cookie='+cuk,
                'rating' : rating,
                'year'   : year,
                    }
            out.append(film)
        pr = page-1 if page>1 else False
    return (out, (pr,gr))    
    
def getSeries(url, page = 1,group = ''):
    global mybtn_user
    mybtn_user = args.get('token',[''])[0]
    cuk=quote(mybtn_user)
    if '?page=' in url:
        url = url.replace('?page=','?page=%d' %page)
    else:
        url += '/' if url[-1] != '/' else ''
        url = url + '?page=%d' %page
    if group:
        url=url.split('?')[0]
    content =getUrlReq(url,url)
    out=[]
    gr=False
    pr=False
    ids = []
    if group:

        result=parseDOM(content,'div', attrs={'id': "item-list","class":"row series-list"}) 
        if 'Ostatnio dodane' in group:
            result=result[0]
        #else:
        #    result=result[1]
            
        links=parseDOM(result,'div', attrs={'class': "col-xs-6 col-sm-3 col-lg-2"}) 
        for link in links:
            src = parseDOM(link, 'img', ret='src')[0]
            href = parseDOM(link, 'a', ret='href')[0]   
            title = parseDOM(link,'div', attrs={'class': "title"})#[0]
            
            title2 = parseDOM(link,'a', ret='title')#[0]  
            title = title[0] if title else title2[0]
            if href and title:
                if src.startswith('//'):
                    src = 'http:'+src
                film = {
                    'href'   : href,
                    'title'  : fixSC(title),
                    'plot'   : '',
                    'img'    : src+'|User-Agent='+quote(UA)+'&Referer='+mainurl+'&Cookie='+cuk,
                        }
                out.append(film)    
    else: 
        
        result=parseDOM(content,'div', attrs={'class': "col-sm-9"})[1]     
        mdata=parseDOM(content,'div', attrs={'id': "item-list","class":"row series-list"}) [0]     
        mdata = unquote(mdata) if mdata else content
        gr=False
        
        if mdata.find( '?page=%d' %(page+1))>-1:
            gr = page+1    
        links=parseDOM(result,'div', attrs={'class': "col-xs-6 col-sm-3 col-lg-2"}) 
        for link in links:
            src = parseDOM(link, 'img', ret='src')[0]
            href = parseDOM(link, 'a', ret='href')[0]   

            title = parseDOM(link,'div', attrs={'class': "title"})#[0]
            
            title2 = parseDOM(link,'a', ret='title')#[0]  
            title = title[0] if title else title2[0]
            if href and title:
                if src.startswith('//'):
                    src = 'http:'+src
                film = {
                    'href'   : href,
                    'title'  : fixSC(title),
                    'plot'   : '',
                    'img'    : src+'|User-Agent='+quote(UA)+'&Referer='+mainurl+'&Cookie='+cuk,
                        }
                out.append(film)        
        pr = page-1 if page > 1 else False
    return (out, (pr,gr))

def parseVideoLink(url, host = ''):
    if 'cda' in host:
        return 'http://www.cda.pl/video/%s'%(url.split('id=')[-1])
    elif 'alltube' in url:
        content =getUrlReq(url,url)
        outurl=''
        href= re.compile('src="(.*?)"').findall(content)
        if href:
            href = [h for h in href if BRAMKA not in h]
            outurl = getHref(href[0])
            if outurl.startswith('//'):
                outurl = 'http:'+outurl
        return outurl
    elif str(host) in url:
        if url.startswith('//'):
            url = 'http:' + url
        return url
    else:
        return url

def getVideos(url):

    content =getUrlReq(url,url)

    out=[]
    try:
        result = parseDOM((parseDOM(content,'table', attrs={'id': "links"})[0]),'tbody')
        hrefok=''
        if result:

            links = re.findall('"link-to-video">(.+?)td class="vote',result[0],re.DOTALL)
            if not links:
                links = re.findall('"link-to-video">(.+?)<\/td',result[0],re.DOTALL)
                
            for link in links:

                if 'odtwarzacz premium' in link.lower():
                    iframe = re.findall('a href="([^"]+)"',link)
                    prem2=True
                else:
                    iframe = re.findall('data\-iframe="([^"]+)"',link)
                    prem2=False

                try:

                    decodiframe=base64.b64decode(iframe[0])
                    decodiframe= decodiframe.decode(encoding='utf-8', errors='strict') if sys.version_info >= (3,0,0) else decodiframe
                    decodiframe = decodiframe.replace('\/','/')
                    if prem2:

                        dod = re.findall("""attr\(\\'href\\'\)\)\s*\+\s*\\'(.+?)\\'""",content,re.DOTALL)[0]
                        hrefok=decodiframe+dod
                    else:
                        hrefok=re.findall("""src['"]:['"](.+?)['"]\,""",decodiframe)[0] 
                    info = ' '.join(re.compile('>(.*?)<',re.DOTALL).findall(link))
                    info = re.sub(' +','  ',fixSC(info))#.strip()
                    info = re.sub('\(.+?\)','',info)
                    if hrefok:
                        film = {'url' : hrefok,'title': info,}
                        out.append(film)
                except:
                    pass
    except:
        pass
    return out

def scanEpisodes(url):
    global mybtn_user
    mybtn_user = args.get('token',[''])[0]
    cuk=quote(mybtn_user)
    content =getUrlReq(url,url)
    src = re.compile('<ul id="episode-list">(.*?)</ul>').findall(content)
    src = src[-1] if src else ''
    out=[]
    odcinki = content.find('Odcinki')
    odcinek = content.find('Dodaj odcinek')
    gdzie=re.findall('Odcinki(.+?)Dodaj odcinek',content,re.DOTALL)[0]
    if 'ten serial nie posiada' in gdzie:
        return out
    links = re.compile('<a href="(.*?)">(.*?)</a>',re.DOTALL).findall(gdzie)
    imgsrc = re.compile('class="col-sm-3">(.+?)<div',re.DOTALL).findall(content)    
    imgsrc = imgsrc[1] if imgsrc else ''
    imgsrc = re.compile('<img src="(.*?)"',re.DOTALL).findall(imgsrc)
    imgsrc = imgsrc[-1]+'|User-Agent='+quote(UA)+'&Referer='+mainurl+'&Cookie='+cuk if imgsrc else ''
    for h,t in links:
        t= fixSC(t.strip())
        t=re.sub(' +',' ',t)
        data = re.compile('[sS](\d+)[Ee](\d+)').findall(t)
        
        film = {
            'href'  : h.strip(),
            'plot' : t,
            'title' : t,
            'img' : imgsrc,
            'season' : int(data[0][0]) if data else '',
            'episode' : int(data[0][1]) if data else '',
            'aired' : ''}
        out.append(film)
    return out

def splitToSeasons(input):
    out={}
    seasons = [x.get('season') for x in input]
    for s in set(seasons):
        out['Sezon %02d'%s]=[input[i] for i, j in enumerate(seasons) if j == s]
    return out

def getSort(mv='film',sc='category'):
    label=[]
    value=[]
    url = 'https://filman.cc/filmy-online-pl/'
    if mv=='film':
        content =getUrlReq(url,BASEURL)

        if sc=='category':
            result=parseDOM(content,'ul', attrs={'id': "filter-category"})[0]
            value=parseDOM(result,'li', ret='data-id') #[0]
            label=parseDOM(result,'a')
        elif sc=='year':
            result=parseDOM(content,'ul', attrs={'id': "filter-year"})[0]
            value=parseDOM(result,'li', ret='data-id') #[0]
            label=parseDOM(result,'a')
        elif sc=='country': 
            result=parseDOM(content,'ul', attrs={'id': "filter-country"})[0]
            value=parseDOM(result,'li', ret='data-id') #[0]
            result = re.sub('    HiszpaniaWielka Brytania', 'Hiszpania/Wielka Brytania', result)
            result = re.sub(r'\s+', ' ', result)
            label=parseDOM(result,'a')
    elif mv=='serial':
        pass
    return (label,value)

def search(pharse='dom'):
    global mybtn_user
    mybtn_user = args.get('token',[''])[0]
    cuk=quote(mybtn_user)
    url='https://filman.cc/wyszukiwarka?phrase='+pharse
    content =getUrlReq(url,BASEURL)
    out1=[]
    out2=[]
    result=parseDOM(content,'div', attrs={'id': "advanced-search"})[0]
    links=parseDOM(result,'div', attrs={'class': "col-sm-4"})
    for link in links:
        src = parseDOM(link, 'img', ret='src')[0]
        src=src.replace('thumb','big')
        href = parseDOM(link, 'a', ret='href')[0]   
        title = parseDOM(link,'div', attrs={'class': "title"})[0] 
        plot = parseDOM(link,'div', attrs={'class': "description text-justify"})[0]  
        if href and title:
            if src.startswith('//'):
                src = 'http:'+src
            film = {
                'href'   : href,
                'title'  : fixSC(title),
                'plot'   : fixSC(plot),
                'img'    : src+'|User-Agent='+quote(UA)+'&Referer='+mainurl+'&Cookie='+cuk,
                    }

            if '/film/' in film['href']:
                out1.append(film)
            else:#elif '/serial' in film['href']: /serial-online/
                out2.append(film)
    return out1,out2

def fixSC(pharse):
    if isinstance(pharse, unicode):
        if sys.version_info >= (3,0,0):
            pharse=pharse
        else:
            pharse = pharse.encode('utf-8')
    pharse = pharse.replace('&lt;br/&gt;',' ')
   # s='JiNcZCs7'
   # pharse = re.sub(s.decode('base64'),'',pharse)
    pharse = pharse.replace('\n','').replace('\r','').replace('\t','')
    pharse = pharse.replace('&nbsp;','')
    pharse = pharse.replace('&quot;','"').replace('&amp;quot;','"')
    pharse = pharse.replace('&oacute;','ó').replace('&Oacute;','Ó')
    pharse = pharse.replace('&amp;oacute;','ó').replace('&amp;Oacute;','Ó')
    pharse = pharse.replace('&amp;','&')
    pharse = pharse.replace('\u0105','ą').replace('\u0104','Ą')
    pharse = pharse.replace('\u0107','ć').replace('\u0106','Ć')
    pharse = pharse.replace('\u0119','ę').replace('\u0118','Ę')
    pharse = pharse.replace('\u0142','ł').replace('\u0141','Ł')
    pharse = pharse.replace('\u0144','ń').replace('\u0144','Ń')
    pharse = pharse.replace('\u00f3','ó').replace('\u00d3','Ó')
    pharse = pharse.replace('\u015b','ś').replace('\u015a','Ś')
    pharse = pharse.replace('\u017a','ź').replace('\u0179','Ź')
    pharse = pharse.replace('\u017c','ż').replace('\u017b','Ż')
    return pharse


mode = args.get('mode', None)


sortv = my_addon.getSetting('sortV')
sortn = my_addon.getSetting('sortN') if sortv else 'Daty dodania'
qualityv = my_addon.getSetting('qualityV')
qualityn = my_addon.getSetting('qualityN') if qualityv else 'Wszystkie'
versionv = my_addon.getSetting('versionV')
versionn = my_addon.getSetting('versionN') if versionv else 'Wszystkie'
def router(paramstring):
    args = dict(parse_qsl(paramstring))
    ex_link = args.get('ex_link', None)
    rys = args.get('iconImage', None)
    page = args.get('page',[1])[0]
    if args:    
        mode = args.get('mode', None)

        if 'filtr:' in mode:
            myMode = mode.split(":")[-1]
            
            if myMode=='sort':
                label=[u'Daty dodania',u'Liczba głosów',u'Premiera',u'Odsłony',u'Ocena']
                value=['sort:date','sort:vote','sort:premiere','sort:view','sort:rate']    
                
                msg = 'Sortowanie'
            elif myMode=='quality':
                label=[u'Wszystkie',u'Niska',u'Średnia',u'Wysoka']
                value=['','quality:1','quality:2','quality:3']
                msg = 'Jakość'
            elif myMode=='version':
                label=['Wszystkie','Dubbing',   'Dubbing Kino','ENG',      'Lektor',   'Lektor IVO','Napisy',  'PL']
                value=[''         ,'version:2', 'version:7',   'version:5','version:1','version:6', 'version:3','version:4']
                msg = 'Wersja'
                        
            if myMode in ['quality','version']:
                try:
                    sel = xbmcgui.Dialog().select('Wybierz wersje językową',label) #l1l1l11ll11l1l11_nktv_
                except:
                    sel = xbmcgui.Dialog().select('Wybierz wersje językową',label)
                if isinstance(sel,list):
                    if 0 in sel: sel=[0]
                    v = myMode+':'+','.join( [ value[i].replace(myMode+':','') for i in sel])
                    n = ','.join( [ label[i] for i in sel])
                else:
                    if sel>-1:
                        v = value[sel]
                        n = label[sel]
                        my_addon.setSetting(myMode+'V',v)
                        my_addon.setSetting(myMode+'N',n)
                        xbmc.executebuiltin('Container.Refresh')
                    else:
                        pass
            else:
                sel = xbmcgui.Dialog().select(msg,label)
                if sel>-1:
                    v = value[sel]
                    n = label[sel]
            
                    my_addon.setSetting(myMode+'V',v)
                    my_addon.setSetting(myMode+'N',n)
                    xbmc.executebuiltin('Container.Refresh')
                else:
                    pass
        
        
        elif mode == 'playTv':
            PlayTv(ex_link)
            #xbmcplugin.setContent(addon_handle, 'movies')    
            xbmcplugin.endOfDirectory(addon_handle,True)    
        elif mode == 'ListTv':
            listTv(ex_link)
            xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE , label2Mask = "%R, %Y, %P")
        #    xbmcplugin.setContent(addon_handle, 'movies')        
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'getTvLinks':
            getTvLinks(ex_link,rys)
        #    xbmcplugin.setContent(addon_handle, 'movies')
            xbmcplugin.endOfDirectory(addon_handle,True)    
        elif mode == 'ListMovies':
            sr = '/'.join([x for x in [sortv,qualityv,versionv] if x]) if '/filmy-online-pl/' in ex_link else ''
            sr = '' if sr in ex_link else sr
            listMovies(ex_link+sr,page)
            
        #    xbmcplugin.setContent(addon_handle, 'movies')
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'ListMoviesKids':
            listMovies(ex_link,page)
        #    xbmcplugin.setContent(addon_handle, 'movies')
            xbmcplugin.endOfDirectory(addon_handle,True)    
        elif mode == 'Opcje':
            my_addon.openSettings()
            xbmc.executebuiltin('Container.Refresh()')    
        
        elif mode == '__page__M':
            url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : ex_link, 'page': page})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
        
        elif mode == '__page__S':
            url = build_url({'mode': 'ListSeriale', 'foldername': '', 'ex_link' : ex_link, 'page': page})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
        
        elif mode == 'getEpisodes':
            getEpisodes(ex_link)
        
        elif mode == 'getEpisodes2':
            getEpisodes2(ex_link)
            
        elif mode == 'ListSeriale':
            listSeries(ex_link,page)
            if 'Ostatnio dodane seriale' in ex_link:
                xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE , label2Mask = "%R, %Y, %P")
            xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE , label2Mask = "%R, %Y, %P")
        #    xbmcplugin.setContent(addon_handle, 'tvshows')
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'getSeasons':
            getSeasons(ex_link)
        
        elif mode == 'ListFS':
            listFS(ex_link)
            xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE , label2Mask = "%R, %Y, %P")
        #    xbmcplugin.setContent(addon_handle, 'tvshows')
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'getLinks':
            getLinks(ex_link)
        
        elif mode == 'DOWNLOAD':
            data = eval(ex_link)
            download_path = my_addon.getSetting('download.path')
        
            if download_path:
                getLinks(data.get('href'), True, data.get('title'), data.get('img'))
            else:
                xbmcgui.Dialog().ok('Ustaw docelowy folder', 'Pobieranie nie powiodło się')
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'GatunekRok':
            param = ex_link.split('|')
            label,value = getSort(mv = param[0], sc = param[1])
            
            try:
                sel = xbmcgui.Dialog().select('Wybierz ',label)
            except:
                sel = xbmcgui.Dialog().select('Wybierz',label)
            
            if isinstance(sel,list):
                v = param[1]+':'+','.join([ value[i] for i in sel])
            else:
                if sel>-1:
                    sel=sel
                    v = param[1]+':'+value[sel]
                    sr = '/'.join([x for x in [sortv,qualityv,versionv,v] if x])
                    listMovies('https://filman.cc/filmy-online-pl/'+sr,1)
                    xbmcplugin.endOfDirectory(addon_handle,True)
                else:
                    xbmc.executebuiltin('Container.Refresh()')            
        elif mode =='Szukaj':
            #global mybtn_user
            mybtn_user = args.get('token',[''])[0]
            addDir('[COLOR green]Nowe Szukanie[/COLOR]','',mode='SzukajNowe')
            history = getHistory()
            if not history == ['']:
                for entry in history:
                    contextmenu = []
                    contextmenu.append((u'Usun', 'Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'ex_link' : entry, 'token': mybtn_user})),) #, 'token': mybtn_user})
                    contextmenu.append((u'Usun cała historie', 'Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll', 'token': mybtn_user})),)
                    addDir(name=entry, ex_link=entry.replace(' ','+'), mode='ListFS', fanart=None, contextmenu=contextmenu)
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode =='SzukajNowe':
            d = xbmcgui.Dialog().input(u'Szukaj, Podaj tytuł filmu/serialu', type=xbmcgui.INPUT_ALPHANUM)
            if d:
                setHistory(d)
                ex_link=d.replace(' ','+')
                listFS(ex_link)
        #     xbmcplugin.setContent(addon_handle, 'tvshows')
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode =='SzukajUsun':
            remCache(ex_link)
            xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj', 'token': mybtn_user}))
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'SzukajUsunAll':
            delHistory()
            xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj', 'token': mybtn_user}))
            xbmcplugin.endOfDirectory(addon_handle,True)
        elif mode == 'folder':
            pass
    else:
        login()
        addDir(name="Telewizja (LIVE)",ex_link='https://filman.cc/telewizja-online-pl',page=1, mode='ListTv',iconImage='DefaultFolder.png',fanart=FANART)
        addLinkItem("[COLOR lightblue]Sortowanie:[/COLOR] [B]"+sortn+"[/B]",'',mode='filtr:sort',iconimage='',IsPlayable=False)
        addLinkItem("[COLOR lightblue]Jakość:[/COLOR] [B]"+qualityn+"[/B]",'',mode='filtr:quality',iconimage='',IsPlayable=False)
        addLinkItem("[COLOR lightblue]Wersja:[/COLOR] [B]"+versionn+"[/B]",'',mode='filtr:version',iconimage='',IsPlayable=False)
        addDir(name="[COLOR blue]Filmy[/COLOR]",ex_link='https://filman.cc/filmy-online-pl/',page=1, mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
        addDir(name=" [Kategoria]",ex_link='film|category',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
        addDir(name=" [Rok]",ex_link='film|year',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
        addDir(name=" [Kraj]",ex_link='film|country',page=1, mode='GatunekRok',iconImage='DefaultFolder.png',fanart=FANART)
        addDir(name="[COLOR blue]Seriale (Lista)[/COLOR]",ex_link='https://filman.cc/seriale-online-pl/',page=1, mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
        addDir(name=" Ostatnio dodane seriale",ex_link='https://filman.cc/seriale-online-pl/|Ostatnio dodane seriale',page=1, mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
    #    addDir(name=" Popularne seriale",ex_link='https://filman.cc/seriale-online-pl/|Popularne seriale',page=1, mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
        addDir(name="[COLOR blue]Dla dzieci[/COLOR]",ex_link='https://filman.cc/dla-dzieci-pl/',page=1, mode='ListMovies',iconImage='DefaultFolder.png',fanart=FANART)
        addDir('[COLOR lightblue]Szukaj[/COLOR]','',mode='Szukaj')
        addLinkItem('[COLOR gold]-=Opcje=-[/COLOR]','','Opcje',IsPlayable=False)
    #    xbmcplugin.setContent(addon_handle, 'movies')
        xbmcplugin.endOfDirectory(addon_handle,True)

if __name__ == '__main__':
    router(sys.argv[2][1:])    
