﻿# -*- coding: UTF-8 -*-
import sys,re,os
from urlparse import parse_qsl
import base64
import urllib
import urllib2

import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc
from CommonFunctions import parseDOM
import resolveurl as urlresolver

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.filmantv')

PATH            = addon.getAddonInfo('path')
DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'
FANART=PATH+'fanart.jpg'
sys.path.append( os.path.join( RESOURCES, "lib" ) )

exlink = params.get('url', None)
name= params.get('title', None)
page = params.get('page',[1])[0]

s = requests.Session()

def build_url(query):
    return base_url + '?' + urllib.urlencode(query)

def add_item(url, name, image, folder, mode, infoLabels=False, itemcount=1, page=1):
	list_item = xbmcgui.ListItem(label=name)

	if folder:
		list_item.setProperty("IsPlayable", 'false')
	else:
		list_item.setProperty("IsPlayable", 'true')
		
	if not infoLabels:
		infoLabels={'title': name}
	list_item.setInfo(type="video", infoLabels=infoLabels)	
	list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': image})
	xbmcplugin.addDirectoryItem(
		handle=addon_handle,
		url = build_url({'mode': mode, 'url' : url, 'page' : page}),			
		listitem=list_item,
		isFolder=folder)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
	
def home():
	add_item('http://filman.tv/', 'Filmy', RESOURCES+'Filmy.png', True, "listmovies")	
	add_item('kategorie:', '    Kategorie', '', True, "gatunek")		
	add_item('', '[COLOR lightblue]Szukaj[/COLOR]', '', True, "search")		
	xbmcplugin.endOfDirectory(addon_handle)
def ListMovies(exlink,page):
	page = int(page) if page else 1		
	links, pagin = getMovies(exlink,page)
	if pagin[0]:
		add_item(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=exlink, mode='__page__M', image='', folder=True, page=pagin[0])	
	itemz=links
	items = len(links)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=False, infoLabels=f, itemcount=items)		
	if pagin[1]:
		add_item(name='[COLOR blue]>> Nastepna strona >>>[/COLOR]', url=exlink, mode='__page__M', image='', folder=True, page=pagin[1])
	xbmcplugin.setContent(addon_handle, 'movies')	
	xbmcplugin.endOfDirectory(addon_handle)
def getUrlReq(url):
	s.headers.update({'User-Agent':"Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0"})	
	content=s.get(url,verify=False).text	
	return content

def getMovies(url,page=1):
	if '/?s=' in url:
		surl=url.split('?s=')
		url=surl[0]+ 'page/%d'%page +'/?s='+surl[1] 
	else:
		url = url + 'page/%d' %page
	html=getUrlReq(url)
	out=[]
	try:
		prevpage=False #gr=False
		nextpage=False  # pr=False	
		if html.find("pny &rarr;</a>")>0:
			nextpage = page+1
		if '/category/' in url or '/?s=' in url:
			result=parseDOM(html,'div', attrs={'id': "content"})[0]	
		else:
			result=parseDOM(html,'section', attrs={'class': "home-latest-posts"})[0] 
		links = parseDOM(result, 'article', attrs={'class': "post-entry post-.*?"})
		for link in links:	
			imag = parseDOM(link, 'img', ret='src')[0]
			href = parseDOM(link, 'a', ret='href')[0]   
			title=parseDOM(link,'a')[0]
			try:
				aa=re.split(r'\((\d+)\)', title) #[1]
				title='[B]'+aa[0]+'[/B][COLOR darkkhaki]('+aa[2].strip()+')[/COLOR]' if aa else title
				year=int(aa[1]) if aa else ''
			except:
				title=title
				year=''
			plot=parseDOM(link,'p')[0]
			if plot.find("<br")>0:
				plot=plot.split('<br')
				plot=plot[0]
			kategor=parseDOM(link, 'div', attrs={'class': "post-info"})[0]
			genre=''
			kategs = parseDOM(kategor, 'a')
			for kateg in kategs:
				genre+=kateg+' '    
			out.append({'title':PLchar(title),'href':href,'img':imag,'plot':PLchar(plot), 'genre':genre, 'year':year})
	except:
		pass
	prevpage = page-1 if page>1 else False
	return (out,(prevpage,nextpage))

def getGatunek(exlink):
	out=[]
	url='http://filman.tv'
	html=getUrlReq(url)
	if 'kategorie:' in exlink:	
		result = parseDOM(html, 'div', attrs={'id': 'categories-2'}) 
		links = parseDOM(result[0], 'li')
		for link in links:	
			url = str(parseDOM(link, 'a', ret='href')[0])	
			genre = PLchar(parseDOM(link, 'a')[0])	
			out.append((PLchar(genre), url))	
	return out		
	
def getLinks(exlink):
	links=getVideosOk(exlink)
	if links:
	
		linksAllb = [x.get('host') for x in links]
		s = xbmcgui.Dialog().select('Linki',linksAllb)	
		hrefs=links[s].get('href') if s>-1 else quit()
		host=links[s].get('host') if s>-1 else quit()
		stream=hrefs	
		try:
			stream_url = urlresolver.resolve(stream)
			play_item = xbmcgui.ListItem(path=stream_url)
			xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
		except Exception,e:
			stream_url=''
			s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link bedzie działał?','ERROR: %s'%str(e))	
	else:
		s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Brak linków','')
		
def getVideosOk(url):
	html=getUrlReq(url)	
	out=[]
	result=parseDOM(html,'div', attrs={'class': "entry-content"})[0]
	hrefhost=re.findall('"button6".href="(.+?)".+?Ogl.+?\/a>(.*?)<',result) #[0]
	for href,host in hrefhost:	
		film = {'href' : href,'host' : host.strip(),}
		out.append(film)	
	return out

def PLchar(char):
	if type(char) is not str:
		char=char.encode('utf-8')
	char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
	char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
	char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
	char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
	char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
	char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
	char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
	char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
	char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
	char = char.replace('&#8217;',"'")
	char = char.replace('&#8211;',"-")	
	char = char.replace('&#8230;',"...")	
	char = char.replace('&#8222;','"').replace('&#8221;','"')	
	char = char.replace('[&hellip;]',"...")
	char = char.replace('&#038;',"&")	
	char = char.replace('&nbsp;',".").replace('&amp;','&')
	return char	

if __name__ == '__main__':
	mode = params.get('mode', None)
	if not mode:
		home()
	elif mode == 'listmovies':
		ListMovies(exlink,page)
	elif mode == 'getLinks':
		getLinks(exlink)	
	elif mode == 'gatunek':
		data = getGatunek(exlink)
		par= exlink.split('|')
		if data:
			label = [x[0].strip() for x in data]
			url = [x[1].strip() for x in data]
			sel = xbmcgui.Dialog().select('Wybierz '+par[0],label)
			if sel>-1:
				urk=url[sel]
				ListMovies(urk,page)
			else:
				quit()
	elif mode == '__page__M':
		url = build_url({'mode': 'listmovies', 'foldername': name, 'url' : exlink, 'page' : page})
		xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
	elif mode=='search':
		query = xbmcgui.Dialog().input(u'Szukaj, Podaj tytuł filmu', type=xbmcgui.INPUT_ALPHANUM)
		if query:  	
			q=query.replace(' ','+')
			elink='http://filman.tv/?s='+q
			ListMovies(elink,page)		

